/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.config.DefaultHoodieConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.config.HoodieHBaseIndexConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.index.HoodieIndex;

@Immutable
public class HoodieIndexConfig
extends DefaultHoodieConfig {
    public static final String INDEX_TYPE_PROP = "hoodie.index.type";
    public static final String INDEX_CLASS_PROP = "hoodie.index.class";
    public static final String DEFAULT_INDEX_CLASS = "";
    public static final String BLOOM_FILTER_NUM_ENTRIES = "hoodie.index.bloom.num_entries";
    public static final String DEFAULT_BLOOM_FILTER_NUM_ENTRIES = "60000";
    public static final String BLOOM_FILTER_FPP = "hoodie.index.bloom.fpp";
    public static final String DEFAULT_BLOOM_FILTER_FPP = "0.000000001";
    public static final String BLOOM_INDEX_PARALLELISM_PROP = "hoodie.bloom.index.parallelism";
    public static final String DEFAULT_BLOOM_INDEX_PARALLELISM = "0";
    public static final String BLOOM_INDEX_PRUNE_BY_RANGES_PROP = "hoodie.bloom.index.prune.by.ranges";
    public static final String DEFAULT_BLOOM_INDEX_PRUNE_BY_RANGES = "true";
    public static final String BLOOM_INDEX_USE_CACHING_PROP = "hoodie.bloom.index.use.caching";
    public static final String DEFAULT_BLOOM_INDEX_USE_CACHING = "true";
    public static final String BLOOM_INDEX_TREE_BASED_FILTER_PROP = "hoodie.bloom.index.use.treebased.filter";
    public static final String DEFAULT_BLOOM_INDEX_TREE_BASED_FILTER = "true";
    public static final String BLOOM_INDEX_BUCKETIZED_CHECKING_PROP = "hoodie.bloom.index.bucketized.checking";
    public static final String DEFAULT_BLOOM_INDEX_BUCKETIZED_CHECKING = "true";
    public static final String BLOOM_INDEX_FILTER_TYPE = "hoodie.bloom.index.filter.type";
    public static final String DEFAULT_BLOOM_INDEX_FILTER_TYPE = BloomFilterTypeCode.SIMPLE.name();
    public static final String HOODIE_BLOOM_INDEX_FILTER_DYNAMIC_MAX_ENTRIES = "hoodie.bloom.index.filter.dynamic.max.entries";
    public static final String DEFAULT_HOODIE_BLOOM_INDEX_FILTER_DYNAMIC_MAX_ENTRIES = "100000";
    public static final String SIMPLE_INDEX_USE_CACHING_PROP = "hoodie.simple.index.use.caching";
    public static final String DEFAULT_SIMPLE_INDEX_USE_CACHING = "true";
    public static final String SIMPLE_INDEX_PARALLELISM_PROP = "hoodie.simple.index.parallelism";
    public static final String DEFAULT_SIMPLE_INDEX_PARALLELISM = "50";
    public static final String GLOBAL_SIMPLE_INDEX_PARALLELISM_PROP = "hoodie.global.simple.index.parallelism";
    public static final String DEFAULT_GLOBAL_SIMPLE_INDEX_PARALLELISM = "100";
    public static final String BLOOM_INDEX_KEYS_PER_BUCKET_PROP = "hoodie.bloom.index.keys.per.bucket";
    public static final String DEFAULT_BLOOM_INDEX_KEYS_PER_BUCKET = "10000000";
    public static final String HBASE_ZKQUORUM_PROP = "hoodie.index.hbase.zkquorum";
    public static final String HBASE_ZKPORT_PROP = "hoodie.index.hbase.zkport";
    public static final String HBASE_ZK_ZNODEPARENT = "hoodie.index.hbase.zknode.path";
    public static final String HBASE_TABLENAME_PROP = "hoodie.index.hbase.table";
    public static final String HBASE_GET_BATCH_SIZE_PROP = "hoodie.index.hbase.get.batch.size";
    public static final String HBASE_PUT_BATCH_SIZE_PROP = "hoodie.index.hbase.put.batch.size";
    public static final String DEFAULT_HBASE_BATCH_SIZE = "100";
    public static final String BLOOM_INDEX_INPUT_STORAGE_LEVEL = "hoodie.bloom.index.input.storage.level";
    public static final String DEFAULT_BLOOM_INDEX_INPUT_STORAGE_LEVEL = "MEMORY_AND_DISK_SER";
    public static final String SIMPLE_INDEX_INPUT_STORAGE_LEVEL = "hoodie.simple.index.input.storage.level";
    public static final String DEFAULT_SIMPLE_INDEX_INPUT_STORAGE_LEVEL = "MEMORY_AND_DISK_SER";
    public static final String BLOOM_INDEX_UPDATE_PARTITION_PATH = "hoodie.bloom.index.update.partition.path";
    public static final String DEFAULT_BLOOM_INDEX_UPDATE_PARTITION_PATH = "false";
    public static final String SIMPLE_INDEX_UPDATE_PARTITION_PATH = "hoodie.simple.index.update.partition.path";
    public static final String DEFAULT_SIMPLE_INDEX_UPDATE_PARTITION_PATH = "false";
    private EngineType engineType;

    private HoodieIndexConfig(Properties props) {
        this(EngineType.SPARK, props);
    }

    private HoodieIndexConfig(EngineType engineType, Properties props) {
        super(props);
        this.engineType = engineType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private EngineType engineType = EngineType.SPARK;
        private final Properties props = new Properties();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withIndexType(HoodieIndex.IndexType indexType) {
            this.props.setProperty(HoodieIndexConfig.INDEX_TYPE_PROP, indexType.name());
            return this;
        }

        public Builder withIndexClass(String indexClass) {
            this.props.setProperty(HoodieIndexConfig.INDEX_CLASS_PROP, indexClass);
            return this;
        }

        public Builder withHBaseIndexConfig(HoodieHBaseIndexConfig hBaseIndexConfig) {
            this.props.putAll((Map<?, ?>)hBaseIndexConfig.getProps());
            return this;
        }

        public Builder bloomFilterNumEntries(int numEntries) {
            this.props.setProperty(HoodieIndexConfig.BLOOM_FILTER_NUM_ENTRIES, String.valueOf(numEntries));
            return this;
        }

        public Builder bloomFilterFPP(double fpp) {
            this.props.setProperty(HoodieIndexConfig.BLOOM_FILTER_FPP, String.valueOf(fpp));
            return this;
        }

        public Builder hbaseZkQuorum(String zkString) {
            this.props.setProperty(HoodieIndexConfig.HBASE_ZKQUORUM_PROP, zkString);
            return this;
        }

        public Builder hbaseZkPort(int port) {
            this.props.setProperty(HoodieIndexConfig.HBASE_ZKPORT_PROP, String.valueOf(port));
            return this;
        }

        public Builder hbaseZkZnodeParent(String zkZnodeParent) {
            this.props.setProperty(HoodieIndexConfig.HBASE_ZK_ZNODEPARENT, zkZnodeParent);
            return this;
        }

        public Builder hbaseTableName(String tableName) {
            this.props.setProperty(HoodieIndexConfig.HBASE_TABLENAME_PROP, tableName);
            return this;
        }

        public Builder bloomIndexParallelism(int parallelism) {
            this.props.setProperty(HoodieIndexConfig.BLOOM_INDEX_PARALLELISM_PROP, String.valueOf(parallelism));
            return this;
        }

        public Builder bloomIndexPruneByRanges(boolean pruneRanges) {
            this.props.setProperty(HoodieIndexConfig.BLOOM_INDEX_PRUNE_BY_RANGES_PROP, String.valueOf(pruneRanges));
            return this;
        }

        public Builder bloomIndexUseCaching(boolean useCaching) {
            this.props.setProperty(HoodieIndexConfig.BLOOM_INDEX_USE_CACHING_PROP, String.valueOf(useCaching));
            return this;
        }

        public Builder bloomIndexTreebasedFilter(boolean useTreeFilter) {
            this.props.setProperty(HoodieIndexConfig.BLOOM_INDEX_TREE_BASED_FILTER_PROP, String.valueOf(useTreeFilter));
            return this;
        }

        public Builder bloomIndexBucketizedChecking(boolean bucketizedChecking) {
            this.props.setProperty(HoodieIndexConfig.BLOOM_INDEX_BUCKETIZED_CHECKING_PROP, String.valueOf(bucketizedChecking));
            return this;
        }

        public Builder bloomIndexKeysPerBucket(int keysPerBucket) {
            this.props.setProperty(HoodieIndexConfig.BLOOM_INDEX_KEYS_PER_BUCKET_PROP, String.valueOf(keysPerBucket));
            return this;
        }

        public Builder withBloomIndexInputStorageLevel(String level) {
            this.props.setProperty(HoodieIndexConfig.BLOOM_INDEX_INPUT_STORAGE_LEVEL, level);
            return this;
        }

        public Builder withBloomIndexUpdatePartitionPath(boolean updatePartitionPath) {
            this.props.setProperty(HoodieIndexConfig.BLOOM_INDEX_UPDATE_PARTITION_PATH, String.valueOf(updatePartitionPath));
            return this;
        }

        public Builder withSimpleIndexParallelism(int parallelism) {
            this.props.setProperty(HoodieIndexConfig.SIMPLE_INDEX_PARALLELISM_PROP, String.valueOf(parallelism));
            return this;
        }

        public Builder simpleIndexUseCaching(boolean useCaching) {
            this.props.setProperty(HoodieIndexConfig.SIMPLE_INDEX_USE_CACHING_PROP, String.valueOf(useCaching));
            return this;
        }

        public Builder withSimpleIndexInputStorageLevel(String level) {
            this.props.setProperty(HoodieIndexConfig.SIMPLE_INDEX_INPUT_STORAGE_LEVEL, level);
            return this;
        }

        public Builder withGlobalSimpleIndexParallelism(int parallelism) {
            this.props.setProperty(HoodieIndexConfig.GLOBAL_SIMPLE_INDEX_PARALLELISM_PROP, String.valueOf(parallelism));
            return this;
        }

        public Builder withGlobalSimpleIndexUpdatePartitionPath(boolean updatePartitionPath) {
            this.props.setProperty(HoodieIndexConfig.SIMPLE_INDEX_UPDATE_PARTITION_PATH, String.valueOf(updatePartitionPath));
            return this;
        }

        public Builder withEngineType(EngineType engineType) {
            this.engineType = engineType;
            return this;
        }

        public HoodieIndexConfig build() {
            HoodieIndexConfig config = new HoodieIndexConfig(this.engineType, this.props);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.INDEX_TYPE_PROP), HoodieIndexConfig.INDEX_TYPE_PROP, this.getDefaultIndexType(this.engineType));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.INDEX_CLASS_PROP), HoodieIndexConfig.INDEX_CLASS_PROP, HoodieIndexConfig.DEFAULT_INDEX_CLASS);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.BLOOM_FILTER_NUM_ENTRIES), HoodieIndexConfig.BLOOM_FILTER_NUM_ENTRIES, HoodieIndexConfig.DEFAULT_BLOOM_FILTER_NUM_ENTRIES);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.BLOOM_FILTER_FPP), HoodieIndexConfig.BLOOM_FILTER_FPP, HoodieIndexConfig.DEFAULT_BLOOM_FILTER_FPP);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.BLOOM_INDEX_PARALLELISM_PROP), HoodieIndexConfig.BLOOM_INDEX_PARALLELISM_PROP, HoodieIndexConfig.DEFAULT_BLOOM_INDEX_PARALLELISM);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.BLOOM_INDEX_PRUNE_BY_RANGES_PROP), HoodieIndexConfig.BLOOM_INDEX_PRUNE_BY_RANGES_PROP, "true");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.BLOOM_INDEX_USE_CACHING_PROP), HoodieIndexConfig.BLOOM_INDEX_USE_CACHING_PROP, "true");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.BLOOM_INDEX_INPUT_STORAGE_LEVEL), HoodieIndexConfig.BLOOM_INDEX_INPUT_STORAGE_LEVEL, "MEMORY_AND_DISK_SER");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.BLOOM_INDEX_UPDATE_PARTITION_PATH), HoodieIndexConfig.BLOOM_INDEX_UPDATE_PARTITION_PATH, "false");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.BLOOM_INDEX_TREE_BASED_FILTER_PROP), HoodieIndexConfig.BLOOM_INDEX_TREE_BASED_FILTER_PROP, "true");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.BLOOM_INDEX_BUCKETIZED_CHECKING_PROP), HoodieIndexConfig.BLOOM_INDEX_BUCKETIZED_CHECKING_PROP, "true");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.BLOOM_INDEX_KEYS_PER_BUCKET_PROP), HoodieIndexConfig.BLOOM_INDEX_KEYS_PER_BUCKET_PROP, HoodieIndexConfig.DEFAULT_BLOOM_INDEX_KEYS_PER_BUCKET);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.BLOOM_INDEX_FILTER_TYPE), HoodieIndexConfig.BLOOM_INDEX_FILTER_TYPE, DEFAULT_BLOOM_INDEX_FILTER_TYPE);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.HOODIE_BLOOM_INDEX_FILTER_DYNAMIC_MAX_ENTRIES), HoodieIndexConfig.HOODIE_BLOOM_INDEX_FILTER_DYNAMIC_MAX_ENTRIES, HoodieIndexConfig.DEFAULT_HOODIE_BLOOM_INDEX_FILTER_DYNAMIC_MAX_ENTRIES);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.SIMPLE_INDEX_PARALLELISM_PROP), HoodieIndexConfig.SIMPLE_INDEX_PARALLELISM_PROP, HoodieIndexConfig.DEFAULT_SIMPLE_INDEX_PARALLELISM);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.SIMPLE_INDEX_USE_CACHING_PROP), HoodieIndexConfig.SIMPLE_INDEX_USE_CACHING_PROP, "true");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.SIMPLE_INDEX_INPUT_STORAGE_LEVEL), HoodieIndexConfig.SIMPLE_INDEX_INPUT_STORAGE_LEVEL, "MEMORY_AND_DISK_SER");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.GLOBAL_SIMPLE_INDEX_PARALLELISM_PROP), HoodieIndexConfig.GLOBAL_SIMPLE_INDEX_PARALLELISM_PROP, "100");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieIndexConfig.SIMPLE_INDEX_UPDATE_PARTITION_PATH), HoodieIndexConfig.SIMPLE_INDEX_UPDATE_PARTITION_PATH, "false");
            HoodieIndex.IndexType.valueOf(this.props.getProperty(HoodieIndexConfig.INDEX_TYPE_PROP));
            return config;
        }

        private String getDefaultIndexType(EngineType engineType) {
            switch (engineType) {
                case SPARK: {
                    return HoodieIndex.IndexType.BLOOM.name();
                }
                case FLINK: 
                case JAVA: {
                    return HoodieIndex.IndexType.INMEMORY.name();
                }
            }
            throw new HoodieNotSupportedException("Unsupported engine " + (Object)((Object)engineType));
        }

        public EngineType getEngineType() {
            return this.engineType;
        }
    }
}

