/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.client.transaction.ConflictResolutionStrategy;
import org.apache.hudi.client.transaction.SimpleConcurrentFileWritesConflictResolutionStrategy;
import org.apache.hudi.client.transaction.lock.ZookeeperBasedLockProvider;
import org.apache.hudi.common.config.DefaultHoodieConfig;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.lock.LockProvider;

public class HoodieLockConfig
extends DefaultHoodieConfig {
    public static final String LOCK_PROVIDER_CLASS_PROP = "hoodie.write.lock.provider";
    public static final String DEFAULT_LOCK_PROVIDER_CLASS = ZookeeperBasedLockProvider.class.getName();
    public static final String WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_PROP = "hoodie.write.lock.conflict.resolution.strategy";
    public static final String DEFAULT_WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS = SimpleConcurrentFileWritesConflictResolutionStrategy.class.getName();

    private HoodieLockConfig(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Properties props = new Properties();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withLockProvider(Class<? extends LockProvider> lockProvider) {
            this.props.setProperty(HoodieLockConfig.LOCK_PROVIDER_CLASS_PROP, lockProvider.getName());
            return this;
        }

        public Builder withHiveDatabaseName(String databaseName) {
            this.props.setProperty("hoodie.write.lock.hivemetastore.database", databaseName);
            return this;
        }

        public Builder withHiveTableName(String tableName) {
            this.props.setProperty("hoodie.write.lock.hivemetastore.table", tableName);
            return this;
        }

        public Builder withHiveMetastoreURIs(String hiveMetastoreURIs) {
            this.props.setProperty("hoodie.write.lock.hivemetastore.uris", hiveMetastoreURIs);
            return this;
        }

        public Builder withZkQuorum(String zkQuorum) {
            this.props.setProperty("hoodie.write.lock.zookeeper.url", zkQuorum);
            return this;
        }

        public Builder withZkBasePath(String zkBasePath) {
            this.props.setProperty("hoodie.write.lock.zookeeper.base_path", zkBasePath);
            return this;
        }

        public Builder withZkPort(String zkPort) {
            this.props.setProperty("hoodie.write.lock.zookeeper.port", zkPort);
            return this;
        }

        public Builder withZkLockKey(String zkLockKey) {
            this.props.setProperty("hoodie.write.lock.zookeeper.lock_key", zkLockKey);
            return this;
        }

        public Builder withZkConnectionTimeoutInMs(Long connectionTimeoutInMs) {
            this.props.setProperty("hoodie.write.lock.zookeeper.connection_timeout_ms", String.valueOf(connectionTimeoutInMs));
            return this;
        }

        public Builder withZkSessionTimeoutInMs(Long sessionTimeoutInMs) {
            this.props.setProperty("hoodie.write.lock.zookeeper.session_timeout_ms", String.valueOf(sessionTimeoutInMs));
            return this;
        }

        public Builder withNumRetries(int numRetries) {
            this.props.setProperty("hoodie.write.lock.num_retries", String.valueOf(numRetries));
            return this;
        }

        public Builder withRetryWaitTimeInMillis(Long retryWaitTimeInMillis) {
            this.props.setProperty("hoodie.write.lock.wait_time_ms_between_retry", String.valueOf(retryWaitTimeInMillis));
            return this;
        }

        public Builder withRetryMaxWaitTimeInMillis(Long retryMaxWaitTimeInMillis) {
            this.props.setProperty("hoodie.write.lock.max_wait_time_ms_between_retry", String.valueOf(retryMaxWaitTimeInMillis));
            return this;
        }

        public Builder withClientNumRetries(int clientNumRetries) {
            this.props.setProperty("hoodie.write.lock.client.num_retries", String.valueOf(clientNumRetries));
            return this;
        }

        public Builder withClientRetryWaitTimeInMillis(Long clientRetryWaitTimeInMillis) {
            this.props.setProperty("hoodie.write.lock.client.wait_time_ms_between_retry", String.valueOf(clientRetryWaitTimeInMillis));
            return this;
        }

        public Builder withLockWaitTimeInMillis(Long waitTimeInMillis) {
            this.props.setProperty("hoodie.write.lock.wait_time_ms", String.valueOf(waitTimeInMillis));
            return this;
        }

        public Builder withConflictResolutionStrategy(ConflictResolutionStrategy conflictResolutionStrategy) {
            this.props.setProperty(HoodieLockConfig.WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_PROP, conflictResolutionStrategy.getClass().getName());
            return this;
        }

        public HoodieLockConfig build() {
            HoodieLockConfig config = new HoodieLockConfig(this.props);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieLockConfig.LOCK_PROVIDER_CLASS_PROP), HoodieLockConfig.LOCK_PROVIDER_CLASS_PROP, DEFAULT_LOCK_PROVIDER_CLASS);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieLockConfig.WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_PROP), HoodieLockConfig.WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_PROP, DEFAULT_WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey("hoodie.write.lock.num_retries"), "hoodie.write.lock.num_retries", LockConfiguration.DEFAULT_LOCK_ACQUIRE_NUM_RETRIES);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey("hoodie.write.lock.wait_time_ms_between_retry"), "hoodie.write.lock.wait_time_ms_between_retry", LockConfiguration.DEFAULT_LOCK_ACQUIRE_RETRY_WAIT_TIME_IN_MILLIS);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey("hoodie.write.lock.max_wait_time_ms_between_retry"), "hoodie.write.lock.max_wait_time_ms_between_retry", LockConfiguration.DEFAULT_LOCK_ACQUIRE_MAX_RETRY_WAIT_TIME_IN_MILLIS);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey("hoodie.write.lock.client.num_retries"), "hoodie.write.lock.client.num_retries", LockConfiguration.DEFAULT_LOCK_ACQUIRE_CLIENT_NUM_RETRIES);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey("hoodie.write.lock.client.wait_time_ms_between_retry"), "hoodie.write.lock.client.wait_time_ms_between_retry", LockConfiguration.DEFAULT_LOCK_ACQUIRE_CLIENT_RETRY_WAIT_TIME_IN_MILLIS);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey("hoodie.write.lock.zookeeper.connection_timeout_ms"), "hoodie.write.lock.zookeeper.connection_timeout_ms", String.valueOf(15000));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey("hoodie.write.lock.zookeeper.session_timeout_ms"), "hoodie.write.lock.zookeeper.session_timeout_ms", String.valueOf(60000));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey("hoodie.write.lock.wait_time_ms"), "hoodie.write.lock.wait_time_ms", String.valueOf(60000));
            return config;
        }
    }
}

