/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.DefaultHoodieConfig;
import org.apache.hudi.common.model.HoodiePayloadProps;

public class HoodiePayloadConfig
extends DefaultHoodieConfig {
    public HoodiePayloadConfig(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Properties props = new Properties();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withPayloadOrderingField(String payloadOrderingField) {
            this.props.setProperty("hoodie.payload.ordering.field", String.valueOf(payloadOrderingField));
            return this;
        }

        public Builder withPayloadEventTimeField(String payloadEventTimeField) {
            this.props.setProperty("hoodie.payload.event.time.field", String.valueOf(payloadEventTimeField));
            return this;
        }

        public HoodiePayloadConfig build() {
            HoodiePayloadConfig config = new HoodiePayloadConfig(this.props);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey("hoodie.payload.ordering.field"), "hoodie.payload.ordering.field", String.valueOf(HoodiePayloadProps.DEFAULT_PAYLOAD_ORDERING_FIELD_VAL));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey("hoodie.payload.event.time.field"), "hoodie.payload.event.time.field", String.valueOf(HoodiePayloadProps.DEFAULT_PAYLOAD_EVENT_TIME_FIELD_VAL));
            return config;
        }
    }
}

