/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.DefaultHoodieConfig;

public class HoodieWriteCommitCallbackConfig
extends DefaultHoodieConfig {
    public static final String CALLBACK_PREFIX = "hoodie.write.commit.callback.";
    public static final String CALLBACK_ON = "hoodie.write.commit.callback.on";
    public static final boolean DEFAULT_CALLBACK_ON = false;
    public static final String CALLBACK_CLASS_PROP = "hoodie.write.commit.callback.class";
    public static final String DEFAULT_CALLBACK_CLASS_PROP = "org.apache.hudi.callback.impl.HoodieWriteCommitHttpCallback";
    public static final String CALLBACK_HTTP_URL_PROP = "hoodie.write.commit.callback.http.url";
    public static final String CALLBACK_HTTP_API_KEY = "hoodie.write.commit.callback.http.api.key";
    public static final String DEFAULT_CALLBACK_HTTP_API_KEY = "hudi_write_commit_http_callback";
    public static final String CALLBACK_HTTP_TIMEOUT_SECONDS = "hoodie.write.commit.callback.http.timeout.seconds";
    public static final int DEFAULT_CALLBACK_HTTP_TIMEOUT_SECONDS = 3;

    private HoodieWriteCommitCallbackConfig(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Properties props = new Properties();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder writeCommitCallbackOn(String callbackOn) {
            this.props.setProperty(HoodieWriteCommitCallbackConfig.CALLBACK_ON, callbackOn);
            return this;
        }

        public Builder withCallbackClass(String callbackClass) {
            this.props.setProperty(HoodieWriteCommitCallbackConfig.CALLBACK_CLASS_PROP, callbackClass);
            return this;
        }

        public Builder withCallbackHttpUrl(String url) {
            this.props.setProperty(HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_URL_PROP, url);
            return this;
        }

        public Builder withCallbackHttpTimeoutSeconds(String timeoutSeconds) {
            this.props.setProperty(HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_TIMEOUT_SECONDS, timeoutSeconds);
            return this;
        }

        public Builder withCallbackHttpApiKey(String apiKey) {
            this.props.setProperty(HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_API_KEY, apiKey);
            return this;
        }

        public HoodieWriteCommitCallbackConfig build() {
            HoodieWriteCommitCallbackConfig config = new HoodieWriteCommitCallbackConfig(this.props);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteCommitCallbackConfig.CALLBACK_ON), HoodieWriteCommitCallbackConfig.CALLBACK_ON, String.valueOf(false));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteCommitCallbackConfig.CALLBACK_CLASS_PROP), HoodieWriteCommitCallbackConfig.CALLBACK_CLASS_PROP, HoodieWriteCommitCallbackConfig.DEFAULT_CALLBACK_CLASS_PROP);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_API_KEY), HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_API_KEY, HoodieWriteCommitCallbackConfig.DEFAULT_CALLBACK_HTTP_API_KEY);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_TIMEOUT_SECONDS), HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_TIMEOUT_SECONDS, String.valueOf(3));
            return config;
        }
    }
}

