/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.exception;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;

public class TableNotFoundException
extends HoodieException {
    public TableNotFoundException(String basePath) {
        super(TableNotFoundException.getErrorMessage(basePath));
    }

    private static String getErrorMessage(String basePath) {
        return "Hoodie table not found in path " + basePath;
    }

    public static void checkTableValidity(FileSystem fs, Path basePathDir, Path metaPathDir) {
        try {
            FileStatus status = fs.getFileStatus(metaPathDir);
            if (!status.isDirectory()) {
                throw new TableNotFoundException(metaPathDir.toString());
            }
        }
        catch (FileNotFoundException | IllegalArgumentException e) {
            throw new TableNotFoundException(metaPathDir.toString());
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not check if " + basePathDir + " is a valid table", e);
        }
    }
}

