/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.LogReaderUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.InputSplitUtils;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;
import org.apache.hudi.hadoop.utils.HoodieRealtimeRecordReaderUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractRealtimeRecordReader {
    private static final Logger LOG = LogManager.getLogger(AbstractRealtimeRecordReader.class);
    protected final RealtimeSplit split;
    protected final JobConf jobConf;
    protected final boolean usesCustomPayload;
    private Schema readerSchema;
    private Schema writerSchema;
    private Schema hiveSchema;

    public AbstractRealtimeRecordReader(RealtimeSplit split, JobConf job) {
        this.split = split;
        this.jobConf = job;
        LOG.info((Object)("cfg ==> " + job.get("hive.io.file.readcolumn.names")));
        LOG.info((Object)("columnIds ==> " + job.get("hive.io.file.readcolumn.ids")));
        LOG.info((Object)("partitioningColumns ==> " + job.get("partition_columns", "")));
        try {
            this.usesCustomPayload = this.usesCustomPayload();
            LOG.info((Object)("usesCustomPayload ==> " + this.usesCustomPayload));
            this.init();
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not create HoodieRealtimeRecordReader on path " + this.split.getPath(), e);
        }
    }

    private boolean usesCustomPayload() {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf((Configuration)this.jobConf).setBasePath(this.split.getBasePath()).build();
        return !metaClient.getTableConfig().getPayloadClass().contains(HoodieAvroPayload.class.getName()) && !metaClient.getTableConfig().getPayloadClass().contains("org.apache.hudi.OverwriteWithLatestAvroPayload");
    }

    private void init() throws IOException {
        Schema schemaFromLogFile = LogReaderUtils.readLatestSchemaFromLogFiles(this.split.getBasePath(), this.split.getDeltaLogPaths(), (Configuration)this.jobConf);
        if (schemaFromLogFile == null) {
            this.writerSchema = InputSplitUtils.getBaseFileSchema((FileSplit)this.split, (Configuration)this.jobConf);
            LOG.info((Object)("Writer Schema From Parquet => " + this.writerSchema.getFields()));
        } else {
            this.writerSchema = schemaFromLogFile;
            LOG.info((Object)("Writer Schema From Log => " + this.writerSchema.toString(true)));
        }
        String partitionFields = this.jobConf.get("partition_columns", "");
        ArrayList<String> partitioningFields = partitionFields.length() > 0 ? Arrays.stream(partitionFields.split("/")).collect(Collectors.toList()) : new ArrayList<String>();
        this.writerSchema = HoodieRealtimeRecordReaderUtils.addPartitionFields(this.writerSchema, partitioningFields);
        List<String> projectionFields = HoodieRealtimeRecordReaderUtils.orderFields(this.jobConf.get("hive.io.file.readcolumn.names"), this.jobConf.get("hive.io.file.readcolumn.ids"), partitioningFields);
        Map<String, Schema.Field> schemaFieldsMap = HoodieRealtimeRecordReaderUtils.getNameToFieldMap(this.writerSchema);
        this.hiveSchema = this.constructHiveOrderedSchema(this.writerSchema, schemaFieldsMap);
        this.readerSchema = HoodieRealtimeRecordReaderUtils.generateProjectionSchema(this.writerSchema, schemaFieldsMap, projectionFields);
        LOG.info((Object)String.format("About to read compacted logs %s for base split %s, projecting cols %s", this.split.getDeltaLogPaths(), this.split.getPath(), projectionFields));
    }

    private Schema constructHiveOrderedSchema(Schema writerSchema, Map<String, Schema.Field> schemaFieldsMap) {
        String hiveColumnString = this.jobConf.get("columns");
        LOG.info((Object)("Hive Columns : " + hiveColumnString));
        String[] hiveColumns = hiveColumnString.split(",");
        LOG.info((Object)("Hive Columns : " + hiveColumnString));
        ArrayList<Schema.Field> hiveSchemaFields = new ArrayList<Schema.Field>();
        for (String columnName : hiveColumns) {
            Schema.Field field = schemaFieldsMap.get(columnName.toLowerCase());
            if (field != null) {
                hiveSchemaFields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal()));
                continue;
            }
            LOG.debug((Object)("Skipping Hive Column => " + columnName));
        }
        Schema hiveSchema = Schema.createRecord((String)writerSchema.getName(), (String)writerSchema.getDoc(), (String)writerSchema.getNamespace(), (boolean)writerSchema.isError());
        hiveSchema.setFields(hiveSchemaFields);
        LOG.debug((Object)("HIVE Schema is :" + hiveSchema.toString(true)));
        return hiveSchema;
    }

    public Schema getReaderSchema() {
        return this.readerSchema;
    }

    public Schema getWriterSchema() {
        return this.writerSchema;
    }

    public Schema getHiveSchema() {
        return this.hiveSchema;
    }
}

