/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.lock.LockState;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class HiveMetastoreBasedLockProvider
implements LockProvider<LockResponse> {
    private static final Logger LOG = LogManager.getLogger(HiveMetastoreBasedLockProvider.class);
    private final String databaseName;
    private final String tableName;
    private final String hiveMetastoreUris;
    private IMetaStoreClient hiveClient;
    private volatile LockResponse lock = null;
    protected LockConfiguration lockConfiguration;
    ExecutorService executor = Executors.newSingleThreadExecutor();

    public HiveMetastoreBasedLockProvider(LockConfiguration lockConfiguration, Configuration conf) {
        this(lockConfiguration);
        try {
            HiveConf hiveConf = new HiveConf();
            this.setHiveLockConfs(hiveConf);
            hiveConf.addResource(conf);
            this.hiveClient = Hive.get((HiveConf)hiveConf).getMSC();
        }
        catch (MetaException | HiveException e) {
            throw new HoodieLockException("Failed to create HiveMetaStoreClient", e);
        }
    }

    public HiveMetastoreBasedLockProvider(LockConfiguration lockConfiguration, IMetaStoreClient metaStoreClient) {
        this(lockConfiguration);
        this.hiveClient = metaStoreClient;
    }

    HiveMetastoreBasedLockProvider(LockConfiguration lockConfiguration) {
        this.checkRequiredProps(lockConfiguration);
        this.lockConfiguration = lockConfiguration;
        this.databaseName = this.lockConfiguration.getConfig().getString("hoodie.write.lock.hivemetastore.database");
        this.tableName = this.lockConfiguration.getConfig().getString("hoodie.write.lock.hivemetastore.table");
        this.hiveMetastoreUris = this.lockConfiguration.getConfig().getOrDefault((Object)"hoodie.write.lock.hivemetastore.uris", "").toString();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) {
        LOG.info((Object)this.generateLogStatement(LockState.ACQUIRING, this.generateLogSuffixString()));
        try {
            this.acquireLock(time, unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException | TException e) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE, this.generateLogSuffixString()), e);
        }
        return this.lock != null && this.lock.getState() == org.apache.hadoop.hive.metastore.api.LockState.ACQUIRED;
    }

    @Override
    public void unlock() {
        try {
            LOG.info((Object)this.generateLogStatement(LockState.RELEASING, this.generateLogSuffixString()));
            LockResponse lockResponseLocal = this.lock;
            if (lockResponseLocal == null) {
                return;
            }
            this.lock = null;
            this.hiveClient.unlock(lockResponseLocal.getLockid());
            LOG.info((Object)this.generateLogStatement(LockState.RELEASED, this.generateLogSuffixString()));
        }
        catch (TException e) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_RELEASE, this.generateLogSuffixString()), e);
        }
    }

    public void acquireLock(long time, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException, TException {
        ValidationUtils.checkArgument(this.lock == null, LockState.ALREADY_ACQUIRED.name());
        LockComponent lockComponent = new LockComponent(LockType.EXCLUSIVE, LockLevel.TABLE, this.databaseName);
        lockComponent.setTablename(this.tableName);
        this.acquireLockInternal(time, unit, lockComponent);
    }

    @Override
    public void close() {
        try {
            if (this.lock != null) {
                this.hiveClient.unlock(this.lock.getLockid());
            }
            this.hiveClient.close();
        }
        catch (Exception e) {
            LOG.error((Object)this.generateLogStatement(LockState.FAILED_TO_RELEASE, this.generateLogSuffixString()));
        }
    }

    public IMetaStoreClient getHiveClient() {
        return this.hiveClient;
    }

    @Override
    public LockResponse getLock() {
        return this.lock;
    }

    public boolean acquireLock(long time, TimeUnit unit, LockComponent component) throws InterruptedException, ExecutionException, TimeoutException, TException {
        ValidationUtils.checkArgument(this.lock == null, LockState.ALREADY_ACQUIRED.name());
        this.acquireLockInternal(time, unit, component);
        return this.lock != null && this.lock.getState() == org.apache.hadoop.hive.metastore.api.LockState.ACQUIRED;
    }

    private void acquireLockInternal(long time, TimeUnit unit, LockComponent lockComponent) throws InterruptedException, ExecutionException, TimeoutException, TException {
        LockRequest lockRequest = null;
        try {
            LockRequestBuilder builder = new LockRequestBuilder();
            lockRequest = builder.addLockComponent(lockComponent).setUser(System.getProperty("user.name")).build();
            lockRequest.setUserIsSet(true);
            LockRequest lockRequestFinal = lockRequest;
            this.lock = this.executor.submit(() -> this.hiveClient.lock(lockRequestFinal)).get(time, unit);
        }
        catch (InterruptedException | TimeoutException e) {
            if (this.lock != null && this.lock.getState() == org.apache.hadoop.hive.metastore.api.LockState.ACQUIRED) {
                return;
            }
            if (lockRequest != null) {
                LockResponse lockResponse = this.hiveClient.checkLock(lockRequest.getTxnid());
                if (lockResponse.getState() == org.apache.hadoop.hive.metastore.api.LockState.ACQUIRED) {
                    this.lock = lockResponse;
                    return;
                }
                throw e;
            }
            throw e;
        }
    }

    private void checkRequiredProps(LockConfiguration lockConfiguration) {
        ValidationUtils.checkArgument(lockConfiguration.getConfig().getString("hoodie.write.lock.hivemetastore.database") != null);
        ValidationUtils.checkArgument(lockConfiguration.getConfig().getString("hoodie.write.lock.hivemetastore.table") != null);
    }

    private void setHiveLockConfs(HiveConf hiveConf) {
        String zkSessionTimeout;
        String zkPort;
        if (!StringUtils.isNullOrEmpty(this.hiveMetastoreUris)) {
            hiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, this.hiveMetastoreUris);
        }
        hiveConf.set("hive.support.concurrency", "true");
        hiveConf.set("hive.lock.manager", "org.apache.hadoop.hive.ql.lockmgr.zookeeper.ZooKeeperHiveLockManager");
        hiveConf.set("hive.lock.numretries", this.lockConfiguration.getConfig().getString("hoodie.write.lock.num_retries"));
        hiveConf.set("hive.unlock.numretries", this.lockConfiguration.getConfig().getString("hoodie.write.lock.num_retries"));
        hiveConf.set("hive.lock.sleep.between.retries", this.lockConfiguration.getConfig().getString("hoodie.write.lock.wait_time_ms_between_retry"));
        String zkConnectUrl = this.lockConfiguration.getConfig().getOrDefault((Object)"hoodie.write.lock.zookeeper.url", "").toString();
        if (zkConnectUrl.length() > 0) {
            hiveConf.set("hive.zookeeper.quorum", zkConnectUrl);
        }
        if ((zkPort = this.lockConfiguration.getConfig().getOrDefault((Object)"hoodie.write.lock.zookeeper.port", "").toString()).length() > 0) {
            hiveConf.set("hive.zookeeper.client.port", zkPort);
        }
        if ((zkSessionTimeout = this.lockConfiguration.getConfig().getOrDefault((Object)"hoodie.write.lock.zookeeper.session_timeout_ms", "").toString()).length() > 0) {
            hiveConf.set("hive.zookeeper.session.timeout", zkSessionTimeout);
        }
    }

    private String generateLogSuffixString() {
        return StringUtils.join(" database ", this.databaseName, " and ", "table ", this.tableName);
    }

    protected String generateLogStatement(LockState state, String suffix) {
        return StringUtils.join(state.name(), " lock at", suffix);
    }
}

