/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.SparkInMemoryHashIndex;
import org.apache.hudi.index.bloom.SparkHoodieBloomIndex;
import org.apache.hudi.index.bloom.SparkHoodieGlobalBloomIndex;
import org.apache.hudi.index.hbase.SparkHoodieHBaseIndex;
import org.apache.hudi.index.simple.SparkHoodieGlobalSimpleIndex;
import org.apache.hudi.index.simple.SparkHoodieSimpleIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.JavaRDD;

public abstract class SparkHoodieIndex<T extends HoodieRecordPayload>
extends HoodieIndex<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    protected SparkHoodieIndex(HoodieWriteConfig config) {
        super(config);
    }

    public static SparkHoodieIndex createIndex(HoodieWriteConfig config) {
        if (!StringUtils.isNullOrEmpty(config.getIndexClass())) {
            Object instance = ReflectionUtils.loadClass(config.getIndexClass(), config);
            if (!(instance instanceof HoodieIndex)) {
                throw new HoodieIndexException(config.getIndexClass() + " is not a subclass of HoodieIndex");
            }
            return (SparkHoodieIndex)instance;
        }
        switch (config.getIndexType()) {
            case HBASE: {
                return new SparkHoodieHBaseIndex(config);
            }
            case INMEMORY: {
                return new SparkInMemoryHashIndex(config);
            }
            case BLOOM: {
                return new SparkHoodieBloomIndex(config);
            }
            case GLOBAL_BLOOM: {
                return new SparkHoodieGlobalBloomIndex(config);
            }
            case SIMPLE: {
                return new SparkHoodieSimpleIndex(config);
            }
            case GLOBAL_SIMPLE: {
                return new SparkHoodieGlobalSimpleIndex(config);
            }
        }
        throw new HoodieIndexException("Index type unspecified, set " + (Object)((Object)config.getIndexType()));
    }

    @Override
    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public abstract JavaRDD<WriteStatus> updateLocation(JavaRDD<WriteStatus> var1, HoodieEngineContext var2, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> var3) throws HoodieIndexException;

    @Override
    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public abstract JavaRDD<HoodieRecord<T>> tagLocation(JavaRDD<HoodieRecord<T>> var1, HoodieEngineContext var2, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> var3) throws HoodieIndexException;
}

