/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieHFileConfig;

public class HoodieHFileWriter<T extends HoodieRecordPayload, R extends IndexedRecord>
implements HoodieFileWriter<R> {
    private static AtomicLong recordIndex = new AtomicLong(1L);
    private final Path file;
    private HoodieHFileConfig hfileConfig;
    private final HoodieWrapperFileSystem fs;
    private final long maxFileSize;
    private final String instantTime;
    private final TaskContextSupplier taskContextSupplier;
    private HFile.Writer writer;
    private String minRecordKey;
    private String maxRecordKey;
    private static String DROP_BEHIND_CACHE_COMPACTION_KEY = "hbase.hfile.drop.behind.compaction";

    public HoodieHFileWriter(String instantTime, Path file, HoodieHFileConfig hfileConfig, Schema schema2, TaskContextSupplier taskContextSupplier) throws IOException {
        Configuration conf = FSUtils.registerFileSystem(file, hfileConfig.getHadoopConf());
        this.file = HoodieWrapperFileSystem.convertToHoodiePath(file, conf);
        this.fs = (HoodieWrapperFileSystem)this.file.getFileSystem(conf);
        this.hfileConfig = hfileConfig;
        this.maxFileSize = hfileConfig.getMaxFileSize();
        this.instantTime = instantTime;
        this.taskContextSupplier = taskContextSupplier;
        HFileContext context = new HFileContextBuilder().withBlockSize(hfileConfig.getBlockSize()).withCompression(hfileConfig.getCompressionAlgorithm()).build();
        conf.set("hbase.rs.prefetchblocksonopen", String.valueOf(hfileConfig.shouldPrefetchBlocksOnOpen()));
        conf.set("CACHE_DATA_IN_L1", String.valueOf(hfileConfig.shouldCacheDataInL1()));
        conf.set(DROP_BEHIND_CACHE_COMPACTION_KEY, String.valueOf(hfileConfig.shouldDropBehindCacheCompaction()));
        CacheConfig cacheConfig = new CacheConfig(conf);
        this.writer = HFile.getWriterFactory(conf, cacheConfig).withPath(this.fs, this.file).withFileContext(context).create();
        this.writer.appendFileInfo("schema".getBytes(), schema2.toString().getBytes());
    }

    @Override
    public void writeAvroWithMetadata(R avroRecord, HoodieRecord record) throws IOException {
        String seqId = HoodieRecord.generateSequenceId(this.instantTime, this.taskContextSupplier.getPartitionIdSupplier().get(), recordIndex.getAndIncrement());
        HoodieAvroUtils.addHoodieKeyToRecord((GenericRecord)avroRecord, record.getRecordKey(), record.getPartitionPath(), this.file.getName());
        HoodieAvroUtils.addCommitMetadataToRecord((GenericRecord)avroRecord, this.instantTime, seqId);
        this.writeAvro(record.getRecordKey(), (IndexedRecord)avroRecord);
    }

    @Override
    public boolean canWrite() {
        return this.fs.getBytesWritten(this.file) < this.maxFileSize;
    }

    @Override
    public void writeAvro(String recordKey, IndexedRecord object) throws IOException {
        byte[] value = HoodieAvroUtils.avroToBytes((GenericRecord)object);
        KeyValue kv = new KeyValue(recordKey.getBytes(), null, null, value);
        this.writer.append(kv);
        if (this.hfileConfig.useBloomFilter()) {
            this.hfileConfig.getBloomFilter().add(recordKey);
            if (this.minRecordKey == null) {
                this.minRecordKey = recordKey;
            }
            this.maxRecordKey = recordKey;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.hfileConfig.useBloomFilter()) {
            final BloomFilter bloomFilter = this.hfileConfig.getBloomFilter();
            if (this.minRecordKey == null) {
                this.minRecordKey = "";
            }
            if (this.maxRecordKey == null) {
                this.maxRecordKey = "";
            }
            this.writer.appendFileInfo("minRecordKey".getBytes(), this.minRecordKey.getBytes());
            this.writer.appendFileInfo("maxRecordKey".getBytes(), this.maxRecordKey.getBytes());
            this.writer.appendFileInfo("bloomFilterTypeCode".getBytes(), bloomFilter.getBloomFilterTypeCode().toString().getBytes());
            this.writer.appendMetaBlock("bloomFilter", new Writable(){

                public void write(DataOutput out) throws IOException {
                    out.write(bloomFilter.serializeToString().getBytes());
                }

                public void readFields(DataInput in) throws IOException {
                }
            });
        }
        this.writer.close();
        this.writer = null;
    }

    @Override
    public long getBytesWritten() {
        return this.fs.getBytesWritten(this.file);
    }
}

