/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.metadata.HoodieTableMetadata;

public class FileSystemBackedTableMetadata
implements HoodieTableMetadata {
    private static final int DEFAULT_LISTING_PARALLELISM = 1500;
    private final transient HoodieEngineContext engineContext;
    private final SerializableConfiguration hadoopConf;
    private final String datasetBasePath;
    private final boolean assumeDatePartitioning;

    public FileSystemBackedTableMetadata(HoodieEngineContext engineContext, SerializableConfiguration conf, String datasetBasePath, boolean assumeDatePartitioning) {
        this.engineContext = engineContext;
        this.hadoopConf = conf;
        this.datasetBasePath = datasetBasePath;
        this.assumeDatePartitioning = assumeDatePartitioning;
    }

    @Override
    public FileStatus[] getAllFilesInPartition(Path partitionPath) throws IOException {
        FileSystem fs = partitionPath.getFileSystem(this.hadoopConf.get());
        return FSUtils.getAllDataFilesInPartition(fs, partitionPath);
    }

    @Override
    public List<String> getAllPartitionPaths() throws IOException {
        if (this.assumeDatePartitioning) {
            FileSystem fs = new Path(this.datasetBasePath).getFileSystem(this.hadoopConf.get());
            return FSUtils.getAllPartitionFoldersThreeLevelsDown(fs, this.datasetBasePath);
        }
        LinkedList<Path> pathsToList = new LinkedList<Path>();
        pathsToList.add(new Path(this.datasetBasePath));
        ArrayList<String> partitionPaths = new ArrayList<String>();
        while (!pathsToList.isEmpty()) {
            int listingParallelism = Math.min(1500, pathsToList.size());
            List<Pair> dirToFileListing = this.engineContext.map(pathsToList, path -> {
                FileSystem fileSystem = path.getFileSystem(this.hadoopConf.get());
                return Pair.of(path, fileSystem.listStatus(path));
            }, listingParallelism);
            pathsToList.clear();
            dirToFileListing.forEach(p -> {
                Option<FileStatus> partitionMetaFile = Option.fromJavaOptional(((Stream)Arrays.stream((Object[])p.getRight()).parallel()).filter(fs -> fs.getPath().getName().equals(".hoodie_partition_metadata")).findFirst());
                if (partitionMetaFile.isPresent()) {
                    String partitionName = FSUtils.getRelativePartitionPath(new Path(this.datasetBasePath), (Path)p.getLeft());
                    partitionPaths.add(partitionName);
                } else {
                    pathsToList.addAll(Arrays.stream((Object[])p.getRight()).filter(fs -> fs.isDirectory() && !fs.getPath().getName().equals(".hoodie")).map(fs -> fs.getPath()).collect(Collectors.toList()));
                }
            });
        }
        return partitionPaths;
    }

    @Override
    public Option<String> getSyncedInstantTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInSync() {
        return true;
    }

    @Override
    public void close() throws Exception {
    }
}

