/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.io.HoodieCreateHandle;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.HoodieSortedMergeHandle;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.bootstrap.HoodieBootstrapWriteMetadata;
import org.apache.hudi.table.action.bootstrap.SparkBootstrapCommitActionExecutor;
import org.apache.hudi.table.action.clean.SparkCleanActionExecutor;
import org.apache.hudi.table.action.clean.SparkCleanPlanActionExecutor;
import org.apache.hudi.table.action.cluster.SparkClusteringPlanActionExecutor;
import org.apache.hudi.table.action.cluster.SparkExecuteClusteringCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkBulkInsertCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkBulkInsertPreppedCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkDeleteCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkDeletePartitionCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkInsertCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkInsertOverwriteCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkInsertOverwriteTableCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkInsertPreppedCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkMergeHelper;
import org.apache.hudi.table.action.commit.SparkUpsertCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkUpsertPreppedCommitActionExecutor;
import org.apache.hudi.table.action.restore.SparkCopyOnWriteRestoreActionExecutor;
import org.apache.hudi.table.action.rollback.SparkCopyOnWriteRollbackActionExecutor;
import org.apache.hudi.table.action.savepoint.SavepointActionExecutor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;

public class HoodieSparkCopyOnWriteTable<T extends HoodieRecordPayload>
extends HoodieSparkTable<T> {
    private static final Logger LOG = LogManager.getLogger(HoodieSparkCopyOnWriteTable.class);

    public HoodieSparkCopyOnWriteTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> upsert(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> records) {
        return new SparkUpsertCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> insert(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> records) {
        return new SparkInsertCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> bulkInsert(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> records, Option<BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>>> userDefinedBulkInsertPartitioner) {
        return new SparkBulkInsertCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, records, userDefinedBulkInsertPartitioner).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> delete(HoodieEngineContext context, String instantTime, JavaRDD<HoodieKey> keys2) {
        return new SparkDeleteCommitActionExecutor((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, keys2).execute();
    }

    @Override
    public HoodieWriteMetadata deletePartitions(HoodieEngineContext context, String instantTime, List<String> partitions) {
        return new SparkDeletePartitionCommitActionExecutor(context, this.config, (HoodieTable)this, instantTime, partitions).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> upsertPrepped(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> preppedRecords) {
        return new SparkUpsertPreppedCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> insertPrepped(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> preppedRecords) {
        return new SparkInsertPreppedCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> bulkInsertPrepped(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> preppedRecords, Option<BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>>> userDefinedBulkInsertPartitioner) {
        return new SparkBulkInsertPreppedCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords, userDefinedBulkInsertPartitioner).execute();
    }

    @Override
    public HoodieWriteMetadata insertOverwrite(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> records) {
        return new SparkInsertOverwriteCommitActionExecutor<T>(context, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> insertOverwriteTable(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> records) {
        return new SparkInsertOverwriteTableCommitActionExecutor<T>(context, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    @Override
    public Option<HoodieCompactionPlan> scheduleCompaction(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        throw new HoodieNotSupportedException("Compaction is not supported on a CopyOnWrite table");
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> compact(HoodieEngineContext context, String compactionInstantTime) {
        throw new HoodieNotSupportedException("Compaction is not supported on a CopyOnWrite table");
    }

    @Override
    public Option<HoodieClusteringPlan> scheduleClustering(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        return new SparkClusteringPlanActionExecutor(context, this.config, this, instantTime, extraMetadata).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> cluster(HoodieEngineContext context, String clusteringInstantTime) {
        return new SparkExecuteClusteringCommitActionExecutor(context, this.config, (HoodieTable)this, clusteringInstantTime).execute();
    }

    @Override
    public HoodieBootstrapWriteMetadata<JavaRDD<WriteStatus>> bootstrap(HoodieEngineContext context, Option<Map<String, String>> extraMetadata) {
        return new SparkBootstrapCommitActionExecutor((HoodieSparkEngineContext)context, this.config, this, extraMetadata).execute();
    }

    @Override
    public void rollbackBootstrap(HoodieEngineContext context, String instantTime) {
        new SparkCopyOnWriteRestoreActionExecutor((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, "00000000000000").execute();
    }

    @Override
    public Option<HoodieCleanerPlan> scheduleCleaning(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        return new SparkCleanPlanActionExecutor(context, this.config, this, instantTime, extraMetadata).execute();
    }

    public Iterator<List<WriteStatus>> handleUpdate(String instantTime, String partitionPath, String fileId, Map<String, HoodieRecord<T>> keyToNewRecords, HoodieBaseFile oldDataFile) throws IOException {
        HoodieMergeHandle upsertHandle = this.getUpdateHandle(instantTime, partitionPath, fileId, keyToNewRecords, oldDataFile);
        return this.handleUpdateInternal(upsertHandle, instantTime, fileId);
    }

    protected Iterator<List<WriteStatus>> handleUpdateInternal(HoodieMergeHandle<?, ?, ?, ?> upsertHandle, String instantTime, String fileId) throws IOException {
        if (upsertHandle.getOldFilePath() == null) {
            throw new HoodieUpsertException("Error in finding the old file path at commit " + instantTime + " for fileId: " + fileId);
        }
        SparkMergeHelper.newInstance().runMerge(this, upsertHandle);
        if (upsertHandle.getPartitionPath() == null) {
            LOG.info((Object)("Upsert Handle has partition path as null " + upsertHandle.getOldFilePath() + ", " + upsertHandle.writeStatuses()));
        }
        return Collections.singletonList(upsertHandle.writeStatuses()).iterator();
    }

    protected HoodieMergeHandle getUpdateHandle(String instantTime, String partitionPath, String fileId, Map<String, HoodieRecord<T>> keyToNewRecords, HoodieBaseFile dataFileToBeMerged) {
        if (this.requireSortedRecords()) {
            return new HoodieSortedMergeHandle(this.config, instantTime, this, keyToNewRecords, partitionPath, fileId, dataFileToBeMerged, this.taskContextSupplier);
        }
        return new HoodieMergeHandle(this.config, instantTime, this, keyToNewRecords, partitionPath, fileId, dataFileToBeMerged, this.taskContextSupplier);
    }

    public Iterator<List<WriteStatus>> handleInsert(String instantTime, String partitionPath, String fileId, Map<String, HoodieRecord<? extends HoodieRecordPayload>> recordMap) {
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.config, instantTime, this, partitionPath, fileId, recordMap, this.taskContextSupplier);
        createHandle.write();
        return Collections.singletonList(createHandle.close()).iterator();
    }

    @Override
    public HoodieCleanMetadata clean(HoodieEngineContext context, String cleanInstantTime) {
        return new SparkCleanActionExecutor((HoodieSparkEngineContext)context, this.config, this, cleanInstantTime).execute();
    }

    @Override
    public HoodieRollbackMetadata rollback(HoodieEngineContext context, String rollbackInstantTime, HoodieInstant commitInstant, boolean deleteInstants) {
        return new SparkCopyOnWriteRollbackActionExecutor((HoodieSparkEngineContext)context, this.config, this, rollbackInstantTime, commitInstant, deleteInstants).execute();
    }

    @Override
    public HoodieSavepointMetadata savepoint(HoodieEngineContext context, String instantToSavepoint, String user, String comment) {
        return new SavepointActionExecutor(context, this.config, this, instantToSavepoint, user, comment).execute();
    }

    @Override
    public HoodieRestoreMetadata restore(HoodieEngineContext context, String restoreInstantTime, String instantToRestore) {
        return new SparkCopyOnWriteRestoreActionExecutor((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, restoreInstantTime, instantToRestore).execute();
    }
}

