/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster;

import java.util.Map;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.BaseClusteringPlanActionExecutor;
import org.apache.hudi.table.action.cluster.strategy.ClusteringPlanStrategy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;

public class SparkClusteringPlanActionExecutor<T extends HoodieRecordPayload>
extends BaseClusteringPlanActionExecutor<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private static final Logger LOG = LogManager.getLogger(SparkClusteringPlanActionExecutor.class);

    public SparkClusteringPlanActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table, String instantTime, Option<Map<String, String>> extraMetadata) {
        super(context, config, table, instantTime, extraMetadata);
    }

    @Override
    protected Option<HoodieClusteringPlan> createClusteringPlan() {
        LOG.info((Object)("Checking if clustering needs to be run on " + this.config.getBasePath()));
        Option<HoodieInstant> lastClusteringInstant = this.table.getActiveTimeline().getCompletedReplaceTimeline().lastInstant();
        int commitsSinceLastClustering = this.table.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().findInstantsAfter(lastClusteringInstant.map(HoodieInstant::getTimestamp).orElse("0"), Integer.MAX_VALUE).countInstants();
        if (this.config.getInlineClusterMaxCommits() > commitsSinceLastClustering) {
            LOG.info((Object)("Not scheduling clustering as only " + commitsSinceLastClustering + " commits was found since last clustering " + lastClusteringInstant + ". Waiting for " + this.config.getInlineClusterMaxCommits()));
            return Option.empty();
        }
        LOG.info((Object)("Generating clustering plan for table " + this.config.getBasePath()));
        ClusteringPlanStrategy strategy = (ClusteringPlanStrategy)ReflectionUtils.loadClass(this.config.getClusteringPlanStrategyClass(), this.table, this.context, this.config);
        return strategy.generateClusteringPlan();
    }
}

