/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.WorkloadStat;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseCommitActionExecutor<T extends HoodieRecordPayload, I, K, O, R>
extends BaseActionExecutor<T, I, K, O, R> {
    private static final Logger LOG = LogManager.getLogger(BaseCommitActionExecutor.class);
    protected final Option<Map<String, String>> extraMetadata;
    protected final WriteOperationType operationType;
    protected final TaskContextSupplier taskContextSupplier;
    protected final TransactionManager txnManager;
    protected Option<Pair<HoodieInstant, Map<String, String>>> lastCompletedTxn;

    public BaseCommitActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, WriteOperationType operationType, Option<Map<String, String>> extraMetadata) {
        super(context, config, table, instantTime);
        this.operationType = operationType;
        this.extraMetadata = extraMetadata;
        this.taskContextSupplier = context.getTaskContextSupplier();
        this.txnManager = new TransactionManager(config, table.getMetaClient().getFs());
        this.lastCompletedTxn = TransactionUtils.getLastCompletedTxnInstantAndMetadata(table.getMetaClient());
    }

    public abstract HoodieWriteMetadata<O> execute(I var1);

    void saveWorkloadProfileMetadataToInflight(WorkloadProfile profile, String instantTime) throws HoodieCommitException {
        try {
            HoodieCommitMetadata metadata = new HoodieCommitMetadata();
            profile.getPartitionPaths().forEach(path -> {
                WorkloadStat partitionStat = profile.getWorkloadStat(path.toString());
                HoodieWriteStat insertStat = new HoodieWriteStat();
                insertStat.setNumInserts(partitionStat.getNumInserts());
                insertStat.setFileId("");
                insertStat.setPrevCommit("null");
                metadata.addWriteStat((String)path, insertStat);
                partitionStat.getUpdateLocationToCount().forEach((key, value) -> {
                    HoodieWriteStat writeStat = new HoodieWriteStat();
                    writeStat.setFileId((String)key);
                    writeStat.setPrevCommit((String)value.getKey());
                    writeStat.setNumUpdateWrites((Long)value.getValue());
                    metadata.addWriteStat((String)path, writeStat);
                });
            });
            metadata.setOperationType(this.operationType);
            HoodieActiveTimeline activeTimeline = this.table.getActiveTimeline();
            String commitActionType = this.getCommitActionType();
            HoodieInstant requested = new HoodieInstant(HoodieInstant.State.REQUESTED, commitActionType, instantTime);
            activeTimeline.transitionRequestedToInflight(requested, Option.of(metadata.toJsonString().getBytes(StandardCharsets.UTF_8)), this.config.shouldAllowMultiWriteOnSameInstant());
        }
        catch (IOException io) {
            throw new HoodieCommitException("Failed to commit " + instantTime + " unable to save inflight metadata ", io);
        }
    }

    protected String getCommitActionType() {
        return this.table.getMetaClient().getCommitActionType();
    }

    protected void commitOnAutoCommit(HoodieWriteMetadata result) {
        if (this.config.shouldAutoCommit().booleanValue()) {
            LOG.info((Object)("Auto commit enabled: Committing " + this.instantTime));
            this.autoCommit(this.extraMetadata, result);
        } else {
            LOG.info((Object)("Auto commit disabled for " + this.instantTime));
        }
    }

    protected void autoCommit(Option<Map<String, String>> extraMetadata, HoodieWriteMetadata<O> result) {
        this.txnManager.beginTransaction(Option.of(new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", this.instantTime)), this.lastCompletedTxn.isPresent() ? Option.of(this.lastCompletedTxn.get().getLeft()) : Option.empty());
        try {
            TransactionUtils.resolveWriteConflictIfAny(this.table, this.txnManager.getCurrentTransactionOwner(), result.getCommitMetadata(), this.config, this.txnManager.getLastCompletedTransactionOwner());
            this.commit(extraMetadata, result);
        }
        finally {
            this.txnManager.endTransaction();
        }
    }

    protected abstract void commit(Option<Map<String, String>> var1, HoodieWriteMetadata<O> var2);

    protected void finalizeWrite(String instantTime, List<HoodieWriteStat> stats, HoodieWriteMetadata result) {
        try {
            Instant start = Instant.now();
            this.table.finalizeWrite(this.context, instantTime, stats);
            result.setFinalizeDuration(Duration.between(start, Instant.now()));
        }
        catch (HoodieIOException ioe) {
            throw new HoodieCommitException("Failed to complete commit " + instantTime + " due to finalize errors.", ioe);
        }
    }

    protected void syncTableMetadata() {
    }

    protected String getSchemaToStoreInCommit() {
        return this.config.getSchema();
    }

    protected boolean isWorkloadProfileNeeded() {
        return true;
    }

    protected abstract Iterator<List<WriteStatus>> handleInsert(String var1, Iterator<HoodieRecord<T>> var2) throws Exception;

    protected abstract Iterator<List<WriteStatus>> handleUpdate(String var1, String var2, Iterator<HoodieRecord<T>> var3) throws IOException;
}

