/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service;

import io.javalin.Javalin;
import io.javalin.core.util.JettyServerUtil;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.com.beust.jcommander.JCommander;
import org.apache.hudi.com.beust.jcommander.Parameter;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.org.apache.jetty.server.Server;
import org.apache.hudi.org.apache.jetty.util.thread.QueuedThreadPool;
import org.apache.hudi.timeline.service.RequestHandler;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TimelineService {
    private static final Logger LOG = LogManager.getLogger(TimelineService.class);
    private static final int START_SERVICE_MAX_RETRIES = 16;
    private static final int DEFAULT_NUM_THREADS = -1;
    private int serverPort;
    private Configuration conf;
    private transient FileSystem fs;
    private transient Javalin app = null;
    private transient FileSystemViewManager fsViewsManager;
    private final int numThreads;
    private final boolean shouldCompressOutput;
    private final boolean useAsync;

    public int getServerPort() {
        return this.serverPort;
    }

    public TimelineService(int serverPort, FileSystemViewManager globalFileSystemViewManager, Configuration conf, int numThreads, boolean compressOutput, boolean useAsync) throws IOException {
        this.conf = FSUtils.prepareHadoopConf(conf);
        this.fs = FileSystem.get((Configuration)conf);
        this.serverPort = serverPort;
        this.fsViewsManager = globalFileSystemViewManager;
        this.numThreads = numThreads;
        this.shouldCompressOutput = compressOutput;
        this.useAsync = useAsync;
    }

    public TimelineService(int serverPort, FileSystemViewManager globalFileSystemViewManager) throws IOException {
        this(serverPort, globalFileSystemViewManager, new Configuration(), -1, true, false);
    }

    public TimelineService(Config config) throws IOException {
        this(config.serverPort, TimelineService.buildFileSystemViewManager(config, new SerializableConfiguration(FSUtils.prepareHadoopConf(new Configuration()))), new Configuration(), config.numThreads, config.compress, config.async);
    }

    private int startServiceOnPort(int port) throws IOException {
        if (port != 0 && (1024 > port || port >= 65536)) {
            throw new IllegalArgumentException(String.format("startPort should be between 1024 and 65535 (inclusive), or 0 for a random free port. but now is %s.", port));
        }
        for (int attempt = 0; attempt < 16; ++attempt) {
            int tryPort = port == 0 ? port : (port + attempt - 1024) % 64512 + 1024;
            try {
                this.app.start(tryPort);
                return this.app.port();
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("Failed to bind to")) {
                    if (tryPort == 0) {
                        LOG.warn((Object)"Timeline server could not bind on a random free port.");
                        continue;
                    }
                    LOG.warn((Object)String.format("Timeline server could not bind on port %d. Attempting port %d + 1.", tryPort, tryPort));
                    continue;
                }
                LOG.warn((Object)String.format("Timeline server start failed on port %d. Attempting port %d + 1.", tryPort, tryPort), (Throwable)e);
                continue;
            }
        }
        throw new IOException(String.format("Timeline server start failed on port %d, after retry %d times", port, 16));
    }

    public int startService() throws IOException {
        Server server = this.numThreads == -1 ? JettyServerUtil.defaultServer() : new Server(new QueuedThreadPool(this.numThreads));
        this.app = Javalin.create().server(() -> server);
        if (!this.shouldCompressOutput) {
            this.app.disableDynamicGzip();
        }
        RequestHandler requestHandler = new RequestHandler(this.app, this.conf, this.fsViewsManager, this.useAsync);
        this.app.get("/", ctx -> ctx.result("Hello World"));
        requestHandler.register();
        int realServerPort = this.startServiceOnPort(this.serverPort);
        LOG.info((Object)("Starting Timeline server on port :" + realServerPort));
        this.serverPort = realServerPort;
        return realServerPort;
    }

    public void run() throws IOException {
        this.startService();
    }

    public static FileSystemViewManager buildFileSystemViewManager(Config config, SerializableConfiguration conf) {
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(conf.get());
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().build();
        switch (config.viewStorageType) {
            case MEMORY: {
                FileSystemViewStorageConfig.Builder inMemConfBuilder = FileSystemViewStorageConfig.newBuilder();
                inMemConfBuilder.withStorageType(FileSystemViewStorageType.MEMORY);
                return FileSystemViewManager.createViewManager(localEngineContext, metadataConfig, inMemConfBuilder.build());
            }
            case SPILLABLE_DISK: {
                FileSystemViewStorageConfig.Builder spillableConfBuilder = FileSystemViewStorageConfig.newBuilder();
                spillableConfBuilder.withStorageType(FileSystemViewStorageType.SPILLABLE_DISK).withBaseStoreDir(config.baseStorePathForFileGroups).withMaxMemoryForView((long)(config.maxViewMemPerTableInMB * 1024) * 1024L).withMemFractionForPendingCompaction(config.memFractionForCompactionPerTable);
                return FileSystemViewManager.createViewManager(localEngineContext, metadataConfig, spillableConfBuilder.build());
            }
            case EMBEDDED_KV_STORE: {
                FileSystemViewStorageConfig.Builder rocksDBConfBuilder = FileSystemViewStorageConfig.newBuilder();
                rocksDBConfBuilder.withStorageType(FileSystemViewStorageType.EMBEDDED_KV_STORE).withRocksDBPath(config.rocksDBPath);
                return FileSystemViewManager.createViewManager(localEngineContext, metadataConfig, rocksDBConfBuilder.build());
            }
        }
        throw new IllegalArgumentException("Invalid view manager storage type :" + (Object)((Object)config.viewStorageType));
    }

    public void close() {
        LOG.info((Object)"Closing Timeline Service");
        this.app.stop();
        this.app = null;
        this.fsViewsManager.close();
        LOG.info((Object)"Closed Timeline Service");
    }

    public Configuration getConf() {
        return this.conf;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public static void main(String[] args) throws Exception {
        Config cfg = new Config();
        JCommander cmd = new JCommander((Object)cfg, null, args);
        if (cfg.help.booleanValue()) {
            cmd.usage();
            System.exit(1);
        }
        Configuration conf = FSUtils.prepareHadoopConf(new Configuration());
        FileSystemViewManager viewManager = TimelineService.buildFileSystemViewManager(cfg, new SerializableConfiguration(conf));
        TimelineService service2 = new TimelineService(cfg.serverPort, viewManager);
        service2.run();
    }

    public static class Config
    implements Serializable {
        @Parameter(names={"--server-port", "-p"}, description=" Server Port")
        public Integer serverPort = 26754;
        @Parameter(names={"--view-storage", "-st"}, description="View Storage Type. Default - SPILLABLE_DISK")
        public FileSystemViewStorageType viewStorageType = FileSystemViewStorageType.SPILLABLE_DISK;
        @Parameter(names={"--max-view-mem-per-table", "-mv"}, description="Maximum view memory per table in MB to be used for storing file-groups. Overflow file-groups will be spilled to disk. Used for SPILLABLE_DISK storage type")
        public Integer maxViewMemPerTableInMB = 2048;
        @Parameter(names={"--mem-overhead-fraction-pending-compaction", "-cf"}, description="Memory Fraction of --max-view-mem-per-table to be allocated for managing pending compaction storage. Overflow entries will be spilled to disk. Used for SPILLABLE_DISK storage type")
        public Double memFractionForCompactionPerTable = 0.001;
        @Parameter(names={"--base-store-path", "-sp"}, description="Directory where spilled view entries will be stored. Used for SPILLABLE_DISK storage type")
        public String baseStorePathForFileGroups = "/tmp/view_map/";
        @Parameter(names={"--rocksdb-path", "-rp"}, description="Root directory for RocksDB")
        public String rocksDBPath = "/tmp/hoodie_timeline_rocksdb";
        @Parameter(names={"--threads", "-t"}, description="Number of threads to use for serving requests")
        public int numThreads = -1;
        @Parameter(names={"--async"}, description="Use asyncronous request processing")
        public boolean async = false;
        @Parameter(names={"--compress"}, description="Compress output using gzip")
        public boolean compress = true;
        @Parameter(names={"--help", "-h"})
        public Boolean help = false;
    }
}

