/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.streaming;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.IncrementalRelation;
import org.apache.hudi.MergeOnReadIncrementalRelation;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.TablePathUtils;
import org.apache.hudi.spark.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset$;
import org.apache.spark.sql.hudi.streaming.HoodieStreamSource$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001B\u0001\u0003\u0001=\u0011!\u0003S8pI&,7\u000b\u001e:fC6\u001cv.\u001e:dK*\u00111\u0001B\u0001\ngR\u0014X-Y7j]\u001eT!!\u0002\u0004\u0002\t!,H-\u001b\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001AAr$\n\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA\u0001\\1oO*\tQ#\u0001\u0003kCZ\f\u0017BA\f\u0013\u0005\u0019y%M[3diB\u0011\u0011$H\u0007\u00025)\u00111a\u0007\u0006\u00039\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005yQ\"AB*pkJ\u001cW\r\u0005\u0002!G5\t\u0011E\u0003\u0002#\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002%C\t9Aj\\4hS:<\u0007C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0015M\fHnQ8oi\u0016DH\u000f\u0005\u0002/_5\ta!\u0003\u00021\r\tQ1+\u0015'D_:$X\r\u001f;\t\u0011I\u0002!\u0011!Q\u0001\nM\nA\"\\3uC\u0012\fG/\u0019)bi\"\u0004\"\u0001N\u001c\u000f\u0005\u0019*\u0014B\u0001\u001c(\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001(\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y:\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u0019M\u001c\u0007.Z7b\u001fB$\u0018n\u001c8\u0011\u0007\u0019jt(\u0003\u0002?O\t1q\n\u001d;j_:\u0004\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0004\u0002\u000bQL\b/Z:\n\u0005\u0011\u000b%AC*ueV\u001cG\u000fV=qK\"Aa\t\u0001B\u0001B\u0003%q)\u0001\u0006qCJ\fW.\u001a;feN\u0004B\u0001\u000e%4g%\u0011\u0011*\u000f\u0002\u0004\u001b\u0006\u0004\b\"B&\u0001\t\u0003a\u0015A\u0002\u001fj]&$h\bF\u0003N\u001fB\u000b&\u000b\u0005\u0002O\u00015\t!\u0001C\u0003-\u0015\u0002\u0007Q\u0006C\u00033\u0015\u0002\u00071\u0007C\u0003<\u0015\u0002\u0007A\bC\u0003G\u0015\u0002\u0007q\tC\u0004U\u0001\t\u0007I\u0011B+\u0002\u0015!\fGm\\8q\u0007>tg-F\u0001W!\t9F,D\u0001Y\u0015\tI&,\u0001\u0003d_:4'BA.\u000b\u0003\u0019A\u0017\rZ8pa&\u0011Q\f\u0017\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\r}\u0003\u0001\u0015!\u0003W\u0003-A\u0017\rZ8pa\u000e{gN\u001a\u0011)\u0005y\u000b\u0007C\u0001\u0014c\u0013\t\u0019wEA\u0005ue\u0006t7/[3oi\"AQ\r\u0001EC\u0002\u0013%a-A\u0005uC\ndW\rU1uQV\tq\r\u0005\u0002iW6\t\u0011N\u0003\u0002k5\u0006\u0011am]\u0005\u0003Y&\u0014A\u0001U1uQ\"Aa\u000e\u0001E\u0001B\u0003&q-\u0001\u0006uC\ndW\rU1uQ\u0002B\u0001\u0002\u001d\u0001\t\u0006\u0004%I!]\u0001\u000b[\u0016$\u0018m\u00117jK:$X#\u0001:\u0011\u0005MLX\"\u0001;\u000b\u0005U4\u0018!\u0002;bE2,'BA<y\u0003\u0019\u0019w.\\7p]*\u0011QAC\u0005\u0003uR\u0014Q\u0003S8pI&,G+\u00192mK6+G/Y\"mS\u0016tG\u000f\u0003\u0005}\u0001!\u0005\t\u0015)\u0003s\u0003-iW\r^1DY&,g\u000e\u001e\u0011\t\u0011y\u0004\u0001R1A\u0005\n}\f\u0011\u0002^1cY\u0016$\u0016\u0010]3\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001da/A\u0003n_\u0012,G.\u0003\u0003\u0002\f\u0005\u0015!a\u0004%p_\u0012LW\rV1cY\u0016$\u0016\u0010]3\t\u0015\u0005=\u0001\u0001#A!B\u0013\t\t!\u0001\u0006uC\ndW\rV=qK\u0002B1\"a\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0016\u0005QA.Y:u\u001f\u001a47/\u001a;\u0016\u0005\u0005]\u0001c\u0001(\u0002\u001a%\u0019\u00111\u0004\u0002\u0003%!{w\u000eZ5f'>,(oY3PM\u001a\u001cX\r\u001e\u0005\f\u0003?\u0001\u0001\u0019!a\u0001\n\u0013\t\t#\u0001\bmCN$xJ\u001a4tKR|F%Z9\u0015\t\u0005\r\u0012\u0011\u0006\t\u0004M\u0005\u0015\u0012bAA\u0014O\t!QK\\5u\u0011)\tY#!\b\u0002\u0002\u0003\u0007\u0011qC\u0001\u0004q\u0012\n\u0004\u0002CA\u0018\u0001\u0001\u0006K!a\u0006\u0002\u00171\f7\u000f^(gMN,G\u000f\t\u0015\u0004\u0003[\t\u0007BCA\u001b\u0001!\u0015\r\u0011\"\u0003\u0002\u0016\u0005q\u0011N\\5uS\u0006dwJ\u001a4tKR\u001c\bBCA\u001d\u0001!\u0005\t\u0015)\u0003\u0002\u0018\u0005y\u0011N\\5uS\u0006dwJ\u001a4tKR\u001c\b\u0005K\u0002\u00028\u0005Dq!a\u0010\u0001\t\u0013\t\t%\u0001\u0006hKR4VM]:j_:$B!a\u0011\u0002JA\u0019a%!\u0012\n\u0007\u0005\u001dsEA\u0002J]RDq!a\u0013\u0002>\u0001\u00071'A\u0006wKJ\u001c\u0018n\u001c8MS:,\u0007bBA(\u0001\u0011\u0005\u0013\u0011K\u0001\u0007g\u000eDW-\\1\u0016\u0003}Bq!!\u0016\u0001\t\u0003\n9&A\u0005hKR|eMZ:fiV\u0011\u0011\u0011\f\t\u0005Mu\nY\u0006E\u0002\u001a\u0003;J1!a\u0018\u001b\u0005\u0019yeMZ:fi\"9\u00111\r\u0001\u0005B\u0005\u0015\u0014\u0001C4fi\n\u000bGo\u00195\u0015\r\u0005\u001d\u00141RAH!\u0011\tI'!\"\u000f\t\u0005-\u0014\u0011\u0011\b\u0005\u0003[\nyH\u0004\u0003\u0002p\u0005ud\u0002BA9\u0003wrA!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003or\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0004\u0003\u00073\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\u000bIIA\u0005ECR\fgI]1nK*\u0019\u00111\u0011\u0004\t\u0011\u00055\u0015\u0011\ra\u0001\u00033\nQa\u001d;beRD\u0001\"!%\u0002b\u0001\u0007\u00111L\u0001\u0004K:$\u0007bBAK\u0001\u0011%\u0011qS\u0001\u0010gR\f'\u000f^\"p[6LG\u000fV5nKR\u00191'!'\t\u0011\u0005m\u00151\u0013a\u0001\u0003/\t1b\u001d;beR|eMZ:fi\"9\u0011q\u0014\u0001\u0005B\u0005\u0005\u0016\u0001B:u_B$\"!a\t\b\u000f\u0005\u0015&\u0001#\u0001\u0002(\u0006\u0011\u0002j\\8eS\u0016\u001cFO]3b[N{WO]2f!\rq\u0015\u0011\u0016\u0004\u0007\u0003\tA\t!a+\u0014\u000b\u0005%\u0016QV\u0013\u0011\u0007\u0019\ny+C\u0002\u00022\u001e\u0012a!\u00118z%\u00164\u0007bB&\u0002*\u0012\u0005\u0011Q\u0017\u000b\u0003\u0003OC!\"!/\u0002*\n\u0007I\u0011AA^\u0003\u001d1VIU*J\u001f:+\"!a\u0011\t\u0013\u0005}\u0016\u0011\u0016Q\u0001\n\u0005\r\u0013\u0001\u0003,F%NKuJ\u0014\u0011\t\u0015\u0005\r\u0017\u0011VA\u0001\n\u0013\t)-A\u0006sK\u0006$'+Z:pYZ,G#\u0001\t")
public class HoodieStreamSource
implements Source,
Logging,
Serializable {
    public final SQLContext org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext;
    public final String org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metadataPath;
    private final Option<StructType> schemaOption;
    private final Map<String, String> parameters;
    private final transient Configuration hadoopConf;
    private Path tablePath;
    private HoodieTableMetaClient org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient;
    private HoodieTableType tableType;
    private transient HoodieSourceOffset lastOffset;
    private transient HoodieSourceOffset org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static int VERSION() {
        return HoodieStreamSource$.MODULE$.VERSION();
    }

    private Path tablePath$lzycompute() {
        HoodieStreamSource hoodieStreamSource = this;
        synchronized (hoodieStreamSource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Path path = new Path((String)this.parameters.getOrElse((Object)"path", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Missing 'path' option";
                    }
                }));
                FileSystem fs = path.getFileSystem(this.hadoopConf());
                this.tablePath = TablePathUtils.getTablePath(fs, path).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.tablePath;
        }
    }

    private HoodieTableMetaClient org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient$lzycompute() {
        HoodieStreamSource hoodieStreamSource = this;
        synchronized (hoodieStreamSource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient = HoodieTableMetaClient.builder().setConf(this.hadoopConf()).setBasePath(this.tablePath().toString()).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient;
        }
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieStreamSource hoodieStreamSource = this;
        synchronized (hoodieStreamSource) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.tableType = this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient().getTableType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.tableType;
        }
    }

    private HoodieSourceOffset org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets$lzycompute() {
        HoodieStreamSource hoodieStreamSource = this;
        synchronized (hoodieStreamSource) {
            if (!this.bitmap$trans$0) {
                HDFSMetadataLog<HoodieSourceOffset> metadataLog = new HDFSMetadataLog<HoodieSourceOffset>(this){
                    private final /* synthetic */ HoodieStreamSource $outer;

                    public void serialize(HoodieSourceOffset metadata, OutputStream out) {
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
                        writer.write(new StringBuilder().append((Object)"v").append((Object)BoxesRunTime.boxToInteger((int)HoodieStreamSource$.MODULE$.VERSION())).append((Object)"\n").toString());
                        writer.write(metadata.json());
                        writer.flush();
                    }

                    public HoodieSourceOffset deserialize(InputStream in) {
                        String content = FileIOUtils.readAsUTFString(in);
                        int firstLineEnd = content.indexOf("\n");
                        if (firstLineEnd > 0) {
                            int version = this.$outer.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$getVersion(content.substring(0, firstLineEnd));
                            if (version > HoodieStreamSource$.MODULE$.VERSION()) {
                                throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnSupportVersion: max support version is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)HoodieStreamSource$.MODULE$.VERSION())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" current version is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)}))).toString());
                            }
                            return HoodieSourceOffset$.MODULE$.fromJson(content.substring(firstLineEnd + 1));
                        }
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bad metadata format, failed to find the version line."})).s((Seq)Nil$.MODULE$));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext.sparkSession(), $outer.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metadataPath, ClassTag$.MODULE$.apply(HoodieSourceOffset.class));
                    }
                };
                this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets = (HoodieSourceOffset)((Object)metadataLog.get(0L).getOrElse((Function0)new Serializable(this, (HDFSMetadataLog)metadataLog){
                    public static final long serialVersionUID = 0L;
                    private final HDFSMetadataLog metadataLog$1;

                    public final HoodieSourceOffset apply() {
                        this.metadataLog$1.add(0L, (Object)((Object)HoodieSourceOffset$.MODULE$.INIT_OFFSET()));
                        return HoodieSourceOffset$.MODULE$.INIT_OFFSET();
                    }
                    {
                        this.metadataLog$1 = metadataLog$1;
                    }
                }));
                this.bitmap$trans$0 = true;
            }
            return this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public void commit(Offset end) {
        Source.class.commit((Source)this, (Offset)end);
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private Path tablePath() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tablePath$lzycompute() : this.tablePath;
    }

    public HoodieTableMetaClient org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient$lzycompute() : this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient;
    }

    private HoodieTableType tableType() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.tableType$lzycompute() : this.tableType;
    }

    private HoodieSourceOffset lastOffset() {
        return this.lastOffset;
    }

    private void lastOffset_$eq(HoodieSourceOffset x$1) {
        this.lastOffset = x$1;
    }

    public HoodieSourceOffset org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets() {
        return this.bitmap$trans$0 ? this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets : this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets$lzycompute();
    }

    public int org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$getVersion(String versionLine) {
        if (versionLine.startsWith("v")) {
            return new StringOps(Predef$.MODULE$.augmentString(versionLine.substring(1))).toInt();
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal version line: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{versionLine}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in the streaming metadata path"})).s((Seq)Nil$.MODULE$)).toString());
    }

    public StructType schema() {
        return (StructType)this.schemaOption.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HoodieStreamSource $outer;

            public final StructType apply() {
                TableSchemaResolver schemaUtil = new TableSchemaResolver(this.$outer.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient());
                return (StructType)SchemaConverters$.MODULE$.toSqlType(schemaUtil.getTableAvroSchema()).dataType();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Offset> getOffset() {
        this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient().reloadActiveTimeline();
        HoodieTimeline activeInstants = this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient().getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        if (activeInstants.empty()) {
            this.lastOffset_$eq(this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets());
        } else {
            String currentLatestCommitTime = activeInstants.lastInstant().get().getTimestamp();
            if (this.lastOffset() == null || new StringOps(Predef$.MODULE$.augmentString(currentLatestCommitTime)).$greater((Object)this.lastOffset().commitTime())) {
                this.lastOffset_$eq(new HoodieSourceOffset(currentLatestCommitTime));
            }
        }
        return new Some((Object)this.lastOffset());
    }

    public Dataset<Row> getBatch(Option<Offset> start, Offset end) {
        block6: {
            Dataset dataset;
            block3: {
                RDD<Row> rDD;
                block5: {
                    HoodieTableType hoodieTableType;
                    Map incParams;
                    block4: {
                        HoodieSourceOffset endOffset;
                        HoodieSourceOffset startOffset;
                        block2: {
                            this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets();
                            startOffset = (HoodieSourceOffset)((Object)start.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final HoodieSourceOffset apply(Offset x$1) {
                                    return HoodieSourceOffset$.MODULE$.apply(x$1);
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ HoodieStreamSource $outer;

                                public final HoodieSourceOffset apply() {
                                    return this.$outer.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$initialOffsets();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }));
                            endOffset = HoodieSourceOffset$.MODULE$.apply(end);
                            HoodieSourceOffset hoodieSourceOffset = startOffset;
                            HoodieSourceOffset hoodieSourceOffset2 = endOffset;
                            if (hoodieSourceOffset != null ? !((Object)((Object)hoodieSourceOffset)).equals((Object)hoodieSourceOffset2) : hoodieSourceOffset2 != null) break block2;
                            dataset = this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext.internalCreateDataFrame(this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)).setName("empty"), this.schema(), true);
                            break block3;
                        }
                        incParams = this.parameters.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME_OPT_KEY()), (Object)this.startCommitTime(startOffset)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.END_INSTANTTIME_OPT_KEY()), (Object)endOffset.commitTime())})));
                        hoodieTableType = this.tableType();
                        if (!((Object)((Object)HoodieTableType.COPY_ON_WRITE)).equals((Object)hoodieTableType)) break block4;
                        SparkRowSerDe serDe = HoodieSparkUtils$.MODULE$.createRowSerDe((ExpressionEncoder<Row>)RowEncoder$.MODULE$.apply(this.schema()));
                        rDD = new IncrementalRelation(this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext, (Map<String, String>)incParams, this.schema(), this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient()).buildScan().map((Function1)new Serializable(this, serDe){
                            public static final long serialVersionUID = 0L;
                            private final SparkRowSerDe serDe$1;

                            public final InternalRow apply(Row x$1) {
                                return this.serDe$1.serializeRow(x$1);
                            }
                            {
                                this.serDe$1 = serDe$1;
                            }
                        }, ClassTag$.MODULE$.apply(InternalRow.class));
                        break block5;
                    }
                    if (!((Object)((Object)HoodieTableType.MERGE_ON_READ)).equals((Object)hoodieTableType)) break block6;
                    String[] requiredColumns = (String[])Predef$.MODULE$.refArrayOps((Object[])this.schema().fields()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(StructField x$2) {
                            return x$2.name();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                    rDD = new MergeOnReadIncrementalRelation(this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext, (Map<String, String>)incParams, this.schema(), this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metaClient()).buildScan(requiredColumns, (Filter[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Filter.class)));
                }
                RDD<Row> rdd = rDD;
                dataset = this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext.internalCreateDataFrame((RDD)rdd, this.schema(), true);
            }
            return dataset;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnSupport tableType: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableType()})));
    }

    private String startCommitTime(HoodieSourceOffset startOffset) {
        block4: {
            String string;
            block3: {
                HoodieSourceOffset hoodieSourceOffset;
                block2: {
                    hoodieSourceOffset = startOffset;
                    HoodieSourceOffset hoodieSourceOffset2 = HoodieSourceOffset$.MODULE$.INIT_OFFSET();
                    HoodieSourceOffset hoodieSourceOffset3 = hoodieSourceOffset;
                    if (hoodieSourceOffset2 != null ? !((Object)((Object)hoodieSourceOffset2)).equals((Object)hoodieSourceOffset3) : hoodieSourceOffset3 != null) break block2;
                    string = startOffset.commitTime();
                    break block3;
                }
                if (hoodieSourceOffset == null) break block4;
                String commitTime = hoodieSourceOffset.commitTime();
                long time = HoodieActiveTimeline.COMMIT_FORMATTER.parse(commitTime).getTime();
                string = HoodieActiveTimeline.COMMIT_FORMATTER.format(new Date(time + 1000L));
            }
            return string;
        }
        throw new IllegalStateException("UnKnow offset type.");
    }

    public void stop() {
    }

    public HoodieStreamSource(SQLContext sqlContext, String metadataPath, Option<StructType> schemaOption, Map<String, String> parameters) {
        this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$sqlContext = sqlContext;
        this.org$apache$spark$sql$hudi$streaming$HoodieStreamSource$$metadataPath = metadataPath;
        this.schemaOption = schemaOption;
        this.parameters = parameters;
        Source.class.$init$((Source)this);
        Logging.class.$init$((Logging)this);
        this.hadoopConf = sqlContext.sparkSession().sessionState().newHadoopConf();
    }
}

