/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.exception.HoodieIncompatibleSchemaException;
import org.apache.hudi.spark.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class AvroConversionHelper$ {
    public static AvroConversionHelper$ MODULE$;

    static {
        new AvroConversionHelper$();
    }

    private Decimal createDecimal(BigDecimal decimal, int precision, int scale) {
        return precision <= Decimal$.MODULE$.MAX_LONG_DIGITS() ? Decimal$.MODULE$.apply(decimal.unscaledValue().longValue(), precision, scale) : Decimal$.MODULE$.apply(decimal, precision, scale);
    }

    public Function1<Object, Object> createConverterToRow(Schema sourceAvroSchema, DataType targetSqlType) {
        return this.createConverter$1(sourceAvroSchema, targetSqlType, List$.MODULE$.empty(), sourceAvroSchema, targetSqlType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function1<Object, Object> createConverterToAvro(DataType dataType, String structName, String recordNamespace) {
        DataType dataType2 = dataType;
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return (Function1 & Serializable & scala.Serializable)item -> {
                ByteBuffer byteBuffer;
                Object object = item;
                if (object == null) {
                    byteBuffer = null;
                } else if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    byteBuffer = ByteBuffer.wrap(byArray);
                } else {
                    throw new MatchError(object);
                }
                return byteBuffer;
            };
        }
        boolean bl = IntegerType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : (FloatType$.MODULE$.equals(dataType2) ? true : (DoubleType$.MODULE$.equals(dataType2) ? true : (StringType$.MODULE$.equals(dataType2) ? true : BooleanType$.MODULE$.equals(dataType2)))));
        if (bl) {
            return (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x);
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return (Function1 & Serializable & scala.Serializable)item -> item == null ? null : BoxesRunTime.boxToInteger((int)Predef$.MODULE$.byte2Byte(BoxesRunTime.unboxToByte((Object)item)).intValue());
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return (Function1 & Serializable & scala.Serializable)item -> item == null ? null : BoxesRunTime.boxToInteger((int)Predef$.MODULE$.short2Short(BoxesRunTime.unboxToShort((Object)item)).intValue());
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            Schema schema = SchemaConverters$.MODULE$.toAvroType((DataType)decimalType, false, structName, recordNamespace);
            return (Function1 & Serializable & scala.Serializable)item -> Option$.MODULE$.apply(item).map((Function1 & Serializable & scala.Serializable)x$4 -> {
                BigDecimal bigDecimalValue = (BigDecimal)item;
                Conversions.DecimalConversion decimalConversions = new Conversions.DecimalConversion();
                return decimalConversions.toFixed(bigDecimalValue, schema, (LogicalType)LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale()));
            }).orNull(Predef$.MODULE$.$conforms());
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return (Function1 & Serializable & scala.Serializable)item -> Option$.MODULE$.apply(item).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)AvroConversionHelper$.$anonfun$createConverterToAvro$8(x$5))).orNull(Predef$.MODULE$.$conforms());
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return (Function1 & Serializable & scala.Serializable)item -> Option$.MODULE$.apply(item).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)AvroConversionHelper$.$anonfun$createConverterToAvro$10(x$6))).orNull(Predef$.MODULE$.$conforms());
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            Function1<Object, Object> elementConverter = this.createConverterToAvro(elementType, structName, recordNamespace);
            return (Function1 & Serializable & scala.Serializable)item -> {
                ArrayList<Object> arrayList;
                if (item == null) {
                    arrayList = null;
                } else {
                    Seq sourceArray = (Seq)item;
                    int sourceArraySize = sourceArray.size();
                    ArrayList<Object> targetList = new ArrayList<Object>(sourceArraySize);
                    for (int idx = 0; idx < sourceArraySize; ++idx) {
                        targetList.add(elementConverter.apply(sourceArray.apply(idx)));
                    }
                    arrayList = targetList;
                }
                return arrayList;
            };
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType dataType3 = mapType.keyType();
            DataType valueType = mapType.valueType();
            if (StringType$.MODULE$.equals(dataType3)) {
                Function1<Object, Object> valueConverter = this.createConverterToAvro(valueType, structName, recordNamespace);
                return (Function1 & Serializable & scala.Serializable)item -> {
                    Object v0;
                    if (item == null) {
                        v0 = null;
                    } else {
                        void var2_2;
                        HashMap javaMap = new HashMap();
                        ((scala.collection.immutable.Map)item).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            String key = (String)tuple2._1();
                            Object value = tuple2._2();
                            Object object = javaMap.put(key, valueConverter.apply(value));
                            return object;
                        });
                        v0 = var2_2;
                    }
                    return v0;
                };
            }
        }
        if (!(dataType2 instanceof StructType)) throw new MatchError((Object)dataType2);
        StructType structType = (StructType)dataType2;
        Schema schema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(structType, structName, recordNamespace);
        String string = recordNamespace;
        String string2 = "";
        String childNameSpace = (string == null ? string2 != null : !string.equals(string2)) ? new StringBuilder(1).append(recordNamespace).append(".").append(structName).toString() : structName;
        Function1[] fieldConverters = (Function1[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.createConverterToAvro(field.dataType(), field.name(), childNameSpace), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
        return (Function1 & Serializable & scala.Serializable)item -> {
            GenericData.Record record;
            if (item == null) {
                record = null;
            } else {
                GenericData.Record record2 = new GenericData.Record(schema);
                Iterator convertersIterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldConverters)).iterator();
                Iterator fieldNamesIterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((StructType)dataType).fieldNames())).iterator();
                Iterator rowIterator = ((Row)item).toSeq().iterator();
                while (convertersIterator.hasNext() && rowIterator.hasNext()) {
                    Function1 converter = (Function1)convertersIterator.next();
                    record2.put((String)fieldNamesIterator.next(), converter.apply(rowIterator.next()));
                }
                record = record2;
            }
            return record;
        };
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$1(Object item) {
        return item == null ? null : item.toString();
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$2(Object x) {
        return Predef$.MODULE$.identity(x);
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$3(Object item) {
        return item == null ? null : ((GenericData.Fixed)item).bytes().clone();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$createConverterToRow$4(Object item) {
        Object v0;
        if (item == null) {
            v0 = null;
        } else {
            void var2_2;
            ByteBuffer byteBuffer = (ByteBuffer)item;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            v0 = var2_2;
        }
        return v0;
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$5(Schema avroSchema$1, DecimalType x48$1, Object item) {
        Decimal decimal;
        if (item == null) {
            decimal = null;
        } else {
            Conversions.DecimalConversion decimalConversion = new Conversions.DecimalConversion();
            BigDecimal bigDecimal = decimalConversion.fromFixed((GenericFixed)item, avroSchema$1, (LogicalType)LogicalTypes.decimal((int)x48$1.precision(), (int)x48$1.scale()));
            decimal = MODULE$.createDecimal(bigDecimal, x48$1.precision(), x48$1.scale());
        }
        return decimal;
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$6(Schema avroSchema$1, DecimalType x50$1, Object item) {
        Decimal decimal;
        if (item == null) {
            decimal = null;
        } else {
            Conversions.DecimalConversion decimalConversion = new Conversions.DecimalConversion();
            BigDecimal bigDecimal = decimalConversion.fromBytes((ByteBuffer)item, avroSchema$1, (LogicalType)LogicalTypes.decimal((int)x50$1.precision(), (int)x50$1.scale()));
            decimal = MODULE$.createDecimal(bigDecimal, x50$1.precision(), x50$1.scale());
        }
        return decimal;
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$7(Object item) {
        Date date;
        if (item == null) {
            date = null;
        } else {
            Date date2;
            Object object = item;
            if (object instanceof Integer) {
                Integer n = (Integer)object;
                date2 = DateTimeUtils$.MODULE$.toJavaDate(Predef$.MODULE$.Integer2int(n));
            } else {
                date2 = new Date(BoxesRunTime.unboxToLong((Object)item));
            }
            date = date2;
        }
        return date;
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$8(Schema avroSchema$1, Object item) {
        Timestamp timestamp;
        if (item == null) {
            timestamp = null;
        } else {
            Timestamp timestamp2;
            LogicalType logicalType = avroSchema$1.getLogicalType();
            if (logicalType instanceof LogicalTypes.TimestampMillis) {
                timestamp2 = new Timestamp(BoxesRunTime.unboxToLong((Object)item));
            } else if (logicalType instanceof LogicalTypes.TimestampMicros) {
                timestamp2 = new Timestamp(BoxesRunTime.unboxToLong((Object)item) / 1000L);
            } else if (logicalType == null) {
                timestamp2 = new Timestamp(BoxesRunTime.unboxToLong((Object)item));
            } else {
                throw new HoodieIncompatibleSchemaException(new StringBuilder(61).append("Cannot convert Avro logical type ").append(logicalType).append(" to Catalyst Timestamp type.").toString());
            }
            timestamp = timestamp2;
        }
        return timestamp;
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$9(int length$1, Function1[] converters$1, int[] avroFieldIndexes$1, Object item) {
        GenericRow genericRow;
        if (item == null) {
            genericRow = null;
        } else {
            GenericRecord record = (GenericRecord)item;
            Object[] result = new Object[length$1];
            for (int i = 0; i < converters$1.length; ++i) {
                if (converters$1[i] == null) continue;
                Function1 converter = converters$1[i];
                result[i] = converter.apply(record.get(avroFieldIndexes$1[i]));
            }
            genericRow = new GenericRow(result);
        }
        return genericRow;
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$10(boolean allowsNull$1, List path$1, Function1 elementConverter$1, Object item) {
        return item == null ? null : ((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)item).asScala()).map((Function1 & Serializable & scala.Serializable)element -> {
            if (element == null && !allowsNull$1) {
                throw new RuntimeException(new StringBuilder(46).append("Array value at path ").append(path$1.mkString(".")).append(" is not ").append("allowed to be null").toString());
            }
            return elementConverter$1.apply(element);
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$12(boolean allowsNull$2, List path$1, Function1 valueConverter$1, Object item) {
        return item == null ? null : ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)item).asScala()).map((Function1 & Serializable & scala.Serializable)x -> {
            if (x._2() == null && !allowsNull$2) {
                throw new RuntimeException(new StringBuilder(44).append("Map value at path ").append(path$1.mkString(".")).append(" is not ").append("allowed to be null").toString());
            }
            return new Tuple2((Object)x._1().toString(), valueConverter$1.apply(x._2()));
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$createConverterToRow$14(Schema x$1) {
        Schema.Type type = x$1.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createConverterToRow$15(Schema x$2) {
        Schema.Type type = x$2.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ Schema.Type $anonfun$createConverterToRow$16(Schema x$3) {
        return x$3.getType();
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$17(Object item) {
        Long l;
        Object object = item;
        if (object == null) {
            l = null;
        } else if (object instanceof Long) {
            Long l2;
            l = l2 = (Long)object;
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            l = new Long(n.longValue());
        } else {
            throw new MatchError(object);
        }
        return l;
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$18(Object item) {
        Double d;
        Object object = item;
        if (object == null) {
            d = null;
        } else if (object instanceof Double) {
            Double d2;
            d = d2 = (Double)object;
        } else if (object instanceof Float) {
            Float f = (Float)object;
            d = new Double(f.doubleValue());
        } else {
            throw new MatchError(object);
        }
        return d;
    }

    public static final /* synthetic */ Function1 $anonfun$createConverterToRow$19(AvroConversionHelper$ $this, List path$1, Schema sourceAvroSchema$1, DataType targetSqlType$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField field = (StructField)tuple2._1();
        Schema schema = (Schema)tuple2._2();
        Function1 function1 = $this.createConverter$1(schema, field.dataType(), (List)path$1.$colon$plus((Object)field.name(), List$.MODULE$.canBuildFrom()), sourceAvroSchema$1, targetSqlType$1);
        return function1;
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$20(Schema avroSchema$1, Function1[] fieldConverters$1, Object item) {
        GenericRow genericRow;
        if (item == null) {
            genericRow = null;
        } else {
            int i = GenericData.get().resolveUnion(avroSchema$1, item);
            Object[] converted = new Object[fieldConverters$1.length];
            converted[i] = fieldConverters$1[i].apply(item);
            genericRow = new GenericRow(converted);
        }
        return genericRow;
    }

    /*
     * Unable to fully structure code
     */
    private final Function1 createConverter$1(Schema avroSchema, DataType sqlType, List path, Schema sourceAvroSchema$1, DataType targetSqlType$1) {
        block39: {
            block40: {
                block49: {
                    block48: {
                        while (true) {
                            block44: {
                                block47: {
                                    block46: {
                                        block45: {
                                            block43: {
                                                block42: {
                                                    block41: {
                                                        if ((var13_9 = new Tuple2((Object)sqlType, (Object)(avroType = avroSchema.getType()))) == null) break block41;
                                                        var14_10 = (DataType)var13_9._1();
                                                        var15_11 = (Schema.Type)var13_9._2();
                                                        if (!StringType$.MODULE$.equals(var14_10) || !Schema.Type.STRING.equals(var15_11)) break block41;
                                                        var11_7 = true;
                                                        break block42;
                                                    }
                                                    if (var13_9 == null) ** GOTO lbl-1000
                                                    var16_12 = (DataType)var13_9._1();
                                                    var17_13 = (Schema.Type)var13_9._2();
                                                    if (StringType$.MODULE$.equals(var16_12) && Schema.Type.ENUM.equals(var17_13)) {
                                                        var11_7 = true;
                                                    } else lbl-1000:
                                                    // 2 sources

                                                    {
                                                        var11_7 = false;
                                                    }
                                                }
                                                if (var11_7) {
                                                    var7_53 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$1(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)();
                                                    break block39;
                                                }
                                                if (var13_9 == null) break block43;
                                                var18_14 = (DataType)var13_9._1();
                                                var19_15 = (Schema.Type)var13_9._2();
                                                if (!IntegerType$.MODULE$.equals(var18_14) || !Schema.Type.INT.equals(var19_15)) break block43;
                                                var10_6 = true;
                                                break block44;
                                            }
                                            if (var13_9 == null) break block45;
                                            var20_16 = (DataType)var13_9._1();
                                            var21_17 = (Schema.Type)var13_9._2();
                                            if (!BooleanType$.MODULE$.equals(var20_16) || !Schema.Type.BOOLEAN.equals(var21_17)) break block45;
                                            var10_6 = true;
                                            break block44;
                                        }
                                        if (var13_9 == null) break block46;
                                        var22_18 = (DataType)var13_9._1();
                                        var23_19 = (Schema.Type)var13_9._2();
                                        if (!DoubleType$.MODULE$.equals(var22_18) || !Schema.Type.DOUBLE.equals(var23_19)) break block46;
                                        var10_6 = true;
                                        break block44;
                                    }
                                    if (var13_9 == null) break block47;
                                    var24_20 = (DataType)var13_9._1();
                                    var25_21 = (Schema.Type)var13_9._2();
                                    if (!FloatType$.MODULE$.equals(var24_20) || !Schema.Type.FLOAT.equals(var25_21)) break block47;
                                    var10_6 = true;
                                    break block44;
                                }
                                if (var13_9 == null) ** GOTO lbl-1000
                                var26_22 = (DataType)var13_9._1();
                                var27_23 = (Schema.Type)var13_9._2();
                                if (LongType$.MODULE$.equals(var26_22) && Schema.Type.LONG.equals(var27_23)) {
                                    var10_6 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var10_6 = false;
                                }
                            }
                            if (var10_6) {
                                var7_53 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$2(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)();
                                break block39;
                            }
                            if (var13_9 != null) {
                                var28_24 = (DataType)var13_9._1();
                                var29_25 = (Schema.Type)var13_9._2();
                                if (BinaryType$.MODULE$.equals(var28_24) && Schema.Type.FIXED.equals(var29_25)) {
                                    var7_53 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$3(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)();
                                    break block39;
                                }
                            }
                            if (var13_9 != null) {
                                var30_26 = (DataType)var13_9._1();
                                var31_27 = (Schema.Type)var13_9._2();
                                if (BinaryType$.MODULE$.equals(var30_26) && Schema.Type.BYTES.equals(var31_27)) {
                                    var7_53 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$4(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)();
                                    break block39;
                                }
                            }
                            if (var13_9 != null) {
                                d = (DataType)var13_9._1();
                                var33_29 = (Schema.Type)var13_9._2();
                                if (d instanceof DecimalType) {
                                    var34_30 = (DecimalType)d;
                                    if (Schema.Type.FIXED.equals(var33_29)) {
                                        var7_53 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$5(org.apache.avro.Schema org.apache.spark.sql.types.DecimalType java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((Schema)avroSchema, (DecimalType)var34_30);
                                        break block39;
                                    }
                                }
                            }
                            if (var13_9 != null) {
                                d = (DataType)var13_9._1();
                                var36_32 = (Schema.Type)var13_9._2();
                                if (d instanceof DecimalType) {
                                    var37_33 = (DecimalType)d;
                                    if (Schema.Type.BYTES.equals(var36_32)) {
                                        var7_53 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$6(org.apache.avro.Schema org.apache.spark.sql.types.DecimalType java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((Schema)avroSchema, (DecimalType)var37_33);
                                        break block39;
                                    }
                                }
                            }
                            if (var13_9 != null) {
                                var38_34 = (DataType)var13_9._1();
                                var39_35 = (Schema.Type)var13_9._2();
                                if (DateType$.MODULE$.equals(var38_34) && Schema.Type.INT.equals(var39_35)) {
                                    var7_53 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$7(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)();
                                    break block39;
                                }
                            }
                            if (var13_9 != null) {
                                var40_36 = (DataType)var13_9._1();
                                var41_37 = (Schema.Type)var13_9._2();
                                if (TimestampType$.MODULE$.equals(var40_36) && Schema.Type.LONG.equals(var41_37)) {
                                    var7_53 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$8(org.apache.avro.Schema java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((Schema)avroSchema);
                                    break block39;
                                }
                            }
                            if (var13_9 != null) {
                                struct = (DataType)var13_9._1();
                                var43_39 = (Schema.Type)var13_9._2();
                                if (struct instanceof StructType) {
                                    var44_40 = (StructType)struct;
                                    if (Schema.Type.RECORD.equals(var43_39)) {
                                        length = var44_40.fields().length;
                                        converters = new Function1[length];
                                        avroFieldIndexes = new int[length];
                                        for (i = 0; i < length; ++i) {
                                            sqlField = var44_40.fields()[i];
                                            avroField = avroSchema.getField(sqlField.name());
                                            if (avroField != null) {
                                                converters[i] = converter = this.createConverter$1(avroField.schema(), sqlField.dataType(), (List)path.$colon$plus((Object)sqlField.name(), List$.MODULE$.canBuildFrom()), sourceAvroSchema$1, targetSqlType$1);
                                                avroFieldIndexes[i] = avroField.pos();
                                                continue;
                                            }
                                            if (sqlField.nullable()) continue;
                                            throw new HoodieIncompatibleSchemaException(new StringBuilder(100).append("Cannot find non-nullable field ").append(sqlField.name()).append(" at path ").append(path.mkString(".")).append(" ").append("in Avro schema\n").append("Source Avro schema: ").append(sourceAvroSchema$1).append(".\n").append("Target Catalyst type: ").append(targetSqlType$1).toString());
                                        }
                                        var7_53 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$9(int scala.Function1[] int[] java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((int)length, (Function1[])converters, (int[])avroFieldIndexes);
                                        break block39;
                                    }
                                }
                            }
                            if (var13_9 != null) {
                                arrayType = (DataType)var13_9._1();
                                var53_42 = (Schema.Type)var13_9._2();
                                if (arrayType instanceof ArrayType) {
                                    var54_43 = (ArrayType)arrayType;
                                    if (Schema.Type.ARRAY.equals(var53_42)) {
                                        elementConverter = this.createConverter$1(avroSchema.getElementType(), var54_43.elementType(), path, sourceAvroSchema$1, targetSqlType$1);
                                        allowsNull = var54_43.containsNull();
                                        var7_53 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$10(boolean scala.collection.immutable.List scala.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((boolean)allowsNull, (List)path, (Function1)elementConverter);
                                        break block39;
                                    }
                                }
                            }
                            if (var13_9 != null) {
                                mapType = (DataType)var13_9._1();
                                var58_45 = (Schema.Type)var13_9._2();
                                if (mapType instanceof MapType) {
                                    var59_46 = (MapType)mapType;
                                    if (Schema.Type.MAP.equals(var58_45)) {
                                        v0 = var59_46.keyType();
                                        var60_47 = StringType$.MODULE$;
                                        if (!(v0 != null ? v0.equals(var60_47) == false : var60_47 != null)) {
                                            valueConverter = this.createConverter$1(avroSchema.getValueType(), var59_46.valueType(), path, sourceAvroSchema$1, targetSqlType$1);
                                            allowsNull = var59_46.valueContainsNull();
                                            var7_53 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$12(boolean scala.collection.immutable.List scala.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((boolean)allowsNull, (List)path, (Function1)valueConverter);
                                            break block39;
                                        }
                                    }
                                }
                            }
                            if (var13_9 == null) break block40;
                            sqlType = (DataType)var13_9._1();
                            var64_49 = (Schema.Type)var13_9._2();
                            if (!Schema.Type.UNION.equals(var64_49)) break block40;
                            if (((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).exists((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$14$adapted(org.apache.avro.Schema ), (Lorg/apache/avro/Schema;)Ljava/lang/Object;)())) {
                                remainingUnionTypes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$15$adapted(org.apache.avro.Schema ), (Lorg/apache/avro/Schema;)Ljava/lang/Object;)());
                                if (remainingUnionTypes.size() == 1) {
                                    sqlType = sqlType;
                                    avroSchema = (Schema)remainingUnionTypes.head();
                                    continue;
                                }
                                sqlType = sqlType;
                                avroSchema = Schema.createUnion((java.util.List)((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(remainingUnionTypes).asJava()));
                                continue;
                            }
                            var66_51 = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$16(org.apache.avro.Schema ), (Lorg/apache/avro/Schema;)Lorg/apache/avro/Schema$Type;)(), Buffer$.MODULE$.canBuildFrom());
                            var67_52 = Seq$.MODULE$.unapplySeq((Seq)var66_51);
                            if (var67_52.isEmpty() || var67_52.get() == null || ((SeqLike)var67_52.get()).lengthCompare(1) != 0) break;
                            sqlType = sqlType;
                            avroSchema = (Schema)avroSchema.getTypes().get(0);
                        }
                        var68_65 = Seq$.MODULE$.unapplySeq((Seq)var66_51);
                        if (var68_65.isEmpty() || var68_65.get() == null || ((SeqLike)var68_65.get()).lengthCompare(2) != 0) break block48;
                        a = (Schema.Type)((SeqLike)var68_65.get()).apply(0);
                        b = (Schema.Type)((SeqLike)var68_65.get()).apply(1);
                        v1 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{a, b}));
                        var71_68 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG}));
                        if (v1 != null ? v1.equals(var71_68) == false : var71_68 != null) break block48;
                        v2 = sqlType;
                        var72_69 = LongType$.MODULE$;
                        if (v2 != null ? v2.equals(var72_69) == false : var72_69 != null) break block48;
                        var8_70 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$17(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)();
                        break block49;
                    }
                    if ((var73_71 = Seq$.MODULE$.unapplySeq((Seq)var66_51)).isEmpty() || var73_71.get() == null || ((SeqLike)var73_71.get()).lengthCompare(2) != 0) ** GOTO lbl-1000
                    a = (Schema.Type)((SeqLike)var73_71.get()).apply(0);
                    b = (Schema.Type)((SeqLike)var73_71.get()).apply(1);
                    v3 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{a, b}));
                    var76_74 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.DOUBLE}));
                    if (v3 != null ? v3.equals(var76_74) == false : var76_74 != null) ** GOTO lbl-1000
                    v4 = sqlType;
                    var77_75 = DoubleType$.MODULE$;
                    if (!(v4 != null ? v4.equals(var77_75) == false : var77_75 != null)) {
                        var8_70 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$18(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)();
                    } else lbl-1000:
                    // 3 sources

                    {
                        if (!((var78_76 = sqlType) instanceof StructType) || (var79_77 = (StructType)var78_76).fields().length != avroSchema.getTypes().size()) {
                            throw new HoodieIncompatibleSchemaException(new StringBuilder(158).append("Cannot convert Avro schema to catalyst type because schema at path ").append(path.mkString(".")).append(" is not compatible ").append("(avroType = ").append(var66_51).append(", sqlType = ").append(sqlType).append("). \n").append("Source Avro schema: ").append(sourceAvroSchema$1).append(".\n").append("Target Catalyst type: ").append(targetSqlType$1).toString());
                        }
                        fieldConverters = (Function1[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])var79_77.fields())).zip((GenIterable)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$19(org.apache.hudi.AvroConversionHelper$ scala.collection.immutable.List org.apache.avro.Schema org.apache.spark.sql.types.DataType scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Function1;)((AvroConversionHelper$)this, (List)path, (Schema)sourceAvroSchema$1, (DataType)targetSqlType$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
                        var9_79 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$createConverterToRow$20(org.apache.avro.Schema scala.Function1[] java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((Schema)avroSchema, (Function1[])fieldConverters);
                        var8_70 = var9_79;
                    }
                }
                var7_53 = var8_70;
                break block39;
            }
            if (var13_9 != null) {
                left = (DataType)var13_9._1();
                right = (Schema.Type)var13_9._2();
                throw new HoodieIncompatibleSchemaException(new StringBuilder(158).append("Cannot convert Avro schema to catalyst type because schema at path ").append(path.mkString(".")).append(" is not compatible (avroType = ").append(left).append(", sqlType = ").append(right).append("). \n").append("Source Avro schema: ").append(sourceAvroSchema$1).append(".\n").append("Target Catalyst type: ").append(targetSqlType$1).toString());
            }
            throw new MatchError((Object)var13_9);
        }
        return var7_53;
    }

    public static final /* synthetic */ long $anonfun$createConverterToAvro$8(Object x$5) {
        return ((Timestamp)x$5).getTime() * 1000L;
    }

    public static final /* synthetic */ int $anonfun$createConverterToAvro$10(Object x$6) {
        return (int)((Date)x$6).toLocalDate().toEpochDay();
    }

    private AvroConversionHelper$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$14$adapted(Schema x$1) {
        return BoxesRunTime.boxToBoolean((boolean)AvroConversionHelper$.$anonfun$createConverterToRow$14(x$1));
    }

    public static final /* synthetic */ Object $anonfun$createConverterToRow$15$adapted(Schema x$2) {
        return BoxesRunTime.boxToBoolean((boolean)AvroConversionHelper$.$anonfun$createConverterToRow$15(x$2));
    }
}

