/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;

public class ConfigProperty<T>
implements Serializable {
    private final String key;
    private final T defaultValue;
    private final String doc;
    private final Option<String> sinceVersion;
    private final Option<String> deprecatedVersion;
    private final String[] alternatives;
    private final Option<Function<HoodieConfig, Option<T>>> inferFunction;

    ConfigProperty(String key, T defaultValue, String doc, Option<String> sinceVersion, Option<String> deprecatedVersion, Option<Function<HoodieConfig, Option<T>>> inferFunc, String ... alternatives) {
        this.key = Objects.requireNonNull(key);
        this.defaultValue = defaultValue;
        this.doc = doc;
        this.sinceVersion = sinceVersion;
        this.deprecatedVersion = deprecatedVersion;
        this.inferFunction = inferFunc;
        this.alternatives = alternatives;
    }

    public String key() {
        return this.key;
    }

    public T defaultValue() {
        if (this.defaultValue == null) {
            throw new HoodieException("There's no default value for this config");
        }
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public String doc() {
        return StringUtils.isNullOrEmpty(this.doc) ? "" : this.doc;
    }

    public Option<String> getSinceVersion() {
        return this.sinceVersion;
    }

    public Option<String> getDeprecatedVersion() {
        return this.deprecatedVersion;
    }

    Option<Function<HoodieConfig, Option<T>>> getInferFunc() {
        return this.inferFunction;
    }

    public List<String> getAlternatives() {
        return Arrays.asList(this.alternatives);
    }

    public ConfigProperty<T> withDocumentation(String doc) {
        Objects.requireNonNull(doc);
        return new ConfigProperty<T>(this.key, this.defaultValue, doc, this.sinceVersion, this.deprecatedVersion, this.inferFunction, this.alternatives);
    }

    public ConfigProperty<T> withAlternatives(String ... alternatives) {
        Objects.requireNonNull(alternatives);
        return new ConfigProperty<T>(this.key, this.defaultValue, this.doc, this.sinceVersion, this.deprecatedVersion, this.inferFunction, alternatives);
    }

    public ConfigProperty<T> sinceVersion(String sinceVersion) {
        Objects.requireNonNull(sinceVersion);
        return new ConfigProperty<T>(this.key, this.defaultValue, this.doc, Option.of(sinceVersion), this.deprecatedVersion, this.inferFunction, this.alternatives);
    }

    public ConfigProperty<T> deprecatedAfter(String deprecatedVersion) {
        Objects.requireNonNull(deprecatedVersion);
        return new ConfigProperty<T>(this.key, this.defaultValue, this.doc, this.sinceVersion, Option.of(deprecatedVersion), this.inferFunction, this.alternatives);
    }

    public ConfigProperty<T> withInferFunction(Function<HoodieConfig, Option<T>> inferFunction) {
        Objects.requireNonNull(inferFunction);
        return new ConfigProperty<T>(this.key, this.defaultValue, this.doc, this.sinceVersion, this.deprecatedVersion, Option.of(inferFunction), this.alternatives);
    }

    public static PropertyBuilder key(String key) {
        Objects.requireNonNull(key);
        return new PropertyBuilder(key);
    }

    public String toString() {
        return String.format("Key: '%s' , default: %s description: %s since version: %s deprecated after: %s)", this.key, this.defaultValue, this.doc, this.sinceVersion.isPresent() ? this.sinceVersion.get() : "version is not defined", this.deprecatedVersion.isPresent() ? this.deprecatedVersion.get() : "version is not defined");
    }

    public static final class PropertyBuilder {
        private final String key;

        PropertyBuilder(String key) {
            this.key = key;
        }

        public <T> ConfigProperty<T> defaultValue(T value) {
            Objects.requireNonNull(value);
            ConfigProperty<T> configProperty = new ConfigProperty<T>(this.key, value, "", Option.empty(), Option.empty(), Option.empty(), new String[0]);
            return configProperty;
        }

        public ConfigProperty<String> noDefaultValue() {
            ConfigProperty<Object> configProperty = new ConfigProperty<Object>(this.key, null, "", Option.empty(), Option.empty(), Option.empty(), new String[0]);
            return configProperty;
        }
    }
}

