/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.Serializable;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;

public interface HoodieTimeline
extends Serializable {
    public static final String COMMIT_ACTION = "commit";
    public static final String DELTA_COMMIT_ACTION = "deltacommit";
    public static final String CLEAN_ACTION = "clean";
    public static final String ROLLBACK_ACTION = "rollback";
    public static final String SAVEPOINT_ACTION = "savepoint";
    public static final String REPLACE_COMMIT_ACTION = "replacecommit";
    public static final String INFLIGHT_EXTENSION = ".inflight";
    public static final String COMPACTION_ACTION = "compaction";
    public static final String REQUESTED_EXTENSION = ".requested";
    public static final String RESTORE_ACTION = "restore";
    public static final String[] VALID_ACTIONS_IN_TIMELINE = new String[]{"commit", "deltacommit", "clean", "savepoint", "restore", "rollback", "compaction", "replacecommit"};
    public static final String COMMIT_EXTENSION = ".commit";
    public static final String DELTA_COMMIT_EXTENSION = ".deltacommit";
    public static final String CLEAN_EXTENSION = ".clean";
    public static final String ROLLBACK_EXTENSION = ".rollback";
    public static final String SAVEPOINT_EXTENSION = ".savepoint";
    public static final String INFLIGHT_COMMIT_EXTENSION = ".inflight";
    public static final String REQUESTED_COMMIT_EXTENSION = ".commit.requested";
    public static final String REQUESTED_DELTA_COMMIT_EXTENSION = ".deltacommit.requested";
    public static final String INFLIGHT_DELTA_COMMIT_EXTENSION = ".deltacommit.inflight";
    public static final String INFLIGHT_CLEAN_EXTENSION = ".clean.inflight";
    public static final String REQUESTED_CLEAN_EXTENSION = ".clean.requested";
    public static final String INFLIGHT_ROLLBACK_EXTENSION = ".rollback.inflight";
    public static final String REQUESTED_ROLLBACK_EXTENSION = ".rollback.requested";
    public static final String INFLIGHT_SAVEPOINT_EXTENSION = ".savepoint.inflight";
    public static final String REQUESTED_COMPACTION_SUFFIX = StringUtils.join("compaction", ".requested");
    public static final String REQUESTED_COMPACTION_EXTENSION = StringUtils.join(".", REQUESTED_COMPACTION_SUFFIX);
    public static final String INFLIGHT_COMPACTION_EXTENSION = StringUtils.join(".", "compaction", ".inflight");
    public static final String INFLIGHT_RESTORE_EXTENSION = ".restore.inflight";
    public static final String RESTORE_EXTENSION = ".restore";
    public static final String INFLIGHT_REPLACE_COMMIT_EXTENSION = ".replacecommit.inflight";
    public static final String REQUESTED_REPLACE_COMMIT_EXTENSION = ".replacecommit.requested";
    public static final String REPLACE_COMMIT_EXTENSION = ".replacecommit";
    public static final String INVALID_INSTANT_TS = "0";
    public static final String INIT_INSTANT_TS = "00000000000000";
    public static final String METADATA_BOOTSTRAP_INSTANT_TS = "00000000000001";
    public static final String FULL_BOOTSTRAP_INSTANT_TS = "00000000000002";
    public static final BiPredicate<String, String> EQUALS = (commit1, commit2) -> commit1.compareTo((String)commit2) == 0;
    public static final BiPredicate<String, String> GREATER_THAN_OR_EQUALS = (commit1, commit2) -> commit1.compareTo((String)commit2) >= 0;
    public static final BiPredicate<String, String> GREATER_THAN = (commit1, commit2) -> commit1.compareTo((String)commit2) > 0;
    public static final BiPredicate<String, String> LESSER_THAN_OR_EQUALS = (commit1, commit2) -> commit1.compareTo((String)commit2) <= 0;
    public static final BiPredicate<String, String> LESSER_THAN = (commit1, commit2) -> commit1.compareTo((String)commit2) < 0;

    public HoodieTimeline filterInflights();

    public HoodieTimeline filterInflightsAndRequested();

    public HoodieTimeline filterPendingExcludingCompaction();

    public HoodieTimeline filterCompletedInstants();

    public HoodieTimeline filterCompletedAndCompactionInstants();

    public HoodieTimeline getWriteTimeline();

    public HoodieTimeline getCompletedReplaceTimeline();

    public HoodieTimeline filterPendingCompactionTimeline();

    public HoodieTimeline filterPendingReplaceTimeline();

    public HoodieTimeline filterPendingRollbackTimeline();

    public HoodieTimeline findInstantsAfterOrEquals(String var1, int var2);

    public HoodieTimeline findInstantsInRange(String var1, String var2);

    public HoodieTimeline findInstantsAfter(String var1, int var2);

    public HoodieTimeline findInstantsAfter(String var1);

    public HoodieTimeline findInstantsBefore(String var1);

    public HoodieTimeline findInstantsBeforeOrEquals(String var1);

    public HoodieTimeline filter(Predicate<HoodieInstant> var1);

    public boolean empty();

    public int countInstants();

    public Option<HoodieInstant> firstInstant();

    public Option<HoodieInstant> firstInstant(String var1, HoodieInstant.State var2);

    public Option<HoodieInstant> nthInstant(int var1);

    public Option<HoodieInstant> lastInstant();

    public String getTimelineHash();

    public Option<HoodieInstant> nthFromLastInstant(int var1);

    public boolean containsInstant(HoodieInstant var1);

    public boolean containsInstant(String var1);

    public boolean containsOrBeforeTimelineStarts(String var1);

    public Stream<HoodieInstant> getInstants();

    public Stream<HoodieInstant> getReverseOrderedInstants();

    public boolean isBeforeTimelineStarts(String var1);

    public Option<byte[]> getInstantDetails(HoodieInstant var1);

    public static boolean compareTimestamps(String commit1, BiPredicate<String, String> predicateToApply, String commit2) {
        return predicateToApply.test(commit1, commit2);
    }

    public static boolean isInRange(String timestamp, String startTs, String endTs) {
        return HoodieTimeline.compareTimestamps(timestamp, GREATER_THAN, startTs) && HoodieTimeline.compareTimestamps(timestamp, LESSER_THAN_OR_EQUALS, endTs);
    }

    public static HoodieInstant getCompletedInstant(HoodieInstant instant) {
        return new HoodieInstant(HoodieInstant.State.COMPLETED, instant.getAction(), instant.getTimestamp());
    }

    public static HoodieInstant getRequestedInstant(HoodieInstant instant) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, instant.getAction(), instant.getTimestamp());
    }

    public static HoodieInstant getCleanRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, CLEAN_ACTION, timestamp);
    }

    public static HoodieInstant getCleanInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, CLEAN_ACTION, timestamp);
    }

    public static HoodieInstant getCompactionRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, COMPACTION_ACTION, timestamp);
    }

    public static HoodieInstant getCompactionInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, COMPACTION_ACTION, timestamp);
    }

    public static HoodieInstant getReplaceCommitRequestedInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.REQUESTED, REPLACE_COMMIT_ACTION, timestamp);
    }

    public static HoodieInstant getReplaceCommitInflightInstant(String timestamp) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, REPLACE_COMMIT_ACTION, timestamp);
    }

    public static HoodieInstant getInflightInstant(HoodieInstant instant, HoodieTableType tableType) {
        if (tableType == HoodieTableType.MERGE_ON_READ && instant.getAction().equals(COMMIT_ACTION)) {
            return new HoodieInstant(true, COMPACTION_ACTION, instant.getTimestamp());
        }
        return new HoodieInstant(true, instant.getAction(), instant.getTimestamp());
    }

    public static String makeCommitFileName(String instantTime) {
        return StringUtils.join(instantTime, COMMIT_EXTENSION);
    }

    public static String makeInflightCommitFileName(String instantTime) {
        return StringUtils.join(instantTime, ".inflight");
    }

    public static String makeRequestedCommitFileName(String instantTime) {
        return StringUtils.join(instantTime, REQUESTED_COMMIT_EXTENSION);
    }

    public static String makeCleanerFileName(String instant) {
        return StringUtils.join(instant, CLEAN_EXTENSION);
    }

    public static String makeRequestedCleanerFileName(String instant) {
        return StringUtils.join(instant, REQUESTED_CLEAN_EXTENSION);
    }

    public static String makeInflightCleanerFileName(String instant) {
        return StringUtils.join(instant, INFLIGHT_CLEAN_EXTENSION);
    }

    public static String makeRollbackFileName(String instant) {
        return StringUtils.join(instant, ROLLBACK_EXTENSION);
    }

    public static String makeRequestedRollbackFileName(String instant) {
        return StringUtils.join(instant, REQUESTED_ROLLBACK_EXTENSION);
    }

    public static String makeInflightRollbackFileName(String instant) {
        return StringUtils.join(instant, INFLIGHT_ROLLBACK_EXTENSION);
    }

    public static String makeInflightSavePointFileName(String instantTime) {
        return StringUtils.join(instantTime, INFLIGHT_SAVEPOINT_EXTENSION);
    }

    public static String makeSavePointFileName(String instantTime) {
        return StringUtils.join(instantTime, SAVEPOINT_EXTENSION);
    }

    public static String makeInflightDeltaFileName(String instantTime) {
        return StringUtils.join(instantTime, INFLIGHT_DELTA_COMMIT_EXTENSION);
    }

    public static String makeRequestedDeltaFileName(String instantTime) {
        return StringUtils.join(instantTime, REQUESTED_DELTA_COMMIT_EXTENSION);
    }

    public static String makeInflightCompactionFileName(String instantTime) {
        return StringUtils.join(instantTime, INFLIGHT_COMPACTION_EXTENSION);
    }

    public static String makeRequestedCompactionFileName(String instantTime) {
        return StringUtils.join(instantTime, REQUESTED_COMPACTION_EXTENSION);
    }

    public static String makeRestoreFileName(String instant) {
        return StringUtils.join(instant, RESTORE_EXTENSION);
    }

    public static String makeInflightRestoreFileName(String instant) {
        return StringUtils.join(instant, INFLIGHT_RESTORE_EXTENSION);
    }

    public static String makeReplaceFileName(String instant) {
        return StringUtils.join(instant, REPLACE_COMMIT_EXTENSION);
    }

    public static String makeInflightReplaceFileName(String instant) {
        return StringUtils.join(instant, INFLIGHT_REPLACE_COMMIT_EXTENSION);
    }

    public static String makeRequestedReplaceFileName(String instant) {
        return StringUtils.join(instant, REQUESTED_REPLACE_COMMIT_EXTENSION);
    }

    public static String makeDeltaFileName(String instantTime) {
        return instantTime + DELTA_COMMIT_EXTENSION;
    }

    public static String getCommitFromCommitFile(String commitFileName) {
        return commitFileName.split("\\.")[0];
    }

    public static String makeFileNameAsComplete(String fileName) {
        return fileName.replace(".inflight", "");
    }

    public static String makeFileNameAsInflight(String fileName) {
        return StringUtils.join(fileName, ".inflight");
    }
}

