/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.InvalidTableException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class InputPathHandler {
    public static final Logger LOG = LogManager.getLogger(InputPathHandler.class);
    private final Configuration conf;
    private final Map<String, HoodieTableMetaClient> tableMetaClientMap;
    private final Map<HoodieTableMetaClient, List<Path>> groupedIncrementalPaths;
    private final List<Path> snapshotPaths;
    private final List<Path> nonHoodieInputPaths;

    public InputPathHandler(Configuration conf, Path[] inputPaths, List<String> incrementalTables) throws IOException {
        this.conf = conf;
        this.tableMetaClientMap = new HashMap<String, HoodieTableMetaClient>();
        this.snapshotPaths = new ArrayList<Path>();
        this.nonHoodieInputPaths = new ArrayList<Path>();
        this.groupedIncrementalPaths = new HashMap<HoodieTableMetaClient, List<Path>>();
        this.parseInputPaths(inputPaths, incrementalTables);
    }

    private void parseInputPaths(Path[] inputPaths, List<String> incrementalTables) throws IOException {
        for (Path inputPath : inputPaths) {
            boolean basePathKnown = false;
            for (HoodieTableMetaClient metaClient : this.tableMetaClientMap.values()) {
                if (!inputPath.toString().contains(metaClient.getBasePath())) continue;
                basePathKnown = true;
                String tableName = metaClient.getTableConfig().getTableName();
                this.tagAsIncrementalOrSnapshot(inputPath, tableName, metaClient, incrementalTables);
                break;
            }
            if (basePathKnown) continue;
            try {
                HoodieTableMetaClient metaClient = HoodieInputFormatUtils.getTableMetaClientForBasePath(inputPath.getFileSystem(this.conf), inputPath);
                String tableName = metaClient.getTableConfig().getTableName();
                this.tableMetaClientMap.put(tableName, metaClient);
                this.tagAsIncrementalOrSnapshot(inputPath, tableName, metaClient, incrementalTables);
            }
            catch (InvalidTableException | TableNotFoundException e) {
                LOG.info((Object)("Handling a non-hoodie path " + inputPath));
                this.nonHoodieInputPaths.add(inputPath);
            }
        }
    }

    private void tagAsIncrementalOrSnapshot(Path inputPath, String tableName, HoodieTableMetaClient metaClient, List<String> incrementalTables) {
        if (!incrementalTables.contains(tableName)) {
            this.snapshotPaths.add(inputPath);
        } else {
            if (!this.groupedIncrementalPaths.containsKey(metaClient)) {
                this.groupedIncrementalPaths.put(metaClient, new ArrayList());
            }
            this.groupedIncrementalPaths.get(metaClient).add(inputPath);
        }
    }

    public Map<HoodieTableMetaClient, List<Path>> getGroupedIncrementalPaths() {
        return this.groupedIncrementalPaths;
    }

    public Map<String, HoodieTableMetaClient> getTableMetaClientMap() {
        return this.tableMetaClientMap;
    }

    public List<Path> getSnapshotPaths() {
        return this.snapshotPaths;
    }

    public List<Path> getNonHoodieInputPaths() {
        return this.nonHoodieInputPaths;
    }
}

