/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal;

import java.util.Optional;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.config.HoodieInternalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.internal.BaseDefaultSource;
import org.apache.hudi.internal.HoodieDataSourceInternalWriter;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.WriteSupport;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.types.StructType;

public class DefaultSource
extends BaseDefaultSource
implements DataSourceV2,
ReadSupport,
WriteSupport,
DataSourceRegister {
    public String shortName() {
        return "hudi_internal";
    }

    public DataSourceReader createReader(StructType schema, DataSourceOptions options) {
        return null;
    }

    public DataSourceReader createReader(DataSourceOptions options) {
        return null;
    }

    public Optional<DataSourceWriter> createWriter(String writeUUID, StructType schema, SaveMode mode, DataSourceOptions options) {
        String instantTime = (String)options.get("hoodie.instant.time").get();
        String path = (String)options.get("path").get();
        String tblName = (String)options.get(HoodieWriteConfig.TBL_NAME.key()).get();
        boolean populateMetaFields = options.getBoolean(HoodieTableConfig.POPULATE_META_FIELDS.key(), Boolean.parseBoolean(HoodieTableConfig.POPULATE_META_FIELDS.defaultValue()));
        HoodieWriteConfig config = DataSourceUtils.createHoodieConfig((String)options.get(HoodieWriteConfig.AVRO_SCHEMA_STRING.key()).get(), path, tblName, options.asMap());
        boolean arePartitionRecordsSorted = HoodieInternalConfig.getBulkInsertIsPartitionRecordsSorted(options.get("hoodie.bulkinsert.are.partitioner.records.sorted").isPresent() ? (String)options.get("hoodie.bulkinsert.are.partitioner.records.sorted").get() : null);
        return Optional.of(new HoodieDataSourceInternalWriter(instantTime, config, schema, this.getSparkSession(), this.getConfiguration(), options, populateMetaFields, arePartitionRecordsSorted));
    }
}

