/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.spark.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001\u0002\u0015*\u0001YB\u0001\u0002\r\u0001\u0003\u0006\u0004%\ta\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\t\"A\u0011\n\u0001BC\u0002\u0013\u0005!\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u001d)\u0006A1A\u0005\nYCaa\u0018\u0001!\u0002\u00139\u0006b\u00021\u0001\u0005\u0004%\t!\u0019\u0005\u0007[\u0002\u0001\u000b\u0011\u00022\t\u000f9\u0004!\u0019!C\u0001_\"11\u000f\u0001Q\u0001\nADq\u0001\u001e\u0001C\u0002\u0013\u0005\u0011\r\u0003\u0004v\u0001\u0001\u0006IA\u0019\u0005\bm\u0002\u0011\r\u0011\"\u0001x\u0011\u0019Y\b\u0001)A\u0005q\"AA\u0010\u0001EC\u0002\u0013\u0005Q\u0010\u0003\u0006\u0002\u0010\u0001A)\u0019!C\u0001\u0003#A\u0011\"!\u0007\u0001\u0011\u000b\u0007I\u0011A1\t\u0015\u0005m\u0001\u0001#b\u0001\n\u0003\ti\u0002C\u0005\u0002,\u0001A)\u0019!C\u0001C\"Q\u0011Q\u0006\u0001\t\u0006\u0004%\t!a\f\t\u0015\u0005]\u0002\u0001#b\u0001\n\u0003\tI\u0004\u0003\u0006\u0002B\u0001A)\u0019!C\u0001\u0003_A!\"a\u0011\u0001\u0011\u000b\u0007I\u0011AA#\u0011)\t\u0019\u0006\u0001EC\u0002\u0013\u0005\u0011Q\t\u0005\u000b\u0003+\u0002\u0001R1A\u0005\u0002\u0005\u0015\u0003BCA,\u0001!\u0015\r\u0011\"\u0001\u0002F!Q\u0011\u0011\f\u0001\t\u0006\u0004%\t!!\u0012\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003\u000b\u0003A\u0011BAD\u0011%\t)\nAI\u0001\n\u0013\t9\nC\u0004\u0002.\u0002!I!a,\b\u000f\u0005=\u0017\u0006#\u0001\u0002R\u001a1\u0001&\u000bE\u0001\u0003'Da\u0001\u0015\u0013\u0005\u0002\u0005U\u0007bBAlI\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003/$C\u0011AAp\u0005IAun\u001c3jK\u000e\u000bG/\u00197pOR\u000b'\r\\3\u000b\u0005)Z\u0013aB2bi\u0006dwn\u001a\u0006\u0003Y5\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003]=\n1a]9m\u0015\t\u0001\u0014'A\u0003ta\u0006\u00148N\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<7\u0001A\n\u0004\u0001]j\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$AB!osJ+g\r\u0005\u0002?\u00036\tqH\u0003\u0002A_\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002C\u007f\t9Aj\\4hS:<W#\u0001#\u0011\u0005\u00153U\"A\u0017\n\u0005\u001dk#\u0001D*qCJ\\7+Z:tS>t\u0017AB:qCJ\\\u0007%A\u0003uC\ndW-F\u0001L!\taU*D\u0001*\u0013\tq\u0015F\u0001\u0007DCR\fGn\\4UC\ndW-\u0001\u0004uC\ndW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I\u001bF\u000b\u0005\u0002M\u0001!)\u0001'\u0002a\u0001\t\")\u0011*\u0002a\u0001\u0017\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0016\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\t\r|gN\u001a\u0006\u00039F\na\u0001[1e_>\u0004\u0018B\u00010Z\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006Y\u0001.\u00193p_B\u001cuN\u001c4!\u0003A\u0019\u0017\r^1m_\u001e$\u0016M\u00197f\u001d\u0006lW-F\u0001c!\t\u0019'N\u0004\u0002eQB\u0011Q-O\u0007\u0002M*\u0011q-N\u0001\u0007yI|w\u000e\u001e \n\u0005%L\u0014A\u0002)sK\u0012,g-\u0003\u0002lY\n11\u000b\u001e:j]\u001eT!![\u001d\u0002#\r\fG/\u00197pOR\u000b'\r\\3OC6,\u0007%A\tdCR\fGn\\4Qe>\u0004XM\u001d;jKN,\u0012\u0001\u001d\t\u0005GF\u0014'-\u0003\u0002sY\n\u0019Q*\u00199\u0002%\r\fG/\u00197pOB\u0013x\u000e]3si&,7\u000fI\u0001\u000ei\u0006\u0014G.\u001a'pG\u0006$\u0018n\u001c8\u0002\u001dQ\f'\r\\3M_\u000e\fG/[8oA\u0005\t\u0002n\\8eS\u0016$\u0016M\u00197f\u000bbL7\u000f^:\u0016\u0003a\u0004\"\u0001O=\n\u0005iL$a\u0002\"p_2,\u0017M\\\u0001\u0013Q>|G-[3UC\ndW-\u0012=jgR\u001c\b%\u0001\u0006nKR\f7\t\\5f]R,\u0012A \t\u0004\u007f\u0006-QBAA\u0001\u0015\rI\u00151\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0004d_6lwN\u001c\u0006\u0004\u0003\u0013\t\u0014\u0001\u00025vI&LA!!\u0004\u0002\u0002\t)\u0002j\\8eS\u0016$\u0016M\u00197f\u001b\u0016$\u0018m\u00117jK:$\u0018a\u0003;bE2,7i\u001c8gS\u001e,\"!a\u0005\u0011\u0007}\f)\"\u0003\u0003\u0002\u0018\u0005\u0005!!\u0005%p_\u0012LW\rV1cY\u0016\u001cuN\u001c4jO\u0006IA/\u00192mK:\u000bW.Z\u0001\ni\u0006\u0014G.\u001a+za\u0016,\"!a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQA!!\n\u0002\u0004\u0005)Qn\u001c3fY&!\u0011\u0011FA\u0012\u0005=Aun\u001c3jKR\u000b'\r\\3UsB,\u0017!\u0004;bE2,G+\u001f9f\u001d\u0006lW-A\u0006qe&l\u0017M]=LKf\u001cXCAA\u0019!\u0011A\u00141\u00072\n\u0007\u0005U\u0012HA\u0003BeJ\f\u00170A\u0007qe\u0016\u001cu.\u001c2j]\u0016\\U-_\u000b\u0003\u0003w\u0001B\u0001OA\u001fE&\u0019\u0011qH\u001d\u0003\r=\u0003H/[8o\u0003=\u0001\u0018M\u001d;ji&|gNR5fY\u0012\u001c\u0018a\u0003;bE2,7k\u00195f[\u0006,\"!a\u0012\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014.\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\t&a\u0013\u0003\u0015M#(/^2u)f\u0004X-\u0001\u000fuC\ndWmU2iK6\fw+\u001b;i_V$X*\u001a;b\r&,G\u000eZ:\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017-A\u000eeCR\f7k\u00195f[\u0006<\u0016\u000e\u001e5pkRlU\r^1GS\u0016dGm]\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\u0006!r-\u001a;BY2\u0004\u0016M\u001d;ji&|g\u000eU1uQN,\"!a\u0018\u0011\u000b\u0005\u0005\u00141\u000e2\u000f\t\u0005\r\u0014q\r\b\u0004K\u0006\u0015\u0014\"\u0001\u001e\n\u0007\u0005%\u0014(A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0014q\u000e\u0002\u0004'\u0016\f(bAA5s\u0005y\u0011N\\5u\u0011>|G-[3UC\ndW\r\u0006\u0002\u0002vA\u0019\u0001(a\u001e\n\u0007\u0005e\u0014H\u0001\u0003V]&$\u0018!\u00069beN,7k\u00195f[\u0006\fe\u000eZ\"p]\u001aLwm\u001d\u000b\u0003\u0003\u007f\u0002b\u0001OAA\u0003\u000f\u0002\u0018bAABs\t1A+\u001e9mKJ\n\u0001#\u001a=ue\u0006$\u0016M\u00197f\u0007>tg-[4\u0015\u000fA\fI)!$\u0002\u0012\"1\u00111\u0012\u0011A\u0002\u0011\u000bAb\u001d9be.\u001cVm]:j_:Da!a$!\u0001\u0004A\u0018!D5t)\u0006\u0014G.Z#ySN$8\u000f\u0003\u0005\u0002\u0014\u0002\u0002\n\u00111\u0001q\u0003Ey'/[4j]R\u000b'\r\\3D_:4\u0017nZ\u0001\u001bKb$(/\u0019+bE2,7i\u001c8gS\u001e$C-\u001a4bk2$HeM\u000b\u0003\u00033S3\u0001]ANW\t\ti\n\u0005\u0003\u0002 \u0006%VBAAQ\u0015\u0011\t\u0019+!*\u0002\u0013Ut7\r[3dW\u0016$'bAATs\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0016\u0011\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u0005<fe&4\u0017\u0010R1uCN\u001b\u0007.Z7b)!\t)(!-\u0002>\u0006\u0015\u0007bBAZE\u0001\u0007\u0011QW\u0001\u0010i\u0006\u0014G.Z%eK:$\u0018NZ5feB!\u0011qWA]\u001b\u0005Y\u0013bAA^W\tyA+\u00192mK&#WM\u001c;jM&,'\u000fC\u0004\u0002\u001c\t\u0002\r!a0\u0011\u00071\u000b\t-C\u0002\u0002D&\u0012\u0001cQ1uC2|w\rV1cY\u0016$\u0016\u0010]3\t\u000f\u0005U#\u00051\u0001\u0002HB1\u0011\u0011MA6\u0003\u0013\u0004B!!\u0013\u0002L&!\u0011QZA&\u0005-\u0019FO];di\u001aKW\r\u001c3\u0002%!{w\u000eZ5f\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\t\u0003\u0019\u0012\u001a\"\u0001J\u001c\u0015\u0005\u0005E\u0017!B1qa2LH#\u0002*\u0002\\\u0006u\u0007BBAFM\u0001\u0007A\tC\u0004\u00024\u001a\u0002\r!!.\u0015\u000bI\u000b\t/a9\t\r\u0005-u\u00051\u0001E\u0011\u0019\t)o\na\u0001\u0017\u0006a1-\u0019;bY><G+\u00192mK\u0002")
public class HoodieCatalogTable
implements Logging {
    private HoodieTableMetaClient metaClient;
    private HoodieTableConfig tableConfig;
    private String tableName;
    private HoodieTableType tableType;
    private String tableTypeName;
    private String[] primaryKeys;
    private Option<String> preCombineKey;
    private String[] partitionFields;
    private StructType tableSchema;
    private StructType tableSchemaWithoutMetaFields;
    private StructType dataSchema;
    private StructType dataSchemaWithoutMetaFields;
    private StructType partitionSchema;
    private final SparkSession spark;
    private final CatalogTable table;
    private final Configuration hadoopConf;
    private final String catalogTableName;
    private final scala.collection.immutable.Map<String, String> catalogProperties;
    private final String tableLocation;
    private final boolean hoodieTableExists;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile int bitmap$0;

    public static HoodieCatalogTable apply(SparkSession sparkSession, CatalogTable catalogTable) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, catalogTable);
    }

    public static HoodieCatalogTable apply(SparkSession sparkSession, TableIdentifier tableIdentifier) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, tableIdentifier);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public CatalogTable table() {
        return this.table;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public String catalogTableName() {
        return this.catalogTableName;
    }

    public scala.collection.immutable.Map<String, String> catalogProperties() {
        return this.catalogProperties;
    }

    public String tableLocation() {
        return this.tableLocation;
    }

    public boolean hoodieTableExists() {
        return this.hoodieTableExists;
    }

    private HoodieTableMetaClient metaClient$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 1) == 0) {
                this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.tableLocation()).setConf(this.hadoopConf()).build();
                this.bitmap$0 |= 1;
            }
        }
        return this.metaClient;
    }

    public HoodieTableMetaClient metaClient() {
        return (this.bitmap$0 & 1) == 0 ? this.metaClient$lzycompute() : this.metaClient;
    }

    private HoodieTableConfig tableConfig$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 2) == 0) {
                this.tableConfig = this.metaClient().getTableConfig();
                this.bitmap$0 |= 2;
            }
        }
        return this.tableConfig;
    }

    public HoodieTableConfig tableConfig() {
        return (this.bitmap$0 & 2) == 0 ? this.tableConfig$lzycompute() : this.tableConfig;
    }

    private String tableName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 4) == 0) {
                this.tableName = this.tableConfig().getTableName();
                this.bitmap$0 |= 4;
            }
        }
        return this.tableName;
    }

    public String tableName() {
        return (this.bitmap$0 & 4) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 8) == 0) {
                this.tableType = this.tableConfig().getTableType();
                this.bitmap$0 |= 8;
            }
        }
        return this.tableType;
    }

    public HoodieTableType tableType() {
        return (this.bitmap$0 & 8) == 0 ? this.tableType$lzycompute() : this.tableType;
    }

    private String tableTypeName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.tableTypeName = this.tableType().name();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.tableTypeName;
    }

    public String tableTypeName() {
        return (this.bitmap$0 & 0x10) == 0 ? this.tableTypeName$lzycompute() : this.tableTypeName;
    }

    private String[] primaryKeys$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.primaryKeys = this.tableConfig().getRecordKeyFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.primaryKeys;
    }

    public String[] primaryKeys() {
        return (this.bitmap$0 & 0x20) == 0 ? this.primaryKeys$lzycompute() : this.primaryKeys;
    }

    private Option<String> preCombineKey$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.preCombineKey = Option$.MODULE$.apply((Object)this.tableConfig().getPreCombineField());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.preCombineKey;
    }

    public Option<String> preCombineKey() {
        return (this.bitmap$0 & 0x40) == 0 ? this.preCombineKey$lzycompute() : this.preCombineKey;
    }

    private String[] partitionFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.partitionFields = this.tableConfig().getPartitionFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x80;
            }
        }
        return this.partitionFields;
    }

    public String[] partitionFields() {
        return (this.bitmap$0 & 0x80) == 0 ? this.partitionFields$lzycompute() : this.partitionFields;
    }

    private StructType tableSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x100) == 0) {
                StructType originSchema = (StructType)HoodieSqlUtils$.MODULE$.getTableSqlSchema(this.metaClient(), true).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.table().schema());
                this.tableSchema = StructType$.MODULE$.apply((Seq)originSchema.map((Function1 & Serializable & scala.Serializable)x$2 -> {
                    boolean x$1 = true;
                    String x$22 = x$2.copy$default$1();
                    DataType x$3 = x$2.copy$default$2();
                    Metadata x$4 = x$2.copy$default$4();
                    return x$2.copy(x$22, x$3, x$1, x$4);
                }, Seq$.MODULE$.canBuildFrom()));
                this.bitmap$0 |= 0x100;
            }
        }
        return this.tableSchema;
    }

    public StructType tableSchema() {
        return (this.bitmap$0 & 0x100) == 0 ? this.tableSchema$lzycompute() : this.tableSchema;
    }

    private StructType tableSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.tableSchemaWithoutMetaFields = HoodieSqlUtils$.MODULE$.removeMetaFields(this.tableSchema());
                this.bitmap$0 |= 0x200;
            }
        }
        return this.tableSchemaWithoutMetaFields;
    }

    public StructType tableSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x200) == 0 ? this.tableSchemaWithoutMetaFields$lzycompute() : this.tableSchemaWithoutMetaFields;
    }

    private StructType dataSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.dataSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$dataSchema$1(this, f))));
                this.bitmap$0 |= 0x400;
            }
        }
        return this.dataSchema;
    }

    public StructType dataSchema() {
        return (this.bitmap$0 & 0x400) == 0 ? this.dataSchema$lzycompute() : this.dataSchema;
    }

    private StructType dataSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.dataSchemaWithoutMetaFields = HoodieSqlUtils$.MODULE$.removeMetaFields(this.dataSchema());
                this.bitmap$0 |= 0x800;
            }
        }
        return this.dataSchemaWithoutMetaFields;
    }

    public StructType dataSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x800) == 0 ? this.dataSchemaWithoutMetaFields$lzycompute() : this.dataSchemaWithoutMetaFields;
    }

    private StructType partitionSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.partitionSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$partitionSchema$1(this, f))));
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.partitionSchema;
    }

    public StructType partitionSchema() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.partitionSchema$lzycompute() : this.partitionSchema;
    }

    public Seq<String> getAllPartitionPaths() {
        return HoodieSqlUtils$.MODULE$.getAllPartitionPaths(this.spark(), this.table());
    }

    public void initHoodieTable() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Init hoodie.properties for ").append(this.table().identifier().unquotedString()).toString());
        Tuple2<StructType, scala.collection.immutable.Map<String, String>> tuple2 = this.parseSchemaAndConfigs();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        StructType finalSchema = (StructType)tuple2._1();
        scala.collection.immutable.Map tableConfigs = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
        Tuple2 tuple23 = tuple22;
        StructType finalSchema2 = (StructType)tuple23._1();
        scala.collection.immutable.Map tableConfigs2 = (scala.collection.immutable.Map)tuple23._2();
        Properties properties = new Properties();
        properties.putAll((java.util.Map<?, ?>)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tableConfigs2).asJava()));
        HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setTableName(this.table().identifier().table()).setTableCreateSchema(SchemaConverters$.MODULE$.toAvroType((DataType)finalSchema2, SchemaConverters$.MODULE$.toAvroType$default$2(), SchemaConverters$.MODULE$.toAvroType$default$3(), SchemaConverters$.MODULE$.toAvroType$default$4()).toString()).setPartitionFields(this.table().partitionColumnNames().mkString(",")).initTable(this.hadoopConf(), this.tableLocation());
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<StructType, scala.collection.immutable.Map<String, String>> parseSchemaAndConfigs() {
        globalProps = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        globalTableConfigs = HoodieWriterUtils$.MODULE$.mappingSparkDatasourceConfigsToTableConfigs((scala.collection.immutable.Map<String, String>)globalProps);
        globalSqlOptions = HoodieOptionConfig$.MODULE$.mappingTableConfigToSqlOption(globalTableConfigs);
        sqlOptions = HoodieOptionConfig$.MODULE$.withDefaultSqlOptions((scala.collection.immutable.Map<String, String>)globalSqlOptions.$plus$plus(this.catalogProperties()));
        var9_5 = new Tuple2((Object)this.table().tableType(), (Object)BoxesRunTime.boxToBoolean((boolean)this.hoodieTableExists()));
        if (var9_5 == null) ** GOTO lbl-1000
        var10_6 = (CatalogTableType)var9_5._1();
        var11_7 = var9_5._2$mcZ$sp();
        v0 = CatalogTableType$.MODULE$.EXTERNAL();
        var12_8 = var10_6;
        if (!(v0 != null ? v0.equals(var12_8) == false : var12_8 != null) && var11_7) {
            existingTableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)this.tableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
            currentTableConfig = globalTableConfigs.$plus$plus((GenTraversableOnce)existingTableConfig);
            catalogTableProps = HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(this.catalogProperties());
            HoodieWriterUtils$.MODULE$.validateTableConfig(this.spark(), catalogTableProps, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)existingTableConfig));
            options = this.extraTableConfig(this.spark(), this.hoodieTableExists(), (scala.collection.immutable.Map<String, String>)currentTableConfig).$plus$plus(HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(sqlOptions)).$plus$plus((GenTraversableOnce)currentTableConfig);
            ValidationUtils.checkArgument(this.tableSchema().nonEmpty() != false || this.table().schema().nonEmpty() != false, new StringBuilder(33).append("Missing schema for Create Table: ").append(this.catalogTableName()).toString());
            schema = this.tableSchema().nonEmpty() != false ? this.tableSchema() : HoodieSqlUtils$.MODULE$.addMetaFields(this.table().schema());
            var2_14 = new Tuple2((Object)schema, (Object)options);
        } else if (var9_5 != null && !(var18_15 = var9_5._2$mcZ$sp())) {
            ValidationUtils.checkArgument(this.table().schema().nonEmpty(), new StringBuilder(33).append("Missing schema for Create Table: ").append(this.catalogTableName()).toString());
            schema = this.table().schema();
            options = this.extraTableConfig(this.spark(), false, globalTableConfigs).$plus$plus(HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(sqlOptions));
            var2_14 = new Tuple2((Object)HoodieSqlUtils$.MODULE$.addMetaFields(schema), (Object)options);
        } else {
            if (var9_5 != null) {
                var21_18 = (CatalogTableType)var9_5._1();
                var22_19 = var9_5._2$mcZ$sp();
                v1 = CatalogTableType$.MODULE$.MANAGED();
                var23_20 = var21_18;
                if (!(v1 != null ? v1.equals(var23_20) == false : var23_20 != null) && var22_19) {
                    throw new AnalysisException(new StringBuilder(81).append("Can not create the managed table('").append(this.catalogTableName()).append("')").append(". The associated location('").append(this.tableLocation()).append("') already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
            throw new MatchError((Object)var9_5);
        }
        var8_21 = var2_14;
        if (var8_21 == null) {
            throw new MatchError((Object)var8_21);
        }
        finalSchema = (StructType)var8_21._1();
        tableConfigs = (scala.collection.immutable.Map)var8_21._2();
        var1_24 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
        var7_25 = var1_24;
        finalSchema = (StructType)var7_25._1();
        tableConfigs = (scala.collection.immutable.Map)var7_25._2();
        HoodieOptionConfig$.MODULE$.validateTable(this.spark(), finalSchema, HoodieOptionConfig$.MODULE$.mappingTableConfigToSqlOption((scala.collection.immutable.Map<String, String>)tableConfigs));
        resolver = this.spark().sessionState().conf().resolver();
        dataSchema = (Seq)finalSchema.filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseSchemaAndConfigs$1$adapted(org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable scala.Function2 org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Ljava/lang/Object;)((HoodieCatalogTable)this, (Function2)resolver));
        this.verifyDataSchema(this.table().identifier(), this.table().tableType(), (Seq<StructField>)dataSchema);
        return new Tuple2((Object)finalSchema, (Object)tableConfigs);
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig(SparkSession sparkSession, boolean isTableExists, scala.collection.immutable.Map<String, String> originTableConfig) {
        scala.collection.mutable.Map extraConfig = Map$.MODULE$.empty();
        if (isTableExists) {
            Seq<String> allPartitionPaths = this.getAllPartitionPaths();
            if (originTableConfig.contains((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key())) {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), originTableConfig.apply((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)String.valueOf(HoodieSqlUtils$.MODULE$.isHiveStyledPartitioning(allPartitionPaths, this.table())));
            }
            if (originTableConfig.contains((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key())) {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), originTableConfig.apply((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)String.valueOf(HoodieSqlUtils$.MODULE$.isUrlEncodeEnabled(allPartitionPaths, this.table())));
            }
        } else {
            extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
            extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.defaultValue());
        }
        if (originTableConfig.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())) {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator((String)originTableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())));
        } else {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)ComplexKeyGenerator.class.getCanonicalName());
        }
        return extraConfig.toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private void verifyDataSchema(TableIdentifier tableIdentifier, CatalogTableType tableType, Seq<StructField> dataSchema) {
        block0: {
            CatalogTableType catalogTableType = tableType;
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2))) break block0;
            Seq invalidChars = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",", ":", ";"}));
            dataSchema.foreach((Function1 & Serializable & scala.Serializable)f -> {
                HoodieCatalogTable.$anonfun$verifyDataSchema$4(tableIdentifier, invalidChars, f);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$dataSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$partitionSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$2(Function2 resolver$1, StructField f$1, String x$5) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)x$5, (Object)f$1.name()));
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$1(HoodieCatalogTable $this, Function2 resolver$1, StructField f) {
        return $this.table().partitionColumnNames().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$2(resolver$1, f, x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyDataSchema$2(StructField f$2, CharSequence x$1) {
        return f$2.name().contains(x$1);
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$1(Seq invalidChars$1, TableIdentifier tableIdentifier$1, StructField f) {
        DataType dataType = f.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (invalidChars$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$verifyDataSchema$2(f, x$1)))) {
                String invalidCharsString = ((TraversableOnce)invalidChars$1.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("'").append((String)c).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String errMsg = new StringBuilder(123).append("Cannot create a table having a nested column whose name contains ").append("invalid characters (").append(invalidCharsString).append(") in Hive metastore. Table: ").append(tableIdentifier$1).append("; ").append("Column: ").append(f.name()).toString();
                throw new AnalysisException(errMsg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void verifyNestedColumnNames$1(StructType schema, Seq invalidChars$1, TableIdentifier tableIdentifier$1) {
        schema.foreach((Function1 & Serializable & scala.Serializable)f -> {
            HoodieCatalogTable.$anonfun$verifyDataSchema$1(invalidChars$1, tableIdentifier$1, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$4(TableIdentifier tableIdentifier$1, Seq invalidChars$1, StructField f) {
        DataType dataType = f.dataType();
        if (f.name().contains(",")) {
            throw new AnalysisException(new StringBuilder(101).append("Cannot create a table having a column whose name ").append("contains commas in Hive metastore. Table: ").append(tableIdentifier$1).append("; Column: ").append(f.name()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public HoodieCatalogTable(SparkSession spark, CatalogTable table) {
        this.spark = spark;
        this.table = table;
        Logging.$init$((Logging)this);
        Object object = table.provider().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toLowerCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms());
        String string = "hudi";
        Predef$.MODULE$.assert(!(object != null ? !object.equals(string) : string != null), (Function0 & Serializable & scala.Serializable)() -> "It's not a Hudi table");
        this.hadoopConf = spark.sessionState().newHadoopConf();
        this.catalogTableName = table.qualifiedName();
        this.catalogProperties = table.storage().properties().$plus$plus((GenTraversableOnce)table.properties());
        this.tableLocation = HoodieSqlUtils$.MODULE$.getTableLocation(table, spark);
        this.hoodieTableExists = HoodieSqlUtils$.MODULE$.tableExistsInPath(this.tableLocation(), this.hadoopConf());
    }

    public static final /* synthetic */ Object $anonfun$parseSchemaAndConfigs$1$adapted(HoodieCatalogTable $this, Function2 resolver$1, StructField f) {
        return BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$1($this, resolver$1, f));
    }
}

