/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.transaction.lock.FileSystemBasedLockProvider;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestFileBasedLockProvider {
    @TempDir
    Path tempDir;
    String basePath;
    LockConfiguration lockConfiguration;
    StorageConfiguration<Configuration> storageConf;

    @BeforeEach
    public void setUp() throws IOException {
        this.basePath = this.tempDir.toUri().getPath();
        Properties properties = new Properties();
        properties.setProperty("hoodie.write.lock.filesystem.path", this.basePath);
        properties.setProperty("hoodie.write.lock.filesystem.expire", "1");
        properties.setProperty("hoodie.write.lock.wait_time_ms", "1000");
        properties.setProperty("hoodie.write.lock.wait_time_ms_between_retry", "1000");
        properties.setProperty("hoodie.write.lock.num_retries", "3");
        this.lockConfiguration = new LockConfiguration(properties);
        this.storageConf = HoodieTestUtils.getDefaultStorageConf();
    }

    @Test
    public void testAcquireLock() {
        FileSystemBasedLockProvider fileBasedLockProvider = new FileSystemBasedLockProvider(this.lockConfiguration, this.storageConf);
        Assertions.assertTrue((boolean)fileBasedLockProvider.tryLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
        fileBasedLockProvider.unlock();
    }

    @Test
    public void testAcquireLockWithDefaultPath() {
        this.lockConfiguration.getConfig().remove((Object)"hoodie.write.lock.filesystem.path");
        this.lockConfiguration.getConfig().setProperty(HoodieWriteConfig.BASE_PATH.key(), this.basePath);
        FileSystemBasedLockProvider fileBasedLockProvider = new FileSystemBasedLockProvider(this.lockConfiguration, this.storageConf);
        Assertions.assertTrue((boolean)fileBasedLockProvider.tryLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
        fileBasedLockProvider.unlock();
        this.lockConfiguration.getConfig().setProperty("hoodie.write.lock.filesystem.path", this.basePath);
    }

    @Test
    public void testUnLock() {
        FileSystemBasedLockProvider fileBasedLockProvider = new FileSystemBasedLockProvider(this.lockConfiguration, this.storageConf);
        Assertions.assertTrue((boolean)fileBasedLockProvider.tryLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
        fileBasedLockProvider.unlock();
        Assertions.assertTrue((boolean)fileBasedLockProvider.tryLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
    }

    @Test
    public void testReentrantLock() {
        FileSystemBasedLockProvider fileBasedLockProvider = new FileSystemBasedLockProvider(this.lockConfiguration, this.storageConf);
        Assertions.assertTrue((boolean)fileBasedLockProvider.tryLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
        Assertions.assertFalse((boolean)fileBasedLockProvider.tryLock(this.lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
        fileBasedLockProvider.unlock();
    }

    @Test
    public void testUnlockWithoutLock() {
        Assertions.assertDoesNotThrow(() -> {
            FileSystemBasedLockProvider fileBasedLockProvider = new FileSystemBasedLockProvider(this.lockConfiguration, this.storageConf);
            fileBasedLockProvider.unlock();
        });
    }
}

