/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.client.SparkRDDReadClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.utils.HoodieWriterClientTestHarness;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.junit.jupiter.api.Test;

public class TestHoodieReadClient
extends HoodieClientTestBase {
    private static final int PARALLELISM = 2;

    @Test
    public void testReadFilterExistAfterInsert() throws Exception {
        this.testReadFilterExist(this.getConfig(), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::insert));
    }

    @Test
    public void testReadFilterExistAfterInsertPrepped() throws Exception {
        this.testReadFilterExist(this.getConfig(), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::insertPreppedRecords));
    }

    @Test
    public void testReadFilterExistAfterBulkInsert() throws Exception {
        this.testReadFilterExist(this.getConfigBuilder().withBulkInsertParallelism(1).build(), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::bulkInsert));
    }

    @Test
    public void testReadFilterExistAfterBulkInsertPrepped() throws Exception {
        this.testReadFilterExist(this.getConfigBuilder().withBulkInsertParallelism(1).build(), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)(writeClient, recordRDD, instantTime) -> writeClient.bulkInsertPreppedRecords(recordRDD, instantTime, Option.empty())));
    }

    @Test
    public void testReadROViewFailsWithoutSqlContext() {
        SparkRDDReadClient readClient = new SparkRDDReadClient(this.context, this.getConfig());
        JavaRDD recordsRDD = this.jsc.parallelize(new ArrayList(), 2);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> readClient.readROView(recordsRDD, 1));
    }

    private void testReadFilterExist(HoodieWriteConfig config, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> writeFn) throws Exception {
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            SparkRDDReadClient readClient = this.getHoodieReadClient(config.getBasePath());
            String newCommitTime = writeClient.startCommit();
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(100));
            JavaRDD recordsRDD = this.jsc.parallelize(records, 2);
            JavaRDD filteredRDD = readClient.filterExists(recordsRDD);
            org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)filteredRDD.collect().size());
            JavaRDD smallRecordsRDD = this.jsc.parallelize(records.subList(0, 75), 2);
            List statuses = ((JavaRDD)writeFn.apply((Object)writeClient, (Object)smallRecordsRDD, (Object)newCommitTime)).collect();
            Assertions.assertNoWriteErrors((List)statuses);
            SparkRDDReadClient anotherReadClient = this.getHoodieReadClient(config.getBasePath());
            filteredRDD = anotherReadClient.filterExists(recordsRDD);
            List result = filteredRDD.collect();
            org.junit.jupiter.api.Assertions.assertEquals((int)25, (int)result.size());
            JavaPairRDD keyToPathPair = anotherReadClient.checkExists(recordsRDD.map(HoodieRecord::getKey));
            JavaRDD keysWithPaths = keyToPathPair.filter((Function & Serializable)keyPath -> ((Option)keyPath._2).isPresent()).map((Function & Serializable)keyPath -> (HoodieKey)keyPath._1);
            org.junit.jupiter.api.Assertions.assertEquals((long)75L, (long)keysWithPaths.count());
            Dataset rows = anotherReadClient.readROView(keysWithPaths, 2);
            org.junit.jupiter.api.Assertions.assertEquals((long)75L, (long)rows.count());
            JavaRDD keysWithoutPaths = keyToPathPair.filter((Function & Serializable)keyPath -> !((Option)keyPath._2).isPresent()).map((Function & Serializable)keyPath -> (HoodieKey)keyPath._1);
            org.junit.jupiter.api.Assertions.assertThrows(AnalysisException.class, () -> anotherReadClient.readROView(keysWithoutPaths, 2));
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)anotherReadClient.getPendingCompactions().size());
        }
    }

    @Test
    public void testTagLocationAfterInsert() throws Exception {
        this.testTagLocation(this.getConfig(), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::insert), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::upsert), false);
    }

    @Test
    public void testTagLocationAfterInsertPrepped() throws Exception {
        this.testTagLocation(this.getConfig(), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::insertPreppedRecords), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::upsertPreppedRecords), true);
    }

    @Test
    public void testTagLocationAfterBulkInsert() throws Exception {
        this.testTagLocation(this.getConfigBuilder().withBulkInsertParallelism(2).build(), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::bulkInsert), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::upsert), false);
    }

    @Test
    public void testTagLocationAfterBulkInsertPrepped() throws Exception {
        this.testTagLocation(this.getConfigBuilder().withBulkInsertParallelism(2).build(), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)(writeClient, recordRDD, instantTime) -> writeClient.bulkInsertPreppedRecords(recordRDD, instantTime, Option.empty())), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::upsertPreppedRecords), true);
    }

    private void testTagLocation(HoodieWriteConfig hoodieWriteConfig, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> insertFn, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> updateFn, boolean isPrepped) throws Exception {
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);){
            String newCommitTime = "001";
            String initCommitTime = "000";
            int numRecords = 200;
            JavaRDD<WriteStatus> result = this.insertFirstBatch(hoodieWriteConfig, client, newCommitTime, initCommitTime, numRecords, insertFn, isPrepped, true, numRecords);
            JavaRDD recordRDD = this.jsc.parallelize(result.collect().stream().map(WriteStatus::getWrittenRecordDelegates).flatMap(Collection::stream).map(recordDelegate -> new HoodieAvroRecord(recordDelegate.getHoodieKey(), null)).collect(Collectors.toList()), 2);
            SparkRDDReadClient readClient = this.getHoodieReadClient(hoodieWriteConfig.getBasePath());
            List taggedRecords = readClient.tagLocation(recordRDD).collect();
            TestHoodieReadClient.checkTaggedRecords(taggedRecords, newCommitTime);
            String prevCommitTime = newCommitTime;
            newCommitTime = "004";
            numRecords = 100;
            String commitTimeBetweenPrevAndNew = "002";
            result = this.updateBatch(hoodieWriteConfig, client, newCommitTime, prevCommitTime, (Option<List<String>>)Option.of(Arrays.asList(commitTimeBetweenPrevAndNew)), initCommitTime, numRecords, updateFn, isPrepped, true, numRecords, 200, 2);
            recordRDD = this.jsc.parallelize(result.collect().stream().map(WriteStatus::getWrittenRecordDelegates).flatMap(Collection::stream).map(recordDelegate -> new HoodieAvroRecord(recordDelegate.getHoodieKey(), null)).collect(Collectors.toList()), 2);
            readClient = this.getHoodieReadClient(hoodieWriteConfig.getBasePath());
            taggedRecords = readClient.tagLocation(recordRDD).collect();
            TestHoodieReadClient.checkTaggedRecords(taggedRecords, newCommitTime);
        }
    }
}

