/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.util.HashMap;
import java.util.UUID;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class TestWriteStatus {
    @Test
    public void testFailureFraction() {
        WriteStatus status = new WriteStatus(Boolean.valueOf(true), Double.valueOf(0.1));
        Exception t = new Exception("some error in writing");
        for (int i = 0; i < 1000; ++i) {
            status.markFailure((HoodieRecord)Mockito.mock(HoodieRecord.class), (Throwable)t, null);
        }
        Assertions.assertTrue((status.getFailedRecords().size() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((status.getFailedRecords().size() < 150 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)status.hasErrors());
    }

    @Test
    public void testSuccessRecordTracking() {
        WriteStatus status = new WriteStatus(Boolean.valueOf(false), Double.valueOf(1.0));
        Exception t = new Exception("some error in writing");
        for (int i = 0; i < 1000; ++i) {
            status.markSuccess((HoodieRecord)Mockito.mock(HoodieRecord.class), Option.empty());
            status.markFailure((HoodieRecord)Mockito.mock(HoodieRecord.class), (Throwable)t, Option.empty());
        }
        Assertions.assertEquals((int)1000, (int)status.getFailedRecords().size());
        Assertions.assertTrue((boolean)status.hasErrors());
        Assertions.assertTrue((boolean)status.getWrittenRecordDelegates().isEmpty());
        Assertions.assertEquals((long)2000L, (long)status.getTotalRecords());
    }

    @Test
    public void testSuccessWithEventTime() {
        long eventTime;
        HashMap<String, String> metadata;
        int i;
        HashMap<String, String> metadata2;
        int i2;
        WriteStatus status = new WriteStatus(Boolean.valueOf(false), Double.valueOf(1.0));
        status.setStat(new HoodieWriteStat());
        for (i2 = 0; i2 < 1000; ++i2) {
            metadata2 = new HashMap<String, String>();
            metadata2.put("metadata.event_time.key", "");
            status.markSuccess((HoodieRecord)Mockito.mock(HoodieRecord.class), Option.of(metadata2));
        }
        Assertions.assertEquals((long)1000L, (long)status.getTotalRecords());
        Assertions.assertFalse((boolean)status.hasErrors());
        Assertions.assertNull((Object)status.getStat().getMaxEventTime());
        Assertions.assertNull((Object)status.getStat().getMinEventTime());
        status = new WriteStatus(Boolean.valueOf(false), Double.valueOf(1.0));
        status.setStat(new HoodieWriteStat());
        for (i2 = 0; i2 < 1000; ++i2) {
            metadata2 = new HashMap();
            metadata2.put("metadata.event_time.key", null);
            status.markSuccess((HoodieRecord)Mockito.mock(HoodieRecord.class), Option.of(metadata2));
        }
        Assertions.assertEquals((long)1000L, (long)status.getTotalRecords());
        Assertions.assertFalse((boolean)status.hasErrors());
        Assertions.assertNull((Object)status.getStat().getMaxEventTime());
        Assertions.assertNull((Object)status.getStat().getMinEventTime());
        status = new WriteStatus(Boolean.valueOf(false), Double.valueOf(1.0));
        status.setStat(new HoodieWriteStat());
        long minSeconds = 0L;
        long maxSeconds = 0L;
        for (i = 0; i < 1000; ++i) {
            metadata = new HashMap<String, String>();
            eventTime = System.currentTimeMillis() / 1000L;
            if (i == 0) {
                minSeconds = eventTime;
            } else if (i == 999) {
                maxSeconds = eventTime;
            }
            metadata.put("metadata.event_time.key", String.valueOf(eventTime));
            status.markSuccess((HoodieRecord)Mockito.mock(HoodieRecord.class), Option.of(metadata));
        }
        Assertions.assertEquals((long)1000L, (long)status.getTotalRecords());
        Assertions.assertFalse((boolean)status.hasErrors());
        Assertions.assertEquals((long)(maxSeconds * 1000L), (Long)status.getStat().getMaxEventTime());
        Assertions.assertEquals((long)(minSeconds * 1000L), (Long)status.getStat().getMinEventTime());
        status = new WriteStatus(Boolean.valueOf(false), Double.valueOf(1.0));
        status.setStat(new HoodieWriteStat());
        minSeconds = 0L;
        maxSeconds = 0L;
        for (i = 0; i < 1000; ++i) {
            metadata = new HashMap();
            eventTime = System.currentTimeMillis();
            if (i == 0) {
                minSeconds = eventTime;
            } else if (i == 999) {
                maxSeconds = eventTime;
            }
            metadata.put("metadata.event_time.key", String.valueOf(eventTime));
            status.markSuccess((HoodieRecord)Mockito.mock(HoodieRecord.class), Option.of(metadata));
        }
        Assertions.assertEquals((long)1000L, (long)status.getTotalRecords());
        Assertions.assertFalse((boolean)status.hasErrors());
        Assertions.assertEquals((long)maxSeconds, (Long)status.getStat().getMaxEventTime());
        Assertions.assertEquals((long)minSeconds, (Long)status.getStat().getMinEventTime());
        status = new WriteStatus(Boolean.valueOf(false), Double.valueOf(1.0));
        status.setStat(new HoodieWriteStat());
        for (i = 0; i < 1000; ++i) {
            metadata = new HashMap();
            metadata.put("metadata.event_time.key", String.valueOf(i));
            status.markSuccess((HoodieRecord)Mockito.mock(HoodieRecord.class), Option.of(metadata));
        }
        Assertions.assertEquals((long)1000L, (long)status.getTotalRecords());
        Assertions.assertFalse((boolean)status.hasErrors());
        Assertions.assertNull((Object)status.getStat().getMaxEventTime());
        Assertions.assertNull((Object)status.getStat().getMinEventTime());
    }

    @Test
    public void testFailureFractionExtended() {
        WriteStatus status = new WriteStatus(Boolean.valueOf(true), Double.valueOf(0.1));
        String fileId = UUID.randomUUID().toString();
        String partitionPath = UUID.randomUUID().toString();
        status.setFileId(fileId);
        status.setPartitionPath(partitionPath);
        Exception t = new Exception("some error in writing");
        for (int i = 0; i < 1000; ++i) {
            status.markFailure((HoodieRecord)Mockito.mock(HoodieRecord.class), (Throwable)t, Option.empty());
        }
        Assertions.assertEquals((Object)fileId, (Object)status.getFileId());
        Assertions.assertEquals((Object)partitionPath, (Object)status.getPartitionPath());
        Assertions.assertTrue((status.getFailedRecords().size() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((status.getFailedRecords().size() < 150 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)status.hasErrors());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSuccessRecordTrackingExtended(boolean trackSuccess) {
        WriteStatus status = new WriteStatus(Boolean.valueOf(trackSuccess), Double.valueOf(1.0));
        String fileId = UUID.randomUUID().toString();
        status.setFileId(fileId);
        String partitionPath = UUID.randomUUID().toString();
        status.setPartitionPath(partitionPath);
        Exception t = new Exception("some error in writing");
        for (int i = 0; i < 1000; ++i) {
            status.markSuccess((HoodieRecord)Mockito.mock(HoodieRecord.class), Option.empty());
            status.markFailure((HoodieRecord)Mockito.mock(HoodieRecord.class), (Throwable)t, Option.empty());
        }
        Assertions.assertEquals((Object)fileId, (Object)status.getFileId());
        Assertions.assertEquals((Object)partitionPath, (Object)status.getPartitionPath());
        Assertions.assertEquals((int)1000, (int)status.getFailedRecords().size());
        Assertions.assertTrue((boolean)status.hasErrors());
        if (trackSuccess) {
            Assertions.assertEquals((int)1000, (int)status.getWrittenRecordDelegates().size());
        } else {
            Assertions.assertTrue((boolean)status.getWrittenRecordDelegates().isEmpty());
        }
        Assertions.assertEquals((long)2000L, (long)status.getTotalRecords());
    }

    @Test
    public void testGlobalError() {
        WriteStatus status = new WriteStatus(Boolean.valueOf(true), Double.valueOf(0.1));
        Exception t = new Exception("some error in writing");
        status.setGlobalError((Throwable)t);
        Assertions.assertEquals((Object)t, (Object)status.getGlobalError());
    }
}

