/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.plan.strategy;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieSliceInfo;
import org.apache.hudi.client.clustering.plan.strategy.SparkConsistentBucketClusteringPlanStrategy;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.bucket.ConsistentBucketIdentifier;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSparkConsistentBucketClusteringPlanStrategy
extends HoodieSparkClientTestHarness {
    private final Random random = new Random();

    private void setup() throws IOException {
        this.initPath();
        this.initSparkContexts();
        this.initHoodieStorage();
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.cleanupResources();
    }

    @Test
    public void testBuildSplitClusteringGroup() throws IOException {
        this.setup();
        int maxFileSize = 5120;
        Properties props = new Properties();
        props.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "uuid");
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withIndexConfig(HoodieIndexConfig.newBuilder().fromProperties(props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.CONSISTENT_HASHING).withBucketMaxNum(6).withBucketNum("4").build()).withStorageConfig(HoodieStorageConfig.newBuilder().parquetMaxFileSize((long)maxFileSize).build()).build();
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        SparkConsistentBucketClusteringPlanStrategy planStrategy = new SparkConsistentBucketClusteringPlanStrategy((HoodieTable)hoodieTable, (HoodieEngineContext)this.context, config);
        HoodieConsistentHashingMetadata metadata = new HoodieConsistentHashingMetadata("partition", config.getBucketIndexNumBuckets());
        ConsistentBucketIdentifier identifier = new ConsistentBucketIdentifier(metadata);
        int[] fsSize = new int[]{maxFileSize * 5, (int)((double)maxFileSize * (Double)HoodieIndexConfig.BUCKET_SPLIT_THRESHOLD.defaultValue() + 1.0), maxFileSize, maxFileSize * 5};
        List fileSlices = IntStream.range(0, metadata.getNodes().size()).mapToObj(i -> this.createFileSliceWithSize(((ConsistentHashingNode)metadata.getNodes().get(i)).getFileIdPrefix(), 1024L, fsSize[i] - 1024)).collect(Collectors.toList());
        Triple res = planStrategy.buildSplitClusteringGroups(identifier, fileSlices, 2);
        Assertions.assertEquals((Object)2, (Object)res.getMiddle());
        List groups = (List)res.getLeft();
        Assertions.assertEquals((int)2, (int)groups.size());
        Assertions.assertEquals((Object)((FileSlice)fileSlices.get(0)).getFileId(), (Object)((HoodieSliceInfo)((HoodieClusteringGroup)groups.get(0)).getSlices().get(0)).getFileId());
        Assertions.assertEquals((Object)((FileSlice)fileSlices.get(1)).getFileId(), (Object)((HoodieSliceInfo)((HoodieClusteringGroup)groups.get(1)).getSlices().get(0)).getFileId());
        List fsUntouched = (List)res.getRight();
        Assertions.assertEquals((int)2, (int)fsUntouched.size());
        Assertions.assertEquals(fileSlices.get(2), fsUntouched.get(0));
        Assertions.assertEquals(fileSlices.get(3), fsUntouched.get(1));
    }

    @Test
    public void testBuildMergeClusteringGroup() throws Exception {
        this.setup();
        int maxFileSize = 5120;
        Properties props = new Properties();
        props.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "uuid");
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withIndexConfig(HoodieIndexConfig.newBuilder().fromProperties(props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.CONSISTENT_HASHING).withBucketMinNum(4).withBucketNum("4").build()).withStorageConfig(HoodieStorageConfig.newBuilder().parquetMaxFileSize((long)maxFileSize).build()).build();
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        SparkConsistentBucketClusteringPlanStrategy planStrategy = new SparkConsistentBucketClusteringPlanStrategy((HoodieTable)hoodieTable, (HoodieEngineContext)this.context, config);
        HoodieConsistentHashingMetadata metadata = new HoodieConsistentHashingMetadata("partition", 8);
        ConsistentBucketIdentifier identifier = new ConsistentBucketIdentifier(metadata);
        int mergeSize = (int)((double)maxFileSize * (Double)HoodieIndexConfig.BUCKET_MERGE_THRESHOLD.defaultValue());
        int[] fsSize = new int[]{0, maxFileSize, mergeSize / 2, mergeSize / 2, mergeSize / 2, maxFileSize, mergeSize / 4, mergeSize / 4};
        List fileSlices = IntStream.range(0, metadata.getNodes().size()).mapToObj(i -> this.createFileSliceWithSize(((ConsistentHashingNode)metadata.getNodes().get(i)).getFileIdPrefix(), fsSize[i] / 2, fsSize[i] / 2)).collect(Collectors.toList());
        Triple res = planStrategy.buildMergeClusteringGroup(identifier, fileSlices, 4);
        Assertions.assertEquals((Object)3, (Object)res.getMiddle());
        List groups = (List)res.getLeft();
        Assertions.assertEquals((int)2, (int)groups.size());
        Assertions.assertEquals((Object)((FileSlice)fileSlices.get(0)).getFileId(), (Object)((HoodieSliceInfo)((HoodieClusteringGroup)groups.get(0)).getSlices().get(2)).getFileId());
        Assertions.assertEquals((Object)((FileSlice)fileSlices.get(7)).getFileId(), (Object)((HoodieSliceInfo)((HoodieClusteringGroup)groups.get(0)).getSlices().get(1)).getFileId());
        Assertions.assertEquals((Object)((FileSlice)fileSlices.get(6)).getFileId(), (Object)((HoodieSliceInfo)((HoodieClusteringGroup)groups.get(0)).getSlices().get(0)).getFileId());
        Assertions.assertEquals((int)3, (int)((HoodieClusteringGroup)groups.get(0)).getSlices().size());
        List nodes = ConsistentHashingNode.fromJsonString((String)((String)((HoodieClusteringGroup)groups.get(0)).getExtraMetadata().get("clustering.group.child.node")));
        Assertions.assertEquals((int)3, (int)nodes.size());
        Assertions.assertEquals((Object)ConsistentHashingNode.NodeTag.DELETE, (Object)((ConsistentHashingNode)nodes.get(0)).getTag());
        Assertions.assertEquals((Object)ConsistentHashingNode.NodeTag.DELETE, (Object)((ConsistentHashingNode)nodes.get(1)).getTag());
        Assertions.assertEquals((Object)ConsistentHashingNode.NodeTag.REPLACE, (Object)((ConsistentHashingNode)nodes.get(2)).getTag());
        Assertions.assertEquals((int)((ConsistentHashingNode)metadata.getNodes().get(0)).getValue(), (int)((ConsistentHashingNode)nodes.get(2)).getValue());
        Assertions.assertEquals((Object)((FileSlice)fileSlices.get(2)).getFileId(), (Object)((HoodieSliceInfo)((HoodieClusteringGroup)groups.get(1)).getSlices().get(0)).getFileId());
        Assertions.assertEquals((Object)((FileSlice)fileSlices.get(3)).getFileId(), (Object)((HoodieSliceInfo)((HoodieClusteringGroup)groups.get(1)).getSlices().get(1)).getFileId());
        Assertions.assertEquals((int)2, (int)((HoodieClusteringGroup)groups.get(1)).getSlices().size());
        nodes = ConsistentHashingNode.fromJsonString((String)((String)((HoodieClusteringGroup)groups.get(1)).getExtraMetadata().get("clustering.group.child.node")));
        Assertions.assertEquals((int)2, (int)nodes.size());
        Assertions.assertEquals((Object)ConsistentHashingNode.NodeTag.DELETE, (Object)((ConsistentHashingNode)nodes.get(0)).getTag());
        Assertions.assertEquals((Object)ConsistentHashingNode.NodeTag.REPLACE, (Object)((ConsistentHashingNode)nodes.get(1)).getTag());
        Assertions.assertEquals((int)((ConsistentHashingNode)metadata.getNodes().get(3)).getValue(), (int)((ConsistentHashingNode)nodes.get(1)).getValue());
        HoodieConsistentHashingMetadata metadata1 = new HoodieConsistentHashingMetadata("partition", 4);
        ConsistentBucketIdentifier identifier1 = new ConsistentBucketIdentifier(metadata1);
        int[] fsSize1 = new int[]{mergeSize / 4, mergeSize / 4, maxFileSize, mergeSize / 4};
        List fileSlices1 = IntStream.range(0, metadata1.getNodes().size()).mapToObj(i -> this.createFileSliceWithSize(((ConsistentHashingNode)metadata1.getNodes().get(i)).getFileIdPrefix(), fsSize1[i] / 2, fsSize1[i] / 2)).collect(Collectors.toList());
        Triple res1 = planStrategy.buildMergeClusteringGroup(identifier1, fileSlices1.stream().filter(fs -> fs.getTotalFileSize() < (long)mergeSize).collect(Collectors.toList()), 4);
        Assertions.assertEquals((int)1, (int)((List)res1.getLeft()).size(), (String)"should have 1 clustering group");
        Assertions.assertEquals((int)3, (int)((HoodieClusteringGroup)((List)res1.getLeft()).get(0)).getSlices().size(), (String)"should have 3 input files");
    }

    private FileSlice createFileSliceWithSize(String fileIdPfx, long baseFileSize, long totalLogFileSize) {
        int numLogFiles;
        String fileId = FSUtils.createNewFileId((String)fileIdPfx, (int)0);
        FileSlice fs = new FileSlice("partition", "001", fileId);
        if (baseFileSize > 0L) {
            HoodieBaseFile f = new HoodieBaseFile(fileId);
            f.setFileLen(baseFileSize);
            fs.setBaseFile(f);
        }
        if (totalLogFileSize < (long)(numLogFiles = this.random.nextInt(10) + 1)) {
            numLogFiles = (int)totalLogFileSize;
        }
        long logFileSize = (totalLogFileSize + (long)numLogFiles - 1L) / (long)Math.max(numLogFiles, 1);
        for (int i = 0; i < numLogFiles; ++i) {
            HoodieLogFile f = new HoodieLogFile(String.format(".%s_%s.log.%d", fileId, "12345678", i));
            f.setFileLen(logFileSize);
            fs.addLogFile(f);
        }
        return fs;
    }
}

