/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.functional;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hudi.client.HoodieTimelineArchiver;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.testutils.HoodieMetadataTestTable;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.metadata.HoodieMetadataWriteUtils;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.junit.jupiter.api.AfterEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHoodieMetadataBase
extends HoodieSparkClientTestHarness {
    private static final Logger LOG = LoggerFactory.getLogger(TestHoodieMetadataBase.class);
    protected static HoodieTestTable testTable;
    protected String metadataTableBasePath;
    protected HoodieTableType tableType;
    protected HoodieWriteConfig writeConfig;
    protected HoodieTableMetadataWriter metadataWriter;

    public void init(HoodieTableType tableType) throws IOException {
        this.init(tableType, true);
    }

    public void init(HoodieTableType tableType, HoodieWriteConfig writeConfig) throws IOException {
        this.init(tableType, (Option<HoodieWriteConfig>)Option.of((Object)writeConfig), true, false, false);
    }

    public void init(HoodieTableType tableType, boolean enableMetadataTable) throws IOException {
        this.init(tableType, enableMetadataTable, true, false, false);
    }

    public void init(HoodieTableType tableType, boolean enableMetadataTable, boolean enableColumnStats) throws IOException {
        this.init(tableType, enableMetadataTable, true, false, false);
    }

    public void init(HoodieTableType tableType, boolean enableMetadataTable, boolean enableFullScan, boolean enableMetrics, boolean validateMetadataPayloadStateConsistency) throws IOException {
        this.init(tableType, (Option<HoodieWriteConfig>)Option.empty(), enableMetadataTable, enableMetrics, validateMetadataPayloadStateConsistency);
    }

    public void init(HoodieTableType tableType, Option<HoodieWriteConfig> writeConfig, boolean enableMetadataTable, boolean enableMetrics, boolean validateMetadataPayloadStateConsistency) throws IOException {
        this.tableType = tableType;
        this.initPath();
        this.initSparkContexts("TestHoodieMetadata");
        this.initHoodieStorage();
        this.storage.createDirectory(new StoragePath(this.basePath));
        this.initTimelineService();
        this.initMetaClient(tableType);
        this.initTestDataGenerator();
        this.metadataTableBasePath = HoodieTableMetadata.getMetadataTableBasePath((String)this.basePath);
        this.writeConfig = writeConfig.isPresent() ? (HoodieWriteConfig)writeConfig.get() : this.getWriteConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER, true, enableMetadataTable, enableMetrics, true, validateMetadataPayloadStateConsistency).build();
        this.initWriteConfigAndMetatableWriter(this.writeConfig, enableMetadataTable);
    }

    protected void initWriteConfigAndMetatableWriter(HoodieWriteConfig writeConfig, boolean enableMetadataTable) throws IOException {
        this.writeConfig = writeConfig;
        if (enableMetadataTable) {
            this.metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context);
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.metadataWriter, (Option)Option.of((Object)this.context));
        } else {
            testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        }
    }

    @AfterEach
    public void clean() throws Exception {
        this.cleanupResources();
        if (this.metadataWriter != null) {
            this.metadataWriter.close();
        }
    }

    protected void doWriteInsertAndUpsert(HoodieTestTable testTable, String commit1, String commit2, boolean nonPartitioned) throws Exception {
        testTable.doWriteOperation(commit1, WriteOperationType.INSERT, nonPartitioned ? Arrays.asList("") : Arrays.asList("p1", "p2"), nonPartitioned ? Arrays.asList("") : Arrays.asList("p1", "p2"), 4, false);
        testTable.doWriteOperation(commit2, WriteOperationType.UPSERT, nonPartitioned ? Arrays.asList("") : Arrays.asList("p1", "p2"), 4, false);
        this.validateMetadata(testTable);
    }

    protected void doWriteOperationAndValidateMetadata(HoodieTestTable testTable, String commitTime) throws Exception {
        this.doWriteOperation(testTable, commitTime);
        this.validateMetadata(testTable);
    }

    protected void doWriteOperation(HoodieTestTable testTable, String commitTime) throws Exception {
        this.doWriteOperation(testTable, commitTime, WriteOperationType.UPSERT);
    }

    protected void doWriteOperationAndValidate(HoodieTestTable testTable, String commitTime) throws Exception {
        this.doWriteOperationAndValidate(testTable, commitTime, WriteOperationType.UPSERT);
    }

    protected void doWriteOperationAndValidate(HoodieTestTable testTable, String commitTime, WriteOperationType operationType) throws Exception {
        this.doWriteOperation(testTable, commitTime, operationType);
        this.validateMetadata(testTable);
    }

    protected void doWriteOperationNonPartitioned(HoodieTestTable testTable, String commitTime, WriteOperationType operationType) throws Exception {
        testTable.doWriteOperation(commitTime, operationType, Collections.emptyList(), Arrays.asList(""), 3);
    }

    protected void doWriteOperation(HoodieTestTable testTable, String commitTime, WriteOperationType operationType, boolean nonPartitioned) throws Exception {
        if (nonPartitioned) {
            this.doWriteOperationNonPartitioned(testTable, commitTime, operationType);
        } else {
            this.doWriteOperation(testTable, commitTime, operationType);
        }
    }

    protected void doWriteOperation(HoodieTestTable testTable, String commitTime, WriteOperationType operationType) throws Exception {
        testTable.doWriteOperation(commitTime, operationType, Collections.emptyList(), Arrays.asList("p1", "p2"), 3);
    }

    protected HoodieCommitMetadata doWriteOperationWithMeta(HoodieTestTable testTable, String commitTime, WriteOperationType operationType) throws Exception {
        return testTable.doWriteOperation(commitTime, operationType, Collections.emptyList(), Arrays.asList("p1", "p2"), 3);
    }

    protected void doClean(HoodieTestTable testTable, String commitTime, List<String> commitsToClean) throws IOException {
        this.doCleanInternal(testTable, commitTime, commitsToClean, false);
    }

    protected void doCleanAndValidate(HoodieTestTable testTable, String commitTime, List<String> commitsToClean) throws IOException {
        this.doCleanInternal(testTable, commitTime, commitsToClean, true);
    }

    private void doCleanInternal(HoodieTestTable testTable, String commitTime, List<String> commitsToClean, boolean validate) throws IOException {
        testTable.doCleanBasedOnCommits(commitTime, commitsToClean);
        if (validate) {
            this.validateMetadata(testTable);
        }
    }

    protected void doCompactionNonPartitioned(HoodieTestTable testTable, String commitTime) throws Exception {
        this.doCompactionInternal(testTable, commitTime, false, true);
    }

    protected void doCompaction(HoodieTestTable testTable, String commitTime, boolean nonPartitioned) throws Exception {
        this.doCompactionInternal(testTable, commitTime, false, nonPartitioned);
    }

    protected void doCompaction(HoodieTestTable testTable, String commitTime) throws Exception {
        this.doCompactionInternal(testTable, commitTime, false, false);
    }

    protected void doCompactionNonPartitionedAndValidate(HoodieTestTable testTable, String commitTime) throws Exception {
        this.doCompactionInternal(testTable, commitTime, true, true);
    }

    protected void doCompactionAndValidate(HoodieTestTable testTable, String commitTime) throws Exception {
        this.doCompactionInternal(testTable, commitTime, true, false);
    }

    private void doCompactionInternal(HoodieTestTable testTable, String commitTime, boolean validate, boolean nonPartitioned) throws Exception {
        testTable.doCompaction(commitTime, nonPartitioned ? Arrays.asList("") : Arrays.asList("p1", "p2"));
        if (validate) {
            this.validateMetadata(testTable);
        }
    }

    protected void doCluster(HoodieTestTable testTable, String commitTime) throws Exception {
        this.doClusterInternal(testTable, commitTime, false);
    }

    protected void doClusterAndValidate(HoodieTestTable testTable, String commitTime) throws Exception {
        this.doClusterInternal(testTable, commitTime, true);
    }

    protected void doClusterInternal(HoodieTestTable testTable, String commitTime, boolean validate) throws Exception {
        testTable.doCluster(commitTime, new HashMap(), Arrays.asList("p1", "p2"), 2);
        if (validate) {
            this.validateMetadata(testTable);
        }
    }

    protected void doRollback(HoodieTestTable testTable, String commitToRollback, String rollbackTime) throws Exception {
        this.doRollbackInternal(testTable, commitToRollback, rollbackTime, false);
    }

    protected void doRollbackAndValidate(HoodieTestTable testTable, String commitToRollback, String rollbackTime) throws Exception {
        this.doRollbackInternal(testTable, commitToRollback, rollbackTime, true);
    }

    private void doRollbackInternal(HoodieTestTable testTable, String commitToRollback, String rollbackTime, boolean validate) throws Exception {
        testTable.doRollback(commitToRollback, rollbackTime);
        if (validate) {
            this.validateMetadata(testTable);
        }
    }

    protected void doPreBootstrapWriteOperation(HoodieTestTable testTable, String commitTime) throws Exception {
        this.doPreBootstrapWriteOperation(testTable, WriteOperationType.UPSERT, commitTime);
    }

    protected void doPreBootstrapWriteOperation(HoodieTestTable testTable, WriteOperationType writeOperationType, String commitTime) throws Exception {
        this.doPreBootstrapWriteOperation(testTable, writeOperationType, commitTime, 2);
    }

    protected void doPreBootstrapWriteOperation(HoodieTestTable testTable, WriteOperationType writeOperationType, String commitTime, int filesPerPartition) throws Exception {
        testTable.doWriteOperation(commitTime, writeOperationType, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), filesPerPartition, true);
    }

    protected void doPreBootstrapClean(HoodieTestTable testTable, String commitTime, List<String> commitsToClean) throws Exception {
        testTable.doCleanBasedOnCommits(commitTime, commitsToClean);
    }

    protected void doPreBootstrapRollback(HoodieTestTable testTable, String rollbackTime, String commitToRollback) throws Exception {
        testTable.doRollback(commitToRollback, rollbackTime);
    }

    protected void doPrebootstrapCompaction(HoodieTestTable testTable, String commitTime) throws Exception {
        this.doPrebootstrapCompaction(testTable, commitTime, Arrays.asList("p1", "p2"));
    }

    protected void doPrebootstrapCompaction(HoodieTestTable testTable, String commitTime, List<String> partitions) throws Exception {
        testTable.doCompaction(commitTime, partitions);
    }

    protected void doPreBootstrapCluster(HoodieTestTable testTable, String commitTime) throws Exception {
        testTable.doCluster(commitTime, new HashMap(), Arrays.asList("p1", "p2"), 2);
    }

    protected void doPreBootstrapRestore(HoodieTestTable testTable, String restoreTime, String commitToRestore) throws Exception {
        testTable.doRestore(commitToRestore, restoreTime);
    }

    protected void archiveDataTable(HoodieWriteConfig writeConfig, HoodieTableMetaClient metaClient) throws IOException {
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)metaClient);
        HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(writeConfig, (HoodieTable)table);
        archiver.archiveIfRequired((HoodieEngineContext)this.context);
    }

    protected void validateMetadata(HoodieTestTable testTable) throws IOException {
        this.validateMetadata(testTable, Collections.emptyList());
    }

    protected void validateMetadata(HoodieTestTable testTable, boolean doFullValidation) throws IOException {
        this.validateMetadata(testTable, Collections.emptyList(), doFullValidation);
    }

    protected void validateMetadata(HoodieTestTable testTable, List<String> inflightCommits) throws IOException {
        this.validateMetadata(testTable, inflightCommits, false);
    }

    protected void validateMetadata(HoodieTestTable testTable, List<String> inflightCommits, boolean doFullValidation) throws IOException {
        this.validateMetadata(testTable, inflightCommits, this.writeConfig, this.metadataTableBasePath, doFullValidation);
    }

    protected HoodieWriteConfig getWriteConfig(boolean autoCommit, boolean useFileListingMetadata) {
        return this.getWriteConfigBuilder(autoCommit, useFileListingMetadata, false).build();
    }

    protected HoodieWriteConfig.Builder getWriteConfigBuilder(boolean autoCommit, boolean useFileListingMetadata, boolean enableMetrics) {
        return this.getWriteConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER, autoCommit, useFileListingMetadata, enableMetrics);
    }

    protected HoodieWriteConfig.Builder getWriteConfigBuilder(HoodieFailedWritesCleaningPolicy policy, boolean autoCommit, boolean useFileListingMetadata, boolean enableMetrics) {
        return this.getWriteConfigBuilder(policy, autoCommit, useFileListingMetadata, enableMetrics, true, false);
    }

    protected HoodieWriteConfig.Builder getWriteConfigBuilder(HoodieFailedWritesCleaningPolicy policy, boolean autoCommit, boolean useFileListingMetadata, boolean enableMetrics, boolean useRollbackUsingMarkers, boolean validateMetadataPayloadConsistency) {
        Properties properties = new Properties();
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withDeleteParallelism(2).withRollbackParallelism(2).withFinalizeWriteParallelism(2).withAutoCommit(autoCommit).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0L).withInlineCompaction(Boolean.valueOf(false)).withMaxNumDeltaCommitsBeforeCompaction(1).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(policy).withAutoClean(Boolean.valueOf(false)).retainCommits(1).retainFileVersions(1).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x40000000L).build()).withEmbeddedTimelineServerEnabled(true).forTable("test-trip-table").withFileSystemViewConfig(new FileSystemViewStorageConfig.Builder().withEnableBackupForRemoteFileSystemView(false).build()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(useFileListingMetadata).enableMetrics(enableMetrics).ignoreSpuriousDeletes(validateMetadataPayloadConsistency).build()).withMetricsConfig(HoodieMetricsConfig.newBuilder().on(enableMetrics).withExecutorMetrics(enableMetrics).withReporterType(MetricsReporterType.INMEMORY.name()).build()).withRollbackUsingMarkers(useRollbackUsingMarkers).withProperties(properties);
    }

    protected HoodieWriteConfig getMetadataWriteConfig(HoodieWriteConfig writeConfig) {
        return HoodieMetadataWriteUtils.createMetadataWriteConfig((HoodieWriteConfig)writeConfig, (HoodieFailedWritesCleaningPolicy)HoodieFailedWritesCleaningPolicy.LAZY);
    }
}

