/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.functional;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import org.apache.hudi.client.functional.TestHoodieMetadataBase;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieMetadataTestTable;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="functional")
public class TestHoodieMetadataBootstrap
extends TestHoodieMetadataBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestHoodieMetadataBootstrap.class);

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataBootstrapInsertUpsert(HoodieTableType tableType) throws Exception {
        this.init(tableType, false);
        this.doPreBootstrapWriteOperation(testTable, WriteOperationType.INSERT, "0000001");
        this.doPreBootstrapWriteOperation(testTable, "0000002");
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            this.doPrebootstrapCompaction(testTable, "0000003");
        }
        this.bootstrapAndVerify();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataBootstrapInsertUpsertClean(HoodieTableType tableType) throws Exception {
        this.init(tableType, false);
        this.doPreBootstrapWriteOperation(testTable, WriteOperationType.INSERT, "0000001");
        this.doPreBootstrapWriteOperation(testTable, "0000002");
        this.doPreBootstrapClean(testTable, "0000003", Arrays.asList("0000001"));
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            this.doPrebootstrapCompaction(testTable, "0000004");
        }
        this.doPreBootstrapWriteOperation(testTable, "0000005");
        this.bootstrapAndVerify();
    }

    @Test
    public void testMetadataBootstrapWithExtraFiles() throws Exception {
        HoodieTableType tableType = HoodieTableType.COPY_ON_WRITE;
        this.init(tableType, false);
        this.doPreBootstrapWriteOperation(testTable, WriteOperationType.INSERT, "0000001");
        this.doPreBootstrapWriteOperation(testTable, "0000002");
        this.doPreBootstrapClean(testTable, "0000003", Arrays.asList("0000001"));
        this.doPreBootstrapWriteOperation(testTable, "0000005");
        String fileName = UUID.randomUUID().toString();
        Path baseFilePath = FileCreateUtils.getBaseFilePath((String)this.basePath, (String)"p1", (String)"0000006", (String)fileName);
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"p1", (String)"0000006", (String)fileName, (long)100L);
        this.writeConfig = this.getWriteConfig(true, true);
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        this.syncTableMetadata(this.writeConfig);
        Files.delete(baseFilePath);
        this.validateMetadata(testTable);
        this.doWriteInsertAndUpsert(testTable);
        this.validateMetadata(testTable);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataBootstrapInsertUpsertRollback(HoodieTableType tableType) throws Exception {
        this.init(tableType, false);
        this.doPreBootstrapWriteOperation(testTable, WriteOperationType.INSERT, "0000001");
        this.doPreBootstrapWriteOperation(testTable, "0000002");
        this.doPreBootstrapRollback(testTable, "0000003", "0000002");
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            this.doPrebootstrapCompaction(testTable, "0000004");
        }
        this.bootstrapAndVerify();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataBootstrapInsertUpsertCluster(HoodieTableType tableType) throws Exception {
        this.init(tableType, false);
        this.doPreBootstrapWriteOperation(testTable, WriteOperationType.INSERT, "0000001");
        this.doPreBootstrapWriteOperation(testTable, "0000002");
        this.doPreBootstrapCluster(testTable, "0000003");
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            this.doPrebootstrapCompaction(testTable, "0000004");
        }
        this.bootstrapAndVerify();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataBootstrapLargeCommitList(HoodieTableType tableType) throws Exception {
        this.init(tableType, false);
        for (int i = 1; i < 25; i += 7) {
            String commitTime1 = (i > 9 ? "00000" : "000000") + i;
            String commitTime2 = (i > 9 ? "00000" : "000000") + (i + 1);
            String commitTime3 = (i > 9 ? "00000" : "000000") + (i + 2);
            String commitTime4 = (i > 9 ? "00000" : "000000") + (i + 3);
            String commitTime5 = (i > 9 ? "00000" : "000000") + (i + 4);
            String commitTime6 = (i > 9 ? "00000" : "000000") + (i + 5);
            String commitTime7 = (i > 9 ? "00000" : "000000") + (i + 6);
            this.doPreBootstrapWriteOperation(testTable, WriteOperationType.INSERT, commitTime1);
            this.doPreBootstrapWriteOperation(testTable, commitTime2);
            this.doPreBootstrapClean(testTable, commitTime3, Arrays.asList(commitTime1));
            this.doPreBootstrapWriteOperation(testTable, commitTime4);
            if (tableType == HoodieTableType.MERGE_ON_READ) {
                this.doPrebootstrapCompaction(testTable, commitTime5);
            }
            this.doPreBootstrapWriteOperation(testTable, commitTime6);
            this.doPreBootstrapRollback(testTable, commitTime7, commitTime6);
        }
        this.bootstrapAndVerify();
    }

    @Test
    public void testMetadataBootstrapInflightCommit() throws Exception {
        HoodieTableType tableType = HoodieTableType.COPY_ON_WRITE;
        this.init(tableType, false);
        this.doPreBootstrapWriteOperation(testTable, WriteOperationType.INSERT, "0000001");
        this.doPreBootstrapWriteOperation(testTable, "0000002");
        HoodieCommitMetadata inflightCommitMeta = testTable.doWriteOperation("00000007", WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2, true, true);
        this.bootstrapAndVerifyFailure();
        ((HoodieMetadataTestTable)testTable).moveInflightCommitToComplete("00000007", inflightCommitMeta, true);
        this.syncTableMetadata(this.writeConfig);
        this.validateMetadata(testTable);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataBootstrapArchival(HoodieTableType tableType) throws Exception {
        this.init(tableType, false);
        this.writeConfig = this.getWriteConfig(2, 4);
        for (int i = 1; i < 13; i += 7) {
            String commitTime1 = (i > 9 ? "00000" : "000000") + i;
            String commitTime2 = (i > 9 ? "00000" : "000000") + (i + 1);
            String commitTime3 = (i > 9 ? "00000" : "000000") + (i + 2);
            String commitTime4 = (i > 9 ? "00000" : "000000") + (i + 3);
            String commitTime5 = (i > 9 ? "00000" : "000000") + (i + 4);
            String commitTime6 = (i > 9 ? "00000" : "000000") + (i + 5);
            String commitTime7 = (i > 9 ? "00000" : "000000") + (i + 6);
            this.doPreBootstrapWriteOperation(testTable, WriteOperationType.INSERT, commitTime1);
            this.doPreBootstrapWriteOperation(testTable, commitTime2);
            this.doPreBootstrapClean(testTable, commitTime3, Arrays.asList(commitTime1));
            this.doPreBootstrapWriteOperation(testTable, commitTime4);
            if (tableType == HoodieTableType.MERGE_ON_READ) {
                this.doPrebootstrapCompaction(testTable, commitTime5);
            }
            this.doPreBootstrapWriteOperation(testTable, commitTime6);
            this.doPreBootstrapRollback(testTable, commitTime7, commitTime6);
        }
        this.archiveDataTable(this.writeConfig, this.metaClient);
        this.bootstrapAndVerify();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataBootstrapAfterRestore(HoodieTableType tableType) throws Exception {
        this.init(tableType, false);
        this.testRestore(false);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataBootstrapAfterRestoreAndUpserts(HoodieTableType tableType) throws Exception {
        this.init(tableType, false);
        this.testRestore(true);
    }

    private void testRestore(boolean addUpsertsAfterRestore) throws Exception {
        this.doPreBootstrapWriteOperation(testTable, WriteOperationType.INSERT, "0000001");
        this.doPreBootstrapWriteOperation(testTable, "0000002");
        if (this.tableType == HoodieTableType.MERGE_ON_READ) {
            this.doPrebootstrapCompaction(testTable, "0000003");
        }
        this.doPreBootstrapWriteOperation(testTable, "0000004");
        this.doPreBootstrapWriteOperation(testTable, "0000005");
        this.doPreBootstrapWriteOperation(testTable, "0000006");
        this.doPreBootstrapRestore(testTable, "0000007", "0000004");
        if (addUpsertsAfterRestore) {
            this.doPreBootstrapWriteOperation(testTable, "0000008");
            this.doPreBootstrapWriteOperation(testTable, "0000009");
            if (this.tableType == HoodieTableType.MERGE_ON_READ) {
                this.doPrebootstrapCompaction(testTable, "0000010");
            }
        }
        this.bootstrapAndVerify();
    }

    private void bootstrapAndVerify() throws Exception {
        this.writeConfig = this.getWriteConfig(true, true);
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        this.syncTableMetadata(this.writeConfig);
        this.validateMetadata(testTable);
        this.doWriteInsertAndUpsert(testTable);
        this.validateMetadata(testTable);
    }

    private void bootstrapAndVerifyFailure() throws Exception {
        this.writeConfig = this.getWriteConfig(true, true);
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        this.syncTableMetadata(this.writeConfig);
        try {
            this.validateMetadata(testTable);
            Assertions.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void doWriteInsertAndUpsert(HoodieTestTable testTable) throws Exception {
        this.doWriteInsertAndUpsert(testTable, "0000100", "0000101", false);
    }

    private HoodieWriteConfig getWriteConfig(int minArchivalCommits, int maxArchivalCommits) throws Exception {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(minArchivalCommits, maxArchivalCommits).build()).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).build()).forTable("test-trip-table").build();
    }

    protected HoodieTableType getTableType() {
        return this.tableType;
    }
}

