/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.functional;

import java.util.Objects;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.utils.HoodieWriterClientTestHarness;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="functional")
public class TestSavepointRestoreCopyOnWrite
extends HoodieClientTestBase {
    @Test
    void testBasicRollback() throws Exception {
        HoodieWriteConfig hoodieWriteConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.LAZY).withRollbackUsingMarkers(true).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);){
            String savepointCommit = null;
            String prevInstant = "00000000000000";
            int numRecords = 10;
            for (int i = 1; i <= 4; ++i) {
                String newCommitTime = HoodieActiveTimeline.createNewInstantTime();
                this.insertBatch(hoodieWriteConfig, client, newCommitTime, prevInstant, 10, (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::insert), false, true, 10, 10 * i, 1, (Option<String>)Option.empty());
                prevInstant = newCommitTime;
                if (i != 2) continue;
                savepointCommit = newCommitTime;
                client.savepoint("user1", "Savepoint for 2nd commit");
            }
            this.assertRowNumberEqualsTo(40);
            client.restoreToSavepoint((String)Objects.requireNonNull(savepointCommit, "restore commit should not be null"));
            this.assertRowNumberEqualsTo(20);
        }
    }

    @Test
    void testCleaningPendingInstants() throws Exception {
        HoodieWriteConfig hoodieWriteConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.LAZY).withRollbackUsingMarkers(true).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);){
            String savepointCommit = null;
            String prevInstant = "00000000000000";
            int numRecords = 10;
            for (int i = 1; i <= 3; ++i) {
                String newCommitTime = HoodieActiveTimeline.createNewInstantTime();
                this.insertBatch(hoodieWriteConfig, client, newCommitTime, prevInstant, 10, (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::insert), false, true, 10, 10 * i, 1, (Option<String>)Option.empty());
                prevInstant = newCommitTime;
                if (i != 2) continue;
                savepointCommit = newCommitTime;
                client.savepoint("user1", "Savepoint for 2nd commit");
            }
            this.assertRowNumberEqualsTo(30);
            this.insertBatchWithoutCommit(HoodieActiveTimeline.createNewInstantTime(), 10);
            client.restoreToSavepoint((String)Objects.requireNonNull(savepointCommit, "restore commit should not be null"));
            this.assertRowNumberEqualsTo(20);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testCleaningRollbackInstants(boolean commitRollback) throws Exception {
        HoodieWriteConfig hoodieWriteConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER).withRollbackUsingMarkers(true).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);){
            String savepointCommit = null;
            String prevInstant = "00000000000000";
            int numRecords = 10;
            for (int i = 1; i <= 2; ++i) {
                String newCommitTime = HoodieActiveTimeline.createNewInstantTime();
                this.insertBatch(hoodieWriteConfig, client, newCommitTime, prevInstant, 10, (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::insert), false, true, 10, 10 * i, 1, (Option<String>)Option.empty());
                prevInstant = newCommitTime;
                if (i != 2) continue;
                savepointCommit = newCommitTime;
                client.savepoint("user1", "Savepoint for 2nd commit");
            }
            this.assertRowNumberEqualsTo(20);
            this.insertBatchWithoutCommit(HoodieActiveTimeline.createNewInstantTime(), 10);
            if (commitRollback) {
                client.rollbackFailedWrites();
            } else {
                HoodieInstant pendingInstant = (HoodieInstant)this.metaClient.getActiveTimeline().filterPendingExcludingCompaction().lastInstant().orElseThrow(() -> new HoodieException("Pending instant does not exist"));
                HoodieSparkTable.create((HoodieWriteConfig)client.getConfig(), (HoodieEngineContext)this.context).scheduleRollback((HoodieEngineContext)this.context, HoodieActiveTimeline.createNewInstantTime(), pendingInstant, false, true, false);
            }
            Option rollbackInstant = this.metaClient.reloadActiveTimeline().getRollbackTimeline().lastInstant().map(HoodieInstant::getTimestamp);
            Assertions.assertTrue((boolean)rollbackInstant.isPresent(), (String)"The latest instant should be a rollback");
            this.insertBatch(hoodieWriteConfig, client, HoodieActiveTimeline.createNewInstantTime(), (String)rollbackInstant.get(), 10, (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::insert), false, true, 10, 30, 1, (Option<String>)Option.empty());
            client.restoreToSavepoint(Objects.requireNonNull(savepointCommit, "restore commit should not be null"));
            this.assertRowNumberEqualsTo(20);
        }
    }
}

