/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.functional;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.storage.StoragePathFilter;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class TestSavepointRestoreMergeOnRead
extends HoodieClientTestBase {
    @Test
    void testCleaningDeltaCommits() throws Exception {
        HoodieWriteConfig hoodieWriteConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(4).withInlineCompaction(Boolean.valueOf(true)).build()).withRollbackUsingMarkers(true).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);){
            String savepointCommit = null;
            int numRecords = 10;
            List baseRecordsToUpdate = null;
            for (int i = 1; i <= 3; ++i) {
                String newCommitTime = HoodieActiveTimeline.createNewInstantTime();
                client.startCommitWithTime(newCommitTime);
                List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(10));
                JavaRDD writeRecords = this.jsc.parallelize(records, 1);
                client.insert(writeRecords, newCommitTime);
                if (i != 3) continue;
                savepointCommit = newCommitTime;
                baseRecordsToUpdate = records;
                client.savepoint("user1", "Savepoint for 3rd commit");
            }
            this.assertRowNumberEqualsTo(30);
            String compactionCommit = null;
            for (int i = 1; i <= 3; ++i) {
                String newCommitTime = HoodieActiveTimeline.createNewInstantTime();
                client.startCommitWithTime(newCommitTime);
                List records = this.dataGen.generateUpdates(newCommitTime, (List)Objects.requireNonNull(baseRecordsToUpdate, "The records to update should not be null"));
                JavaRDD writeRecords = this.jsc.parallelize(records, 1);
                client.upsert(writeRecords, newCommitTime);
                if (i != 1) continue;
                Option compactionInstant = client.scheduleCompaction(Option.empty());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)compactionInstant.isPresent(), (String)"A compaction plan should be scheduled");
                compactionCommit = (String)compactionInstant.get();
                client.compact((String)compactionInstant.get());
            }
            client.restoreToSavepoint((String)Objects.requireNonNull(savepointCommit, "restore commit should not be null"));
            this.assertRowNumberEqualsTo(30);
            String finalCompactionCommit = compactionCommit;
            StoragePathFilter & Serializable filter = (StoragePathFilter & Serializable)path -> path.toString().contains(finalCompactionCommit);
            for (String pPath : this.dataGen.getPartitionPaths()) {
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.storage.listDirectEntries(FSUtils.constructAbsolutePath((String)hoodieWriteConfig.getBasePath(), (String)pPath), (StoragePathFilter)filter).size());
            }
        }
    }

    @Test
    public void testRestoreWithFileGroupCreatedWithDeltaCommits() throws IOException {
        String secondCommit;
        String firstCommit;
        HoodieWriteConfig hoodieWriteConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(4).withInlineCompaction(Boolean.valueOf(true)).build()).withRollbackUsingMarkers(true).build();
        int numRecords = 100;
        String[] stringArray = null;
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);){
            String newCommitTime = HoodieActiveTimeline.createNewInstantTime();
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(100));
            JavaRDD writeRecords = this.jsc.parallelize(records, 1);
            client.startCommitWithTime(newCommitTime);
            client.insert(writeRecords, newCommitTime);
            firstCommit = newCommitTime;
            newCommitTime = HoodieActiveTimeline.createNewInstantTime();
            List records2 = this.dataGen.generateUniqueUpdates(newCommitTime, Integer.valueOf(100));
            JavaRDD writeRecords2 = this.jsc.parallelize(records2, 1);
            List records3 = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(30));
            JavaRDD writeRecords3 = this.jsc.parallelize(records3, 1);
            client.startCommitWithTime(newCommitTime);
            client.upsert(writeRecords2.union(writeRecords3), newCommitTime);
            secondCommit = newCommitTime;
            client.savepoint(firstCommit, "test user", "test comment");
        }
        catch (Throwable object) {
            stringArray = object;
            throw object;
        }
        this.assertRowNumberEqualsTo(130);
        StoragePathFilter & Serializable filter = (StoragePathFilter & Serializable)path -> path.toString().contains(secondCommit);
        for (String pPath : this.dataGen.getPartitionPaths()) {
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.storage.listDirectEntries(FSUtils.constructAbsolutePath((String)hoodieWriteConfig.getBasePath(), (String)pPath), (StoragePathFilter)filter).size());
        }
        hoodieWriteConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(4).withInlineCompaction(Boolean.valueOf(true)).compactionSmallFileSize(0L).build()).withRollbackUsingMarkers(true).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);){
            String newCommitTime = HoodieActiveTimeline.createNewInstantTime();
            List records = this.dataGen.generateUniqueUpdates(newCommitTime, Integer.valueOf(100));
            JavaRDD writeRecords = this.jsc.parallelize(records, 1);
            client.startCommitWithTime(newCommitTime);
            client.upsert(writeRecords, newCommitTime);
            newCommitTime = HoodieActiveTimeline.createNewInstantTime();
            records = this.dataGen.generateUniqueUpdates(newCommitTime, Integer.valueOf(100));
            writeRecords = this.jsc.parallelize(records, 1);
            client.startCommitWithTime(newCommitTime);
            client.upsert(writeRecords, newCommitTime);
        }
        this.assertRowNumberEqualsTo(130);
        client = this.getHoodieWriteClient(hoodieWriteConfig);
        var7_9 = null;
        try {
            client.restoreToSavepoint(firstCommit);
        }
        catch (Throwable throwable) {
            var7_9 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var7_9 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        var7_9.addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
        this.assertRowNumberEqualsTo(100);
        filter = (StoragePathFilter & Serializable)path -> path.toString().contains(secondCommit);
        for (String pPath : this.dataGen.getPartitionPaths()) {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.storage.listDirectEntries(FSUtils.constructAbsolutePath((String)hoodieWriteConfig.getBasePath(), (String)pPath), (StoragePathFilter)filter).size());
        }
        filter = (StoragePathFilter & Serializable)path -> path.toString().contains(firstCommit);
        for (String pPath : this.dataGen.getPartitionPaths()) {
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.storage.listDirectEntries(FSUtils.constructAbsolutePath((String)hoodieWriteConfig.getBasePath(), (String)pPath), (StoragePathFilter)filter).size());
        }
    }

    @Test
    void testCleaningPendingCompaction() throws Exception {
        HoodieWriteConfig hoodieWriteConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(4).withInlineCompaction(Boolean.valueOf(false)).withScheduleInlineCompaction(Boolean.valueOf(true)).build()).withRollbackUsingMarkers(true).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);){
            int i;
            String savepointCommit = null;
            int numRecords = 10;
            List baseRecordsToUpdate = null;
            for (i = 1; i <= 3; ++i) {
                String newCommitTime = HoodieActiveTimeline.createNewInstantTime();
                client.startCommitWithTime(newCommitTime);
                List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(10));
                JavaRDD writeRecords = this.jsc.parallelize(records, 1);
                client.insert(writeRecords, newCommitTime);
                if (i != 3) continue;
                savepointCommit = newCommitTime;
                baseRecordsToUpdate = records;
                client.savepoint("user1", "Savepoint for 3rd commit");
            }
            this.assertRowNumberEqualsTo(30);
            for (i = 1; i <= 3; ++i) {
                this.upsertBatch(this.writeClient, baseRecordsToUpdate);
                if (i != 1) continue;
                Option compactionInstant = client.scheduleCompaction(Option.empty());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)compactionInstant.isPresent(), (String)"A compaction plan should be scheduled");
                this.compactWithoutCommit((String)compactionInstant.get());
            }
            client.restoreToSavepoint((String)Objects.requireNonNull(savepointCommit, "restore commit should not be null"));
            this.assertRowNumberEqualsTo(30);
        }
    }

    @Test
    void testCleaningCompletedRollback() throws Exception {
        HoodieWriteConfig hoodieWriteConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(3).withInlineCompaction(Boolean.valueOf(false)).withScheduleInlineCompaction(Boolean.valueOf(true)).build()).withRollbackUsingMarkers(true).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);){
            String savepointCommit = null;
            int numRecords = 10;
            List baseRecordsToUpdate = null;
            for (int i = 1; i <= 2; ++i) {
                String newCommitTime = HoodieActiveTimeline.createNewInstantTime();
                client.startCommitWithTime(newCommitTime);
                List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(10));
                JavaRDD writeRecords = this.jsc.parallelize(records, 1);
                client.insert(writeRecords, newCommitTime);
                if (i != 2) continue;
                baseRecordsToUpdate = records;
            }
            this.upsertBatch(client, baseRecordsToUpdate);
            Option compactionInstant = client.scheduleCompaction(Option.empty());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)compactionInstant.isPresent(), (String)"A compaction plan should be scheduled");
            client.compact((String)compactionInstant.get());
            savepointCommit = (String)compactionInstant.get();
            client.savepoint("user1", "Savepoint for 3td commit");
            this.assertRowNumberEqualsTo(20);
            this.updateBatchWithoutCommit(HoodieActiveTimeline.createNewInstantTime(), Objects.requireNonNull(baseRecordsToUpdate, "The records to update should not be null"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.writeClient.rollbackFailedWrites(), (String)"The last delta_commit should be rolled back");
            this.upsertBatch(this.writeClient, baseRecordsToUpdate);
            client.restoreToSavepoint(Objects.requireNonNull(savepointCommit, "restore commit should not be null"));
            this.assertRowNumberEqualsTo(20);
        }
    }

    private void upsertBatch(SparkRDDWriteClient client, List<HoodieRecord> baseRecordsToUpdate) throws IOException {
        String newCommitTime = HoodieActiveTimeline.createNewInstantTime();
        client.startCommitWithTime(newCommitTime);
        List records = this.dataGen.generateUpdates(newCommitTime, Objects.requireNonNull(baseRecordsToUpdate, "The records to update should not be null"));
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        client.upsert(writeRecords, newCommitTime);
    }

    private void compactWithoutCommit(String compactionInstantTime) {
        HoodieWriteConfig hoodieWriteConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.LAZY).withAutoCommit(false).withRollbackUsingMarkers(true).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);){
            JavaRDD statuses = (JavaRDD)client.compact(compactionInstantTime).getWriteStatuses();
            Assertions.assertNoWriteErrors((List)statuses.collect());
        }
    }

    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }
}

