/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.index.bloom.BucketizedBloomCheckPartitioner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBucketizedBloomCheckPartitioner {
    @Test
    public void testAssignmentCorrectness() {
        final HoodieFileGroupId fg1 = new HoodieFileGroupId("p1", "f1");
        final HoodieFileGroupId fg2 = new HoodieFileGroupId("p1", "f2");
        final HoodieFileGroupId fg3 = new HoodieFileGroupId("p1", "f3");
        HashMap<HoodieFileGroupId, Long> fileToComparisons = new HashMap<HoodieFileGroupId, Long>(){
            {
                this.put(fg1, 40L);
                this.put(fg2, 35L);
                this.put(fg3, 20L);
            }
        };
        BucketizedBloomCheckPartitioner p = new BucketizedBloomCheckPartitioner(4, (Map)fileToComparisons, 10);
        Map assignments = p.getFileGroupToPartitions();
        Assertions.assertEquals((int)4, (int)((List)assignments.get(fg1)).size(), (String)"f1 should have 4 buckets");
        Assertions.assertEquals((int)4, (int)((List)assignments.get(fg2)).size(), (String)"f2 should have 4 buckets");
        Assertions.assertEquals((int)2, (int)((List)assignments.get(fg3)).size(), (String)"f3 should have 2 buckets");
        Assertions.assertArrayEquals((Object[])new Integer[]{0, 0, 1, 3}, (Object[])((List)assignments.get(fg1)).toArray(), (String)"f1 spread across 3 partitions");
        Assertions.assertArrayEquals((Object[])new Integer[]{2, 2, 3, 1}, (Object[])((List)assignments.get(fg2)).toArray(), (String)"f2 spread across 3 partitions");
        Assertions.assertArrayEquals((Object[])new Integer[]{1, 0}, (Object[])((List)assignments.get(fg3)).toArray(), (String)"f3 spread across 2 partitions");
    }

    @Test
    public void testUniformPacking() {
        HashMap<HoodieFileGroupId, Long> comparisons1 = new HashMap<HoodieFileGroupId, Long>(){
            {
                IntStream.range(0, 10).forEach((int f) -> this.put(new HoodieFileGroupId("p1", "f" + f), 100L));
            }
        };
        BucketizedBloomCheckPartitioner partitioner = new BucketizedBloomCheckPartitioner(100, (Map)comparisons1, 10);
        Map assignments = partitioner.getFileGroupToPartitions();
        assignments.forEach((key, value) -> Assertions.assertEquals((int)10, (int)value.size()));
        Map<Integer, Long> partitionToNumBuckets = assignments.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(p -> Pair.of((Object)p, e.getKey()))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.counting()));
        partitionToNumBuckets.forEach((key, value) -> Assertions.assertEquals((long)1L, (long)value));
    }

    @Test
    public void testNumPartitions() {
        HashMap<HoodieFileGroupId, Long> comparisons1 = new HashMap<HoodieFileGroupId, Long>(){
            {
                IntStream.range(0, 10).forEach((int f) -> this.put(new HoodieFileGroupId("p1", "f" + f), 100L));
            }
        };
        BucketizedBloomCheckPartitioner p = new BucketizedBloomCheckPartitioner(10000, (Map)comparisons1, 10);
        Assertions.assertEquals((int)100, (int)p.numPartitions(), (String)"num partitions must equal total buckets");
    }

    @Test
    public void testGetPartitions() {
        HashMap<HoodieFileGroupId, Long> comparisons1 = new HashMap<HoodieFileGroupId, Long>(){
            {
                IntStream.range(0, 100000).forEach((int f) -> this.put(new HoodieFileGroupId("p1", "f" + f), 100L));
            }
        };
        BucketizedBloomCheckPartitioner p = new BucketizedBloomCheckPartitioner(1000, (Map)comparisons1, 10);
        IntStream.range(0, 100000).forEach(f -> {
            int partition = p.getPartition((Object)Pair.of((Object)new HoodieFileGroupId("p1", "f" + f), (Object)"value"));
            Assertions.assertTrue((0 <= partition && partition <= 1000 ? 1 : 0) != 0, (String)("partition is out of range: " + partition));
        });
    }
}

