/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.hbase;

import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieHBaseIndexConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.hbase.DefaultHBaseQPSResourceAllocator;
import org.apache.hudi.index.hbase.HBaseIndexQPSResourceAllocator;
import org.apache.hudi.index.hbase.SparkHoodieHBaseIndex;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHBaseQPSResourceAllocator {
    @Test
    public void testsDefaultQPSResourceAllocator() {
        HoodieWriteConfig config = this.getConfig((Option<String>)Option.empty());
        SparkHoodieHBaseIndex index = new SparkHoodieHBaseIndex(config);
        HBaseIndexQPSResourceAllocator hBaseIndexQPSResourceAllocator = index.createQPSResourceAllocator(config);
        Assertions.assertEquals((Object)hBaseIndexQPSResourceAllocator.getClass().getName(), (Object)DefaultHBaseQPSResourceAllocator.class.getName());
        Assertions.assertEquals((float)config.getHbaseIndexQPSFraction(), (float)hBaseIndexQPSResourceAllocator.acquireQPSResources(config.getHbaseIndexQPSFraction(), 100L), (float)0.0f);
    }

    @Test
    public void testsExplicitDefaultQPSResourceAllocator() {
        HoodieWriteConfig config = this.getConfig((Option<String>)Option.of((Object)HoodieHBaseIndexConfig.QPS_ALLOCATOR_CLASS_NAME.defaultValue()));
        SparkHoodieHBaseIndex index = new SparkHoodieHBaseIndex(config);
        HBaseIndexQPSResourceAllocator hBaseIndexQPSResourceAllocator = index.createQPSResourceAllocator(config);
        Assertions.assertEquals((Object)hBaseIndexQPSResourceAllocator.getClass().getName(), (Object)DefaultHBaseQPSResourceAllocator.class.getName());
        Assertions.assertEquals((float)config.getHbaseIndexQPSFraction(), (float)hBaseIndexQPSResourceAllocator.acquireQPSResources(config.getHbaseIndexQPSFraction(), 100L), (float)0.0f);
    }

    @Test
    public void testsInvalidQPSResourceAllocator() {
        HoodieWriteConfig config = this.getConfig((Option<String>)Option.of((Object)"InvalidResourceAllocatorClassName"));
        SparkHoodieHBaseIndex index = new SparkHoodieHBaseIndex(config);
        HBaseIndexQPSResourceAllocator hBaseIndexQPSResourceAllocator = index.createQPSResourceAllocator(config);
        Assertions.assertEquals((Object)hBaseIndexQPSResourceAllocator.getClass().getName(), (Object)DefaultHBaseQPSResourceAllocator.class.getName());
        Assertions.assertEquals((float)config.getHbaseIndexQPSFraction(), (float)hBaseIndexQPSResourceAllocator.acquireQPSResources(config.getHbaseIndexQPSFraction(), 100L), (float)0.0f);
    }

    private HoodieWriteConfig getConfig(Option<String> resourceAllocatorClass) {
        HoodieHBaseIndexConfig hoodieHBaseIndexConfig = this.getConfigWithResourceAllocator(resourceAllocatorClass);
        return this.getConfigBuilder(hoodieHBaseIndexConfig).build();
    }

    private HoodieWriteConfig.Builder getConfigBuilder(HoodieHBaseIndexConfig hoodieHBaseIndexConfig) {
        return HoodieWriteConfig.newBuilder().withPath("/foo").withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(1, 1).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x100000L).withInlineCompaction(Boolean.valueOf(false)).build()).withAutoCommit(false).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(1024000L).parquetMaxFileSize(0x100000L).build()).forTable("test-trip-table").withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.HBASE).withHBaseIndexConfig(hoodieHBaseIndexConfig).build());
    }

    private HoodieHBaseIndexConfig getConfigWithResourceAllocator(Option<String> resourceAllocatorClass) {
        HoodieHBaseIndexConfig.Builder builder = new HoodieHBaseIndexConfig.Builder().hbaseZkPort(0).hbaseZkQuorum("localhost").hbaseTableName("foobar").hbaseIndexGetBatchSize(100);
        if (resourceAllocatorClass.isPresent()) {
            builder.withQPSResourceAllocatorType((String)resourceAllocatorClass.get());
        }
        return builder.build();
    }
}

