/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.Transformations;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.io.HoodieKeyLocationFetchHandle;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.hudi.testutils.HoodieSparkWriteableTestTable;
import org.apache.hudi.testutils.MetadataMergeWriteStatus;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Tuple2;

public class TestHoodieKeyLocationFetchHandle
extends HoodieSparkClientTestHarness {
    private HoodieWriteConfig config;

    @BeforeEach
    public void setUp() throws Exception {
        this.initSparkContexts("TestRecordFetcher");
        this.initPath();
        this.initTestDataGenerator();
        this.initHoodieStorage();
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.cleanupResources();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testFetchHandle(boolean populateMetaFields) throws Exception {
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (Properties)(populateMetaFields ? new Properties() : TestHoodieKeyLocationFetchHandle.getPropertiesForKeyGen()));
        this.config = this.getConfigBuilder().withProperties(TestHoodieKeyLocationFetchHandle.getPropertiesForKeyGen()).withIndexConfig(HoodieIndexConfig.newBuilder().build()).build();
        List records = this.dataGen.generateInserts(HoodieTestTable.makeNewCommitTime(), Integer.valueOf(100));
        Map partitionRecordsMap = Transformations.recordsToPartitionRecordsMap((List)records);
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)this.config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieSparkWriteableTestTable testTable = HoodieSparkWriteableTestTable.of((HoodieTable)hoodieTable, HoodieTestDataGenerator.AVRO_SCHEMA_WITH_METADATA_FIELDS);
        Map<Tuple2<String, String>, List<Tuple2<HoodieKey, HoodieRecordLocation>>> expectedList = this.writeToParquetAndGetExpectedRecordLocations(partitionRecordsMap, testTable);
        List<Tuple2<String, HoodieBaseFile>> partitionPathFileIdPairs = TestHoodieKeyLocationFetchHandle.loadAllFilesForPartitions(new ArrayList<String>(partitionRecordsMap.keySet()), (HoodieEngineContext)this.context, (HoodieTable)hoodieTable);
        BaseKeyGenerator keyGenerator = (BaseKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)new TypedProperties(TestHoodieKeyLocationFetchHandle.getPropertiesForKeyGen()));
        for (Tuple2<String, HoodieBaseFile> entry : partitionPathFileIdPairs) {
            HoodieKeyLocationFetchHandle fetcherHandle = new HoodieKeyLocationFetchHandle(this.config, (HoodieTable)hoodieTable, Pair.of((Object)entry._1, (Object)entry._2), populateMetaFields ? Option.empty() : Option.of((Object)keyGenerator));
            Iterator result = fetcherHandle.locations().iterator();
            ArrayList actualList = new ArrayList();
            result.forEachRemaining(x -> actualList.add(new Tuple2(x.getLeft(), x.getRight())));
            Assertions.assertEquals(expectedList.get(new Tuple2(entry._1, (Object)((HoodieBaseFile)entry._2).getFileId())), actualList);
        }
    }

    private Map<Tuple2<String, String>, List<Tuple2<HoodieKey, HoodieRecordLocation>>> writeToParquetAndGetExpectedRecordLocations(Map<String, List<HoodieRecord>> partitionRecordsMap, HoodieSparkWriteableTestTable testTable) throws Exception {
        HashMap<Tuple2<String, String>, List<Tuple2<HoodieKey, HoodieRecordLocation>>> expectedList = new HashMap<Tuple2<String, String>, List<Tuple2<HoodieKey, HoodieRecordLocation>>>();
        for (Map.Entry<String, List<HoodieRecord>> entry : partitionRecordsMap.entrySet()) {
            int totalRecordsPerPartition = entry.getValue().size();
            int totalSlices = 1;
            if (totalRecordsPerPartition > 5) {
                totalSlices = totalRecordsPerPartition / 3;
            }
            int recordsPerFileSlice = totalRecordsPerPartition / totalSlices;
            ArrayList recordsForFileSlices = new ArrayList();
            recordsForFileSlices.add(new ArrayList());
            int index = 0;
            int count = 0;
            for (HoodieRecord hoodieRecord : entry.getValue()) {
                if (count < recordsPerFileSlice) {
                    ((List)recordsForFileSlices.get(index)).add(hoodieRecord);
                    ++count;
                    continue;
                }
                recordsForFileSlices.add(new ArrayList());
                ++index;
                count = 0;
            }
            for (List list : recordsForFileSlices) {
                String instantTime = HoodieTestTable.makeNewCommitTime();
                String fileId = testTable.addCommit(instantTime).getFileIdWithInserts(entry.getKey(), list.toArray(new HoodieRecord[0]));
                Tuple2 fileIdInstantTimePair = new Tuple2((Object)fileId, (Object)instantTime);
                ArrayList<Tuple2> expectedEntries = new ArrayList<Tuple2>();
                for (HoodieRecord record : list) {
                    expectedEntries.add(new Tuple2((Object)record.getKey(), (Object)new HoodieRecordLocation((String)fileIdInstantTimePair._2, (String)fileIdInstantTimePair._1)));
                }
                expectedList.put((Tuple2<String, String>)new Tuple2((Object)entry.getKey(), fileIdInstantTimePair._1), expectedEntries);
            }
        }
        return expectedList;
    }

    private static List<Tuple2<String, HoodieBaseFile>> loadAllFilesForPartitions(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        List partitionPathFileIDList = HoodieIndexUtils.getLatestBaseFilesForAllPartitions(partitions, (HoodieEngineContext)context, (HoodieTable)hoodieTable);
        return partitionPathFileIDList.stream().map(pf -> new Tuple2(pf.getKey(), pf.getValue())).collect(Collectors.toList());
    }

    public HoodieWriteConfig.Builder getConfigBuilder() {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withBulkInsertParallelism(2).withFinalizeWriteParallelism(2).withDeleteParallelism(2).withWriteStatusClass(MetadataMergeWriteStatus.class).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x100000L).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x100000L).parquetMaxFileSize(0x100000L).build()).forTable("test-trip-table").withIndexConfig(HoodieIndexConfig.newBuilder().build()).withEmbeddedTimelineServerEnabled(true);
    }
}

