/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hudi.HoodieTestCommitGenerator;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.client.HoodieTimelineArchiver;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.client.utils.MetadataConversionUtils;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.testutils.HoodieMetadataTestTable;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHoodieTimelineArchiver
extends HoodieSparkClientTestHarness {
    private static final Logger LOG = LoggerFactory.getLogger(TestHoodieTimelineArchiver.class);
    private HoodieTableMetadataWriter metadataWriter;
    private HoodieTestTable testTable;

    public void init() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
    }

    public void init(HoodieTableType tableType) throws Exception {
        this.initPath();
        this.initSparkContexts();
        this.initTimelineService();
        this.initMetaClient();
        this.storage = this.metaClient.getStorage();
        this.metaClient.getStorage().createDirectory(new StoragePath(this.basePath));
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)tableType);
    }

    private void initWriteConfigAndMetatableWriter(HoodieWriteConfig writeConfig, boolean enableMetadataTable) throws IOException {
        if (enableMetadataTable) {
            this.metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context);
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            this.testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.metadataWriter, (Option)Option.of((Object)this.context));
        } else {
            this.testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        }
    }

    @AfterEach
    public void clean() throws Exception {
        this.cleanupResources();
        if (this.metadataWriter != null) {
            this.metadataWriter.close();
        }
    }

    private HoodieWriteConfig initTestTableAndGetWriteConfig(boolean enableMetadata, int minArchivalCommits, int maxArchivalCommits, int maxDeltaCommitsMetadataTable) throws Exception {
        return this.initTestTableAndGetWriteConfig(enableMetadata, minArchivalCommits, maxArchivalCommits, maxDeltaCommitsMetadataTable, HoodieTableType.COPY_ON_WRITE);
    }

    private HoodieWriteConfig initTestTableAndGetWriteConfig(boolean enableMetadata, int minArchivalCommits, int maxArchivalCommits, int maxDeltaCommits, int maxDeltaCommitsMetadataTable, HoodieTableType tableType) throws Exception {
        return this.initTestTableAndGetWriteConfig(enableMetadata, minArchivalCommits, maxArchivalCommits, maxDeltaCommits, maxDeltaCommitsMetadataTable, tableType, false, 10, 0xC800000L, HoodieFailedWritesCleaningPolicy.EAGER, WriteConcurrencyMode.SINGLE_WRITER);
    }

    private HoodieWriteConfig initTestTableAndGetWriteConfig(boolean enableMetadata, int minArchivalCommits, int maxArchivalCommits, int maxDeltaCommitsMetadataTable, HoodieTableType tableType) throws Exception {
        return this.initTestTableAndGetWriteConfig(enableMetadata, minArchivalCommits, maxArchivalCommits, 5, maxDeltaCommitsMetadataTable, tableType, false, 10, 0xC800000L, HoodieFailedWritesCleaningPolicy.EAGER, WriteConcurrencyMode.SINGLE_WRITER);
    }

    private HoodieWriteConfig initTestTableAndGetWriteConfig(boolean enableMetadata, int minArchivalCommits, int maxArchivalCommits, int maxDeltaCommitsMetadataTable, boolean enableArchiveMerge, int archiveFilesBatch, long size) throws Exception {
        return this.initTestTableAndGetWriteConfig(enableMetadata, minArchivalCommits, maxArchivalCommits, 5, maxDeltaCommitsMetadataTable, HoodieTableType.COPY_ON_WRITE, enableArchiveMerge, archiveFilesBatch, size, HoodieFailedWritesCleaningPolicy.EAGER, WriteConcurrencyMode.SINGLE_WRITER);
    }

    private HoodieWriteConfig initTestTableAndGetWriteConfig(boolean enableMetadata, int minArchivalCommits, int maxArchivalCommits, int maxDeltaCommits, int maxDeltaCommitsMetadataTable, HoodieTableType tableType, boolean enableArchiveMerge, int archiveFilesBatch, long size, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, WriteConcurrencyMode writeConcurrencyMode) throws Exception {
        return this.initTestTableAndGetWriteConfig(enableMetadata, minArchivalCommits, maxArchivalCommits, maxDeltaCommits, maxDeltaCommitsMetadataTable, tableType, enableArchiveMerge, archiveFilesBatch, size, failedWritesCleaningPolicy, writeConcurrencyMode, (Boolean)HoodieArchivalConfig.ARCHIVE_BEYOND_SAVEPOINT.defaultValue());
    }

    private HoodieWriteConfig initTestTableAndGetWriteConfig(boolean enableMetadata, int minArchivalCommits, int maxArchivalCommits, int maxDeltaCommits, int maxDeltaCommitsMetadataTable, HoodieTableType tableType, boolean enableArchiveMerge, int archiveFilesBatch, long size, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, WriteConcurrencyMode writeConcurrencyMode, boolean archiveProceedBeyondSavepoints) throws Exception {
        this.init(tableType);
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).withFailedWritesCleaningPolicy(failedWritesCleaningPolicy).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().withArchiveMergeEnable(enableArchiveMerge).withArchiveMergeFilesBatchSize(archiveFilesBatch).withArchiveMergeSmallFileLimit(size).archiveCommitsWith(minArchivalCommits, maxArchivalCommits).withArchiveBeyondSavepoint(archiveProceedBeyondSavepoints).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(maxDeltaCommits).build()).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMetadata).withMaxNumDeltaCommitsBeforeCompaction(maxDeltaCommitsMetadataTable).build()).withWriteConcurrencyMode(writeConcurrencyMode).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(InProcessLockProvider.class).build()).forTable("test-trip-table").build();
        this.initWriteConfigAndMetatableWriter(writeConfig, enableMetadata);
        return writeConfig;
    }

    @Test
    public void testArchiveEmptyTable() throws Exception {
        this.init();
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).forTable("test-trip-table").build();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(cfg, (HoodieTable)table);
        boolean result = archiver.archiveIfRequired((HoodieEngineContext)this.context);
        Assertions.assertTrue((boolean)result);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchiveTableWithArchival(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 2);
        for (int i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            if (i < 6) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            if (i == 6) {
                this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002")), this.getActiveCommitInstants(Arrays.asList("00000003", "00000004", "00000005", "00000006")), commitsAfterArchival);
                continue;
            }
            if (i < 8) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            if (i == 8) {
                this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000003", "00000004")), this.getActiveCommitInstants(Arrays.asList("00000005", "00000006", "00000007", "00000008")), commitsAfterArchival);
                continue;
            }
            Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        }
    }

    @Test
    public void testArchiveTableWithReplaceCommits() throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 2);
        for (int i = 1; i < 9; ++i) {
            if (i < 3) {
                this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            } else {
                this.testTable.doWriteOperation("0000000" + i, WriteOperationType.INSERT_OVERWRITE, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            }
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            if (i != 8) continue;
            Assertions.assertEquals((int)6, (int)originalCommits.size());
            Assertions.assertEquals((int)4, (int)commitsAfterArchival.size());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"KEEP_LATEST_BY_HOURS", "KEEP_LATEST_COMMITS"})
    public void testArchivalWithAutoAdjustmentBasedOnCleanConfigs(String cleaningPolicy) throws Exception {
        this.init();
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withAssumeDatePartitioning(true).withMaxNumDeltaCommitsBeforeCompaction(5).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).withCleanerPolicy(HoodieCleaningPolicy.valueOf((String)cleaningPolicy)).cleanerNumHoursRetained(1).retainCommits(5).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(3, 4).build()).build();
        HoodieTestTable testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        String p0 = "2020/01/01";
        String p1 = "2020/01/02";
        Instant instant = Instant.now();
        ZonedDateTime commitDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        ArrayList<HoodieInstant> expectedAllCommits = new ArrayList<HoodieInstant>();
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 90, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 80, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 70, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 50, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 45, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 40, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 30, false, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 20, false, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 10, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 5, true, testTable, config));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(config, true);
        List originalCommits = (List)commitsList.getKey();
        List commitsAfterArchival = (List)commitsList.getValue();
        this.assertInstantListEquals(expectedAllCommits, originalCommits);
        this.assertInstantListEquals(expectedAllCommits.subList(2, expectedAllCommits.size()), commitsAfterArchival);
    }

    private HoodieInstant triggerCommit(final String p0, final String p1, ZonedDateTime curDateTime, int minutesForCommit, boolean isComplete, HoodieTestTable testTable, HoodieWriteConfig config) throws Exception {
        final String file1P0C0 = UUID.randomUUID().toString();
        final String file1P1C0 = UUID.randomUUID().toString();
        String commitTs = HoodieActiveTimeline.formatDate((Date)Date.from(curDateTime.minusMinutes(minutesForCommit).toInstant()));
        try (HoodieTableMetadataWriter metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)config, (HoodieEngineContext)this.context);){
            Map<String, List<String>> part1ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
                {
                    this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0C0}));
                    this.put(p1, CollectionUtils.createImmutableList((Object[])new String[]{file1P1C0}));
                }
            });
            HoodieInstant hoodieInstant = this.commitWithMdt(commitTs, part1ToFileId, testTable, metadataWriter, true, true, isComplete);
            return hoodieInstant;
        }
    }

    private HoodieInstant commitWithMdt(String instantTime, Map<String, List<String>> partToFileId, HoodieTestTable testTable, HoodieTableMetadataWriter metadataWriter, boolean addBaseFiles, boolean addLogFiles, boolean isComplete) throws Exception {
        testTable.addInflightCommit(instantTime);
        if (isComplete) {
            HashMap<String, List<String>> partToFileIds = new HashMap<String, List<String>>();
            partToFileId.forEach((key, value) -> {
                try {
                    ArrayList files = new ArrayList();
                    if (addBaseFiles) {
                        files.addAll((Collection)testTable.withBaseFilesInPartition(key, value.toArray(new String[0])).getValue());
                    }
                    if (addLogFiles) {
                        value.forEach(logFilePrefix -> {
                            try {
                                files.addAll((Collection)testTable.withLogFile(key, logFilePrefix, new int[]{1, 2}).getValue());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    }
                    partToFileIds.put((String)key, files);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            org.apache.hudi.common.model.HoodieCommitMetadata commitMeta = TestHoodieTimelineArchiver.generateCommitMetadata(instantTime, partToFileIds);
            metadataWriter.performTableServices(Option.of((Object)instantTime));
            metadataWriter.updateFromWriteStatuses(commitMeta, this.context.emptyHoodieData(), instantTime);
            this.metaClient.getActiveTimeline().saveAsComplete(new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime), Option.of((Object)StringUtils.getUTF8Bytes((String)commitMeta.toJsonString())));
        } else {
            org.apache.hudi.common.model.HoodieCommitMetadata commitMeta = TestHoodieTimelineArchiver.generateCommitMetadata(instantTime, new HashMap<String, List<String>>());
        }
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return new HoodieInstant(isComplete ? HoodieInstant.State.COMPLETED : HoodieInstant.State.INFLIGHT, "commit", instantTime);
    }

    protected static org.apache.hudi.common.model.HoodieCommitMetadata generateCommitMetadata(String instantTime, Map<String, List<String>> partitionToFilePaths) {
        org.apache.hudi.common.model.HoodieCommitMetadata metadata = new org.apache.hudi.common.model.HoodieCommitMetadata();
        metadata.addMetadata("schema", "{\"namespace\": \"org.apache.hudi.avro.model\", \"type\": \"record\", \"name\": \"PhonyRecord\", \"fields\": []}");
        partitionToFilePaths.forEach((partitionPath, fileList) -> fileList.forEach(f -> {
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setPartitionPath(partitionPath);
            writeStat.setPath(partitionPath + "/" + HoodieTestCommitGenerator.getBaseFilename((String)instantTime, (String)f));
            writeStat.setFileId(f);
            writeStat.setTotalWriteBytes(1L);
            writeStat.setFileSizeInBytes(1L);
            metadata.addWriteStat(partitionPath, writeStat);
        }));
        return metadata;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSavepointWithArchival(boolean archiveBeyondSavepoint) throws Exception {
        boolean enableMetadata = false;
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 2, 4, 5, 2, HoodieTableType.COPY_ON_WRITE, false, 10, 0xC800000L, HoodieFailedWritesCleaningPolicy.EAGER, WriteConcurrencyMode.SINGLE_WRITER, archiveBeyondSavepoint);
        for (int i = 1; i < 5; ++i) {
            this.testTable.doWriteOperation(String.format("%08d", i), WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        }
        String commitToSavepoint = String.format("%08d", 3);
        HoodieSavepointMetadata savepointMetadata = this.testTable.doSavepoint(commitToSavepoint);
        this.testTable.addSavepoint(commitToSavepoint, savepointMetadata);
        for (int i = 5; i < 7; ++i) {
            this.testTable.doWriteOperation(String.format("%08d", i), WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        }
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
        List originalCommits = (List)commitsList.getKey();
        List commitsAfterArchival = (List)commitsList.getValue();
        if (archiveBeyondSavepoint) {
            this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000004", "00000005")), Stream.concat(this.getActiveCommitInstants(Arrays.asList("00000003", "00000006")).stream(), this.getActiveSavepointedCommitInstants(Arrays.asList("00000003")).stream()).collect(Collectors.toList()), commitsAfterArchival);
        } else {
            this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002")), Stream.concat(this.getActiveCommitInstants(Arrays.asList("00000003", "00000004", "00000005", "00000006")).stream(), this.getActiveSavepointedCommitInstants(Arrays.asList("00000003")).stream()).collect(Collectors.toList()), commitsAfterArchival);
        }
        for (int i = 7; i < 10; ++i) {
            this.testTable.doWriteOperation(String.format("%08d", i), WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        }
        this.testTable.deleteSavepoint(commitToSavepoint);
        commitsList = this.archiveAndGetCommitsList(writeConfig);
        originalCommits = (List)commitsList.getKey();
        commitsAfterArchival = (List)commitsList.getValue();
        this.metaClient.reloadActiveTimeline();
        this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000003", "00000004", "00000005", "00000006", "00000007")), this.getActiveCommitInstants(Arrays.asList("00000008", "00000009")), commitsAfterArchival);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMergeSmallArchiveFilesRecoverFromBuildPlanFailed(boolean enableArchiveMerge) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 2, enableArchiveMerge, 3, 0xC800000L);
        for (int i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.archiveAndGetCommitsList(writeConfig);
        }
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(writeConfig, (HoodieTable)table);
        List entryList = this.metaClient.getStorage().globEntries(new StoragePath(this.metaClient.getArchivePath() + "/.commits_.archive*"));
        List candidateFiles = entryList.stream().map(fs -> fs.getPath().toString()).collect(Collectors.toList());
        archiver.reOpenWriter();
        StoragePath plan = new StoragePath(this.metaClient.getArchivePath(), "mergeArchivePlan");
        archiver.buildArchiveMergePlan(candidateFiles, plan, ".commits_.archive.3_1-0-1");
        String s = "Dummy Content";
        FileIOUtils.createFileInPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)plan, (Option)Option.of((Object)s.getBytes()));
        HoodieActiveTimeline rawActiveTimeline = new HoodieActiveTimeline(this.metaClient, false);
        HoodieArchivedTimeline archivedTimeLine = this.metaClient.getArchivedTimeline().reload();
        Assertions.assertEquals((int)27, (int)(rawActiveTimeline.countInstants() + archivedTimeLine.countInstants()));
        for (int i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation("1000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.archiveAndGetCommitsList(writeConfig);
        }
        HoodieActiveTimeline rawActiveTimeline1 = new HoodieActiveTimeline(this.metaClient, false);
        HoodieArchivedTimeline archivedTimeLine1 = this.metaClient.getArchivedTimeline().reload();
        Assertions.assertEquals((int)54, (int)(archivedTimeLine1.countInstants() + rawActiveTimeline1.countInstants()));
        StoragePath damagedFile = new StoragePath(this.metaClient.getArchivePath(), ".commits_.archive.300_1-0-1");
        FileIOUtils.createFileInPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)damagedFile, (Option)Option.of((Object)StringUtils.getUTF8Bytes((String)s)));
        Assertions.assertThrows(HoodieException.class, () -> this.metaClient.getArchivedTimeline().reload());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMergeSmallArchiveFilesRecoverFromMergeFailed(boolean enableArchiveMerge) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 2, enableArchiveMerge, 3, 0xC800000L);
        for (int i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.archiveAndGetCommitsList(writeConfig);
        }
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(writeConfig, (HoodieTable)table);
        List entryList = this.metaClient.getStorage().globEntries(new StoragePath(this.metaClient.getArchivePath() + "/.commits_.archive*"));
        List candidateFiles = entryList.stream().map(fs -> fs.getPath().toString()).collect(Collectors.toList());
        archiver.reOpenWriter();
        archiver.buildArchiveMergePlan(candidateFiles, new StoragePath(this.metaClient.getArchivePath(), "mergeArchivePlan"), ".commits_.archive.3_1-0-1");
        archiver.mergeArchiveFiles(entryList.stream().collect(Collectors.toList()));
        HoodieLogFormat.Writer writer = archiver.reOpenWriter();
        HoodieActiveTimeline rawActiveTimeline = new HoodieActiveTimeline(this.metaClient, false);
        HoodieArchivedTimeline archivedTimeLine = this.metaClient.getArchivedTimeline().reload();
        Assertions.assertEquals((int)27, (int)(rawActiveTimeline.countInstants() + archivedTimeLine.reload().countInstants()));
        String s = "Dummy Content";
        FileIOUtils.createFileInPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)writer.getLogFile().getPath(), (Option)Option.of((Object)s.getBytes()));
        for (int i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation("1000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.archiveAndGetCommitsList(writeConfig);
        }
        HoodieActiveTimeline rawActiveTimeline1 = new HoodieActiveTimeline(this.metaClient, false);
        HoodieArchivedTimeline archivedTimeLine1 = this.metaClient.getArchivedTimeline().reload();
        Assertions.assertEquals((int)54, (int)(archivedTimeLine1.countInstants() + rawActiveTimeline1.countInstants()));
        StoragePath damagedFile = new StoragePath(this.metaClient.getArchivePath(), ".commits_.archive.300_1-0-1");
        FileIOUtils.createFileInPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)damagedFile, (Option)Option.of((Object)s.getBytes()));
        Assertions.assertThrows(HoodieException.class, () -> this.metaClient.getArchivedTimeline().reload());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMergeSmallArchiveFilesRecoverFromDeleteFailed(boolean enableArchiveMerge) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 2, enableArchiveMerge, 3, 0xC800000L);
        for (int i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.archiveAndGetCommitsList(writeConfig);
        }
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(writeConfig, (HoodieTable)table);
        List entryList = this.metaClient.getStorage().globEntries(new StoragePath(this.metaClient.getArchivePath() + "/.commits_.archive*"));
        List candidateFiles = entryList.stream().map(fs -> fs.getPath().toString()).collect(Collectors.toList());
        archiver.reOpenWriter();
        archiver.buildArchiveMergePlan(candidateFiles, new StoragePath(this.metaClient.getArchivePath(), "mergeArchivePlan"), ".commits_.archive.3_1-0-1");
        archiver.mergeArchiveFiles(entryList.stream().collect(Collectors.toList()));
        archiver.reOpenWriter();
        this.metaClient.getStorage().deleteFile(((StoragePathInfo)entryList.get(0)).getPath());
        HoodieActiveTimeline rawActiveTimeline = new HoodieActiveTimeline(this.metaClient, false);
        HoodieArchivedTimeline archivedTimeLine = this.metaClient.getArchivedTimeline().reload();
        Assertions.assertEquals((int)27, (int)(rawActiveTimeline.countInstants() + archivedTimeLine.countInstants()));
        for (int i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation("1000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.archiveAndGetCommitsList(writeConfig);
        }
        HoodieActiveTimeline rawActiveTimeline1 = new HoodieActiveTimeline(this.metaClient, false);
        HoodieArchivedTimeline archivedTimeLine1 = this.metaClient.getArchivedTimeline().reload();
        Assertions.assertEquals((int)54, (int)(archivedTimeLine1.countInstants() + rawActiveTimeline1.countInstants()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLoadArchiveTimelineWithDamagedPlanFile(boolean enableArchiveMerge) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 2, enableArchiveMerge, 3, 0xC800000L);
        int numInstant = 12;
        for (int i = 1; i < 12; ++i) {
            this.testTable.doWriteOperation("000000" + String.format("%02d", i), WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.archiveAndGetCommitsList(writeConfig);
        }
        StoragePath plan = new StoragePath(this.metaClient.getArchivePath(), "mergeArchivePlan");
        String s = "Dummy Content";
        FileIOUtils.createFileInPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)plan, (Option)Option.of((Object)s.getBytes()));
        HoodieActiveTimeline rawActiveTimeline = new HoodieActiveTimeline(this.metaClient, false);
        HoodieArchivedTimeline archivedTimeLine = this.metaClient.getArchivedTimeline().reload();
        Assertions.assertEquals((int)((numInstant - 1) * 3), (int)(rawActiveTimeline.countInstants() + archivedTimeLine.countInstants()));
        StoragePath damagedFile = new StoragePath(this.metaClient.getArchivePath(), ".commits_.archive.300_1-0-1");
        FileIOUtils.createFileInPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)damagedFile, (Option)Option.of((Object)s.getBytes()));
        Assertions.assertThrows(HoodieException.class, () -> this.metaClient.getArchivedTimeline().reload());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Disabled(value="HUDI-6386")
    public void testArchivalWithMultiWriters(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 5, 2, HoodieTableType.COPY_ON_WRITE, false, 10, 0xC800000L, HoodieFailedWritesCleaningPolicy.LAZY, WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL);
        ExecutorService executors = Executors.newFixedThreadPool(2);
        ArrayList<CompletableFuture<Boolean>> completableFutureList = new ArrayList<CompletableFuture<Boolean>>();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        IntStream.range(0, 2).forEach(index -> completableFutureList.add(CompletableFuture.supplyAsync(() -> {
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
            try {
                countDownLatch.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new HoodieException("Should not have thrown InterruptedException ", (Throwable)e);
            }
            this.metaClient.reloadActiveTimeline();
            while (!((HoodieInstant)this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().get()).getTimestamp().endsWith("29") || this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().countInstants() > 5) {
                try {
                    HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(writeConfig, (HoodieTable)table);
                    archiver.archiveIfRequired((HoodieEngineContext)this.context, true);
                    if (enableMetadata) {
                        Thread.sleep(2L);
                    }
                }
                catch (IOException e) {
                    throw new HoodieException("IOException thrown while archiving ", (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new HoodieException("Should not have thrown InterruptedException ", (Throwable)e);
                }
                table.getMetaClient().reloadActiveTimeline();
            }
            return true;
        }, executors)));
        for (int i = 1; i < 30; ++i) {
            this.testTable.doWriteOperation("0000000" + String.format("%02d", i), WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            if (i != 6) continue;
            countDownLatch.countDown();
        }
        try {
            CompletableFuture completableFuture = TestHoodieTimelineArchiver.allOfTerminateOnFailure(completableFutureList);
            completableFuture.get();
        }
        finally {
            executors.shutdownNow();
        }
    }

    private static CompletableFuture allOfTerminateOnFailure(List<CompletableFuture<Boolean>> futures) {
        CompletableFuture failure = new CompletableFuture();
        AtomicBoolean jobFailed = new AtomicBoolean(false);
        int counter = 0;
        while (counter < futures.size()) {
            CompletableFuture<Boolean> curFuture = futures.get(counter);
            int finalCounter = counter++;
            curFuture.exceptionally(ex -> {
                if (!jobFailed.getAndSet(true)) {
                    LOG.warn("One of the job failed. Cancelling all other futures. " + ex.getCause() + ", " + ex.getMessage());
                    for (int secondCounter = 0; secondCounter < futures.size(); ++secondCounter) {
                        if (secondCounter == finalCounter) continue;
                        ((CompletableFuture)futures.get(secondCounter)).cancel(true);
                    }
                }
                return null;
            });
        }
        return CompletableFuture.anyOf(failure, CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLoadArchiveTimelineWithUncompletedMergeArchiveFile(boolean enableArchiveMerge) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 2, enableArchiveMerge, 3, 0xC800000L);
        for (int i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.archiveAndGetCommitsList(writeConfig);
        }
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(writeConfig, (HoodieTable)table);
        List entryList = this.metaClient.getStorage().globEntries(new StoragePath(this.metaClient.getArchivePath() + "/.commits_.archive*"));
        List candidateFiles = entryList.stream().map(fs -> fs.getPath().toString()).collect(Collectors.toList());
        archiver.reOpenWriter();
        archiver.buildArchiveMergePlan(candidateFiles, new StoragePath(this.metaClient.getArchivePath(), "mergeArchivePlan"), ".commits_.archive.3_1-0-1");
        archiver.mergeArchiveFiles(entryList.stream().collect(Collectors.toList()));
        HoodieLogFormat.Writer writer = archiver.reOpenWriter();
        String s = "Dummy Content";
        FileIOUtils.createFileInPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)writer.getLogFile().getPath(), (Option)Option.of((Object)s.getBytes()));
        HoodieActiveTimeline rawActiveTimeline1 = new HoodieActiveTimeline(this.metaClient, false);
        HoodieArchivedTimeline archivedTimeLine1 = this.metaClient.getArchivedTimeline();
        Assertions.assertEquals((int)27, (int)(archivedTimeLine1.countInstants() + rawActiveTimeline1.countInstants()));
        StoragePath damagedFile = new StoragePath(this.metaClient.getArchivePath(), ".commits_.archive.300_1-0-1");
        FileIOUtils.createFileInPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)damagedFile, (Option)Option.of((Object)s.getBytes()));
        Assertions.assertThrows(HoodieException.class, () -> this.metaClient.getArchivedTimeline().reload());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testNoArchivalUntilMaxArchiveConfigWithExtraInflightCommits(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 2);
        for (int i = 1; i < 6; ++i) {
            this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 2);
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        }
        this.testTable.doWriteOperation("00000006", WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 2, false, true);
        this.testTable.doWriteOperation("00000007", WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 2, false, true);
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
        List originalCommits = (List)commitsList.getKey();
        List commitsAfterArchival = (List)commitsList.getValue();
        Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
    }

    private static Stream<Arguments> archiveCommitSavepointNoHoleParams() {
        return Arrays.stream(new Boolean[][]{{true, true}, {false, true}, {true, false}, {false, false}}).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"archiveCommitSavepointNoHoleParams"})
    public void testArchiveCommitSavepointNoHole(boolean enableMetadataTable, boolean archiveBeyondSavepoint) throws Exception {
        this.init();
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).forTable("test-trip-table").withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(2, 5).withArchiveBeyondSavepoint(archiveBeyondSavepoint).build()).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMetadataTable).build()).build();
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"100", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"101", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createSavepointFile((String)this.basePath, (String)"101", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"102", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"103", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"104", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"105", (StorageConfiguration)this.storageConf);
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context);
        HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(cfg, (HoodieTable)table);
        if (enableMetadataTable) {
            HoodieTestUtils.createCompactionCommitInMetadataTable((StorageConfiguration)this.storageConf, (String)this.basePath, (String)"105");
        }
        HoodieTimeline timeline = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        Assertions.assertEquals((int)6, (int)timeline.countInstants(), (String)"Loaded 6 commits and the count should match");
        Assertions.assertTrue((boolean)archiver.archiveIfRequired((HoodieEngineContext)this.context));
        timeline = this.metaClient.getActiveTimeline().reload().getCommitsTimeline().filterCompletedInstants();
        if (archiveBeyondSavepoint) {
            Assertions.assertEquals((int)2, (int)timeline.countInstants(), (String)"Since archiveBeyondSavepoint config is enabled, we will archive commits 102, 103 ");
            Assertions.assertTrue((boolean)timeline.containsInstant(new HoodieInstant(false, "commit", "101")), (String)"Savepointed commits should always be safe");
            Assertions.assertFalse((boolean)timeline.containsInstant(new HoodieInstant(false, "commit", "102")), (String)"102 expected to be archived");
            Assertions.assertFalse((boolean)timeline.containsInstant(new HoodieInstant(false, "commit", "103")), (String)"103 expected to be archived");
            Assertions.assertTrue((boolean)timeline.containsInstant(new HoodieInstant(false, "commit", "105")), (String)"104 expected to be archived");
            Assertions.assertTrue((boolean)timeline.containsInstant(new HoodieInstant(false, "commit", "105")), (String)"105 expected to be in active timeline");
        } else {
            Assertions.assertEquals((int)5, (int)timeline.countInstants(), (String)"Since we have a savepoint at 101, we should never archive any commit after 101 (we only archive 100)");
            Assertions.assertTrue((boolean)timeline.containsInstant(new HoodieInstant(false, "commit", "101")), (String)"Archived commits should always be safe");
            Assertions.assertTrue((boolean)timeline.containsInstant(new HoodieInstant(false, "commit", "102")), (String)"Archived commits should always be safe");
            Assertions.assertTrue((boolean)timeline.containsInstant(new HoodieInstant(false, "commit", "103")), (String)"Archived commits should always be safe");
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPendingClusteringWillBlockArchival(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 2);
        HoodieTestDataGenerator.createPendingReplaceFile((String)this.basePath, (String)"00000000", (StorageConfiguration)this.storageConf);
        for (int i = 1; i < 8; ++i) {
            this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 2);
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        }
        HoodieTimeline timeline = this.metaClient.getActiveTimeline().reload().getCommitsTimeline().filterCompletedInstants();
        Assertions.assertEquals((int)7, (int)timeline.countInstants(), (String)"Since we have a pending clustering instant at 00000000, we should never archive any commit after 00000000");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchiveRollbacksTestTable(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 2);
        for (int i = 1; i < 13; i += 2) {
            this.testTable.doWriteOperation("000000" + String.format("%02d", i), WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.testTable.doRollback("000000" + String.format("%02d", i), "000000" + String.format("%02d", i + 1));
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            if (i != 11) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            ArrayList<HoodieInstant> expectedArchivedInstants = new ArrayList<HoodieInstant>();
            expectedArchivedInstants.addAll(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000003")));
            expectedArchivedInstants.addAll(this.getAllArchivedCommitInstants(Arrays.asList("00000002", "00000004"), "rollback"));
            ArrayList<HoodieInstant> expectedActiveInstants = new ArrayList<HoodieInstant>();
            expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000005", "00000007", "00000009", "00000011")));
            expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000006", "00000008", "00000010", "00000012"), "rollback"));
            this.verifyArchival(expectedArchivedInstants, expectedActiveInstants, commitsAfterArchival);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testNoArchivalWithInflightCompactionInMiddle(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 2, 2, HoodieTableType.MERGE_ON_READ);
        org.apache.hudi.common.model.HoodieCommitMetadata inflightCompactionMetadata = null;
        for (int i = 1; i < 8; ++i) {
            if (i == 2) {
                inflightCompactionMetadata = this.testTable.doCompaction("0000000" + i, Arrays.asList("p1", "p2"), true);
            } else {
                this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            }
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            if (enableMetadata) {
                if (i != 7) {
                    Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                    continue;
                }
                Assertions.assertEquals((int)(originalCommits.size() - commitsAfterArchival.size()), (int)0);
                continue;
            }
            if (i != 7) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            Assertions.assertEquals((int)(originalCommits.size() - commitsAfterArchival.size()), (int)0);
            for (int j = 1; j <= 7; ++j) {
                if (j == 1) {
                    Assertions.assertTrue((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000000" + j)));
                    continue;
                }
                if (j == 2) {
                    Assertions.assertFalse((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", "0000000" + j)));
                    continue;
                }
                Assertions.assertTrue((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000000" + j)));
            }
        }
        this.testTable.moveInflightCompactionToComplete("00000002", inflightCompactionMetadata);
        this.testTable.doWriteOperation("00000008", WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), 2);
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
        List commitsAfterArchival = (List)commitsList.getValue();
        List<HoodieInstant> archivedInstants = this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000003", "00000004"), "deltacommit");
        archivedInstants.add(new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", "00000002"));
        archivedInstants.add(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "00000002"));
        this.verifyArchival(archivedInstants, this.getActiveCommitInstants(Arrays.asList("00000005", "00000006", "00000007", "00000008"), "deltacommit"), commitsAfterArchival);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchiveCommitTimeline(boolean enableMetadataTable) throws Exception {
        this.init();
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).forTable("test-trip-table").withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(2, 3).build()).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMetadataTable).build()).build();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"1", (StorageConfiguration)this.storageConf);
        HoodieInstant instant1 = new HoodieInstant(false, "commit", "1");
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"2", (StorageConfiguration)this.storageConf);
        StoragePath markerPath = new StoragePath(this.metaClient.getMarkerFolderPath("2"));
        this.storage.createDirectory(markerPath);
        HoodieInstant instant2 = new HoodieInstant(false, "commit", "2");
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"3", (StorageConfiguration)this.storageConf);
        HoodieInstant instant3 = new HoodieInstant(false, "commit", "3");
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"4", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"5", (StorageConfiguration)this.storageConf);
        if (enableMetadataTable) {
            HoodieTestUtils.createCompactionCommitInMetadataTable((StorageConfiguration)this.storageConf, (String)this.basePath, (String)"5");
        }
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(cfg, (HoodieTable)table);
        boolean result = archiver.archiveIfRequired((HoodieEngineContext)this.context);
        Assertions.assertTrue((boolean)result);
        HoodieArchivedTimeline archivedTimeline = this.metaClient.getArchivedTimeline();
        List<HoodieInstant> archivedInstants = Arrays.asList(instant1, instant2, instant3);
        Assertions.assertEquals(new HashSet<HoodieInstant>(archivedInstants), archivedTimeline.filterCompletedInstants().getInstantsAsStream().collect(Collectors.toSet()));
        Assertions.assertFalse((boolean)this.storage.exists(markerPath));
    }

    private void verifyInflightInstants(HoodieTableMetaClient metaClient, int expectedTotalInstants) {
        HoodieTimeline timeline = metaClient.getActiveTimeline().reload().getTimelineOfActions(Collections.singleton("clean")).filterInflights();
        Assertions.assertEquals((int)expectedTotalInstants, (int)timeline.countInstants(), (String)"Loaded inflight clean actions and the count should match");
    }

    @Test
    public void testConvertCommitMetadata() throws Exception {
        this.init();
        org.apache.hudi.common.model.HoodieCommitMetadata hoodieCommitMetadata = new org.apache.hudi.common.model.HoodieCommitMetadata();
        hoodieCommitMetadata.setOperationType(WriteOperationType.INSERT);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieCommitMetadata expectedCommitMetadata = MetadataConversionUtils.convertCommitMetadata((org.apache.hudi.common.model.HoodieCommitMetadata)hoodieCommitMetadata);
        Assertions.assertEquals((Object)expectedCommitMetadata.getOperationType(), (Object)WriteOperationType.INSERT.toString());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchiveTableWithCleanCommits(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 2);
        HashMap<String, Integer> cleanStats = new HashMap<String, Integer>();
        cleanStats.put("p1", 1);
        cleanStats.put("p2", 2);
        for (int i = 1; i <= 10; ++i) {
            ArrayList<HoodieInstant> expectedActiveInstants;
            if (i == 1) {
                this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 20);
            } else if (i <= 7 || i == 9) {
                this.testTable.doClean("0000000" + i, cleanStats);
            } else {
                this.testTable.doWriteOperation("000000" + String.format("%02d", i), WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            }
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            if (i < 7) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            if (i == 7) {
                if (!enableMetadata) {
                    expectedActiveInstants = new ArrayList<HoodieInstant>();
                    expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000001")));
                    expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000004", "00000005", "00000006", "00000007"), "clean"));
                    this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000002", "00000003"), "clean"), expectedActiveInstants, commitsAfterArchival);
                    continue;
                }
                expectedActiveInstants = new ArrayList();
                expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000001")));
                expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000002", "00000003", "00000004", "00000005", "00000006", "00000007"), "clean"));
                this.verifyArchival(this.getAllArchivedCommitInstants(Collections.emptyList(), "clean"), expectedActiveInstants, commitsAfterArchival);
                continue;
            }
            if (!enableMetadata) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            if (i == 8) {
                expectedActiveInstants = new ArrayList();
                expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000001", "00000008")));
                expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000004", "00000005", "00000006", "00000007"), "clean"));
                this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000002", "00000003"), "clean"), expectedActiveInstants, commitsAfterArchival);
                continue;
            }
            Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        }
    }

    @Test
    public void testArchiveRollbacksAndCleanTestTable() throws Exception {
        int i;
        int minArchiveCommits = 4;
        int maxArchiveCommits = 9;
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, minArchiveCommits, maxArchiveCommits, 2);
        this.testTable.doWriteOperation("00000001", WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 20);
        HashMap<String, Integer> partitionToFileDeleteCount = new HashMap<String, Integer>();
        partitionToFileDeleteCount.put("p1", 1);
        partitionToFileDeleteCount.put("p2", 1);
        for (i = 2; i <= maxArchiveCommits + 2; ++i) {
            this.testTable.doClean((i > 9 ? "000000" : "0000000") + i, partitionToFileDeleteCount);
        }
        for (i = 12; i <= 2 * maxArchiveCommits; i += 2) {
            this.testTable.doWriteOperation("000000" + i, WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.testTable.doRollback("000000" + i, "000000" + (i + 1));
        }
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
        List originalCommits = (List)commitsList.getKey();
        List commitsAfterArchival = (List)commitsList.getValue();
        ArrayList<HoodieInstant> expectedActiveInstants = new ArrayList<HoodieInstant>();
        expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000008", "00000009", "00000010", "00000011"), "clean"));
        expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000001", "00000012", "00000014", "00000016", "00000018")));
        expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000013", "00000015", "00000017", "00000019"), "rollback"));
        this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000002", "00000003", "00000004", "00000005", "00000006", "00000007"), "clean"), expectedActiveInstants, commitsAfterArchival);
    }

    @ParameterizedTest
    @CsvSource(value={"true,true", "true,false", "false,true", "false,false"})
    public void testArchiveCompletedRollbackAndClean(boolean isEmpty, boolean enableMetadataTable) throws Exception {
        this.init();
        int minInstantsToKeep = 2;
        int maxInstantsToKeep = 10;
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).forTable("test-trip-table").withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(minInstantsToKeep, maxInstantsToKeep).build()).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMetadataTable).build()).build();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        int startInstant = 1;
        List<Object> expectedArchivedInstants = new ArrayList<HoodieInstant>();
        int i = 0;
        while (i < maxInstantsToKeep + 1) {
            this.createCleanMetadata(startInstant + "", false, false, isEmpty || i % 2 == 0);
            expectedArchivedInstants.add(new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", startInstant + ""));
            expectedArchivedInstants.add(new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", startInstant + ""));
            expectedArchivedInstants.add(new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", startInstant + ""));
            ++i;
            ++startInstant;
        }
        i = 0;
        while (i < maxInstantsToKeep + 1) {
            this.createCommitAndRollbackFile(startInstant + 1 + "", startInstant + "", false, isEmpty || i % 2 == 0);
            expectedArchivedInstants.add(new HoodieInstant(HoodieInstant.State.REQUESTED, "rollback", startInstant + ""));
            expectedArchivedInstants.add(new HoodieInstant(HoodieInstant.State.INFLIGHT, "rollback", startInstant + ""));
            expectedArchivedInstants.add(new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", startInstant + ""));
            ++i;
            startInstant += 2;
        }
        if (enableMetadataTable) {
            HoodieTestUtils.createCompactionCommitInMetadataTable((StorageConfiguration)this.storageConf, (String)this.basePath, (String)Integer.toString(99));
        }
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(cfg, (HoodieTable)table);
        archiver.archiveIfRequired((HoodieEngineContext)this.context);
        Stream currentInstants = this.metaClient.getActiveTimeline().reload().getInstantsAsStream();
        Map<Object, List<HoodieInstant>> actionInstantMap = currentInstants.collect(Collectors.groupingBy(HoodieInstant::getAction));
        Assertions.assertTrue((boolean)actionInstantMap.containsKey("clean"), (String)"Clean Action key must be preset");
        Assertions.assertEquals((int)minInstantsToKeep, (int)actionInstantMap.get("clean").size(), (String)"Should have min instant");
        Assertions.assertTrue((boolean)actionInstantMap.containsKey("rollback"), (String)"Rollback Action key must be preset");
        Assertions.assertEquals((int)minInstantsToKeep, (int)actionInstantMap.get("rollback").size(), (String)"Should have min instant");
        this.metaClient.getArchivedTimeline().loadCompletedInstantDetailsInMemory();
        HoodieInstant firstInstant = (HoodieInstant)this.metaClient.reloadActiveTimeline().firstInstant().get();
        expectedArchivedInstants = expectedArchivedInstants.stream().filter(entry -> HoodieTimeline.compareTimestamps((String)entry.getTimestamp(), (BiPredicate)HoodieTimeline.LESSER_THAN, (String)firstInstant.getTimestamp())).collect(Collectors.toList());
        expectedArchivedInstants.forEach(entry -> Assertions.assertTrue((boolean)this.metaClient.getArchivedTimeline().containsInstant(entry)));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchiveInflightClean(boolean enableMetadataTable) throws Exception {
        this.init();
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).forTable("test-trip-table").withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(2, 3).build()).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMetadataTable).build()).build();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        this.createCleanMetadata("10", false);
        this.createCleanMetadata("11", false);
        HoodieInstant notArchivedInstant1 = this.createCleanMetadata("12", false);
        HoodieInstant notArchivedInstant2 = this.createCleanMetadata("13", false);
        HoodieInstant notArchivedInstant3 = this.createCleanMetadata("14", true);
        if (enableMetadataTable) {
            HoodieTestUtils.createCompactionCommitInMetadataTable((StorageConfiguration)this.storageConf, (String)this.basePath, (String)"14");
        }
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(cfg, (HoodieTable)table);
        archiver.archiveIfRequired((HoodieEngineContext)this.context);
        List notArchivedInstants = this.metaClient.getActiveTimeline().reload().getInstants();
        Assertions.assertEquals((int)3, (int)notArchivedInstants.size(), (String)"Not archived instants should be 3");
        Assertions.assertEquals((Object)notArchivedInstants, Arrays.asList(notArchivedInstant1, notArchivedInstant2, notArchivedInstant3), (String)"");
    }

    @Test
    public void testArchiveTableWithMetadataTableCompaction() throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 7);
        for (int i = 1; i < 7; ++i) {
            this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        }
        this.testTable.doWriteOperation("00000007", WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
        List originalCommits = (List)commitsList.getKey();
        List commitsAfterArchival = (List)commitsList.getValue();
        Assertions.assertEquals((int)(originalCommits.size() - commitsAfterArchival.size()), (int)3);
        this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000003")), this.getActiveCommitInstants(Arrays.asList("00000004", "00000005", "00000006", "00000007")), commitsAfterArchival);
        this.testTable.doWriteOperation("00000008", WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        this.testTable.doWriteOperation("00000009", WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        this.testTable.doWriteOperation("00000010", WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        commitsList = this.archiveAndGetCommitsList(writeConfig);
        originalCommits = (List)commitsList.getKey();
        commitsAfterArchival = (List)commitsList.getValue();
        Assertions.assertEquals((int)(originalCommits.size() - commitsAfterArchival.size()), (int)3);
        this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000003", "00000004", "00000005", "00000006")), this.getActiveCommitInstants(Arrays.asList("00000007", "00000008", "00000009", "00000010")), commitsAfterArchival);
        this.testTable.doWriteOperation("00000011", WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        this.testTable.doWriteOperation("00000012", WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        commitsList = this.archiveAndGetCommitsList(writeConfig);
        originalCommits = (List)commitsList.getKey();
        commitsAfterArchival = (List)commitsList.getValue();
        Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000003", "00000004", "00000005", "00000006")), this.getActiveCommitInstants(Arrays.asList("00000007", "00000008", "00000009", "00000010", "00000011", "00000012")), commitsAfterArchival);
        this.testTable.doWriteOperation("00000013", WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        commitsList = this.archiveAndGetCommitsList(writeConfig);
        originalCommits = (List)commitsList.getKey();
        commitsAfterArchival = (List)commitsList.getValue();
        Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        this.testTable.doWriteOperation("00000014", WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        commitsList = this.archiveAndGetCommitsList(writeConfig);
        originalCommits = (List)commitsList.getKey();
        commitsAfterArchival = (List)commitsList.getValue();
        Assertions.assertEquals((int)(originalCommits.size() - commitsAfterArchival.size()), (int)4);
        this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000003", "00000004", "00000005", "00000006", "00000007", "00000008", "00000009", "00000010")), this.getActiveCommitInstants(Arrays.asList("00000011", "00000012", "00000013", "00000014")), commitsAfterArchival);
    }

    @Test
    public void testArchiveCommitsWithCompactionCommitInMetadataTableTimeline() throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 20);
        int startInstantTime = 100;
        int numCommits = 15;
        int numExpectedArchived = 6;
        for (int i = startInstantTime; i < startInstantTime + numCommits; ++i) {
            HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)Integer.toString(i), (StorageConfiguration)this.storageConf);
        }
        HoodieTestUtils.createCompactionCommitInMetadataTable((StorageConfiguration)this.storageConf, (String)this.basePath, (String)"105");
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context);
        HoodieTimelineArchiver archiveLog = new HoodieTimelineArchiver(writeConfig, (HoodieTable)table);
        HoodieTimeline timeline = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        Assertions.assertEquals((int)numCommits, (int)timeline.countInstants(), (String)String.format("Loaded %d commits and the count should match", numCommits));
        Assertions.assertTrue((boolean)archiveLog.archiveIfRequired((HoodieEngineContext)this.context));
        timeline = this.metaClient.getActiveTimeline().reload().getCommitsTimeline().filterCompletedInstants();
        Assertions.assertEquals((int)(numCommits - numExpectedArchived), (int)timeline.countInstants(), (String)"Since we have a compaction commit of 105 in metadata table timeline, we should never archive any commit after that");
        for (int i = startInstantTime + numExpectedArchived; i < startInstantTime + numCommits; ++i) {
            Assertions.assertTrue((boolean)timeline.containsInstant(new HoodieInstant(false, "commit", Integer.toString(i))), (String)String.format("Commit %d should not be archived", i));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchivalWithMaxDeltaCommitsGuaranteeForCompaction(boolean enableMetadata) throws Exception {
        List commitsAfterArchival;
        List originalCommits;
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList;
        int i;
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 8, 1, HoodieTableType.MERGE_ON_READ);
        for (i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            commitsList = this.archiveAndGetCommitsList(writeConfig);
            originalCommits = (List)commitsList.getKey();
            commitsAfterArchival = (List)commitsList.getValue();
            if (i <= 8) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            Assertions.assertEquals((int)1, (int)(originalCommits.size() - commitsAfterArchival.size()));
            Assertions.assertFalse((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "00000001")));
            IntStream.range(2, 10).forEach(j -> Assertions.assertTrue((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000000" + j))));
        }
        this.testTable.doCompaction("00000010", Arrays.asList("p1", "p2"));
        for (i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation("0000001" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            commitsList = this.archiveAndGetCommitsList(writeConfig);
            originalCommits = (List)commitsList.getKey();
            commitsAfterArchival = (List)commitsList.getValue();
            if (i <= 2) {
                IntStream.range(1, 8).forEach(j -> Assertions.assertFalse((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000000" + j))));
                Assertions.assertEquals((int)(i == 1 ? 6 : 0), (int)(originalCommits.size() - commitsAfterArchival.size()));
                Assertions.assertTrue((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "00000008")));
                Assertions.assertTrue((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "00000009")));
                Assertions.assertTrue((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "00000010")));
                for (int j2 = 1; j2 <= i; ++j2) {
                    Assertions.assertTrue((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000001" + j2)));
                }
                continue;
            }
            IntStream.range(1, 10).forEach(j -> Assertions.assertFalse((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000000" + j))));
            if (i == 3) {
                Assertions.assertEquals((int)2, (int)(originalCommits.size() - commitsAfterArchival.size()));
                continue;
            }
            if (i < 8) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            Assertions.assertEquals((int)1, (int)(originalCommits.size() - commitsAfterArchival.size()));
            Assertions.assertFalse((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "00000010")));
            if (i == 9) {
                Assertions.assertFalse((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "00000011")));
            }
            IntStream.range(i - 7, i + 1).forEach(j -> Assertions.assertTrue((boolean)commitsAfterArchival.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000001" + j))));
        }
    }

    @Test
    public void testGetCommitInstantsToArchiveDuringInflightCommits() throws Exception {
        String instantTime;
        int i;
        HoodieWriteConfig cfg = this.initTestTableAndGetWriteConfig(false, 3, 4, 2);
        HashSet<String> expectedInstants = new HashSet<String>();
        for (int i2 = 0; i2 < 3; ++i2) {
            String instantTime2 = "100" + i2;
            HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)instantTime2, (StorageConfiguration)this.storageConf);
            expectedInstants.add(instantTime2);
        }
        String replaceInstant = "1003";
        HoodieTestDataGenerator.createReplaceCommitRequestedFile((String)this.basePath, (String)replaceInstant, (StorageConfiguration)this.storageConf);
        expectedInstants.add(replaceInstant);
        for (i = 4; i < 7; ++i) {
            instantTime = "100" + i;
            HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)instantTime, (StorageConfiguration)this.storageConf);
            expectedInstants.add(instantTime);
        }
        HoodieTestDataGenerator.createRequestedCommitFile((String)this.basePath, (String)"1007", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createPendingCommitFile((String)this.basePath, (String)"1007", (StorageConfiguration)this.storageConf);
        expectedInstants.add("1007");
        for (i = 0; i < 6; ++i) {
            instantTime = "101" + i;
            HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)instantTime, (StorageConfiguration)this.storageConf);
            expectedInstants.add(instantTime);
        }
        HoodieDefaultTimeline timeline = this.metaClient.reloadActiveTimeline().getWriteTimeline();
        Assertions.assertEquals((int)expectedInstants.size(), (int)timeline.countInstants(), (String)"Loaded 14 commits and the count should match");
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(cfg, (HoodieTable)table);
        boolean result = archiver.archiveIfRequired((HoodieEngineContext)this.context);
        expectedInstants.remove("1000");
        expectedInstants.remove("1001");
        Assertions.assertTrue((boolean)result);
        timeline = this.metaClient.reloadActiveTimeline().getWriteTimeline();
        Assertions.assertEquals((int)12, (int)timeline.countInstants(), (String)"After archival only first 2 commits should be archived");
        Assertions.assertEquals((int)expectedInstants.size(), (int)timeline.countInstants(), (String)"After archival only first 2 commits should be archived");
        HoodieDefaultTimeline finalTimeline = timeline;
        Assertions.assertEquals((long)12L, (long)expectedInstants.stream().filter(arg_0 -> TestHoodieTimelineArchiver.lambda$testGetCommitInstantsToArchiveDuringInflightCommits$21((HoodieTimeline)finalTimeline, arg_0)).count());
        Assertions.assertEquals((Object)"1002", (Object)((HoodieInstant)timeline.getInstantsAsStream().findFirst().get()).getTimestamp());
        StoragePath replaceCommitRequestedPath = new StoragePath(this.basePath + "/" + ".hoodie" + "/" + HoodieTimeline.makeRequestedReplaceFileName((String)replaceInstant));
        this.metaClient.getStorage().deleteDirectory(replaceCommitRequestedPath);
        this.metaClient.reloadActiveTimeline();
        Assertions.assertTrue((boolean)archiver.archiveIfRequired((HoodieEngineContext)this.context));
        timeline = this.metaClient.reloadActiveTimeline().getWriteTimeline();
        expectedInstants.removeAll(Arrays.asList("1002", "1003", "1004", "1005"));
        Assertions.assertEquals((int)8, (int)timeline.countInstants(), (String)"After archival only first 2 commits should be archived");
        Assertions.assertEquals((int)expectedInstants.size(), (int)timeline.countInstants(), (String)"After archival only first 2 commits should be archived");
        HoodieDefaultTimeline refreshedTimeline = timeline;
        Assertions.assertEquals((long)8L, (long)expectedInstants.stream().filter(arg_0 -> TestHoodieTimelineArchiver.lambda$testGetCommitInstantsToArchiveDuringInflightCommits$22((HoodieTimeline)refreshedTimeline, arg_0)).count());
        Assertions.assertEquals((Object)"1006", (Object)((HoodieInstant)timeline.getInstantsAsStream().findFirst().get()).getTimestamp());
    }

    @Test
    public void testWithOldestReplaceCommit() throws Exception {
        HoodieWriteConfig cfg = this.initTestTableAndGetWriteConfig(false, 2, 3, 2);
        HoodieTestDataGenerator.createReplaceCommitRequestedFile((String)this.basePath, (String)"1001", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createReplaceCommitInflightFile((String)this.basePath, (String)"1001", (StorageConfiguration)this.storageConf);
        for (int i = 2; i < 10; ++i) {
            String instantTime = "100" + i;
            HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)instantTime, (StorageConfiguration)this.storageConf);
        }
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(cfg, (HoodieTable)table);
        HoodieActiveTimeline timeline = this.metaClient.reloadActiveTimeline();
        Assertions.assertEquals((int)9, (int)timeline.countInstants(), (String)"Loaded 9 commits and the count should match");
        boolean result = archiver.archiveIfRequired((HoodieEngineContext)this.context);
        Assertions.assertTrue((boolean)result);
        timeline = this.metaClient.reloadActiveTimeline();
        Assertions.assertEquals((int)9, (int)timeline.countInstants(), (String)"Since we have a pending replacecommit at 1001, we should never archive any commit after 1001");
        Assertions.assertEquals((Object)"1001", (Object)((HoodieInstant)timeline.getInstantsAsStream().findFirst().get()).getTimestamp());
    }

    @Test
    public void testArchivalAndCompactionInMetadataTable() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(4, 6).build()).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withMaxNumDeltaCommitsBeforeCompaction(8).build()).forTable("test-trip-table").build();
        this.initWriteConfigAndMetatableWriter(writeConfig, true);
        HoodieTableMetaClient metadataTableMetaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.metaClient.getStorageConf(), (String)HoodieTableMetadata.getMetadataTableBasePath((String)this.basePath));
        for (int i = 1; i <= 18; ++i) {
            if (i != 2) {
                this.testTable.doWriteOperation("000000" + String.format("%02d", i), WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            } else {
                this.testTable.doRollback("00000001", "00000002");
            }
            this.archiveAndGetCommitsList(writeConfig);
            metadataTableMetaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metadataTableMetaClient);
            List metadataTableInstants = metadataTableMetaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().getInstants();
            if (i == 1) {
                Assertions.assertEquals((int)(i + 1), (int)metadataTableInstants.size());
                Assertions.assertTrue((boolean)metadataTableInstants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "00000000000000010")));
                Assertions.assertTrue((boolean)metadataTableInstants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "00000001")));
                continue;
            }
            if (i <= 8) {
                Assertions.assertEquals((int)i, (int)metadataTableInstants.size());
                Assertions.assertTrue((boolean)metadataTableInstants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "00000000000000010")));
                IntStream.range(2, i).forEach(j -> Assertions.assertTrue((boolean)metadataTableInstants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000000" + j))));
                continue;
            }
            if (i == 9) {
                Assertions.assertEquals((int)9, (int)metadataTableInstants.size());
                IntStream.range(2, i).forEach(j -> Assertions.assertTrue((boolean)metadataTableInstants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000000" + j))));
                continue;
            }
            if (i <= 12) {
                Assertions.assertEquals((int)(i - 4), (int)metadataTableInstants.size());
                Assertions.assertTrue((boolean)metadataTableInstants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "00000008001")));
                IntStream.range(6, i).forEach(j -> Assertions.assertTrue((boolean)metadataTableInstants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "000000" + String.format("%02d", j)))));
                continue;
            }
            if (i <= 16) {
                Assertions.assertEquals((int)(i - 7), (int)metadataTableInstants.size());
                Assertions.assertTrue((boolean)metadataTableInstants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "00000008001")));
                IntStream.range(9, i).forEach(j -> Assertions.assertTrue((boolean)metadataTableInstants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "000000" + String.format("%02d", j)))));
                continue;
            }
            if (i == 17) {
                Assertions.assertEquals((int)10, (int)metadataTableInstants.size());
                Assertions.assertTrue((boolean)metadataTableInstants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "00000016001")));
                IntStream.range(9, i).forEach(j -> Assertions.assertTrue((boolean)metadataTableInstants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "000000" + String.format("%02d", j)))));
                continue;
            }
            Assertions.assertEquals((int)6, (int)metadataTableInstants.size());
            Assertions.assertTrue((boolean)metadataTableInstants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "00000016001")));
            IntStream.range(14, i).forEach(j -> Assertions.assertTrue((boolean)metadataTableInstants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "000000" + String.format("%02d", j)))));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPendingClusteringAfterArchiveCommit(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 2);
        HoodieTestDataGenerator.createPendingReplaceFile((String)this.basePath, (String)"00000002", (StorageConfiguration)this.storageConf);
        for (int i = 1; i < 8; ++i) {
            if (i != 2) {
                this.testTable.doWriteOperation("0000000" + i, WriteOperationType.CLUSTER, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 2);
            }
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        }
        HoodieTimeline timeline = this.metaClient.getActiveTimeline().reload().getCommitsTimeline().filterCompletedInstants();
        Assertions.assertEquals((int)6, (int)timeline.countInstants(), (String)"Since we have a pending clustering instant at 00000002, we should never archive any commit after 00000000");
    }

    private Pair<List<HoodieInstant>, List<HoodieInstant>> archiveAndGetCommitsList(HoodieWriteConfig writeConfig) throws IOException {
        return this.archiveAndGetCommitsList(writeConfig, false);
    }

    private Pair<List<HoodieInstant>, List<HoodieInstant>> archiveAndGetCommitsList(HoodieWriteConfig writeConfig, boolean includeIncompleteInstants) throws IOException {
        this.metaClient.reloadActiveTimeline();
        HoodieTimeline timeline = includeIncompleteInstants ? this.metaClient.getActiveTimeline().reload().getAllCommitsTimeline() : this.metaClient.getActiveTimeline().reload().getAllCommitsTimeline().filterCompletedInstants();
        List originalCommits = timeline.getInstants();
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(writeConfig, (HoodieTable)table);
        archiver.archiveIfRequired((HoodieEngineContext)this.context);
        timeline = includeIncompleteInstants ? this.metaClient.getActiveTimeline().reload().getAllCommitsTimeline() : this.metaClient.getActiveTimeline().reload().getAllCommitsTimeline().filterCompletedInstants();
        List commitsAfterArchival = timeline.getInstants();
        return Pair.of((Object)originalCommits, (Object)commitsAfterArchival);
    }

    private void verifyArchival(List<HoodieInstant> expectedArchivedInstants, List<HoodieInstant> expectedActiveInstants, List<HoodieInstant> commitsAfterArchival) {
        Collections.sort(expectedActiveInstants, Comparator.comparing(HoodieInstant::getTimestamp));
        Collections.sort(commitsAfterArchival, Comparator.comparing(HoodieInstant::getTimestamp));
        Assertions.assertEquals(expectedActiveInstants, commitsAfterArchival);
        expectedArchivedInstants.forEach(entry -> Assertions.assertFalse((boolean)commitsAfterArchival.contains(entry)));
        HoodieArchivedTimeline archivedTimeline = new HoodieArchivedTimeline(this.metaClient);
        List actualArchivedInstants = archivedTimeline.getInstants();
        Collections.sort(actualArchivedInstants, Comparator.comparing(HoodieInstant::getTimestamp));
        Collections.sort(expectedArchivedInstants, Comparator.comparing(HoodieInstant::getTimestamp));
        Assertions.assertEquals((Object)actualArchivedInstants, expectedArchivedInstants);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        expectedArchivedInstants.forEach(arg_0 -> TestHoodieTimelineArchiver.lambda$verifyArchival$30((HoodieTimeline)timeline, arg_0));
    }

    private List<HoodieInstant> getArchivedInstants(HoodieInstant instant) {
        ArrayList<HoodieInstant> instants = new ArrayList<HoodieInstant>();
        if (instant.getAction().equals("commit") || instant.getAction().equals("deltacommit") || instant.getAction().equals("clean") || instant.getAction().equals("rollback")) {
            instants.add(new HoodieInstant(HoodieInstant.State.REQUESTED, instant.getAction(), instant.getTimestamp()));
        }
        instants.add(new HoodieInstant(HoodieInstant.State.INFLIGHT, instant.getAction(), instant.getTimestamp()));
        instants.add(new HoodieInstant(HoodieInstant.State.COMPLETED, instant.getAction(), instant.getTimestamp()));
        return instants;
    }

    private List<HoodieInstant> getAllArchivedCommitInstants(List<String> commitTimes) {
        return this.getAllArchivedCommitInstants(commitTimes, "commit");
    }

    private List<HoodieInstant> getAllArchivedCommitInstants(List<String> commitTimes, String action) {
        ArrayList<HoodieInstant> allInstants = new ArrayList<HoodieInstant>();
        commitTimes.forEach(entry -> allInstants.addAll(this.getArchivedInstants(new HoodieInstant(HoodieInstant.State.COMPLETED, action, entry))));
        return allInstants;
    }

    private List<HoodieInstant> getActiveCommitInstants(List<String> commitTimes) {
        return this.getActiveCommitInstants(commitTimes, "commit");
    }

    private List<HoodieInstant> getActiveSavepointedCommitInstants(List<String> commitTimes) {
        return this.getActiveCommitInstants(commitTimes, "savepoint");
    }

    private List<HoodieInstant> getActiveCommitInstants(List<String> commitTimes, String action) {
        ArrayList<HoodieInstant> allInstants = new ArrayList<HoodieInstant>();
        commitTimes.forEach(entry -> allInstants.add(new HoodieInstant(HoodieInstant.State.COMPLETED, action, entry)));
        return allInstants;
    }

    private void createCommitAndRollbackFile(String commitToRollback, String rollbackTIme, boolean isRollbackInflight) throws IOException {
        this.createCommitAndRollbackFile(commitToRollback, rollbackTIme, isRollbackInflight, false);
    }

    private void createCommitAndRollbackFile(String commitToRollback, String rollbackTIme, boolean isRollbackInflight, boolean isEmpty) throws IOException {
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)commitToRollback, (StorageConfiguration)this.storageConf);
        this.createRollbackMetadata(rollbackTIme, commitToRollback, isRollbackInflight, isEmpty);
    }

    private HoodieInstant createRollbackMetadata(String rollbackTime, String commitToRollback, boolean inflight, boolean isEmpty) throws IOException {
        if (inflight) {
            HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addInflightRollback(rollbackTime);
        } else {
            HoodieRollbackMetadata hoodieRollbackMetadata = HoodieRollbackMetadata.newBuilder().setVersion(Integer.valueOf(1)).setStartRollbackTime(rollbackTime).setTotalFilesDeleted(1).setTimeTakenInMillis(1000L).setCommitsRollback(Collections.singletonList(commitToRollback)).setPartitionMetadata(Collections.emptyMap()).setInstantsRollback(Collections.emptyList()).build();
            HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addRollback(rollbackTime, hoodieRollbackMetadata, isEmpty, null);
            HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addRollbackCompleted(rollbackTime, hoodieRollbackMetadata, isEmpty);
        }
        return new HoodieInstant(inflight, "rollback", rollbackTime);
    }

    private void assertInstantListEquals(List<HoodieInstant> expected, List<HoodieInstant> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            HoodieInstant expectedInstant = expected.get(i);
            HoodieInstant actualInstant = actual.get(i);
            Assertions.assertEquals((Object)expectedInstant.getTimestamp(), (Object)actualInstant.getTimestamp());
            Assertions.assertEquals((Object)expectedInstant.getAction(), (Object)actualInstant.getAction());
            Assertions.assertEquals((Object)expectedInstant.getState(), (Object)actualInstant.getState());
        }
    }

    private static /* synthetic */ void lambda$verifyArchival$30(HoodieTimeline timeline, HoodieInstant entry) {
        if (!entry.getAction().equals("rollback")) {
            Assertions.assertTrue((boolean)timeline.containsOrBeforeTimelineStarts(entry.getTimestamp()), (String)"Archived commits should always be safe");
        }
    }

    private static /* synthetic */ boolean lambda$testGetCommitInstantsToArchiveDuringInflightCommits$22(HoodieTimeline refreshedTimeline, String instant) {
        return refreshedTimeline.containsInstant(instant);
    }

    private static /* synthetic */ boolean lambda$testGetCommitInstantsToArchiveDuringInflightCommits$21(HoodieTimeline finalTimeline, String instant) {
        return finalTimeline.containsInstant(instant);
    }
}

