/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FailSafeConsistencyGuard;
import org.apache.hudi.common.fs.OptimisticConsistencyGuard;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestConsistencyGuard
extends HoodieSparkClientTestHarness {
    private static final String BASE_FILE_EXTENSION = ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension();

    public static List<Arguments> consistencyGuardType() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{FailSafeConsistencyGuard.class.getName()}), Arguments.of((Object[])new Object[]{OptimisticConsistencyGuard.class.getName()}));
    }

    @BeforeEach
    public void setup() {
        this.initPath();
        this.initFileSystemWithDefaultConfiguration();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    @ParameterizedTest
    @MethodSource(value={"consistencyGuardType"})
    public void testCheckPassingAppearAndDisAppear(String consistencyGuardType) throws Exception {
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"partition/path", (String)"000", (String)"f1");
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"partition/path", (String)"000", (String)"f2");
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"partition/path", (String)"000", (String)"f3");
        ConsistencyGuardConfig config = this.getConsistencyGuardConfig(1, 1000, 1000);
        FailSafeConsistencyGuard passing = consistencyGuardType.equals(FailSafeConsistencyGuard.class.getName()) ? new FailSafeConsistencyGuard(this.storage, config) : new OptimisticConsistencyGuard(this.storage, config);
        passing.waitTillFileAppears(new StoragePath(this.basePath + "/partition/path/f1_1-0-1_000" + BASE_FILE_EXTENSION));
        passing.waitTillFileAppears(new StoragePath(this.basePath + "/partition/path/f2_1-0-1_000" + BASE_FILE_EXTENSION));
        passing.waitTillAllFilesAppear(this.basePath + "/partition/path", Arrays.asList(this.basePath + "/partition/path/f1_1-0-1_000" + BASE_FILE_EXTENSION, this.basePath + "/partition/path/f2_1-0-1_000" + BASE_FILE_EXTENSION));
        this.storage.deleteFile(new StoragePath(this.basePath + "/partition/path/f1_1-0-1_000" + BASE_FILE_EXTENSION));
        this.storage.deleteFile(new StoragePath(this.basePath + "/partition/path/f2_1-0-1_000" + BASE_FILE_EXTENSION));
        passing.waitTillFileDisappears(new StoragePath(this.basePath + "/partition/path/f1_1-0-1_000" + BASE_FILE_EXTENSION));
        passing.waitTillFileDisappears(new StoragePath(this.basePath + "/partition/path/f2_1-0-1_000" + BASE_FILE_EXTENSION));
        passing.waitTillAllFilesDisappear(this.basePath + "/partition/path", Arrays.asList(this.basePath + "/partition/path/f1_1-0-1_000" + BASE_FILE_EXTENSION, this.basePath + "/partition/path/f2_1-0-1_000" + BASE_FILE_EXTENSION));
    }

    @Test
    public void testCheckFailingAppearFailSafe() throws Exception {
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"partition/path", (String)"000", (String)"f1");
        FailSafeConsistencyGuard passing = new FailSafeConsistencyGuard(this.storage, this.getConsistencyGuardConfig());
        Assertions.assertThrows(TimeoutException.class, () -> this.lambda$testCheckFailingAppearFailSafe$0((ConsistencyGuard)passing));
    }

    @Test
    public void testCheckFailingAppearTimedWait() throws Exception {
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"partition/path", (String)"000", (String)"f1");
        OptimisticConsistencyGuard passing = new OptimisticConsistencyGuard(this.storage, this.getConsistencyGuardConfig());
        passing.waitTillAllFilesAppear(this.basePath + "/partition/path", Arrays.asList(this.basePath + "/partition/path/f1_1-0-2_000" + BASE_FILE_EXTENSION, this.basePath + "/partition/path/f2_1-0-2_000" + BASE_FILE_EXTENSION));
    }

    @Test
    public void testCheckFailingAppearsFailSafe() throws Exception {
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"partition/path", (String)"000", (String)"f1");
        FailSafeConsistencyGuard passing = new FailSafeConsistencyGuard(this.storage, this.getConsistencyGuardConfig());
        Assertions.assertThrows(TimeoutException.class, () -> this.lambda$testCheckFailingAppearsFailSafe$1((ConsistencyGuard)passing));
    }

    @Test
    public void testCheckFailingAppearsTimedWait() throws Exception {
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"partition/path", (String)"000", (String)"f1");
        OptimisticConsistencyGuard passing = new OptimisticConsistencyGuard(this.storage, this.getConsistencyGuardConfig());
        passing.waitTillFileAppears(new StoragePath(this.basePath + "/partition/path/f1_1-0-2_000" + BASE_FILE_EXTENSION));
    }

    @Test
    public void testCheckFailingDisappearFailSafe() throws Exception {
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"partition/path", (String)"000", (String)"f1");
        FailSafeConsistencyGuard passing = new FailSafeConsistencyGuard(this.storage, this.getConsistencyGuardConfig());
        Assertions.assertThrows(TimeoutException.class, () -> this.lambda$testCheckFailingDisappearFailSafe$2((ConsistencyGuard)passing));
    }

    @Test
    public void testCheckFailingDisappearTimedWait() throws Exception {
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"partition/path", (String)"000", (String)"f1");
        OptimisticConsistencyGuard passing = new OptimisticConsistencyGuard(this.storage, this.getConsistencyGuardConfig());
        passing.waitTillAllFilesDisappear(this.basePath + "/partition/path", Arrays.asList(this.basePath + "/partition/path/f1_1-0-1_000" + BASE_FILE_EXTENSION, this.basePath + "/partition/path/f2_1-0-2_000" + BASE_FILE_EXTENSION));
    }

    @Test
    public void testCheckFailingDisappearsFailSafe() throws Exception {
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"partition/path", (String)"000", (String)"f1");
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"partition/path", (String)"000", (String)"f1");
        FailSafeConsistencyGuard passing = new FailSafeConsistencyGuard(this.storage, this.getConsistencyGuardConfig());
        Assertions.assertThrows(TimeoutException.class, () -> this.lambda$testCheckFailingDisappearsFailSafe$3((ConsistencyGuard)passing));
    }

    @Test
    public void testCheckFailingDisappearsTimedWait() throws Exception {
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"partition/path", (String)"000", (String)"f1");
        FileCreateUtils.createBaseFile((String)this.basePath, (String)"partition/path", (String)"000", (String)"f1");
        OptimisticConsistencyGuard passing = new OptimisticConsistencyGuard(this.storage, this.getConsistencyGuardConfig());
        passing.waitTillFileDisappears(new StoragePath(this.basePath + "/partition/path/f1_1-0-1_000" + BASE_FILE_EXTENSION));
    }

    private ConsistencyGuardConfig getConsistencyGuardConfig() {
        return this.getConsistencyGuardConfig(3, 10, 10);
    }

    private ConsistencyGuardConfig getConsistencyGuardConfig(int maxChecks, int initialSleep, int maxSleep) {
        return ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).withInitialConsistencyCheckIntervalMs(initialSleep).withMaxConsistencyCheckIntervalMs(maxSleep).withMaxConsistencyChecks(maxChecks).build();
    }

    private /* synthetic */ void lambda$testCheckFailingDisappearsFailSafe$3(ConsistencyGuard passing) throws Throwable {
        passing.waitTillFileDisappears(new StoragePath(this.basePath + "/partition/path/f1_1-0-1_000" + BASE_FILE_EXTENSION));
    }

    private /* synthetic */ void lambda$testCheckFailingDisappearFailSafe$2(ConsistencyGuard passing) throws Throwable {
        passing.waitTillAllFilesDisappear(this.basePath + "/partition/path", Arrays.asList(this.basePath + "/partition/path/f1_1-0-1_000" + BASE_FILE_EXTENSION, this.basePath + "/partition/path/f2_1-0-2_000" + BASE_FILE_EXTENSION));
    }

    private /* synthetic */ void lambda$testCheckFailingAppearsFailSafe$1(ConsistencyGuard passing) throws Throwable {
        passing.waitTillFileAppears(new StoragePath(this.basePath + "/partition/path/f1_1-0-2_000" + BASE_FILE_EXTENSION));
    }

    private /* synthetic */ void lambda$testCheckFailingAppearFailSafe$0(ConsistencyGuard passing) throws Throwable {
        passing.waitTillAllFilesAppear(this.basePath + "/partition/path", Arrays.asList(this.basePath + "/partition/path/f1_1-0-2_000" + BASE_FILE_EXTENSION, this.basePath + "/partition/path/f2_1-0-2_000" + BASE_FILE_EXTENSION));
    }
}

