/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.validator.SqlQueryEqualityPreCommitValidator;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.testutils.CompactionTestUtils;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodiePreCommitValidatorConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.testutils.MetadataMergeWriteStatus;
import org.apache.hudi.utils.HoodieWriterClientTestHarness;

public class ClusteringTestUtils {
    protected static int timelineServicePort = (Integer)FileSystemViewStorageConfig.REMOTE_PORT_NUM.defaultValue();
    private static final String COUNT_SQL_QUERY_FOR_VALIDATION = "select count(*) from <TABLE_NAME>";

    public static HoodieWriteConfig getClusteringConfig(String basePath) {
        return ClusteringTestUtils.getClusteringConfig(basePath, "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    }

    public static HoodieWriteConfig getClusteringConfig(String basePath, String schemaStr) {
        return ClusteringTestUtils.getClusteringConfig(basePath, schemaStr, new Properties());
    }

    public static HoodieWriteConfig getClusteringConfig(String basePath, String schemaStr, Properties properties) {
        HoodieFailedWritesCleaningPolicy cleaningPolicy = HoodieFailedWritesCleaningPolicy.EAGER;
        HoodieIndex.IndexType indexType = HoodieIndex.IndexType.BLOOM;
        boolean populateMetaFields = true;
        HoodieClusteringConfig clusteringConfig = HoodieClusteringConfig.newBuilder().withClusteringMaxNumGroups(10).withClusteringSortColumns(populateMetaFields ? "_hoodie_record_key" : "_row_key").withClusteringTargetPartitions(0).withInlineClusteringNumCommits(0).withInlineClustering(Boolean.valueOf(false)).build();
        properties.putAll((Map<?, ?>)HoodieWriterClientTestHarness.getPropertiesForKeyGen());
        return HoodieWriteConfig.newBuilder().withPath(basePath).withSchema(schemaStr).withParallelism(2, 2).withBulkInsertParallelism(2).withFinalizeWriteParallelism(2).withDeleteParallelism(2).withTimelineLayoutVersion(TimelineLayoutVersion.CURR_VERSION.intValue()).withWriteStatusClass(MetadataMergeWriteStatus.class).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x100000L).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(cleaningPolicy).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x100000L).parquetMaxFileSize(0x100000L).orcMaxFileSize(0x100000L).build()).forTable("test-trip-table").withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(indexType).build()).withEmbeddedTimelineServerEnabled(true).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withEnableBackupForRemoteFileSystemView(false).withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withClusteringConfig(clusteringConfig).withPreCommitValidatorConfig(HoodiePreCommitValidatorConfig.newBuilder().withPreCommitValidator(SqlQueryEqualityPreCommitValidator.class.getName()).withPrecommitValidatorEqualitySqlQueries(COUNT_SQL_QUERY_FOR_VALIDATION).build()).withProps((Map)properties).build();
    }

    public static String runClustering(SparkRDDWriteClient clusteringClient, boolean skipExecution, boolean shouldCommit) {
        String clusteringCommitTime = HoodieActiveTimeline.createNewInstantTime();
        return ClusteringTestUtils.runClusteringOnInstant(clusteringClient, skipExecution, shouldCommit, clusteringCommitTime);
    }

    public static String runClusteringOnInstant(SparkRDDWriteClient clusteringClient, boolean skipExecution, boolean shouldCommit, String clusteringCommitTime) {
        clusteringClient.scheduleClusteringAtInstant(clusteringCommitTime, Option.empty());
        if (!skipExecution) {
            clusteringClient.cluster(clusteringCommitTime, shouldCommit);
        }
        return clusteringCommitTime;
    }

    public static HoodieClusteringPlan createClusteringPlan(HoodieTableMetaClient metaClient, String instantTime, String fileId) {
        try {
            String basePath = metaClient.getBasePath();
            String partition = HoodieTestUtils.DEFAULT_PARTITION_PATHS[0];
            FileCreateUtils.createBaseFile((String)basePath, (String)partition, (String)instantTime, (String)fileId, (long)1L);
            FileSlice slice = new FileSlice(partition, instantTime, fileId);
            slice.setBaseFile((HoodieBaseFile)new CompactionTestUtils.DummyHoodieBaseFile(Paths.get(basePath, partition, FileCreateUtils.baseFileName((String)instantTime, (String)fileId)).toString()));
            List[] fileSliceGroups = new List[]{Collections.singletonList(slice)};
            HoodieClusteringPlan clusteringPlan = ClusteringUtils.createClusteringPlan((String)"strategy", new HashMap(), (List[])fileSliceGroups, Collections.emptyMap());
            return clusteringPlan;
        }
        catch (Exception e) {
            throw new HoodieException(e.getMessage(), (Throwable)e);
        }
    }
}

