/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.commit.AverageRecordSizeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class TestAverageRecordSizeUtils {
    private final HoodieTimeline mockTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
    private static final String PARTITION1 = "partition1";
    private static final String TEST_WRITE_TOKEN = "1-0-1";

    @ParameterizedTest
    @MethodSource(value={"testCases"})
    public void testAverageRecordSize(List<Pair<HoodieInstant, List<HWriteStat>>> instantSizePairs, long expectedSize) {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").build();
        HoodieDefaultTimeline commitsTimeline = new HoodieDefaultTimeline();
        ArrayList instants = new ArrayList();
        instantSizePairs.forEach(entry -> {
            HoodieInstant hoodieInstant = (HoodieInstant)entry.getKey();
            HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
            ((List)entry.getValue()).forEach(hWriteStat -> {
                HoodieWriteStat writeStat = new HoodieWriteStat();
                writeStat.setNumWrites(hWriteStat.getTotalRecordsWritten().longValue());
                writeStat.setTotalWriteBytes(hWriteStat.getPerRecordSize() * hWriteStat.getTotalRecordsWritten());
                writeStat.setPath(hWriteStat.getPath());
                commitMetadata.addWriteStat(PARTITION1, writeStat);
            });
            instants.add(hoodieInstant);
            try {
                Mockito.when((Object)this.mockTimeline.getInstantDetails(hoodieInstant)).thenReturn((Object)Option.of((Object)StringUtils.getUTF8Bytes((String)commitMetadata.toJsonString())));
            }
            catch (IOException e) {
                throw new RuntimeException("Should not have failed", e);
            }
        });
        ArrayList reverseOrderInstants = new ArrayList(instants);
        Collections.reverse(reverseOrderInstants);
        Mockito.when((Object)this.mockTimeline.getInstants()).thenReturn(instants);
        Mockito.when((Object)this.mockTimeline.getReverseOrderedInstants()).then(i -> reverseOrderInstants.stream());
        commitsTimeline.setInstants(instants);
        Assertions.assertEquals((long)expectedSize, (long)AverageRecordSizeUtils.averageBytesPerRecord((HoodieTimeline)this.mockTimeline, (HoodieWriteConfig)writeConfig));
    }

    @Test
    public void testErrorHandling() {
        int recordSize = 10000;
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withProps(Collections.singletonMap(HoodieCompactionConfig.COPY_ON_WRITE_RECORD_SIZE_ESTIMATE.key(), String.valueOf(recordSize))).build(false);
        HoodieDefaultTimeline commitsTimeline = new HoodieDefaultTimeline();
        List<HoodieInstant> instants = Collections.singletonList(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "1"));
        Mockito.when((Object)this.mockTimeline.getInstants()).thenReturn(instants);
        Mockito.when((Object)this.mockTimeline.getReverseOrderedInstants()).then(i -> instants.stream());
        commitsTimeline.setInstants(new ArrayList());
        Assertions.assertEquals((long)recordSize, (long)AverageRecordSizeUtils.averageBytesPerRecord((HoodieTimeline)this.mockTimeline, (HoodieWriteConfig)writeConfig));
    }

    private static String getBaseFileName(String instantTime) {
        String fileName = UUID.randomUUID().toString();
        return FSUtils.makeBaseFileName((String)instantTime, (String)TEST_WRITE_TOKEN, (String)fileName, (String)HoodieFileFormat.PARQUET.getFileExtension());
    }

    private static String getLogFileName(String instantTime) {
        String fileName = UUID.randomUUID().toString();
        String fullFileName = FSUtils.makeBaseFileName((String)instantTime, (String)TEST_WRITE_TOKEN, (String)fileName, (String)HoodieFileFormat.PARQUET.getFileExtension());
        Assertions.assertEquals((Object)instantTime, (Object)FSUtils.getCommitTime((String)fullFileName));
        return FSUtils.makeLogFileName((String)fileName, (String)HoodieFileFormat.HOODIE_LOG.getFileExtension(), (String)instantTime, (int)1, (String)TEST_WRITE_TOKEN);
    }

    static Stream<Arguments> testCases() {
        Long baseInstant = 20231204194919610L;
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", Long.toString(baseInstant)), Collections.singletonList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant)), 10000000L, 100L)))), 100L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", Long.toString(baseInstant)), Collections.singletonList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant)), 10000000L, 100L))), Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", Long.toString(baseInstant + 100L)), Collections.singletonList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant + 100L)), 10000000L, 200L)))), 200L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", Long.toString(baseInstant)), Collections.singletonList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant)), 10000000L, 100L))), Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", Long.toString(baseInstant + 100L)), Collections.singletonList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant + 100L)), 10000L, 200L)))), 100L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", Long.toString(baseInstant)), Collections.singletonList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant)), 10000000L, 100L))), Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", Long.toString(baseInstant + 100L)), Collections.singletonList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant + 100L)), 10000000L, 200L)))), 200L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", Long.toString(baseInstant)), Collections.singletonList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant)), 10000000L, 100L))), Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", Long.toString(baseInstant + 100L)), Collections.singletonList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant + 100L)), 10000000L, 200L)))), 200L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", Long.toString(baseInstant)), Collections.singletonList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant)), 1000000L, 100L))), Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", Long.toString(baseInstant + 100L)), Arrays.asList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant + 100L)), 10000000L, 200L), new HWriteStat(TestAverageRecordSizeUtils.getLogFileName(String.valueOf(baseInstant + 100L)), 10000000L, 300L)))), 200L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", Long.toString(baseInstant)), Collections.singletonList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant)), 10000000L, 100L))), Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", Long.toString(baseInstant + 100L)), Arrays.asList(new HWriteStat(TestAverageRecordSizeUtils.getLogFileName(String.valueOf(baseInstant + 100L)), 1000000L, 200L), new HWriteStat(TestAverageRecordSizeUtils.getLogFileName(String.valueOf(baseInstant + 100L)), 10000000L, 300L)))), 100L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", Long.toString(baseInstant)), Collections.singletonList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant)), 1000000L, 100L))), Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", Long.toString(baseInstant + 100L)), Arrays.asList(new HWriteStat(TestAverageRecordSizeUtils.getLogFileName(String.valueOf(baseInstant + 100L)), 1000000L, 200L), new HWriteStat(TestAverageRecordSizeUtils.getLogFileName(String.valueOf(baseInstant + 100L)), 1000000L, 300L))), Pair.of((Object)new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", Long.toString(baseInstant)), Collections.singletonList(new HWriteStat(TestAverageRecordSizeUtils.getBaseFileName(String.valueOf(baseInstant + 200L)), 1000000L, 400L)))), 400L}));
        return arguments.stream();
    }

    static class HWriteStat {
        private final String path;
        private final Long totalRecordsWritten;
        private final Long perRecordSize;

        public HWriteStat(String path, Long totalRecordsWritten, Long perRecordSize) {
            this.path = path;
            this.totalRecordsWritten = totalRecordsWritten;
            this.perRecordSize = perRecordSize;
        }

        public String getPath() {
            return this.path;
        }

        public Long getTotalRecordsWritten() {
            return this.totalRecordsWritten;
        }

        public Long getPerRecordSize() {
            return this.perRecordSize;
        }
    }
}

