/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import com.codahale.metrics.Counter;
import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieMemoryConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.SparkHoodieBloomIndexHelper;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieCompactor
extends HoodieSparkClientTestHarness {
    private HoodieTableMetaClient metaClient;

    @BeforeEach
    public void setUp() throws Exception {
        this.initSparkContexts();
        this.initPath();
        this.storage = HoodieStorageUtils.getStorage((String)this.basePath, (StorageConfiguration)this.storageConf);
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        this.initTestDataGenerator();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    public HoodieWriteConfig getConfig() {
        return this.getConfigBuilder().withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).build()).withMetricsConfig(TestHoodieCompactor.getMetricsConfig()).build();
    }

    private static HoodieMetricsConfig getMetricsConfig() {
        return HoodieMetricsConfig.newBuilder().on(true).withReporterType("INMEMORY").build();
    }

    private long getCompactionMetricCount(String metric) {
        HoodieMetrics metrics = this.writeClient.getMetrics();
        String metricName = metrics.getMetricsName("counter", metric);
        SortedMap counters = metrics.getMetrics().getRegistry().getCounters();
        return counters.containsKey(metricName) ? ((Counter)counters.get(metricName)).getCount() : 0L;
    }

    public HoodieWriteConfig.Builder getConfigBuilder() {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x100000L).withInlineCompaction(Boolean.valueOf(false)).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x100000L).parquetMaxFileSize(0x100000L).orcMaxFileSize(0x100000L).build()).withMemoryConfig(HoodieMemoryConfig.newBuilder().withMaxDFSStreamBufferSize(0x100000).build()).forTable("test-trip-table").withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build());
    }

    @Test
    public void testCompactionOnCopyOnWriteFail() throws Exception {
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE);
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(this.getConfig());){
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
            String compactionInstantTime = HoodieActiveTimeline.createNewInstantTime();
            Assertions.assertThrows(HoodieNotSupportedException.class, () -> this.lambda$testCompactionOnCopyOnWriteFail$0((HoodieTable)table, compactionInstantTime));
            Assertions.assertEquals((long)0L, (long)this.getCompactionMetricCount(HoodieTimeline.REQUESTED_COMPACTION_SUFFIX));
            Assertions.assertEquals((long)0L, (long)this.getCompactionMetricCount(HoodieTimeline.COMPLETED_COMPACTION_SUFFIX));
        }
    }

    @Test
    public void testCompactionEmpty() {
        HoodieWriteConfig config = this.getConfig();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            String newCommitTime = writeClient.startCommit();
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(100));
            JavaRDD recordsRDD = this.jsc.parallelize(records, 1);
            writeClient.insert(recordsRDD, newCommitTime).collect();
            String compactionInstantTime = HoodieActiveTimeline.createNewInstantTime();
            Option plan = table.scheduleCompaction((HoodieEngineContext)this.context, compactionInstantTime, Option.empty());
            Assertions.assertFalse((boolean)plan.isPresent(), (String)"If there is nothing to compact, result will be empty");
            Assertions.assertEquals((long)0L, (long)this.getCompactionMetricCount(HoodieTimeline.REQUESTED_COMPACTION_SUFFIX));
            Assertions.assertEquals((long)0L, (long)this.getCompactionMetricCount(HoodieTimeline.COMPLETED_COMPACTION_SUFFIX));
        }
    }

    @Test
    public void testScheduleCompactionWithInflightInstant() {
        HoodieWriteConfig config = this.getConfig();
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            String newCommitTime = "100";
            writeClient.startCommitWithTime(newCommitTime);
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(100));
            JavaRDD recordsRDD = this.jsc.parallelize(records, 1);
            writeClient.insert(recordsRDD, newCommitTime).collect();
            newCommitTime = "102";
            writeClient.startCommitWithTime(newCommitTime);
            this.metaClient.getActiveTimeline().transitionRequestedToInflight(new HoodieInstant(HoodieInstant.State.REQUESTED, "deltacommit", newCommitTime), Option.empty());
            String compactionTime = "101";
            writeClient.scheduleCompactionAtInstant(compactionTime, Option.empty());
        }
    }

    @Test
    public void testWriteStatusContentsAfterCompaction() throws Exception {
        HoodieWriteConfig config = this.getConfigBuilder().withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).build()).withMetricsConfig(TestHoodieCompactor.getMetricsConfig()).build();
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            int i;
            String newCommitTime = "100";
            writeClient.startCommitWithTime(newCommitTime);
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(1000));
            JavaRDD recordsRDD = this.jsc.parallelize(records, 1);
            writeClient.insert(recordsRDD, newCommitTime).collect();
            for (i = 1; i < 5; ++i) {
                newCommitTime = String.format("10%s", i);
                this.updateRecords(config, newCommitTime, records);
                this.assertLogFilesNumEqualsTo(config, i);
            }
            HoodieData<WriteStatus> result = this.compact(writeClient, String.format("10%s", i));
            this.verifyCompaction(result);
            Assertions.assertEquals((long)1L, (long)this.getCompactionMetricCount(HoodieTimeline.REQUESTED_COMPACTION_SUFFIX));
            Assertions.assertEquals((long)1L, (long)this.getCompactionMetricCount(HoodieTimeline.COMPLETED_COMPACTION_SUFFIX));
        }
    }

    @Test
    public void testSpillingWhenCompaction() throws Exception {
        HoodieWriteConfig config = this.getConfigBuilder().withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).build()).withMemoryConfig(HoodieMemoryConfig.newBuilder().withMaxMemoryMaxSize(1L, 1L).build()).withMetricsConfig(TestHoodieCompactor.getMetricsConfig()).build();
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            String newCommitTime = "100";
            writeClient.startCommitWithTime(newCommitTime);
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(100));
            JavaRDD recordsRDD = this.jsc.parallelize(records, 1);
            writeClient.insert(recordsRDD, newCommitTime).collect();
            for (int i = 1; i < 5; i += 2) {
                newCommitTime = "10" + i;
                this.updateRecords(config, newCommitTime, records);
                this.assertLogFilesNumEqualsTo(config, 1);
                HoodieData<WriteStatus> result = this.compact(writeClient, "10" + (i + 1));
                this.verifyCompaction(result);
                Assertions.assertEquals((long)(i / 2 + 1), (long)this.getCompactionMetricCount(HoodieTimeline.REQUESTED_COMPACTION_SUFFIX));
                Assertions.assertEquals((long)(i / 2 + 1), (long)this.getCompactionMetricCount(HoodieTimeline.COMPLETED_COMPACTION_SUFFIX));
            }
        }
    }

    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }

    private void updateRecords(HoodieWriteConfig config, String newCommitTime, List<HoodieRecord> records) throws IOException {
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context);
        List updatedRecords = this.dataGen.generateUpdates(newCommitTime, records);
        JavaRDD updatedRecordsRDD = this.jsc.parallelize(updatedRecords, 1);
        HoodieBloomIndex index = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
        JavaRDD<HoodieRecord> updatedTaggedRecordsRDD = this.tagLocation((HoodieIndex)index, (JavaRDD<HoodieRecord>)updatedRecordsRDD, (HoodieTable)table);
        this.writeClient.startCommitWithTime(newCommitTime);
        this.writeClient.upsertPreppedRecords(updatedTaggedRecordsRDD, newCommitTime).collect();
        this.metaClient.reloadActiveTimeline();
    }

    private void assertLogFilesNumEqualsTo(HoodieWriteConfig config, int expected) {
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context);
        for (String partitionPath : this.dataGen.getPartitionPaths()) {
            List groupedLogFiles = table.getSliceView().getLatestFileSlices(partitionPath).collect(Collectors.toList());
            for (FileSlice fileSlice : groupedLogFiles) {
                Assertions.assertEquals((long)expected, (long)fileSlice.getLogFiles().count(), (String)("There should be " + expected + " log file written for every data file"));
            }
        }
    }

    private HoodieData<WriteStatus> compact(SparkRDDWriteClient writeClient, String compactionInstantTime) {
        writeClient.scheduleCompactionAtInstant(compactionInstantTime, Option.empty());
        JavaRDD writeStatusJavaRDD = (JavaRDD)writeClient.compact(compactionInstantTime).getWriteStatuses();
        return HoodieListData.eager((List)writeStatusJavaRDD.collect());
    }

    private void verifyCompaction(HoodieData<WriteStatus> result) {
        List writeStatuses = result.collectAsList();
        for (String partitionPath : this.dataGen.getPartitionPaths()) {
            Assertions.assertTrue((boolean)writeStatuses.stream().anyMatch(writeStatus -> writeStatus.getStat().getPartitionPath().contentEquals(partitionPath)));
        }
        writeStatuses.forEach(writeStatus -> {
            HoodieWriteStat.RuntimeStats stats = writeStatus.getStat().getRuntimeStats();
            Assertions.assertNotNull((Object)stats);
            Assertions.assertEquals((long)stats.getTotalCreateTime(), (long)0L);
            Assertions.assertTrue((stats.getTotalUpsertTime() > 0L ? 1 : 0) != 0);
            Assertions.assertTrue((stats.getTotalScanTime() > 0L ? 1 : 0) != 0);
        });
    }

    private /* synthetic */ void lambda$testCompactionOnCopyOnWriteFail$0(HoodieTable table, String compactionInstantTime) throws Throwable {
        table.scheduleCompaction((HoodieEngineContext)this.context, compactionInstantTime, Option.empty());
        table.compact((HoodieEngineContext)this.context, compactionInstantTime);
    }
}

