/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.compact.strategy.BoundedIOCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.BoundedPartitionAwareCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.DayBasedCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.LogFileNumBasedCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.LogFileSizeBasedCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.UnBoundedCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.UnBoundedPartitionAwareCompactionStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieCompactionStrategy {
    private static final long MB = 0x100000L;
    private static final Random RANDOM = new Random();
    private String[] partitionPaths = new String[]{"2017/01/01", "2017/01/02", "2017/01/03"};

    @Test
    public void testUnBounded() {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5A00000L, Collections.singletonList(0x40000000L));
        UnBoundedCompactionStrategy strategy = new UnBoundedCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy((CompactionStrategy)strategy).build()).build();
        List<HoodieCompactionOperation> operations = this.createCompactionOperations(writeConfig, sizesMap);
        List returned = strategy.orderAndFilter(writeConfig, operations, new ArrayList());
        Assertions.assertEquals(operations, (Object)returned, (String)"UnBounded should not re-order or filter");
    }

    @Test
    public void testBoundedIOSimple() {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5A00000L, Collections.singletonList(0x40000000L));
        BoundedIOCompactionStrategy strategy = new BoundedIOCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy((CompactionStrategy)strategy).withTargetIOPerCompactionInMB(400L).build()).build();
        List<HoodieCompactionOperation> operations = this.createCompactionOperations(writeConfig, sizesMap);
        List returned = strategy.orderAndFilter(writeConfig, operations, new ArrayList());
        Assertions.assertTrue((returned.size() < operations.size() ? 1 : 0) != 0, (String)"BoundedIOCompaction should have resulted in fewer compactions");
        Assertions.assertEquals((int)2, (int)returned.size(), (String)"BoundedIOCompaction should have resulted in 2 compactions being chosen");
        Long returnedSize = returned.stream().map(s -> (Double)s.getMetrics().get("TOTAL_IO_MB")).map(Double::longValue).reduce(Long::sum).orElse(0L);
        Assertions.assertEquals((long)610L, (long)returnedSize, (String)"Should chose the first 2 compactions which should result in a total IO of 610 MB");
    }

    @Test
    public void testLogFileSizeCompactionSimple() {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5A00000L, Collections.singletonList(0x40000000L));
        LogFileSizeBasedCompactionStrategy strategy = new LogFileSizeBasedCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy((CompactionStrategy)strategy).withTargetIOPerCompactionInMB(1205L).withLogFileSizeThresholdBasedCompaction(0x6400000L).build()).build();
        List<HoodieCompactionOperation> operations = this.createCompactionOperations(writeConfig, sizesMap);
        List returned = strategy.orderAndFilter(writeConfig, operations, new ArrayList());
        Assertions.assertTrue((returned.size() < operations.size() ? 1 : 0) != 0, (String)"LogFileSizeBasedCompactionStrategy should have resulted in fewer compactions");
        Assertions.assertEquals((int)2, (int)returned.size(), (String)"LogFileSizeBasedCompactionStrategy should have resulted in 2 compaction");
        Long returnedSize = returned.stream().map(s -> (Double)s.getMetrics().get("TOTAL_IO_MB")).map(Double::longValue).reduce(Long::sum).orElse(0L);
        Assertions.assertEquals((long)1594L, (long)returnedSize, (String)"Should chose the first 2 compactions which should result in a total IO of 1594 MB");
    }

    @Test
    public void testDayBasedCompactionSimple() {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5A00000L, Collections.singletonList(0x40000000L));
        Map<Long, String> keyToPartitionMap = Collections.unmodifiableMap(new HashMap<Long, String>(){
            {
                this.put(0x7800000L, TestHoodieCompactionStrategy.this.partitionPaths[2]);
                this.put(0x6E00000L, TestHoodieCompactionStrategy.this.partitionPaths[2]);
                this.put(0x6400000L, TestHoodieCompactionStrategy.this.partitionPaths[1]);
                this.put(0x5A00000L, TestHoodieCompactionStrategy.this.partitionPaths[0]);
            }
        });
        DayBasedCompactionStrategy strategy = new DayBasedCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy((CompactionStrategy)strategy).withTargetPartitionsPerDayBasedCompaction(1).build()).build();
        List<HoodieCompactionOperation> operations = this.createCompactionOperations(writeConfig, sizesMap, keyToPartitionMap);
        List returned = strategy.orderAndFilter(writeConfig, operations, new ArrayList());
        Assertions.assertTrue((returned.size() < operations.size() ? 1 : 0) != 0, (String)"DayBasedCompactionStrategy should have resulted in fewer compactions");
        Assertions.assertEquals((int)2, (int)returned.size(), (String)"DayBasedCompactionStrategy should have resulted in fewer compactions");
        int comparison = strategy.getComparator().compare(((HoodieCompactionOperation)returned.get(returned.size() - 1)).getPartitionPath(), ((HoodieCompactionOperation)returned.get(0)).getPartitionPath());
        Assertions.assertTrue((comparison >= 0 ? 1 : 0) != 0, (String)"DayBasedCompactionStrategy should sort partitions in descending order");
    }

    @Test
    public void testBoundedPartitionAwareCompactionSimple() {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x4600000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5000000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5A00000L, Collections.singletonList(0x40000000L));
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        Date today = new Date();
        final String currentDay = format.format(today);
        final String currentDayMinus1 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)-1));
        final String currentDayMinus2 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)-2));
        final String currentDayMinus3 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)-3));
        final String currentDayPlus1 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)1));
        final String currentDayPlus5 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)5));
        Map<Long, String> keyToPartitionMap = Collections.unmodifiableMap(new HashMap<Long, String>(){
            {
                this.put(0x7800000L, currentDay);
                this.put(0x6E00000L, currentDayMinus1);
                this.put(0x6400000L, currentDayMinus2);
                this.put(0x5000000L, currentDayMinus3);
                this.put(0x5A00000L, currentDayPlus1);
                this.put(0x4600000L, currentDayPlus5);
            }
        });
        BoundedPartitionAwareCompactionStrategy strategy = new BoundedPartitionAwareCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy((CompactionStrategy)strategy).withTargetPartitionsPerDayBasedCompaction(2).build()).build();
        List<HoodieCompactionOperation> operations = this.createCompactionOperations(writeConfig, sizesMap, keyToPartitionMap);
        List returned = strategy.orderAndFilter(writeConfig, operations, new ArrayList());
        Assertions.assertTrue((returned.size() < operations.size() ? 1 : 0) != 0, (String)"BoundedPartitionAwareCompactionStrategy should have resulted in fewer compactions");
        Assertions.assertEquals((int)5, (int)returned.size(), (String)"BoundedPartitionAwareCompactionStrategy should have resulted in fewer compactions");
        int comparison = strategy.getComparator().compare(((HoodieCompactionOperation)returned.get(returned.size() - 1)).getPartitionPath(), ((HoodieCompactionOperation)returned.get(0)).getPartitionPath());
        Assertions.assertTrue((comparison >= 0 ? 1 : 0) != 0, (String)"BoundedPartitionAwareCompactionStrategy should sort partitions in descending order");
    }

    @Test
    public void testUnboundedPartitionAwareCompactionSimple() {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5000000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x4600000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5A00000L, Collections.singletonList(0x40000000L));
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        Date today = new Date();
        final String currentDay = format.format(today);
        final String currentDayMinus1 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)-1));
        final String currentDayMinus2 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)-2));
        final String currentDayMinus3 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)-3));
        final String currentDayPlus1 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)1));
        final String currentDayPlus5 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)5));
        Map<Long, String> keyToPartitionMap = Collections.unmodifiableMap(new HashMap<Long, String>(){
            {
                this.put(0x7800000L, currentDay);
                this.put(0x6E00000L, currentDayMinus1);
                this.put(0x6400000L, currentDayMinus2);
                this.put(0x5000000L, currentDayMinus3);
                this.put(0x5A00000L, currentDayPlus1);
                this.put(0x4600000L, currentDayPlus5);
            }
        });
        UnBoundedPartitionAwareCompactionStrategy strategy = new UnBoundedPartitionAwareCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy((CompactionStrategy)strategy).withTargetPartitionsPerDayBasedCompaction(2).build()).build();
        List<HoodieCompactionOperation> operations = this.createCompactionOperations(writeConfig, sizesMap, keyToPartitionMap);
        List returned = strategy.orderAndFilter(writeConfig, operations, new ArrayList());
        Assertions.assertTrue((returned.size() < operations.size() ? 1 : 0) != 0, (String)("UnBoundedPartitionAwareCompactionStrategy should not include last " + writeConfig.getTargetPartitionsPerDayBasedCompaction() + " partitions or later partitions from today"));
        Assertions.assertEquals((int)1, (int)returned.size(), (String)"BoundedPartitionAwareCompactionStrategy should have resulted in 1 compaction");
    }

    @Test
    public void testLogFileLengthBasedCompactionStrategy() {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x80000000L));
        sizesMap.put(0x5A00000L, Arrays.asList(0x20000000L, 0x20000000L));
        LogFileNumBasedCompactionStrategy strategy = new LogFileNumBasedCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy((CompactionStrategy)strategy).withTargetIOPerCompactionInMB(1024L).withCompactionLogFileNumThreshold(2).build()).build();
        List<HoodieCompactionOperation> operations = this.createCompactionOperations(writeConfig, sizesMap);
        List returned = strategy.orderAndFilter(writeConfig, operations, new ArrayList());
        Assertions.assertTrue((returned.size() < operations.size() ? 1 : 0) != 0, (String)"LogFileLengthBasedCompactionStrategy should have resulted in fewer compactions");
        Assertions.assertEquals((int)2, (int)returned.size(), (String)"LogFileLengthBasedCompactionStrategy should have resulted in 2 compaction");
        Integer allFileLength = returned.stream().map(s -> s.getDeltaFilePaths().size()).reduce(Integer::sum).orElse(0);
        Assertions.assertEquals((int)5, (Integer)allFileLength);
        Assertions.assertEquals((int)3, (int)((HoodieCompactionOperation)returned.get(0)).getDeltaFilePaths().size());
        Assertions.assertEquals((int)2, (int)((HoodieCompactionOperation)returned.get(1)).getDeltaFilePaths().size());
        Long returnedSize = returned.stream().map(s -> (Double)s.getMetrics().get("TOTAL_IO_MB")).map(Double::longValue).reduce(Long::sum).orElse(0L);
        Assertions.assertEquals((long)1594L, (long)returnedSize, (String)"Should chose the first 2 compactions which should result in a total IO of 1594 MB");
    }

    private List<HoodieCompactionOperation> createCompactionOperations(HoodieWriteConfig config, Map<Long, List<Long>> sizesMap) {
        Map<Long, String> keyToPartitionMap = sizesMap.keySet().stream().map(e -> Pair.of((Object)e, (Object)this.partitionPaths[RANDOM.nextInt(this.partitionPaths.length - 1)])).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        return this.createCompactionOperations(config, sizesMap, keyToPartitionMap);
    }

    private List<HoodieCompactionOperation> createCompactionOperations(HoodieWriteConfig config, Map<Long, List<Long>> sizesMap, Map<Long, String> keyToPartitionMap) {
        ArrayList<HoodieCompactionOperation> operations = new ArrayList<HoodieCompactionOperation>(sizesMap.size());
        sizesMap.forEach((k, v) -> {
            HoodieBaseFile df = TestHoodieBaseFile.newDataFile(k);
            String partitionPath = (String)keyToPartitionMap.get(k);
            List logFiles = v.stream().map(TestHoodieLogFile::newLogFile).collect(Collectors.toList());
            FileSlice slice = new FileSlice(new HoodieFileGroupId(partitionPath, df.getFileId()), df.getCommitTime());
            slice.setBaseFile(df);
            logFiles.stream().forEach(f -> slice.addLogFile(f));
            operations.add(new HoodieCompactionOperation(df.getCommitTime(), logFiles.stream().map(s -> s.getPath().toString()).collect(Collectors.toList()), df.getPath(), df.getFileId(), partitionPath, config.getCompactionStrategy().captureMetrics(config, slice), (String)df.getBootstrapBaseFile().map(BaseFile::getPath).orElse(null)));
        });
        return operations;
    }

    public static class TestHoodieLogFile
    extends HoodieLogFile {
        private static int version = 0;
        private final long size;

        public TestHoodieLogFile(long size) {
            super("/tmp/.ce481ee7-9e53-4a2e-999-f9e295fa79c0_20180919184844.log." + version++);
            this.size = size;
        }

        public static HoodieLogFile newLogFile(long size) {
            return new TestHoodieLogFile(size);
        }

        public long getFileSize() {
            return this.size;
        }
    }

    public static class TestHoodieBaseFile
    extends HoodieBaseFile {
        private final long size;

        public TestHoodieBaseFile(long size) {
            super("/tmp/XYXYXYXYXYYX_11_20180918020003" + ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
            this.size = size;
        }

        public static HoodieBaseFile newDataFile(long size) {
            return new TestHoodieBaseFile(size);
        }

        public String getPath() {
            return "/tmp/test";
        }

        public String getFileId() {
            return UUID.randomUUID().toString();
        }

        public String getCommitTime() {
            return "100";
        }

        public long getFileSize() {
            return this.size;
        }
    }
}

