/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieRollbackPartitionMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.ClusteringTestUtils;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.action.rollback.CopyOnWriteRollbackActionExecutor;
import org.apache.hudi.table.action.rollback.HoodieClientRollbackTestBase;
import org.apache.hudi.table.action.rollback.ListingBasedRollbackStrategy;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.utils.HoodieWriterClientTestHarness;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestCopyOnWriteRollbackActionExecutor
extends HoodieClientRollbackTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.initPath();
        this.initSparkContexts();
        this.initHoodieStorage();
        this.initMetaClient();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    @Test
    public void testCopyOnWriteRollbackActionExecutorForFileListingAsGenerateFile() throws Exception {
        String p1 = "2015/03/16";
        String p2 = "2015/03/17";
        String p3 = "2016/03/15";
        HoodieTestTable testTable = (HoodieTestTable)((HoodieTestTable)((HoodieTestTable)((HoodieTestTable)((HoodieTestTable)HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).withPartitionMetaFiles(new String[]{"2015/03/16", "2015/03/17", "2016/03/15"}).addCommit("001").withBaseFilesInPartition("2015/03/16", new String[]{"id11"}).getLeft()).withBaseFilesInPartition("2015/03/17", new String[]{"id12"}).getLeft()).withLogFile("2015/03/16", "id11", new int[]{3}).getLeft()).addCommit("002").withBaseFilesInPartition("2015/03/16", new String[]{"id21"}).getLeft()).withBaseFilesInPartition("2015/03/17", new String[]{"id22"}).getLeft();
        HoodieWriteConfig writeConfig = this.getConfigBuilder().withRollbackUsingMarkers(false).withEmbeddedTimelineServerEnabled(false).build();
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, writeConfig);
        HoodieInstant needRollBackInstant = new HoodieInstant(false, "commit", "002");
        String rollbackInstant = "003";
        BaseRollbackPlanActionExecutor copyOnWriteRollbackPlanActionExecutor = new BaseRollbackPlanActionExecutor((HoodieEngineContext)this.context, table.getConfig(), (HoodieTable)table, rollbackInstant, needRollBackInstant, false, table.getConfig().shouldRollbackUsingMarkers(), false);
        HoodieRollbackPlan rollbackPlan = (HoodieRollbackPlan)copyOnWriteRollbackPlanActionExecutor.execute().get();
        CopyOnWriteRollbackActionExecutor copyOnWriteRollbackActionExecutor = new CopyOnWriteRollbackActionExecutor((HoodieEngineContext)this.context, table.getConfig(), (HoodieTable)table, "003", needRollBackInstant, true, false);
        List hoodieRollbackStats = copyOnWriteRollbackActionExecutor.executeRollback(rollbackPlan);
        org.junit.jupiter.api.Assertions.assertEquals((int)hoodieRollbackStats.size(), (int)2);
        block10: for (HoodieRollbackStat stat : hoodieRollbackStats) {
            switch (stat.getPartitionPath()) {
                case "2015/03/16": {
                    org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)stat.getSuccessDeleteFiles().size());
                    org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)stat.getFailedDeleteFiles().size());
                    org.junit.jupiter.api.Assertions.assertEquals((Object)Collections.EMPTY_MAP, (Object)stat.getCommandBlocksCount());
                    org.junit.jupiter.api.Assertions.assertEquals((Object)testTable.forCommit("002").getBaseFilePath("2015/03/16", "id21").toString(), (Object)(this.storage.getScheme() + ":" + (String)stat.getSuccessDeleteFiles().get(0)));
                    continue block10;
                }
                case "2015/03/17": {
                    org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)stat.getSuccessDeleteFiles().size());
                    org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)stat.getFailedDeleteFiles().size());
                    org.junit.jupiter.api.Assertions.assertEquals((Object)Collections.EMPTY_MAP, (Object)stat.getCommandBlocksCount());
                    org.junit.jupiter.api.Assertions.assertEquals((Object)testTable.forCommit("002").getBaseFilePath("2015/03/17", "id22").toString(), (Object)(this.storage.getScheme() + ":" + (String)stat.getSuccessDeleteFiles().get(0)));
                    continue block10;
                }
                case "2016/03/15": {
                    org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)stat.getSuccessDeleteFiles().size());
                    org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)stat.getFailedDeleteFiles().size());
                    org.junit.jupiter.api.Assertions.assertEquals((Object)Collections.EMPTY_MAP, (Object)stat.getCommandBlocksCount());
                    continue block10;
                }
            }
            org.junit.jupiter.api.Assertions.fail((String)("Unexpected partition: " + stat.getPartitionPath()));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.inflightCommitExists("001"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.commitExists("001"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists("2015/03/16", "001", "id11"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists("2015/03/17", "001", "id12"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.inflightCommitExists("002"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.commitExists("002"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFileExists("2015/03/16", "002", "id21"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFileExists("2015/03/17", "002", "id22"));
    }

    @Test
    public void testListBasedRollbackStrategy() throws Exception {
        this.dataGen = new HoodieTestDataGenerator(new String[]{"2016/03/15", "2015/03/16", "2015/03/17"});
        HoodieWriteConfig cfg = this.getConfigBuilder().withRollbackUsingMarkers(false).build();
        HoodieTestDataGenerator.writePartitionMetadataDeprecated((HoodieStorage)this.storage, (String[])new String[]{"2016/03/15", "2015/03/16"}, (String)this.basePath);
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        String newCommitTime = "001";
        client.startCommitWithTime(newCommitTime);
        List records = this.dataGen.generateInsertsContainsAllPartitions(newCommitTime, Integer.valueOf(3));
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        JavaRDD statuses = client.upsert(writeRecords, newCommitTime);
        Assertions.assertNoWriteErrors((List)statuses.collect());
        newCommitTime = "002";
        client.startCommitWithTime(newCommitTime);
        records = this.dataGen.generateUpdates(newCommitTime, records);
        statuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime);
        Assertions.assertNoWriteErrors((List)statuses.collect());
        this.context = new HoodieSparkEngineContext(this.jsc);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, cfg);
        HoodieInstant needRollBackInstant = new HoodieInstant(false, "commit", "002");
        String rollbackInstant = "003";
        ListingBasedRollbackStrategy rollbackStrategy = new ListingBasedRollbackStrategy((HoodieTable)table, (HoodieEngineContext)this.context, table.getConfig(), rollbackInstant, false);
        List rollBackRequests = rollbackStrategy.getRollbackRequests(needRollBackInstant);
        rollBackRequests.forEach(entry -> System.out.println(" " + entry.getPartitionPath() + ", " + entry.getFileId() + " " + Arrays.toString(entry.getFilesToBeDeleted().toArray())));
        HoodieRollbackRequest rollbackRequest = rollBackRequests.stream().filter(entry -> entry.getPartitionPath().equals("2016/03/15")).findFirst().get();
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        MockitoAnnotations.initMocks((Object)((Object)this));
        System.out.println("Fs.exists() call for " + ((String)rollbackRequest.getFilesToBeDeleted().get(0)).toString());
        Mockito.when((Object)fs.exists((Path)ArgumentMatchers.any())).thenThrow(new Throwable[]{new IOException("Failing exists call for " + (String)rollbackRequest.getFilesToBeDeleted().get(0))});
        rollbackStrategy = new ListingBasedRollbackStrategy((HoodieTable)table, (HoodieEngineContext)this.context, cfg, rollbackInstant, false);
        List rollBackRequestsUpdated = rollbackStrategy.getRollbackRequests(needRollBackInstant);
        rollBackRequestsUpdated.forEach(entry -> System.out.println(" " + entry.getPartitionPath() + ", " + entry.getFileId() + " " + Arrays.toString(entry.getFilesToBeDeleted().toArray())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)rollBackRequests, (Object)rollBackRequestsUpdated);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCopyOnWriteRollbackWithReplaceCommits(boolean isUsingMarkers) throws IOException {
        ArrayList<FileSlice> firstPartitionCommit2FileSlices = new ArrayList<FileSlice>();
        ArrayList<FileSlice> secondPartitionCommit2FileSlices = new ArrayList<FileSlice>();
        HoodieWriteConfig cfg = this.getConfigBuilder().withRollbackUsingMarkers(isUsingMarkers).withAutoCommit(false).build();
        this.insertOverwriteCommitDataWithTwoPartitions(firstPartitionCommit2FileSlices, secondPartitionCommit2FileSlices, cfg, !isUsingMarkers);
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, cfg);
        this.performRollbackAndValidate(isUsingMarkers, cfg, (HoodieTable)table, firstPartitionCommit2FileSlices, secondPartitionCommit2FileSlices);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCopyOnWriteRollbackActionExecutor(boolean isUsingMarkers) throws IOException {
        ArrayList<FileSlice> firstPartitionCommit2FileSlices = new ArrayList<FileSlice>();
        ArrayList<FileSlice> secondPartitionCommit2FileSlices = new ArrayList<FileSlice>();
        HoodieWriteConfig cfg = this.getConfigBuilder().withRollbackUsingMarkers(isUsingMarkers).withAutoCommit(false).build();
        this.twoUpsertCommitDataWithTwoPartitions(firstPartitionCommit2FileSlices, secondPartitionCommit2FileSlices, cfg, !isUsingMarkers);
        this.metaClient.reloadActiveTimeline();
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, cfg);
        this.performRollbackAndValidate(isUsingMarkers, cfg, (HoodieTable)table, firstPartitionCommit2FileSlices, secondPartitionCommit2FileSlices);
    }

    @Test
    public void testRollbackScale() throws Exception {
        String p1 = "2015/03/16";
        String p2 = "2015/03/17";
        String p3 = "2016/03/15";
        int largeCommitNumFiles = 10000;
        int[] fileLengths = IntStream.range(10, 10010).toArray();
        HoodieTestTable testTable = ((HoodieTestTable)((HoodieTestTable)((HoodieTestTable)((HoodieTestTable)((HoodieTestTable)HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).withPartitionMetaFiles(new String[]{"2015/03/16", "2015/03/17", "2016/03/15"}).addCommit("001").withBaseFilesInPartition("2015/03/16", new String[]{"id11"}).getLeft()).withBaseFilesInPartition("2015/03/17", new String[]{"id12"}).getLeft()).withLogFile("2015/03/16", "id11", new int[]{3}).getLeft()).addCommit("002").withBaseFilesInPartition("2015/03/16", new String[]{"id21"}).getLeft()).withBaseFilesInPartition("2015/03/17", new String[]{"id22"}).getLeft()).addCommit("003").withBaseFilesInPartition("2016/03/15", fileLengths);
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, this.getConfigBuilder().withRollbackUsingMarkers(false).withEmbeddedTimelineServerEnabled(false).build());
        HoodieInstant needRollBackInstant = new HoodieInstant(false, "commit", "003");
        BaseRollbackPlanActionExecutor copyOnWriteRollbackPlanActionExecutor = new BaseRollbackPlanActionExecutor((HoodieEngineContext)this.context, table.getConfig(), (HoodieTable)table, "003", needRollBackInstant, false, table.getConfig().shouldRollbackUsingMarkers(), false);
        HoodieRollbackPlan hoodieRollbackPlan = (HoodieRollbackPlan)copyOnWriteRollbackPlanActionExecutor.execute().get();
        CopyOnWriteRollbackActionExecutor copyOnWriteRollbackActionExecutor = new CopyOnWriteRollbackActionExecutor((HoodieEngineContext)this.context, table.getConfig(), (HoodieTable)table, "003", needRollBackInstant, true, true);
        copyOnWriteRollbackActionExecutor.doRollbackAndGetStats(hoodieRollbackPlan);
        org.junit.jupiter.api.Assertions.assertEquals((int)10000, (int)hoodieRollbackPlan.getRollbackRequests().stream().mapToInt(r -> r.getFilesToBeDeleted().size()).sum());
        org.junit.jupiter.api.Assertions.assertEquals((long)10000L, (long)hoodieRollbackPlan.getRollbackRequests().stream().filter(r -> !r.getFilesToBeDeleted().isEmpty()).count());
    }

    private void performRollbackAndValidate(boolean isUsingMarkers, HoodieWriteConfig cfg, HoodieTable table, List<FileSlice> firstPartitionCommit2FileSlices, List<FileSlice> secondPartitionCommit2FileSlices) throws IOException {
        HoodieInstant commitInstant = isUsingMarkers ? (HoodieInstant)table.getActiveTimeline().getCommitAndReplaceTimeline().filterInflights().lastInstant().get() : (HoodieInstant)table.getCompletedCommitTimeline().lastInstant().get();
        BaseRollbackPlanActionExecutor copyOnWriteRollbackPlanActionExecutor = new BaseRollbackPlanActionExecutor((HoodieEngineContext)this.context, table.getConfig(), table, "003", commitInstant, false, table.getConfig().shouldRollbackUsingMarkers(), false);
        HoodieRollbackPlan hoodieRollbackPlan = (HoodieRollbackPlan)copyOnWriteRollbackPlanActionExecutor.execute().get();
        CopyOnWriteRollbackActionExecutor copyOnWriteRollbackActionExecutor = new CopyOnWriteRollbackActionExecutor((HoodieEngineContext)this.context, cfg, table, "003", commitInstant, false, false);
        Map rollbackMetadata = copyOnWriteRollbackActionExecutor.execute().getPartitionMetadata();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)rollbackMetadata.size());
        for (Map.Entry entry : rollbackMetadata.entrySet()) {
            HoodieRollbackPartitionMetadata meta = (HoodieRollbackPartitionMetadata)entry.getValue();
            org.junit.jupiter.api.Assertions.assertTrue((meta.getFailedDeleteFiles() == null || meta.getFailedDeleteFiles().size() == 0 ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertTrue((meta.getSuccessDeleteFiles() == null || meta.getSuccessDeleteFiles().size() == 1 ? 1 : 0) != 0);
        }
        List firstPartitionRollBack1FileGroups = table.getFileSystemView().getAllFileGroups("2016/03/15").collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstPartitionRollBack1FileGroups.size());
        List firstPartitionRollBack1FileSlices = ((HoodieFileGroup)firstPartitionRollBack1FileGroups.get(0)).getAllFileSlices().collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstPartitionRollBack1FileSlices.size());
        firstPartitionCommit2FileSlices.removeAll(firstPartitionRollBack1FileSlices);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstPartitionCommit2FileSlices.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)((HoodieBaseFile)firstPartitionCommit2FileSlices.get(0).getBaseFile().get()).getPath(), (Object)(this.storage.getScheme() + ":" + (String)((HoodieRollbackPartitionMetadata)rollbackMetadata.get("2016/03/15")).getSuccessDeleteFiles().get(0)));
        List secondPartitionRollBack1FileGroups = table.getFileSystemView().getAllFileGroups("2015/03/16").collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)secondPartitionRollBack1FileGroups.size());
        List secondPartitionRollBack1FileSlices = ((HoodieFileGroup)secondPartitionRollBack1FileGroups.get(0)).getAllFileSlices().collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)secondPartitionRollBack1FileSlices.size());
        secondPartitionCommit2FileSlices.removeAll(secondPartitionRollBack1FileSlices);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)secondPartitionCommit2FileSlices.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)((HoodieBaseFile)secondPartitionCommit2FileSlices.get(0).getBaseFile().get()).getPath(), (Object)(this.storage.getScheme() + ":" + (String)((HoodieRollbackPartitionMetadata)rollbackMetadata.get("2015/03/16")).getSuccessDeleteFiles().get(0)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)WriteMarkersFactory.get((MarkerType)cfg.getMarkersType(), (HoodieTable)table, (String)commitInstant.getTimestamp()).doesMarkerDirExist());
    }

    @Test
    public void testRollbackBackup() throws Exception {
        String p1 = "2015/03/16";
        String p2 = "2015/03/17";
        String p3 = "2016/03/15";
        HoodieTestTable testTable = (HoodieTestTable)((HoodieTestTable)((HoodieTestTable)((HoodieTestTable)((HoodieTestTable)HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).withPartitionMetaFiles(new String[]{"2015/03/16", "2015/03/17", "2016/03/15"}).addCommit("001").withBaseFilesInPartition("2015/03/16", new String[]{"id11"}).getLeft()).withBaseFilesInPartition("2015/03/17", new String[]{"id12"}).getLeft()).withLogFile("2015/03/16", "id11", new int[]{3}).getLeft()).addCommit("002").withBaseFilesInPartition("2015/03/16", new String[]{"id21"}).getLeft()).withBaseFilesInPartition("2015/03/17", new String[]{"id22"}).getLeft();
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, this.getConfigBuilder().withRollbackBackupEnabled(true).withEmbeddedTimelineServerEnabled(false).build());
        HoodieInstant needRollBackInstant = new HoodieInstant(false, "commit", "002");
        BaseRollbackPlanActionExecutor copyOnWriteRollbackPlanActionExecutor = new BaseRollbackPlanActionExecutor((HoodieEngineContext)this.context, table.getConfig(), (HoodieTable)table, "003", needRollBackInstant, false, table.getConfig().shouldRollbackUsingMarkers(), false);
        copyOnWriteRollbackPlanActionExecutor.execute();
        CopyOnWriteRollbackActionExecutor copyOnWriteRollbackActionExecutor = new CopyOnWriteRollbackActionExecutor((HoodieEngineContext)this.context, table.getConfig(), (HoodieTable)table, "003", needRollBackInstant, true, false);
        copyOnWriteRollbackActionExecutor.execute();
        StoragePath backupDir = new StoragePath(this.metaClient.getMetaPath(), table.getConfig().getRollbackBackupDirectory());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.exists(new StoragePath(backupDir, testTable.getCommitFilePath("002").getName())));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.exists(new StoragePath(backupDir, testTable.getInflightCommitFilePath("002").getName())));
    }

    @Test
    public void testRollbackForMultiwriter() throws Exception {
        String p1 = "2015/03/16";
        String p2 = "2015/03/17";
        String p3 = "2016/03/15";
        HoodieTestTable testTable = ((HoodieTestTable)((HoodieTestTable)((HoodieTestTable)((HoodieTestTable)((HoodieTestTable)((HoodieTestTable)HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).withPartitionMetaFiles(new String[]{"2015/03/16", "2015/03/17", "2016/03/15"}).addCommit("001").withBaseFilesInPartition("2015/03/16", new String[]{"id11"}).getLeft()).withBaseFilesInPartition("2015/03/17", new String[]{"id12"}).getLeft()).withLogFile("2015/03/16", "id11", new int[]{3}).getLeft()).addCommit("002").withBaseFilesInPartition("2015/03/16", new String[]{"id21"}).getLeft()).withBaseFilesInPartition("2015/03/17", new String[]{"id22"}).getLeft()).addInflightCommit("003").withBaseFilesInPartition("2015/03/16", new String[]{"id31"}).getLeft()).addCommit("004");
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, this.getConfigBuilder().build());
        HoodieInstant needRollBackInstant = new HoodieInstant(true, "commit", "003");
        CopyOnWriteRollbackActionExecutor copyOnWriteRollbackActionExecutor = new CopyOnWriteRollbackActionExecutor((HoodieEngineContext)this.context, table.getConfig(), (HoodieTable)table, "003", needRollBackInstant, true, true);
        org.junit.jupiter.api.Assertions.assertThrows(HoodieRollbackException.class, () -> copyOnWriteRollbackActionExecutor.execute());
    }

    @Test
    public void testRollbackWhenReplaceCommitIsPresent() throws Exception {
        HoodieWriteConfig writeConfig = this.getConfigBuilder().withAutoCommit(false).withEmbeddedTimelineServerEnabled(false).build();
        SparkRDDWriteClient writeClient = this.getHoodieWriteClient(writeConfig);
        int numRecords = 200;
        String firstCommit = HoodieActiveTimeline.createNewInstantTime();
        String partitionStr = "2016/03/15";
        this.dataGen = new HoodieTestDataGenerator(new String[]{partitionStr});
        this.writeBatch(writeClient, firstCommit, "000", (Option<List<String>>)Option.of(Arrays.asList("000")), "000", numRecords, (HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer>)((HoodieWriterClientTestHarness.Function2)(arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1)), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::insert), true, numRecords, numRecords, 1, true);
        String secondCommit = HoodieActiveTimeline.createNewInstantTime();
        this.writeBatch(writeClient, secondCommit, firstCommit, (Option<List<String>>)Option.of(Arrays.asList(firstCommit)), "000", 100, (HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer>)((HoodieWriterClientTestHarness.Function2)(arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1)), (HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::insert), true, 100, 300, 2, true);
        Properties properties = new Properties();
        properties.put("hoodie.datasource.write.row.writer.enable", String.valueOf(false));
        SparkRDDWriteClient clusteringClient = this.getHoodieWriteClient(ClusteringTestUtils.getClusteringConfig(this.basePath, "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", properties));
        String clusteringInstant1 = HoodieActiveTimeline.createNewInstantTime();
        ClusteringTestUtils.runClustering(clusteringClient, false, true);
        ClusteringTestUtils.runClusteringOnInstant(clusteringClient, false, false, clusteringInstant1);
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, this.getConfigBuilder().withEmbeddedTimelineServerEnabled(false).build());
        HoodieInstant needRollBackInstant = new HoodieInstant(false, "commit", secondCommit);
        String rollbackInstant = HoodieActiveTimeline.createNewInstantTime();
        BaseRollbackPlanActionExecutor copyOnWriteRollbackPlanActionExecutor = new BaseRollbackPlanActionExecutor((HoodieEngineContext)this.context, table.getConfig(), (HoodieTable)table, rollbackInstant, needRollBackInstant, false, !table.getConfig().shouldRollbackUsingMarkers(), false);
        copyOnWriteRollbackPlanActionExecutor.execute().get();
        CopyOnWriteRollbackActionExecutor copyOnWriteRollbackActionExecutor = new CopyOnWriteRollbackActionExecutor((HoodieEngineContext)this.context, table.getConfig(), (HoodieTable)table, rollbackInstant, needRollBackInstant, true, false, true);
        org.junit.jupiter.api.Assertions.assertThrows(HoodieRollbackException.class, () -> ((CopyOnWriteRollbackActionExecutor)copyOnWriteRollbackActionExecutor).execute());
        needRollBackInstant = new HoodieInstant(true, "replacecommit", clusteringInstant1);
        rollbackInstant = HoodieActiveTimeline.createNewInstantTime();
        copyOnWriteRollbackPlanActionExecutor = new BaseRollbackPlanActionExecutor((HoodieEngineContext)this.context, table.getConfig(), (HoodieTable)table, rollbackInstant, needRollBackInstant, false, table.getConfig().shouldRollbackUsingMarkers(), false);
        HoodieRollbackPlan rollbackPlan = (HoodieRollbackPlan)copyOnWriteRollbackPlanActionExecutor.execute().get();
        CopyOnWriteRollbackActionExecutor copyOnWriteRollbackActionExecutorForClustering = new CopyOnWriteRollbackActionExecutor((HoodieEngineContext)this.context, table.getConfig(), (HoodieTable)table, rollbackInstant, needRollBackInstant, true, false, true);
        copyOnWriteRollbackActionExecutorForClustering.execute();
    }
}

