/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieRollbackPartitionMetadata;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.action.rollback.HoodieClientRollbackTestBase;
import org.apache.hudi.table.action.rollback.MergeOnReadRollbackActionExecutor;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.MetadataMergeWriteStatus;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestMergeOnReadRollbackActionExecutor
extends HoodieClientRollbackTestBase {
    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.initPath();
        this.initSparkContexts();
        this.dataGen = new HoodieTestDataGenerator(new String[]{"2016/03/15", "2015/03/16"});
        this.initHoodieStorage();
        this.initMetaClient();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testMergeOnReadRollbackActionExecutor(boolean isUsingMarkers) throws IOException {
        ArrayList<FileSlice> firstPartitionCommit2FileSlices = new ArrayList<FileSlice>();
        ArrayList<FileSlice> secondPartitionCommit2FileSlices = new ArrayList<FileSlice>();
        HoodieWriteConfig cfg = this.getConfigBuilder().withRollbackUsingMarkers(isUsingMarkers).withAutoCommit(false).build();
        this.twoUpsertCommitDataWithTwoPartitions(firstPartitionCommit2FileSlices, secondPartitionCommit2FileSlices, cfg, !isUsingMarkers);
        ArrayList firstPartitionCommit2LogFiles = new ArrayList();
        ArrayList secondPartitionCommit2LogFiles = new ArrayList();
        ((FileSlice)firstPartitionCommit2FileSlices.get(0)).getLogFiles().collect(Collectors.toList()).forEach(logFile -> firstPartitionCommit2LogFiles.add(logFile));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstPartitionCommit2LogFiles.size());
        ((FileSlice)secondPartitionCommit2FileSlices.get(0)).getLogFiles().collect(Collectors.toList()).forEach(logFile -> secondPartitionCommit2LogFiles.add(logFile));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)secondPartitionCommit2LogFiles.size());
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, cfg);
        HoodieInstant rollBackInstant = new HoodieInstant(isUsingMarkers, "deltacommit", "002");
        BaseRollbackPlanActionExecutor mergeOnReadRollbackPlanActionExecutor = new BaseRollbackPlanActionExecutor((HoodieEngineContext)this.context, cfg, (HoodieTable)table, "003", rollBackInstant, false, cfg.shouldRollbackUsingMarkers(), false);
        mergeOnReadRollbackPlanActionExecutor.execute().get();
        MergeOnReadRollbackActionExecutor mergeOnReadRollbackActionExecutor = new MergeOnReadRollbackActionExecutor((HoodieEngineContext)this.context, cfg, (HoodieTable)table, "003", rollBackInstant, true, false);
        Map rollbackMetadata = mergeOnReadRollbackActionExecutor.execute().getPartitionMetadata();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)rollbackMetadata.size());
        for (Map.Entry entry : rollbackMetadata.entrySet()) {
            HoodieRollbackPartitionMetadata meta = (HoodieRollbackPartitionMetadata)entry.getValue();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)meta.getFailedDeleteFiles().size());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)meta.getSuccessDeleteFiles().size());
        }
        List firstPartitionRollBack1FileGroups = table.getFileSystemView().getAllFileGroups("2016/03/15").collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstPartitionRollBack1FileGroups.size());
        List firstPartitionRollBack1FileSlices = ((HoodieFileGroup)firstPartitionRollBack1FileGroups.get(0)).getAllFileSlices().collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstPartitionRollBack1FileSlices.size());
        FileSlice firstPartitionRollBack1FileSlice = (FileSlice)firstPartitionRollBack1FileSlices.get(0);
        List firstPartitionRollBackLogFiles = firstPartitionRollBack1FileSlice.getLogFiles().collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)firstPartitionRollBackLogFiles.size());
        firstPartitionRollBackLogFiles.removeAll(firstPartitionCommit2LogFiles);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstPartitionRollBackLogFiles.size());
        List secondPartitionRollBack1FileGroups = table.getFileSystemView().getAllFileGroups("2015/03/16").collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)secondPartitionRollBack1FileGroups.size());
        List secondPartitionRollBack1FileSlices = ((HoodieFileGroup)secondPartitionRollBack1FileGroups.get(0)).getAllFileSlices().collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)secondPartitionRollBack1FileSlices.size());
        FileSlice secondPartitionRollBack1FileSlice = (FileSlice)secondPartitionRollBack1FileSlices.get(0);
        List secondPartitionRollBackLogFiles = secondPartitionRollBack1FileSlice.getLogFiles().collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)secondPartitionRollBackLogFiles.size());
        secondPartitionRollBackLogFiles.removeAll(secondPartitionCommit2LogFiles);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)secondPartitionRollBackLogFiles.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)WriteMarkersFactory.get((MarkerType)cfg.getMarkersType(), (HoodieTable)table, (String)"002").doesMarkerDirExist());
    }

    @Test
    public void testMergeOnReadRestoreCompactionCommit() throws IOException {
        boolean isUsingMarkers = false;
        HoodieWriteConfig cfg = this.getConfigBuilder().withRollbackUsingMarkers(isUsingMarkers).withAutoCommit(false).build();
        HoodieTestDataGenerator dataGenPartition3 = new HoodieTestDataGenerator(new String[]{"2015/03/17"});
        HoodieTestDataGenerator.writePartitionMetadataDeprecated((HoodieStorage)this.storage, (String[])new String[]{"2015/03/17"}, (String)this.basePath);
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        String newCommitTime = "0000001";
        client.startCommitWithTime(newCommitTime);
        List records = dataGenPartition3.generateInsertsContainsAllPartitions(newCommitTime, Integer.valueOf(2));
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        JavaRDD statuses = client.upsert(writeRecords, newCommitTime);
        Assertions.assertNoWriteErrors((List)statuses.collect());
        client.commit(newCommitTime, (Object)statuses);
        ArrayList<FileSlice> firstPartitionCommit2FileSlices = new ArrayList<FileSlice>();
        ArrayList<FileSlice> secondPartitionCommit2FileSlices = new ArrayList<FileSlice>();
        this.twoUpsertCommitDataWithTwoPartitions(firstPartitionCommit2FileSlices, secondPartitionCommit2FileSlices, cfg, !isUsingMarkers);
        ArrayList firstPartitionCommit2LogFiles = new ArrayList();
        ArrayList secondPartitionCommit2LogFiles = new ArrayList();
        ((FileSlice)firstPartitionCommit2FileSlices.get(0)).getLogFiles().collect(Collectors.toList()).forEach(logFile -> firstPartitionCommit2LogFiles.add(logFile));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstPartitionCommit2LogFiles.size());
        ((FileSlice)secondPartitionCommit2FileSlices.get(0)).getLogFiles().collect(Collectors.toList()).forEach(logFile -> secondPartitionCommit2LogFiles.add(logFile));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)secondPartitionCommit2LogFiles.size());
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, cfg);
        HoodieInstant rollBackInstant = new HoodieInstant(isUsingMarkers, "deltacommit", "002");
        BaseRollbackPlanActionExecutor mergeOnReadRollbackPlanActionExecutor = new BaseRollbackPlanActionExecutor((HoodieEngineContext)this.context, cfg, (HoodieTable)table, "003", rollBackInstant, false, cfg.shouldRollbackUsingMarkers(), true);
        mergeOnReadRollbackPlanActionExecutor.execute().get();
        MergeOnReadRollbackActionExecutor mergeOnReadRollbackActionExecutor = new MergeOnReadRollbackActionExecutor((HoodieEngineContext)this.context, cfg, (HoodieTable)table, "003", rollBackInstant, true, false);
        Map rollbackMetadata = mergeOnReadRollbackActionExecutor.execute().getPartitionMetadata();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)rollbackMetadata.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)WriteMarkersFactory.get((MarkerType)cfg.getMarkersType(), (HoodieTable)table, (String)"002").doesMarkerDirExist());
        HoodieInstant rollBackInstant1 = new HoodieInstant(isUsingMarkers, "deltacommit", "001");
        BaseRollbackPlanActionExecutor mergeOnReadRollbackPlanActionExecutor1 = new BaseRollbackPlanActionExecutor((HoodieEngineContext)this.context, cfg, (HoodieTable)table, "004", rollBackInstant1, false, cfg.shouldRollbackUsingMarkers(), true);
        mergeOnReadRollbackPlanActionExecutor1.execute().get();
        MergeOnReadRollbackActionExecutor mergeOnReadRollbackActionExecutor1 = new MergeOnReadRollbackActionExecutor((HoodieEngineContext)this.context, cfg, (HoodieTable)table, "004", rollBackInstant1, true, false);
        mergeOnReadRollbackActionExecutor1.execute().getPartitionMetadata();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)table.getFileSystemView().getAllFileGroups("2016/03/15").count());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)table.getFileSystemView().getAllFileGroups("2015/03/16").count());
        org.junit.jupiter.api.Assertions.assertTrue((table.getFileSystemView().getAllFileGroups("2015/03/17").count() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testRollbackForCanIndexLogFile() throws IOException {
        this.dataGen = new HoodieTestDataGenerator(new String[]{"2016/03/15"});
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withBulkInsertParallelism(2).withFinalizeWriteParallelism(2).withDeleteParallelism(2).withTimelineLayoutVersion(TimelineLayoutVersion.CURR_VERSION.intValue()).withWriteStatusClass(MetadataMergeWriteStatus.class).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x100000L).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x100000L).parquetMaxFileSize(0x100000L).build()).forTable("test-trip-table").withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withEmbeddedTimelineServerEnabled(true).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withEnableBackupForRemoteFileSystemView(false).build()).withRollbackUsingMarkers(false).withAutoCommit(false).build();
        new HoodieTestDataGenerator().writePartitionMetadata(this.storage, new String[]{"2016/03/15"}, this.basePath);
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        String newCommitTime = "001";
        client.startCommitWithTime(newCommitTime);
        List records = this.dataGen.generateInsertsForPartition(newCommitTime, Integer.valueOf(2), "2016/03/15");
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        JavaRDD statuses = client.upsert(writeRecords, newCommitTime);
        Assertions.assertNoWriteErrors((List)statuses.collect());
        client.commit(newCommitTime, (Object)statuses);
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, cfg);
        SyncableFileSystemView fsView = this.getFileSystemViewWithUnCommittedSlices(table.getMetaClient());
        List firstPartitionCommit2FileGroups = fsView.getAllFileGroups("2016/03/15").collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstPartitionCommit2FileGroups.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((int)((HoodieFileGroup)firstPartitionCommit2FileGroups.get(0)).getAllFileSlices().count()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((FileSlice)((HoodieFileGroup)firstPartitionCommit2FileGroups.get(0)).getAllFileSlices().findFirst().get()).getBaseFile().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)((FileSlice)((HoodieFileGroup)firstPartitionCommit2FileGroups.get(0)).getAllFileSlices().findFirst().get()).getLogFiles().count());
        String generatedFileID = ((HoodieFileGroup)firstPartitionCommit2FileGroups.get(0)).getFileGroupId().getFileId();
        HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])table.getMetaClient().getCommitTimeline().getInstantDetails(new HoodieInstant(true, "deltacommit", "001")).get()), HoodieCommitMetadata.class);
        List firstPartitionWriteStat = (List)commitMetadata.getPartitionToWriteStats().get("2016/03/15");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)firstPartitionWriteStat.size());
        assert (firstPartitionWriteStat.stream().anyMatch(wStat -> StringUtils.isNullOrEmpty((String)wStat.getFileId())));
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)firstPartitionWriteStat.stream().filter(wStat -> !StringUtils.isNullOrEmpty((String)wStat.getFileId())).count());
        firstPartitionWriteStat.stream().filter(wStat -> !StringUtils.isNullOrEmpty((String)wStat.getFileId())).forEach(wStat -> {
            assert (wStat.getNumInserts() > 0L);
        });
        newCommitTime = "002";
        client.startCommitWithTime(newCommitTime);
        List<HoodieRecord> updateRecords = Collections.singletonList(this.dataGen.generateUpdateRecord(((HoodieRecord)records.get(0)).getKey(), newCommitTime));
        List insertRecordsInSamePartition = this.dataGen.generateInsertsForPartition(newCommitTime, Integer.valueOf(2), "2016/03/15");
        List insertRecordsInOtherPartition = this.dataGen.generateInsertsForPartition(newCommitTime, Integer.valueOf(2), "2015/03/16");
        List recordsToBeWrite = Stream.concat(Stream.concat(updateRecords.stream(), insertRecordsInSamePartition.stream()), insertRecordsInOtherPartition.stream()).collect(Collectors.toList());
        writeRecords = this.jsc.parallelize(recordsToBeWrite, 1);
        statuses = client.upsert(writeRecords, newCommitTime);
        client.commit(newCommitTime, (Object)statuses);
        table = this.getHoodieTable(this.metaClient, cfg);
        commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])table.getMetaClient().getCommitTimeline().getInstantDetails(new HoodieInstant(false, "deltacommit", newCommitTime)).get()), HoodieCommitMetadata.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)commitMetadata.getPartitionToWriteStats().containsKey("2016/03/15"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)commitMetadata.getPartitionToWriteStats().containsKey("2015/03/16"));
        List hoodieWriteStatOptionList = (List)commitMetadata.getPartitionToWriteStats().get("2016/03/15");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)hoodieWriteStatOptionList.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)generatedFileID, (Object)((HoodieWriteStat)hoodieWriteStatOptionList.get(0)).getFileId());
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)((HoodieWriteStat)hoodieWriteStatOptionList.get(0)).getNumInserts());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)((HoodieWriteStat)hoodieWriteStatOptionList.get(0)).getNumUpdateWrites());
        List secondHoodieWriteStatOptionList = (List)commitMetadata.getPartitionToWriteStats().get("2015/03/16");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)secondHoodieWriteStatOptionList.size());
        String fileIdInPartitionTwo = ((HoodieWriteStat)secondHoodieWriteStatOptionList.get(0)).getFileId();
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)((HoodieWriteStat)hoodieWriteStatOptionList.get(0)).getNumInserts());
        HoodieInstant rollBackInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "002");
        BaseRollbackPlanActionExecutor mergeOnReadRollbackPlanActionExecutor = new BaseRollbackPlanActionExecutor((HoodieEngineContext)this.context, cfg, (HoodieTable)table, "003", rollBackInstant, false, cfg.shouldRollbackUsingMarkers(), false);
        mergeOnReadRollbackPlanActionExecutor.execute().get();
        MergeOnReadRollbackActionExecutor mergeOnReadRollbackActionExecutor = new MergeOnReadRollbackActionExecutor((HoodieEngineContext)this.context, cfg, (HoodieTable)table, "003", rollBackInstant, true, false);
        Map rollbackMetadata = mergeOnReadRollbackActionExecutor.execute().getPartitionMetadata();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)rollbackMetadata.size());
        HoodieRollbackPartitionMetadata partitionMetadata = (HoodieRollbackPartitionMetadata)rollbackMetadata.get("2016/03/15");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)partitionMetadata.getSuccessDeleteFiles().isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)partitionMetadata.getFailedDeleteFiles().isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)partitionMetadata.getRollbackLogFiles().size());
        partitionMetadata = (HoodieRollbackPartitionMetadata)rollbackMetadata.get("2015/03/16");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)partitionMetadata.getSuccessDeleteFiles().size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)partitionMetadata.getFailedDeleteFiles().isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)partitionMetadata.getRollbackLogFiles().isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)partitionMetadata.getSuccessDeleteFiles().size());
    }

    @Test
    public void testRollbackWhenFirstCommitFail() {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withRollbackUsingMarkers(false).withPath(this.basePath).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(config);){
            client.startCommitWithTime("001");
            client.insert(this.jsc.emptyRDD(), "001");
            client.rollback("001");
        }
    }
}

