/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRollbackUtils {
    private static final String BASE_FILE_EXTENSION = ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension();

    private StoragePathInfo generateFileStatus(String filePath) {
        return new StoragePathInfo(new StoragePath(filePath), 1L, true, 2, 1000000L, 1L);
    }

    @Test
    public void testGenerateHeader() {
        HoodieInstant hoodieInstant = new HoodieInstant(false, "commit", "101");
        String instantToRollback = "1";
        Map header = RollbackUtils.generateHeader((String)instantToRollback, (String)hoodieInstant.getTimestamp());
        HashMap<HoodieLogBlock.HeaderMetadataType, String> headerExpect = new HashMap<HoodieLogBlock.HeaderMetadataType, String>(3);
        headerExpect.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, "101");
        headerExpect.put(HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME, "1");
        headerExpect.put(HoodieLogBlock.HeaderMetadataType.COMMAND_BLOCK_TYPE, "0");
        Assertions.assertEquals((Object)header, headerExpect);
    }

    @Test
    public void testMergeRollbackStat() {
        String partitionPath1 = "/partitionPath1/";
        String partitionPath2 = "/partitionPath2/";
        HashMap<StoragePathInfo, Boolean> dataFilesOnlyStat1Files = new HashMap<StoragePathInfo, Boolean>();
        dataFilesOnlyStat1Files.put(this.generateFileStatus(partitionPath1 + "dataFile1" + BASE_FILE_EXTENSION), true);
        dataFilesOnlyStat1Files.put(this.generateFileStatus(partitionPath1 + "dataFile2" + BASE_FILE_EXTENSION), true);
        HoodieRollbackStat dataFilesOnlyStat1 = HoodieRollbackStat.newBuilder().withPartitionPath(partitionPath1).withDeletedFileResults(dataFilesOnlyStat1Files).build();
        HashMap<StoragePathInfo, Boolean> dataFilesOnlyStat2Files = new HashMap<StoragePathInfo, Boolean>();
        dataFilesOnlyStat2Files.put(this.generateFileStatus(partitionPath2 + "dataFile1" + BASE_FILE_EXTENSION), true);
        dataFilesOnlyStat2Files.put(this.generateFileStatus(partitionPath2 + "dataFile2" + BASE_FILE_EXTENSION), true);
        HoodieRollbackStat dataFilesOnlyStat2 = HoodieRollbackStat.newBuilder().withPartitionPath(partitionPath2).withDeletedFileResults(dataFilesOnlyStat1Files).build();
        Assertions.assertThrows(IllegalArgumentException.class, () -> RollbackUtils.mergeRollbackStat((HoodieRollbackStat)dataFilesOnlyStat1, (HoodieRollbackStat)dataFilesOnlyStat2), (String)"different partition rollbackstat merge will failed");
        HashMap<StoragePathInfo, Boolean> dataFilesOnlyStat3Files = new HashMap<StoragePathInfo, Boolean>();
        dataFilesOnlyStat3Files.put(this.generateFileStatus(partitionPath1 + "dataFile1.log"), true);
        dataFilesOnlyStat3Files.put(this.generateFileStatus(partitionPath1 + "dataFile3" + BASE_FILE_EXTENSION), false);
        HoodieRollbackStat dataFilesOnlyStat3 = HoodieRollbackStat.newBuilder().withPartitionPath(partitionPath1).withDeletedFileResults(dataFilesOnlyStat3Files).build();
        HashMap<StoragePathInfo, Long> dataFilesOnlyStat4Files = new HashMap<StoragePathInfo, Long>();
        dataFilesOnlyStat4Files.put(this.generateFileStatus(partitionPath1 + "dataFile1.log"), 10L);
        HoodieRollbackStat dataFilesOnlyStat4 = HoodieRollbackStat.newBuilder().withPartitionPath(partitionPath1).withRollbackBlockAppendResults(dataFilesOnlyStat4Files).build();
        HoodieRollbackStat dataFilesOnlyStatMerge1 = RollbackUtils.mergeRollbackStat((HoodieRollbackStat)dataFilesOnlyStat1, (HoodieRollbackStat)dataFilesOnlyStat3);
        Assertions.assertEquals((Object)partitionPath1, (Object)dataFilesOnlyStatMerge1.getPartitionPath());
        Assertions.assertIterableEquals((Iterable)CollectionUtils.createImmutableList((Object[])new String[]{partitionPath1 + "dataFile3" + BASE_FILE_EXTENSION}), (Iterable)dataFilesOnlyStatMerge1.getFailedDeleteFiles());
        Assertions.assertIterableEquals((Iterable)CollectionUtils.createImmutableList((Object[])new String[]{partitionPath1 + "dataFile1" + BASE_FILE_EXTENSION, partitionPath1 + "dataFile2" + BASE_FILE_EXTENSION, partitionPath1 + "dataFile1.log"}).stream().sorted().collect(Collectors.toList()), (Iterable)dataFilesOnlyStatMerge1.getSuccessDeleteFiles().stream().sorted().collect(Collectors.toList()));
        Assertions.assertEquals((int)0, (int)dataFilesOnlyStatMerge1.getCommandBlocksCount().size());
        HoodieRollbackStat dataFilesOnlyStatMerge2 = RollbackUtils.mergeRollbackStat((HoodieRollbackStat)dataFilesOnlyStatMerge1, (HoodieRollbackStat)dataFilesOnlyStat4);
        Assertions.assertEquals((Object)partitionPath1, (Object)dataFilesOnlyStatMerge1.getPartitionPath());
        Assertions.assertIterableEquals((Iterable)CollectionUtils.createImmutableList((Object[])new String[]{partitionPath1 + "dataFile3" + BASE_FILE_EXTENSION}).stream().sorted().collect(Collectors.toList()), (Iterable)dataFilesOnlyStatMerge2.getFailedDeleteFiles().stream().sorted().collect(Collectors.toList()));
        Assertions.assertIterableEquals((Iterable)CollectionUtils.createImmutableList((Object[])new String[]{partitionPath1 + "dataFile1" + BASE_FILE_EXTENSION, partitionPath1 + "dataFile2" + BASE_FILE_EXTENSION, partitionPath1 + "dataFile1.log"}).stream().sorted().collect(Collectors.toList()), (Iterable)dataFilesOnlyStatMerge2.getSuccessDeleteFiles().stream().sorted().collect(Collectors.toList()));
        Assertions.assertEquals(Collections.singletonMap(this.generateFileStatus(partitionPath1 + "dataFile1.log"), 10L), (Object)dataFilesOnlyStatMerge2.getCommandBlocksCount());
    }

    @Test
    public void testMergeRollbackRequestSuccess() {
        String partitionPath = "partition/path";
        String fileId = "fileId";
        String latestBaseInstant = "latestBaseInstant";
        List<String> filesToBeDeleted1 = Arrays.asList("file1", "file2");
        HashMap<String, Long> logBlocksToBeDeleted1 = new HashMap<String, Long>();
        logBlocksToBeDeleted1.put("block1", 1L);
        List<String> filesToBeDeleted2 = Arrays.asList("file3", "file4");
        HashMap<String, Long> logBlocksToBeDeleted2 = new HashMap<String, Long>();
        logBlocksToBeDeleted2.put("block2", 2L);
        HoodieRollbackRequest request1 = new HoodieRollbackRequest(partitionPath, fileId, latestBaseInstant, filesToBeDeleted1, logBlocksToBeDeleted1);
        HoodieRollbackRequest request2 = new HoodieRollbackRequest(partitionPath, fileId, latestBaseInstant, filesToBeDeleted2, logBlocksToBeDeleted2);
        HoodieRollbackRequest mergedRequest = RollbackUtils.mergeRollbackRequest((HoodieRollbackRequest)request1, (HoodieRollbackRequest)request2);
        Assertions.assertEquals((Object)partitionPath, (Object)mergedRequest.getPartitionPath());
        Assertions.assertEquals((Object)fileId, (Object)mergedRequest.getFileId());
        Assertions.assertEquals((Object)latestBaseInstant, (Object)mergedRequest.getLatestBaseInstant());
        Assertions.assertTrue((boolean)mergedRequest.getFilesToBeDeleted().containsAll(Arrays.asList("file1", "file2", "file3", "file4")));
        Assertions.assertEquals((int)2, (int)mergedRequest.getLogBlocksToBeDeleted().size());
        Assertions.assertTrue((boolean)mergedRequest.getLogBlocksToBeDeleted().keySet().containsAll(Arrays.asList("block1", "block2")));
    }

    @Test
    public void testMergeRollbackRequestWithMismatchArguments() {
        HoodieRollbackRequest request1 = new HoodieRollbackRequest("partition/path", "fileId", "latestBaseInstant", null, null);
        HoodieRollbackRequest request2 = new HoodieRollbackRequest("partition/path2", "fileId2", "latestBaseInstant2", null, null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> RollbackUtils.mergeRollbackRequest((HoodieRollbackRequest)request1, (HoodieRollbackRequest)request2));
    }
}

