/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.functional;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieDeltaWriteStat;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.hudi.testutils.HoodieMergeOnReadTestUtils;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="functional")
public class TestHoodieSparkMergeOnReadTableInsertUpdateDelete
extends SparkClientFunctionalTestHarness {
    private static Stream<Arguments> testSimpleInsertAndUpdate() {
        return Stream.of(Arguments.of((Object[])new Object[]{HoodieFileFormat.PARQUET, true}), Arguments.of((Object[])new Object[]{HoodieFileFormat.PARQUET, false}), Arguments.of((Object[])new Object[]{HoodieFileFormat.HFILE, true}));
    }

    @ParameterizedTest
    @MethodSource
    public void testSimpleInsertAndUpdate(HoodieFileFormat fileFormat, boolean populateMetaFields) throws Exception {
        Properties properties = populateMetaFields ? new Properties() : this.getPropertiesForKeyGen();
        properties.setProperty(HoodieTableConfig.BASE_FILE_FORMAT.key(), fileFormat.toString());
        HoodieTableMetaClient metaClient = this.getHoodieMetaClient(HoodieTableType.MERGE_ON_READ, properties);
        HoodieWriteConfig.Builder cfgBuilder = this.getConfigBuilder(true);
        this.addConfigsForPopulateMetaFields(cfgBuilder, populateMetaFields);
        HoodieWriteConfig cfg = cfgBuilder.build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
            String newCommitTime = "001";
            client.startCommitWithTime(newCommitTime);
            List records = dataGen.generateInserts(newCommitTime, Integer.valueOf(200));
            Stream<HoodieBaseFile> dataFiles = this.insertRecordsToMORTable(metaClient, records, client, cfg, newCommitTime);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)dataFiles.findAny().isPresent(), (String)"should list the base files we wrote in the delta commit");
            newCommitTime = "004";
            client.startCommitWithTime(newCommitTime);
            records = dataGen.generateUpdates(newCommitTime, Integer.valueOf(100));
            this.updateRecordsInMORTable(metaClient, records, client, cfg, newCommitTime, false);
            String compactionCommitTime = client.scheduleCompaction(Option.empty()).get().toString();
            client.compact(compactionCommitTime);
            HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context(), (HoodieTableMetaClient)metaClient);
            hoodieTable.getHoodieView().sync();
            List<StoragePathInfo> allFiles = this.listAllBaseFilesInPath((HoodieTable)hoodieTable);
            HoodieTableFileSystemView tableView = this.getHoodieTableFileSystemView(metaClient, hoodieTable.getCompletedCommitsTimeline(), allFiles);
            Stream dataFilesToRead = tableView.getLatestBaseFiles();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)dataFilesToRead.findAny().isPresent());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            HoodieTimeline timeline = metaClient.getCommitTimeline().filterCompletedInstants();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeline.findInstantsAfter("000", Integer.MAX_VALUE).countInstants(), (String)"Expecting a single commit.");
            String latestCompactionCommitTime = ((HoodieInstant)timeline.lastInstant().get()).getTimestamp();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTimeline.compareTimestamps((String)"000", (BiPredicate)HoodieTimeline.LESSER_THAN, (String)latestCompactionCommitTime));
            if (cfg.populateMetaFields()) {
                org.junit.jupiter.api.Assertions.assertEquals((long)200L, (long)HoodieClientTestUtils.countRecordsOptionallySince(this.jsc(), this.basePath(), this.sqlContext(), timeline, (Option<String>)Option.of((Object)"000")), (String)"Must contain 200 records");
            } else {
                org.junit.jupiter.api.Assertions.assertEquals((long)200L, (long)HoodieClientTestUtils.countRecordsOptionallySince(this.jsc(), this.basePath(), this.sqlContext(), timeline, (Option<String>)Option.empty()));
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInlineScheduleCompaction(boolean scheduleInlineCompaction) throws Exception {
        HoodieFileFormat fileFormat = HoodieFileFormat.PARQUET;
        Properties properties = new Properties();
        properties.setProperty(HoodieTableConfig.BASE_FILE_FORMAT.key(), fileFormat.toString());
        HoodieTableMetaClient metaClient = this.getHoodieMetaClient(HoodieTableType.MERGE_ON_READ, properties);
        HoodieWriteConfig cfg = this.getConfigBuilder(false).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x40000000L).withInlineCompaction(Boolean.valueOf(false)).withMaxNumDeltaCommitsBeforeCompaction(2).withScheduleInlineCompaction(Boolean.valueOf(scheduleInlineCompaction)).build()).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
            String newCommitTime = "001";
            client.startCommitWithTime(newCommitTime);
            List records = dataGen.generateInserts(newCommitTime, Integer.valueOf(200));
            Stream<HoodieBaseFile> dataFiles = this.insertRecordsToMORTable(metaClient, records, client, cfg, newCommitTime, true);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)dataFiles.findAny().isPresent(), (String)"should list the base files we wrote in the delta commit");
            newCommitTime = "004";
            client.startCommitWithTime(newCommitTime);
            records = dataGen.generateUpdates(newCommitTime, Integer.valueOf(100));
            this.updateRecordsInMORTable(metaClient, records, client, cfg, newCommitTime, true);
            if (scheduleInlineCompaction) {
                org.junit.jupiter.api.Assertions.assertEquals((int)metaClient.reloadActiveTimeline().getAllCommitsTimeline().filterPendingCompactionTimeline().countInstants(), (int)1);
            } else {
                org.junit.jupiter.api.Assertions.assertEquals((int)metaClient.reloadActiveTimeline().getAllCommitsTimeline().filterPendingCompactionTimeline().countInstants(), (int)0);
            }
        }
    }

    @Test
    public void testRepeatedRollbackOfCompaction() throws Exception {
        boolean scheduleInlineCompaction = false;
        HoodieFileFormat fileFormat = HoodieFileFormat.PARQUET;
        Properties properties = new Properties();
        properties.setProperty(HoodieTableConfig.BASE_FILE_FORMAT.key(), fileFormat.toString());
        HoodieTableMetaClient metaClient = this.getHoodieMetaClient(HoodieTableType.MERGE_ON_READ, properties);
        HoodieWriteConfig cfg = this.getConfigBuilder(false).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x40000000L).withInlineCompaction(Boolean.valueOf(false)).withMaxNumDeltaCommitsBeforeCompaction(2).withScheduleInlineCompaction(Boolean.valueOf(scheduleInlineCompaction)).build()).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
            String newCommitTime = "001";
            client.startCommitWithTime(newCommitTime);
            List records = dataGen.generateInserts(newCommitTime, Integer.valueOf(200));
            Stream<HoodieBaseFile> dataFiles = this.insertRecordsToMORTable(metaClient, records, client, cfg, newCommitTime, true);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)dataFiles.findAny().isPresent(), (String)"should list the base files we wrote in the delta commit");
            newCommitTime = "004";
            client.startCommitWithTime(newCommitTime);
            records = dataGen.generateUpdates(newCommitTime, Integer.valueOf(100));
            this.updateRecordsInMORTable(metaClient, records, client, cfg, newCommitTime, true);
            Option compactionInstant = client.scheduleCompaction(Option.empty());
            client.compact((String)compactionInstant.get());
            client.compact((String)compactionInstant.get());
            metaClient.reloadActiveTimeline();
            HoodieInstant rollbackInstant = (HoodieInstant)metaClient.getActiveTimeline().getRollbackTimeline().lastInstant().get();
            FileCreateUtils.deleteRollbackCommit((String)metaClient.getBasePath().substring(metaClient.getBasePath().indexOf(":") + 1), (String)rollbackInstant.getTimestamp());
            metaClient.reloadActiveTimeline();
            try (SparkRDDWriteClient client1 = this.getHoodieWriteClient(cfg);){
                client1.compact((String)compactionInstant.get());
                metaClient.reloadActiveTimeline();
                HoodieInstant newRollbackInstant = (HoodieInstant)metaClient.getActiveTimeline().getRollbackTimeline().lastInstant().get();
                org.junit.jupiter.api.Assertions.assertEquals((Object)rollbackInstant.getTimestamp(), (Object)newRollbackInstant.getTimestamp());
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSimpleInsertUpdateAndDelete(boolean populateMetaFields) throws Exception {
        Properties properties = populateMetaFields ? new Properties() : this.getPropertiesForKeyGen();
        properties.setProperty(HoodieTableConfig.BASE_FILE_FORMAT.key(), ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).toString());
        HoodieTableMetaClient metaClient = this.getHoodieMetaClient(HoodieTableType.MERGE_ON_READ, properties);
        HoodieWriteConfig.Builder cfgBuilder = this.getConfigBuilder(true);
        this.addConfigsForPopulateMetaFields(cfgBuilder, populateMetaFields);
        HoodieWriteConfig cfg = cfgBuilder.build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
            String newCommitTime = "001";
            client.startCommitWithTime(newCommitTime);
            List records = dataGen.generateInserts(newCommitTime, Integer.valueOf(20));
            JavaRDD writeRecords = this.jsc().parallelize(records, 1);
            List statuses = client.upsert(writeRecords, newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)statuses);
            HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context(), (HoodieTableMetaClient)metaClient);
            Option deltaCommit = metaClient.getActiveTimeline().getDeltaCommitTimeline().firstInstant();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)deltaCommit.isPresent());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"001", (Object)((HoodieInstant)deltaCommit.get()).getTimestamp(), (String)"Delta commit should be 001");
            Option commit = metaClient.getActiveTimeline().getCommitAndReplaceTimeline().firstInstant();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)commit.isPresent());
            List<StoragePathInfo> allFiles = this.listAllBaseFilesInPath((HoodieTable)hoodieTable);
            HoodieTableFileSystemView tableView = this.getHoodieTableFileSystemView(metaClient, metaClient.getCommitTimeline().filterCompletedInstants(), allFiles);
            Stream dataFilesToRead = tableView.getLatestBaseFiles();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)dataFilesToRead.findAny().isPresent());
            tableView = this.getHoodieTableFileSystemView(metaClient, hoodieTable.getCompletedCommitsTimeline(), allFiles);
            dataFilesToRead = tableView.getLatestBaseFiles();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)dataFilesToRead.findAny().isPresent(), (String)"should list the base files we wrote in the delta commit");
            newCommitTime = "002";
            client.startCommitWithTime(newCommitTime);
            records = dataGen.generateUpdates(newCommitTime, records);
            writeRecords = this.jsc().parallelize(records, 1);
            statuses = client.upsert(writeRecords, newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)statuses);
            newCommitTime = "004";
            client.startCommitWithTime(newCommitTime);
            List fewRecordsForDelete = dataGen.generateDeletesFromExistingRecords(records);
            statuses = client.upsert(this.jsc().parallelize(fewRecordsForDelete, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)statuses);
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            deltaCommit = metaClient.getActiveTimeline().getDeltaCommitTimeline().lastInstant();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)deltaCommit.isPresent());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"004", (Object)((HoodieInstant)deltaCommit.get()).getTimestamp(), (String)"Latest Delta commit should be 004");
            commit = metaClient.getActiveTimeline().getCommitAndReplaceTimeline().firstInstant();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)commit.isPresent());
            allFiles = this.listAllBaseFilesInPath((HoodieTable)hoodieTable);
            tableView = this.getHoodieTableFileSystemView(metaClient, hoodieTable.getCompletedCommitsTimeline(), allFiles);
            dataFilesToRead = tableView.getLatestBaseFiles();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)dataFilesToRead.findAny().isPresent());
            List inputPaths = tableView.getLatestBaseFiles().map(baseFile -> new Path(baseFile.getPath()).getParent().toString()).collect(Collectors.toList());
            List recordsRead = HoodieMergeOnReadTestUtils.getRecordsUsingInputFormat(this.storageConf(), inputPaths, (String)this.basePath(), (JobConf)new JobConf((Configuration)this.storageConf().unwrap()), (boolean)true, (boolean)populateMetaFields);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)recordsRead.size(), (String)"Must contain 0 records");
        }
    }

    @Test
    public void testSimpleInsertsGeneratedIntoLogFiles() throws Exception {
        HoodieWriteConfig config = this.getConfigBuilder(false, HoodieIndex.IndexType.INMEMORY).build();
        Properties properties = new Properties();
        properties.setProperty(HoodieTableConfig.BASE_FILE_FORMAT.key(), ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).toString());
        HoodieTableMetaClient metaClient = this.getHoodieMetaClient(HoodieTableType.MERGE_ON_READ, properties);
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            String newCommitTime = "100";
            writeClient.startCommitWithTime(newCommitTime);
            HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
            List records = dataGen.generateInserts(newCommitTime, Integer.valueOf(100));
            JavaRDD recordsRDD = this.jsc().parallelize(records, 1);
            JavaRDD statuses = writeClient.insert(recordsRDD, newCommitTime);
            long expectedLogFileNum = statuses.map((Function & Serializable)writeStatus -> (HoodieDeltaWriteStat)writeStatus.getStat()).flatMap((FlatMapFunction & Serializable)deltaWriteStat -> deltaWriteStat.getLogFiles().iterator()).count();
            HoodieDeltaWriteStat correctWriteStat = (HoodieDeltaWriteStat)statuses.map(WriteStatus::getStat).take(1).get(0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)HadoopFSUtils.isLogFile((Path)new Path(correctWriteStat.getPath())));
            HoodieLogFile correctLogFile = new HoodieLogFile(correctWriteStat.getPath());
            String correctWriteToken = FSUtils.getWriteTokenFromLogPath((StoragePath)correctLogFile.getPath());
            String newToken = this.generateNewDifferentWriteToken(correctWriteToken);
            String originalLogfileName = correctLogFile.getPath().getName();
            String logFileWithoutWriteToken = originalLogfileName.substring(0, originalLogfileName.lastIndexOf("_") + 1);
            String newLogFileName = logFileWithoutWriteToken + newToken;
            Path parentPath = new Path(correctLogFile.getPath().getParent().toUri());
            FileSystem fs = parentPath.getFileSystem(this.jsc().hadoopConfiguration());
            fs.copyToLocalFile(new Path(config.getBasePath(), correctLogFile.getPath().toString()), new Path(config.getBasePath().toString() + "/" + parentPath, newLogFileName));
            WriteMarkers writeMarkers = WriteMarkersFactory.get((MarkerType)config.getMarkersType(), (HoodieTable)HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context()), (String)newCommitTime);
            writeMarkers.create(correctWriteStat.getPartitionPath(), newLogFileName, IOType.APPEND);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writeMarkers.allMarkerFilePaths().stream().anyMatch(marker -> marker.contains(newToken)));
            SyncableFileSystemView unCommittedFsView = this.getFileSystemViewWithUnCommittedSlices(metaClient);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)unCommittedFsView.getAllFileSlices(correctWriteStat.getPartitionPath()).flatMap(FileSlice::getLogFiles).map(HoodieLogFile::getPath).anyMatch(path -> path.getName().equals(newLogFileName)));
            writeClient.commit(newCommitTime, (Object)statuses);
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context(), (HoodieTableMetaClient)metaClient);
            table.getHoodieView().sync();
            TableFileSystemView.SliceView tableRTFileSystemView = table.getSliceView();
            long numLogFiles = 0L;
            for (String partitionPath : dataGen.getPartitionPaths()) {
                List allSlices = tableRTFileSystemView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
                org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)allSlices.stream().filter(fileSlice -> fileSlice.getBaseFile().isPresent()).count());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)allSlices.stream().anyMatch(fileSlice -> fileSlice.getLogFiles().count() > 0L));
                long logFileCount = allSlices.stream().mapToLong(fileSlice -> fileSlice.getLogFiles().count()).sum();
                if (logFileCount > 0L) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)allSlices.stream().map(slice -> ((HoodieLogFile)slice.getLogFiles().findFirst().get()).getLogVersion()).allMatch(version -> version.equals(HoodieLogFile.LOGFILE_BASE_VERSION)));
                }
                numLogFiles += logFileCount;
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)(expectedLogFileNum + 1L), (long)numLogFiles);
            Option bytes = table.getActiveTimeline().getInstantDetails((HoodieInstant)table.getActiveTimeline().getDeltaCommitTimeline().lastInstant().get());
            HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])bytes.get()), HoodieCommitMetadata.class);
            org.junit.jupiter.api.Assertions.assertEquals((long)(expectedLogFileNum + 1L), (long)commitMetadata.getWriteStats().size());
            String instantTime = writeClient.scheduleCompaction(Option.empty()).get().toString();
            HoodieWriteMetadata compactionMetadata = writeClient.compact(instantTime);
            String extension = table.getBaseFileExtension();
            Collection stats = ((HoodieCommitMetadata)compactionMetadata.getCommitMetadata().get()).getPartitionToWriteStats().values();
            org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)stats.stream().flatMap(Collection::stream).filter(state -> state.getPath().contains(extension)).count());
            writeClient.commitCompaction(instantTime, (HoodieCommitMetadata)compactionMetadata.getCommitMetadata().get(), Option.empty());
        }
    }

    private HoodieDataBlock getLogBlock(List<HoodieRecord> hoodieRecords, String schema) {
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, "100");
        header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, schema);
        return new HoodieAvroDataBlock(hoodieRecords, header, HoodieRecord.RECORD_KEY_METADATA_FIELD);
    }

    private String generateNewDifferentWriteToken(String correctWriteToken) {
        Random random = new Random();
        String fakeToken = "";
        while ((fakeToken = Math.abs(random.nextInt()) + "-" + Math.abs(random.nextInt()) + "-" + Math.abs(random.nextInt())).equals(correctWriteToken)) {
        }
        return fakeToken;
    }
}

