/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.marker.TestWriteMarkersBase;
import org.apache.hudi.table.marker.TimelineServerBasedWriteMarkers;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.spark.api.java.JavaSparkContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class TestTimelineServerBasedWriteMarkers
extends TestWriteMarkersBase {
    TimelineService timelineService;

    @BeforeEach
    public void setup() throws IOException {
        this.initPath();
        this.initMetaClient();
        this.jsc = new JavaSparkContext(HoodieClientTestUtils.getSparkConfForTest(TestTimelineServerBasedWriteMarkers.class.getName()));
        this.context = new HoodieSparkEngineContext(this.jsc);
        this.storage = this.metaClient.getStorage();
        this.markerFolderPath = new StoragePath(this.metaClient.getMarkerFolderPath("000"));
        FileSystemViewStorageConfig storageConf = FileSystemViewStorageConfig.newBuilder().withStorageType(FileSystemViewStorageType.SPILLABLE_DISK).build();
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        try {
            this.timelineService = new TimelineService((HoodieEngineContext)localEngineContext, new Configuration(), TimelineService.Config.builder().serverPort(0).enableMarkerRequests(true).build(), this.storage, FileSystemViewManager.createViewManager((HoodieEngineContext)localEngineContext, (FileSystemViewStorageConfig)storageConf, (HoodieCommonConfig)HoodieCommonConfig.newBuilder().build()));
            this.timelineService.startService();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.writeMarkers = new TimelineServerBasedWriteMarkers(this.metaClient.getBasePath(), this.markerFolderPath.toString(), "000", "localhost", this.timelineService.getServerPort(), 300);
    }

    @AfterEach
    public void cleanup() {
        if (this.timelineService != null) {
            this.timelineService.close();
        }
        this.jsc.stop();
        this.context = null;
    }

    @Override
    void verifyMarkersInFileSystem(boolean isTablePartitioned) throws IOException {
        List allMarkers = MarkerUtils.readTimelineServerBasedMarkersFromFileSystem((String)this.markerFolderPath.toString(), (HoodieStorage)this.storage, (HoodieEngineContext)this.context, (int)1).values().stream().flatMap(Collection::stream).sorted().collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)allMarkers.size());
        List expectedMarkers = isTablePartitioned ? CollectionUtils.createImmutableList((Object[])new String[]{"2020/06/01/file1.marker.MERGE", "2020/06/02/file2.marker.APPEND", "2020/06/03/file3.marker.CREATE"}) : CollectionUtils.createImmutableList((Object[])new String[]{"file1.marker.MERGE", "file2.marker.APPEND", "file3.marker.CREATE"});
        Assertions.assertIterableEquals((Iterable)expectedMarkers, allMarkers);
        StoragePath markerTypeFilePath = new StoragePath(this.markerFolderPath, "MARKERS.type");
        Assertions.assertTrue((boolean)MarkerUtils.doesMarkerTypeFileExist((HoodieStorage)this.storage, (String)this.markerFolderPath.toString()));
        InputStream inputStream = this.storage.open(markerTypeFilePath);
        Assertions.assertEquals((Object)MarkerType.TIMELINE_SERVER_BASED.toString(), (Object)FileIOUtils.readAsUTFString((InputStream)inputStream));
        this.closeQuietly(inputStream);
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

