/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.client.SparkRDDReadClient;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.testutils.GenericRecordValidationTestUtils;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieClientTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieClientTestUtils.class);

    public static SparkConf getSparkConfForTest(String appName) {
        String evlogDir;
        SparkConf sparkConf = new SparkConf().setAppName(appName).setMaster("local[8]").set("spark.serializer", "org.apache.spark.serializer.KryoSerializer").set("spark.kryo.registrator", "org.apache.spark.HoodieSparkKryoRegistrar").set("spark.sql.shuffle.partitions", "4").set("spark.default.parallelism", "4");
        if (HoodieClientTestUtils.canLoadClass("org.apache.spark.sql.hudi.HoodieSparkSessionExtension")) {
            sparkConf.set("spark.sql.extensions", "org.apache.spark.sql.hudi.HoodieSparkSessionExtension");
        }
        if (HoodieClientTestUtils.canLoadClass("org.apache.spark.sql.hudi.catalog.HoodieCatalog") && HoodieSparkUtils.gteqSpark3_2()) {
            sparkConf.set("spark.sql.catalog.spark_catalog", "org.apache.spark.sql.hudi.catalog.HoodieCatalog");
        }
        if ((evlogDir = System.getProperty("SPARK_EVLOG_DIR")) != null) {
            sparkConf.set("spark.eventLog.enabled", "true");
            sparkConf.set("spark.eventLog.dir", evlogDir);
            sparkConf.set("spark.ui.enabled", "true");
        } else {
            sparkConf.set("spark.ui.enabled", "false");
        }
        return SparkRDDReadClient.addHoodieSupport((SparkConf)sparkConf);
    }

    public static void overrideSparkHadoopConfiguration(SparkContext sparkContext) {
        try {
            Field hadoopConfigurationField = sparkContext.getClass().getDeclaredField("_hadoopConfiguration");
            hadoopConfigurationField.setAccessible(true);
            Configuration testHadoopConfig = new Configuration(false);
            hadoopConfigurationField.set(sparkContext, testHadoopConfig);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.warn(e.getMessage());
        }
    }

    private static HashMap<String, String> getLatestFileIDsToFullPath(String basePath, HoodieTimeline commitTimeline, List<HoodieInstant> commitsToReturn) throws IOException {
        HashMap<String, String> fileIdToFullPath = new HashMap<String, String>();
        for (HoodieInstant commit : commitsToReturn) {
            HoodieCommitMetadata metadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])commitTimeline.getInstantDetails(commit).get()), HoodieCommitMetadata.class);
            fileIdToFullPath.putAll(metadata.getFileIdAndFullPaths(new StoragePath(basePath)));
        }
        return fileIdToFullPath;
    }

    public static Dataset<Row> readCommit(String basePath, SQLContext sqlContext, HoodieTimeline commitTimeline, String instantTime) {
        return HoodieClientTestUtils.readCommit(basePath, sqlContext, commitTimeline, instantTime, true);
    }

    public static Dataset<Row> readCommit(String basePath, SQLContext sqlContext, HoodieTimeline commitTimeline, String instantTime, boolean filterByCommitTime) {
        HoodieInstant commitInstant = new HoodieInstant(false, "commit", instantTime);
        if (!commitTimeline.containsInstant(commitInstant)) {
            throw new HoodieException("No commit exists at " + instantTime);
        }
        try {
            HashMap<String, String> paths = HoodieClientTestUtils.getLatestFileIDsToFullPath(basePath, commitTimeline, Arrays.asList(commitInstant));
            LOG.info("Path :" + paths.values());
            Dataset unFilteredRows = null;
            if (((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).equals((Object)HoodieFileFormat.PARQUET)) {
                unFilteredRows = sqlContext.read().parquet(paths.values().toArray(new String[paths.size()]));
            } else if (((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).equals((Object)HoodieFileFormat.ORC)) {
                unFilteredRows = sqlContext.read().orc(paths.values().toArray(new String[paths.size()]));
            }
            if (unFilteredRows != null) {
                if (filterByCommitTime) {
                    return unFilteredRows.filter(String.format("%s ='%s'", HoodieRecord.COMMIT_TIME_METADATA_FIELD, instantTime));
                }
                return unFilteredRows;
            }
            return sqlContext.emptyDataFrame();
        }
        catch (Exception e) {
            throw new HoodieException("Error reading commit " + instantTime, (Throwable)e);
        }
    }

    public static long countRecordsOptionallySince(JavaSparkContext jsc, String basePath, SQLContext sqlContext, HoodieTimeline commitTimeline, Option<String> lastCommitTimeOpt) {
        List commitsToReturn = lastCommitTimeOpt.isPresent() ? commitTimeline.findInstantsAfter((String)lastCommitTimeOpt.get(), Integer.MAX_VALUE).getInstants() : commitTimeline.getInstants();
        try {
            HashMap<String, String> fileIdToFullPath = HoodieClientTestUtils.getLatestFileIDsToFullPath(basePath, commitTimeline, commitsToReturn);
            String[] paths = fileIdToFullPath.values().toArray(new String[fileIdToFullPath.size()]);
            if (paths[0].endsWith(HoodieFileFormat.PARQUET.getFileExtension())) {
                Dataset rows = sqlContext.read().parquet(paths);
                if (lastCommitTimeOpt.isPresent()) {
                    return rows.filter(String.format("%s >'%s'", HoodieRecord.COMMIT_TIME_METADATA_FIELD, lastCommitTimeOpt.get())).count();
                }
                return rows.count();
            }
            if (paths[0].endsWith(HoodieFileFormat.HFILE.getFileExtension())) {
                Stream genericRecordStream = GenericRecordValidationTestUtils.readHFile((Configuration)jsc.hadoopConfiguration(), (String[])paths);
                if (lastCommitTimeOpt.isPresent()) {
                    return genericRecordStream.filter(gr -> HoodieTimeline.compareTimestamps((String)((String)lastCommitTimeOpt.get()), (BiPredicate)HoodieActiveTimeline.LESSER_THAN, (String)gr.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD).toString())).count();
                }
                return genericRecordStream.count();
            }
            if (paths[0].endsWith(HoodieFileFormat.ORC.getFileExtension())) {
                Dataset rows = sqlContext.read().orc(paths);
                if (lastCommitTimeOpt.isPresent()) {
                    return rows.filter(String.format("%s >'%s'", HoodieRecord.COMMIT_TIME_METADATA_FIELD, lastCommitTimeOpt.get())).count();
                }
                return rows.count();
            }
            throw new HoodieException("Unsupported base file format for file :" + paths[0]);
        }
        catch (IOException e) {
            throw new HoodieException("Error pulling data incrementally from commitTimestamp :" + (String)lastCommitTimeOpt.get(), (Throwable)e);
        }
    }

    public static List<HoodieBaseFile> getLatestBaseFiles(String basePath, HoodieStorage storage, String ... paths) {
        ArrayList<HoodieBaseFile> latestFiles = new ArrayList<HoodieBaseFile>();
        try {
            HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((HoodieStorage)storage, (String)basePath);
            for (String path : paths) {
                HoodieTableFileSystemView fileSystemView = new HoodieTableFileSystemView(metaClient, metaClient.getCommitsTimeline().filterCompletedInstants(), storage.globEntries(new StoragePath(path)));
                latestFiles.addAll(fileSystemView.getLatestBaseFiles().collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            throw new HoodieException("Error reading hoodie table as a dataframe", (Throwable)e);
        }
        return latestFiles;
    }

    public static Dataset<Row> read(JavaSparkContext jsc, String basePath, SQLContext sqlContext, HoodieStorage storage, String ... paths) {
        ArrayList<String> filteredPaths = new ArrayList<String>();
        try {
            List<HoodieBaseFile> latestFiles = HoodieClientTestUtils.getLatestBaseFiles(basePath, storage, paths);
            for (HoodieBaseFile file : latestFiles) {
                filteredPaths.add(file.getPath());
            }
            if (filteredPaths.isEmpty()) {
                return sqlContext.emptyDataFrame();
            }
            String[] filteredPathsToRead = filteredPaths.toArray(new String[filteredPaths.size()]);
            if (filteredPathsToRead[0].endsWith(HoodieFileFormat.PARQUET.getFileExtension())) {
                return sqlContext.read().parquet(filteredPathsToRead);
            }
            if (filteredPathsToRead[0].endsWith(HoodieFileFormat.ORC.getFileExtension())) {
                return sqlContext.read().orc(filteredPathsToRead);
            }
            return sqlContext.emptyDataFrame();
        }
        catch (Exception e) {
            throw new HoodieException("Error reading hoodie table as a dataframe", (Throwable)e);
        }
    }

    public static TimelineService initTimelineService(HoodieEngineContext context, String basePath, int timelineServicePort) {
        try {
            HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(basePath).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).build();
            TimelineService timelineService = new TimelineService(context, new Configuration(), TimelineService.Config.builder().enableMarkerRequests(true).serverPort(config.getViewStorageConfig().getRemoteViewServerPort().intValue()).build(), HoodieStorageUtils.getStorage((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf()), FileSystemViewManager.createViewManager((HoodieEngineContext)context, (FileSystemViewStorageConfig)config.getViewStorageConfig(), (HoodieCommonConfig)config.getCommonConfig()));
            timelineService.startService();
            LOG.info("Timeline service server port: " + timelineServicePort);
            return timelineService;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Option<HoodieCommitMetadata> getCommitMetadataForLatestInstant(HoodieTableMetaClient metaClient) {
        HoodieTimeline timeline = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        if (timeline.lastInstant().isPresent()) {
            return HoodieClientTestUtils.getCommitMetadataForInstant(metaClient, (HoodieInstant)timeline.lastInstant().get());
        }
        return Option.empty();
    }

    public static HoodieTableMetaClient createMetaClient(JavaSparkContext jsc, String basePath) {
        return HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(jsc.hadoopConfiguration()), (String)basePath);
    }

    public static HoodieTableMetaClient createMetaClient(SparkSession spark, String basePath) {
        return HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(spark.sessionState().newHadoopConf()), (String)basePath);
    }

    private static Option<HoodieCommitMetadata> getCommitMetadataForInstant(HoodieTableMetaClient metaClient, HoodieInstant instant) {
        try {
            HoodieTimeline timeline = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
            byte[] data = (byte[])timeline.getInstantDetails(instant).get();
            return Option.of((Object)HoodieCommitMetadata.fromBytes((byte[])data, HoodieCommitMetadata.class));
        }
        catch (Exception e) {
            throw new HoodieException("Failed to read schema from commit metadata", (Throwable)e);
        }
    }

    private static boolean canLoadClass(String className) {
        try {
            return ReflectionUtils.getClass((String)className) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

