/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.run.strategy;

import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.RewriteAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;

public class ExecutionStrategyUtil {
    public static <T> HoodieRecord<T> transform(IndexedRecord indexedRecord, HoodieWriteConfig writeConfig) {
        GenericRecord record = (GenericRecord)indexedRecord;
        Option<BaseKeyGenerator> keyGeneratorOpt = HoodieSparkKeyGeneratorFactory.createBaseKeyGenerator(writeConfig);
        String key = KeyGenUtils.getRecordKeyFromGenericRecord((GenericRecord)record, keyGeneratorOpt);
        String partition = KeyGenUtils.getPartitionPathFromGenericRecord((GenericRecord)record, keyGeneratorOpt);
        HoodieKey hoodieKey = new HoodieKey(key, partition);
        RewriteAvroPayload avroPayload = new RewriteAvroPayload(record);
        HoodieAvroRecord hoodieRecord = new HoodieAvroRecord(hoodieKey, (HoodieRecordPayload)avroPayload);
        return hoodieRecord;
    }
}

