/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.spark.api.java.JavaRDD;

public class SparkReleaseResources {
    public static void releaseCachedData(HoodieEngineContext context, HoodieWriteConfig config, String basePath, String instantTime) {
        if (config.areReleaseResourceEnabled()) {
            HoodieSparkEngineContext sparkEngineContext = (HoodieSparkEngineContext)context;
            Map allCachedRdds = sparkEngineContext.getJavaSparkContext().getPersistentRDDs();
            ArrayList<Integer> allDataIds = new ArrayList<Integer>(sparkEngineContext.removeCachedDataIds(HoodieData.HoodieDataCacheKey.of((String)basePath, (String)instantTime)));
            if (config.isMetadataTableEnabled()) {
                String metadataTableBasePath = HoodieTableMetadata.getMetadataTableBasePath((String)basePath);
                allDataIds.addAll(sparkEngineContext.removeCachedDataIds(HoodieData.HoodieDataCacheKey.of((String)metadataTableBasePath, (String)instantTime)));
            }
            Iterator iterator = allDataIds.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                if (!allCachedRdds.containsKey(id)) continue;
                ((JavaRDD)allCachedRdds.get(id)).unpersist();
            }
        }
    }
}

