/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.validator;

import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.validator.SqlQueryPreCommitValidator;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.config.HoodiePreCommitValidatorConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlQueryEqualityPreCommitValidator<T, I, K, O extends HoodieData<WriteStatus>>
extends SqlQueryPreCommitValidator<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(SqlQueryEqualityPreCommitValidator.class);

    public SqlQueryEqualityPreCommitValidator(HoodieSparkTable<T> table, HoodieEngineContext engineContext, HoodieWriteConfig config) {
        super(table, engineContext, config);
    }

    @Override
    protected String getQueryConfigName() {
        return HoodiePreCommitValidatorConfig.EQUALITY_SQL_QUERIES.key();
    }

    @Override
    protected void validateUsingQuery(String query, String prevTableSnapshot, String newTableSnapshot, SQLContext sqlContext) {
        Dataset prevRows = this.executeSqlQuery(sqlContext, query, prevTableSnapshot, "previous state").cache();
        LOG.info("Total rows in prevRows " + prevRows.count());
        Dataset newRows = this.executeSqlQuery(sqlContext, query, newTableSnapshot, "new state").cache();
        LOG.info("Total rows in newRows " + newRows.count());
        this.printAllRowsIfDebugEnabled((Dataset<Row>)prevRows);
        this.printAllRowsIfDebugEnabled((Dataset<Row>)newRows);
        boolean areDatasetsEqual = prevRows.intersect(newRows).count() == prevRows.count();
        LOG.info("Completed Equality Validation, datasets equal? " + areDatasetsEqual);
        if (!areDatasetsEqual) {
            LOG.error("query validation failed. See stdout for sample query results. Query: " + query);
            System.out.println("Expected result (sample records only):");
            prevRows.show();
            System.out.println("Actual result (sample records only):");
            newRows.show();
            throw new HoodieValidationException("Query validation failed for '" + query + "'. See stdout for expected vs actual records");
        }
    }
}

