/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.execution.bulkinsert.RowRecordKeyExtractor;
import org.apache.hudi.index.bucket.ConsistentBucketIdentifier;
import org.apache.hudi.index.bucket.ConsistentBucketIndexUtils;
import org.apache.hudi.index.bucket.HoodieSparkConsistentBucketIndex;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.ConsistentHashingBucketInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Tuple2;

public class ConsistentBucketIndexBulkInsertPartitionerWithRows
implements BulkInsertPartitioner<Dataset<Row>>,
ConsistentHashingBucketInsertPartitioner {
    private final HoodieTable table;
    private final String indexKeyFields;
    private final List<String> fileIdPfxList = new ArrayList<String>();
    private final Map<String, List<ConsistentHashingNode>> hashingChildrenNodes;
    private Map<String, ConsistentBucketIdentifier> partitionToIdentifier;
    private final Option<BuiltinKeyGenerator> keyGeneratorOpt;
    private Map<String, Map<String, Integer>> partitionToFileIdPfxIdxMap;
    private final RowRecordKeyExtractor extractor;

    public ConsistentBucketIndexBulkInsertPartitionerWithRows(HoodieTable table, boolean populateMetaFields) {
        this.indexKeyFields = table.getConfig().getBucketIndexHashField();
        this.table = table;
        this.hashingChildrenNodes = new HashMap<String, List<ConsistentHashingNode>>();
        this.keyGeneratorOpt = !populateMetaFields ? HoodieSparkKeyGeneratorFactory.getKeyGenerator((Properties)table.getConfig().getProps()) : Option.empty();
        this.extractor = RowRecordKeyExtractor.getRowRecordKeyExtractor(populateMetaFields, this.keyGeneratorOpt);
        ValidationUtils.checkArgument((boolean)table.getMetaClient().getTableType().equals((Object)HoodieTableType.MERGE_ON_READ), (String)"Consistent hash bucket index doesn't support CoW table");
    }

    private ConsistentBucketIdentifier getBucketIdentifier(String partition) {
        HoodieSparkConsistentBucketIndex index = (HoodieSparkConsistentBucketIndex)this.table.getIndex();
        HoodieConsistentHashingMetadata metadata = ConsistentBucketIndexUtils.loadOrCreateMetadata((HoodieTable)this.table, (String)partition, (int)index.getNumBuckets());
        if (this.hashingChildrenNodes.containsKey(partition)) {
            metadata.setChildrenNodes(this.hashingChildrenNodes.get(partition));
        }
        return new ConsistentBucketIdentifier(metadata);
    }

    public Dataset<Row> repartitionRecords(Dataset<Row> rows, int outputPartitions) {
        JavaRDD rowJavaRDD = rows.toJavaRDD();
        this.prepareRepartition((JavaRDD<Row>)rowJavaRDD);
        Partitioner partitioner = new Partitioner(){

            public int getPartition(Object key) {
                return (Integer)key;
            }

            public int numPartitions() {
                return ConsistentBucketIndexBulkInsertPartitionerWithRows.this.fileIdPfxList.size();
            }
        };
        return rows.sparkSession().createDataFrame(rowJavaRDD.mapToPair((PairFunction & Serializable)row -> new Tuple2((Object)this.getBucketId((Row)row), row)).partitionBy(partitioner).values(), rows.schema());
    }

    private void prepareRepartition(JavaRDD<Row> rows) {
        this.partitionToIdentifier = this.initializeBucketIdentifier(rows);
        this.partitionToFileIdPfxIdxMap = ConsistentBucketIndexUtils.generatePartitionToFileIdPfxIdxMap(this.partitionToIdentifier);
        this.partitionToIdentifier.values().forEach(identifier -> this.fileIdPfxList.addAll(identifier.getNodes().stream().map(ConsistentHashingNode::getFileIdPrefix).collect(Collectors.toList())));
    }

    private Map<String, ConsistentBucketIdentifier> initializeBucketIdentifier(JavaRDD<Row> rows) {
        return rows.map(this.extractor::getPartitionPath).distinct().collect().stream().collect(Collectors.toMap(p -> p, this::getBucketIdentifier));
    }

    public void addHashingChildrenNodes(String partition, List<ConsistentHashingNode> nodes) {
        ValidationUtils.checkState((boolean)nodes.stream().noneMatch(n -> n.getTag() == ConsistentHashingNode.NodeTag.NORMAL), (String)"children nodes should not be tagged as NORMAL");
        this.hashingChildrenNodes.put(partition, nodes);
    }

    public boolean arePartitionRecordsSorted() {
        return false;
    }

    private int getBucketId(Row row) {
        String recordKey = this.extractor.getRecordKey(row);
        String partitionPath = this.extractor.getPartitionPath(row);
        ConsistentHashingNode node = this.partitionToIdentifier.get(partitionPath).getBucket(recordKey, this.indexKeyFields);
        return this.partitionToFileIdPfxIdxMap.get(partitionPath).get(node.getFileIdPrefix());
    }
}

