/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.Serializable;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.execution.bulkinsert.PartitionPathRDDPartitioner;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class PartitionPathRepartitionAndSortPartitioner<T extends HoodieRecordPayload>
implements BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>> {
    private final boolean isTablePartitioned;
    private final boolean shouldPopulateMetaFields;

    public PartitionPathRepartitionAndSortPartitioner(boolean isTablePartitioned, HoodieWriteConfig config) {
        this.isTablePartitioned = isTablePartitioned;
        this.shouldPopulateMetaFields = config.populateMetaFields();
    }

    public JavaRDD<HoodieRecord<T>> repartitionRecords(JavaRDD<HoodieRecord<T>> records, int outputSparkPartitions) {
        if (!this.shouldPopulateMetaFields) {
            throw new HoodieException(BulkInsertSortMode.PARTITION_PATH_REPARTITION_AND_SORT.name() + " mode requires meta-fields to be enabled");
        }
        if (this.isTablePartitioned) {
            PartitionPathRDDPartitioner partitioner = new PartitionPathRDDPartitioner((SerializableFunctionUnchecked<Object, String>)(SerializableFunctionUnchecked & Serializable)partitionPath -> (String)partitionPath, outputSparkPartitions);
            return records.mapToPair((PairFunction & Serializable)record -> new Tuple2((Object)record.getPartitionPath(), record)).repartitionAndSortWithinPartitions((Partitioner)partitioner).values();
        }
        return records.coalesce(outputSparkPartitions);
    }

    public boolean arePartitionRecordsSorted() {
        return this.isTablePartitioned;
    }
}

