/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.util.Arrays;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class RowCustomColumnsSortPartitioner
implements BulkInsertPartitioner<Dataset<Row>> {
    private final String[] sortColumnNames;

    public RowCustomColumnsSortPartitioner(HoodieWriteConfig config) {
        this.sortColumnNames = BulkInsertPartitioner.tryPrependPartitionPathColumns((String[])this.getSortColumnName(config), (HoodieWriteConfig)config);
    }

    public RowCustomColumnsSortPartitioner(String[] columnNames, HoodieWriteConfig config) {
        this.sortColumnNames = BulkInsertPartitioner.tryPrependPartitionPathColumns((String[])columnNames, (HoodieWriteConfig)config);
    }

    public Dataset<Row> repartitionRecords(Dataset<Row> records, int outputSparkPartitions) {
        return records.sort((Column[])Arrays.stream(this.sortColumnNames).map(Column::new).toArray(Column[]::new)).coalesce(outputSparkPartitions);
    }

    public boolean arePartitionRecordsSorted() {
        return true;
    }

    private String[] getSortColumnName(HoodieWriteConfig config) {
        return (String[])Arrays.stream(config.getUserDefinedBulkInsertPartitionerSortColumns().split(",")).map(String::trim).toArray(String[]::new);
    }
}

